/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.logistics.gas.crafter;

import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.simple.DeferralBehaviour;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.clockwork.ClockworkRecipes;
import org.valkyrienskies.clockwork.content.logistics.gas.crafter.GasCraftingRecipe;
import org.valkyrienskies.clockwork.util.KNodeBlockEntity;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 I2\u00020\u0001:\u0001IB%\u0012\f\u0010B\u001a\b\u0012\u0002\b\u0003\u0018\u00010A\u0012\u0006\u0010D\u001a\u00020C\u0012\u0006\u0010F\u001a\u00020E\u00a2\u0006\u0004\bG\u0010HJ\u001d\u0010\u0006\u001a\u00020\u00052\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\b\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\n\u0010\tJ\r\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0019\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u000e0\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J'\u0010\u0014\u001a\u00020\u000b\"\b\b\u0000\u0010\u0012*\u00020\u00112\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000e\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0013\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001f\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\u001f\u0010\u001eR$\u0010!\u001a\u0004\u0018\u00010 8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\"\u0010(\u001a\u00020'8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R(\u0010.\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b.\u0010/\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\"\u00105\u001a\u0002048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b5\u00106\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u0017\u0010<\u001a\u00020;8\u0006\u00a2\u0006\f\n\u0004\b<\u0010=\u001a\u0004\b>\u0010?R\u0011\u0010@\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b@\u0010\r\u00a8\u0006J"}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/gas/crafter/GasCrafterBlockEntity;", "Lorg/valkyrienskies/clockwork/util/KNodeBlockEntity;", "", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BlockEntityBehaviour;", "behaviours", "", "addBehaviours", "(Ljava/util/List;)V", "tick", "()V", "lazyTick", "", "updateBasin", "()Z", "Lnet/minecraft/world/item/crafting/Recipe;", "getMatchingRecipes", "()Ljava/util/List;", "Lnet/minecraft/world/Container;", "C", "recipe", "matchRecipe", "(Lnet/minecraft/world/item/crafting/Recipe;)Z", "Ljava/util/Optional;", "Lcom/simibubi/create/content/processing/basin/BasinBlockEntity;", "getBasin", "()Ljava/util/Optional;", "Lnet/minecraft/nbt/CompoundTag;", "tag", "clientPacket", "write", "(Lnet/minecraft/nbt/CompoundTag;Z)V", "read", "Lcom/simibubi/create/foundation/blockEntity/behaviour/simple/DeferralBehaviour;", "basinChecker", "Lcom/simibubi/create/foundation/blockEntity/behaviour/simple/DeferralBehaviour;", "getBasinChecker", "()Lcom/simibubi/create/foundation/blockEntity/behaviour/simple/DeferralBehaviour;", "setBasinChecker", "(Lcom/simibubi/create/foundation/blockEntity/behaviour/simple/DeferralBehaviour;)V", "", "processingTicks", "I", "getProcessingTicks", "()I", "setProcessingTicks", "(I)V", "currentRecipe", "Lnet/minecraft/world/item/crafting/Recipe;", "getCurrentRecipe", "()Lnet/minecraft/world/item/crafting/Recipe;", "setCurrentRecipe", "(Lnet/minecraft/world/item/crafting/Recipe;)V", "", "clientProcessingTicks", "F", "getClientProcessingTicks", "()F", "setClientProcessingTicks", "(F)V", "Lnet/createmod/catnip/animation/LerpedFloat;", "glow", "Lnet/createmod/catnip/animation/LerpedFloat;", "getGlow", "()Lnet/createmod/catnip/animation/LerpedFloat;", "isRunning", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "type", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "Companion", "clockwork"})
public final class GasCrafterBlockEntity
extends KNodeBlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private DeferralBehaviour basinChecker;
    private int processingTicks;
    @Nullable
    private Recipe<?> currentRecipe;
    private float clientProcessingTicks;
    @NotNull
    private final LerpedFloat glow;
    @NotNull
    private static final Object GAS_CRAFTER_RECIPES_KEY = new Object();

    public GasCrafterBlockEntity(@Nullable BlockEntityType<?> type, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, pos, state);
        LerpedFloat lerpedFloat = LerpedFloat.linear();
        Intrinsics.checkNotNullExpressionValue((Object)lerpedFloat, (String)"linear(...)");
        this.glow = lerpedFloat;
        this.glow.chase(0.0, 0.5, LerpedFloat.Chaser.EXP);
    }

    @Nullable
    public final DeferralBehaviour getBasinChecker() {
        return this.basinChecker;
    }

    public final void setBasinChecker(@Nullable DeferralBehaviour deferralBehaviour) {
        this.basinChecker = deferralBehaviour;
    }

    public final int getProcessingTicks() {
        return this.processingTicks;
    }

    public final void setProcessingTicks(int n) {
        this.processingTicks = n;
    }

    @Nullable
    public final Recipe<?> getCurrentRecipe() {
        return this.currentRecipe;
    }

    public final void setCurrentRecipe(@Nullable Recipe<?> recipe) {
        this.currentRecipe = recipe;
    }

    public final float getClientProcessingTicks() {
        return this.clientProcessingTicks;
    }

    public final void setClientProcessingTicks(float f) {
        this.clientProcessingTicks = f;
    }

    @NotNull
    public final LerpedFloat getGlow() {
        return this.glow;
    }

    public final boolean isRunning() {
        return this.processingTicks > 0;
    }

    public void addBehaviours(@NotNull List<BlockEntityBehaviour> behaviours) {
        Intrinsics.checkNotNullParameter(behaviours, (String)"behaviours");
        DeferralBehaviour deferralBehaviour = this.basinChecker = new DeferralBehaviour((SmartBlockEntity)this, this::updateBasin);
        Intrinsics.checkNotNull((Object)deferralBehaviour);
        behaviours.add((BlockEntityBehaviour)deferralBehaviour);
    }

    public void tick() {
        super.tick();
        this.glow.tickChaser();
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (level.f_46443_ && !this.isVirtual()) {
            return;
        }
        this.processingTicks = Math.max(this.processingTicks - 1, 0);
        if (this.processingTicks == 0 && this.currentRecipe != null) {
            this.glow.setValue(2.0);
            Recipe<?> recipe = this.currentRecipe;
            Intrinsics.checkNotNull(recipe);
            GasCraftingRecipe.Companion.apply(this, recipe);
            this.currentRecipe = null;
            this.sendData();
        }
    }

    @Override
    public void lazyTick() {
        DeferralBehaviour deferralBehaviour = this.basinChecker;
        if (deferralBehaviour != null) {
            deferralBehaviour.scheduleUpdate();
        }
        super.lazyTick();
    }

    public final boolean updateBasin() {
        block7: {
            block6: {
                if (this.isRunning()) {
                    return true;
                }
                if (this.f_58857_ == null) break block6;
                Level level = this.f_58857_;
                Intrinsics.checkNotNull((Object)level);
                if (!level.f_46443_) break block7;
            }
            return true;
        }
        Optional<BasinBlockEntity> basin = this.getBasin();
        if (!basin.filter(GasCrafterBlockEntity::updateBasin$lambda$0).isPresent()) {
            return true;
        }
        List<Recipe<?>> recipes = this.getMatchingRecipes();
        if (recipes.isEmpty() || this.currentRecipe != null) {
            return true;
        }
        Recipe<?> recipe = this.currentRecipe = recipes.get(0);
        Intrinsics.checkNotNull(recipe, (String)"null cannot be cast to non-null type org.valkyrienskies.clockwork.content.logistics.gas.crafter.GasCraftingRecipe");
        int n = ((GasCraftingRecipe)recipe).getProcessingDuration();
        int n2 = 20;
        this.processingTicks = Math.max(n, n2);
        this.sendData();
        return true;
    }

    @NotNull
    public final List<Recipe<?>> getMatchingRecipes() {
        Optional<BasinBlockEntity> basin = this.getBasin();
        if (basin.isEmpty()) {
            return new ArrayList();
        }
        List list = new ArrayList();
        for (Recipe r : RecipeFinder.get((Object)GAS_CRAFTER_RECIPES_KEY, (Level)this.f_58857_, GasCrafterBlockEntity::getMatchingRecipes$lambda$1)) {
            if (!this.matchRecipe(r)) continue;
            list.add(r);
        }
        if (list.size() > 1) {
            CollectionsKt.sortWith((List)list, GasCrafterBlockEntity::getMatchingRecipes$lambda$2);
        }
        return list;
    }

    public final <C extends Container> boolean matchRecipe(@Nullable Recipe<C> recipe) {
        if (recipe == null) {
            return false;
        }
        return GasCraftingRecipe.Companion.match(this, recipe);
    }

    @NotNull
    public final Optional<BasinBlockEntity> getBasin() {
        if (this.f_58857_ == null) {
            Optional<BasinBlockEntity> optional = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
            return optional;
        }
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        BlockEntity basinBE = level.m_7702_(this.f_58858_.m_6625_(1));
        if (!(basinBE instanceof BasinBlockEntity)) {
            Optional<BasinBlockEntity> optional = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
            return optional;
        }
        Optional<BlockEntity> optional = Optional.of(basinBE);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
        return optional;
    }

    @Override
    protected void write(@NotNull CompoundTag tag, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        tag.m_128405_("processingTicks", this.processingTicks);
        tag.m_128350_("glow", this.glow.getValue());
        super.write(tag, clientPacket);
    }

    @Override
    protected void read(@NotNull CompoundTag tag, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        super.read(tag, clientPacket);
        this.processingTicks = tag.m_128451_("processingTicks");
        this.glow.setValue((double)tag.m_128457_("glow"));
        if (clientPacket) {
            this.clientProcessingTicks = this.processingTicks;
        }
    }

    private static final boolean updateBasin$lambda$0(BasinBlockEntity obj) {
        BasinBlockEntity basinBlockEntity = obj;
        Intrinsics.checkNotNull((Object)basinBlockEntity);
        return basinBlockEntity.canContinueProcessing();
    }

    private static final boolean getMatchingRecipes$lambda$1(Recipe recipe) {
        Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
        return Intrinsics.areEqual((Object)recipe.m_6671_(), ClockworkRecipes.ClockworkRecipeTypes.GAS_CRAFTING.getType());
    }

    private static final int getMatchingRecipes$lambda$2(Recipe r1, Recipe r2) {
        Intrinsics.checkNotNullParameter((Object)r1, (String)"r1");
        Intrinsics.checkNotNullParameter((Object)r2, (String)"r2");
        return r2.m_7527_().size() - r1.m_7527_().size();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0017\u0010\u0002\u001a\u00020\u00018\u0006\u00a2\u0006\f\n\u0004\b\u0002\u0010\u0003\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\b"}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/gas/crafter/GasCrafterBlockEntity$Companion;", "", "GAS_CRAFTER_RECIPES_KEY", "Ljava/lang/Object;", "getGAS_CRAFTER_RECIPES_KEY", "()Ljava/lang/Object;", "<init>", "()V", "clockwork"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Object getGAS_CRAFTER_RECIPES_KEY() {
            return GAS_CRAFTER_RECIPES_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

