/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.kinetics.sequenced_seat;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.clockwork.content.kinetics.sequenced_seat.InputKey;
import org.valkyrienskies.clockwork.content.kinetics.sequenced_seat.SequencedSeatBlockEntity;
import org.valkyrienskies.clockwork.content.kinetics.sequenced_seat.SequencedSeatOperation;
import org.valkyrienskies.clockwork.content.kinetics.sequenced_seat.SequencedSeatValue;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 '2\u00020\u0001:\u0001'B'\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0015\u0012\u0006\u0010\u001a\u001a\u00020\u0019\u0012\b\u0010\u001f\u001a\u0004\u0018\u00010\u001e\u00a2\u0006\u0004\b%\u0010&J\u001b\u0010\u0006\u001a\u00020\u00052\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J+\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ'\u0010\u000f\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J'\u0010\u0011\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0010J\r\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00158\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u001a\u001a\u00020\u00198\u0006\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u0019\u0010\u001f\u001a\u0004\u0018\u00010\u001e8\u0006\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"R\u0016\u0010#\u001a\u00020\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010$\u00a8\u0006("}, d2={"Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/SequencedSeatRule;", "", "", "Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/InputKey;", "inputKeys", "", "matches", "(Ljava/util/Set;)Z", "Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/SequencedSeatBlockEntity;", "be", "Lnet/minecraft/core/Direction;", "face", "", "calculateModifier", "(Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/SequencedSeatBlockEntity;Lnet/minecraft/core/Direction;Ljava/util/Set;)F", "angleRotate", "(Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/SequencedSeatBlockEntity;Lnet/minecraft/core/Direction;Z)F", "distanceRotate", "Lnet/minecraft/nbt/CompoundTag;", "serializeNBT", "()Lnet/minecraft/nbt/CompoundTag;", "", "Ljava/util/Set;", "getInputKeys", "()Ljava/util/Set;", "Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/SequencedSeatOperation;", "operation", "Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/SequencedSeatOperation;", "getOperation", "()Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/SequencedSeatOperation;", "Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/SequencedSeatValue;", "value", "Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/SequencedSeatValue;", "getValue", "()Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/SequencedSeatValue;", "inAction", "Z", "<init>", "(Ljava/util/Set;Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/SequencedSeatOperation;Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/SequencedSeatValue;)V", "Companion", "clockwork"})
public final class SequencedSeatRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<InputKey> inputKeys;
    @NotNull
    private final SequencedSeatOperation operation;
    @Nullable
    private final SequencedSeatValue value;
    private boolean inAction;

    public SequencedSeatRule(@NotNull Set<InputKey> inputKeys, @NotNull SequencedSeatOperation operation, @Nullable SequencedSeatValue value) {
        Intrinsics.checkNotNullParameter(inputKeys, (String)"inputKeys");
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        this.inputKeys = inputKeys;
        this.operation = operation;
        this.value = value;
    }

    @NotNull
    public final Set<InputKey> getInputKeys() {
        return this.inputKeys;
    }

    @NotNull
    public final SequencedSeatOperation getOperation() {
        return this.operation;
    }

    @Nullable
    public final SequencedSeatValue getValue() {
        return this.value;
    }

    public final boolean matches(@NotNull Set<? extends InputKey> inputKeys) {
        Intrinsics.checkNotNullParameter(inputKeys, (String)"inputKeys");
        return Intrinsics.areEqual(inputKeys, this.inputKeys);
    }

    public final float calculateModifier(@NotNull SequencedSeatBlockEntity be, @NotNull Direction face, @NotNull Set<? extends InputKey> inputKeys) {
        Intrinsics.checkNotNullParameter((Object)((Object)be), (String)"be");
        Intrinsics.checkNotNullParameter((Object)face, (String)"face");
        Intrinsics.checkNotNullParameter(inputKeys, (String)"inputKeys");
        boolean matches = this.matches(inputKeys);
        return switch (WhenMappings.$EnumSwitchMapping$0[this.operation.ordinal()]) {
            case 1 -> 0.0f;
            case 2 -> this.angleRotate(be, face, matches);
            case 3 -> this.distanceRotate(be, face, matches);
            case 4 -> {
                if (matches) {
                    SequencedSeatValue v1 = this.value;
                    Intrinsics.checkNotNull((Object)v1, (String)"null cannot be cast to non-null type org.valkyrienskies.clockwork.content.kinetics.sequenced_seat.SequencedSeatValue.MultiplyValue");
                    yield ((SequencedSeatValue.MultiplyValue)v1).getMultiplier();
                }
                yield 0.0f;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final float angleRotate(SequencedSeatBlockEntity be, Direction face, boolean matches) {
        float diff;
        if (!this.inAction && !matches) {
            return 0.0f;
        }
        SequencedSeatValue sequencedSeatValue = this.value;
        Intrinsics.checkNotNull((Object)sequencedSeatValue, (String)"null cannot be cast to non-null type org.valkyrienskies.clockwork.content.kinetics.sequenced_seat.SequencedSeatValue.AngleValue");
        int targetDegrees = -((SequencedSeatValue.AngleValue)sequencedSeatValue).getDegrees();
        float degreesAway = be.getDegreesAwayFromBase(face);
        float f = diff = matches ? (float)targetDegrees - degreesAway : -degreesAway;
        if (diff > 180.0f) {
            diff -= 360.0f;
        } else if (diff < -180.0f) {
            diff += 360.0f;
        }
        if ((double)diff < 0.1 && (double)diff > -0.1) {
            this.inAction = matches;
            return 0.0f;
        }
        this.inAction = true;
        double degreesPerTick = KineticBlockEntity.convertToAngular((float)be.getSpeed());
        return Math.abs(degreesPerTick) > (double)Math.abs(diff) ? (float)((double)diff / degreesPerTick) : ((double)diff * degreesPerTick < 0.0 ? -1.0f : 1.0f);
    }

    private final float distanceRotate(SequencedSeatBlockEntity be, Direction face, boolean matches) {
        float diff;
        if (!this.inAction && !matches) {
            return 0.0f;
        }
        SequencedSeatValue sequencedSeatValue = this.value;
        Intrinsics.checkNotNull((Object)sequencedSeatValue, (String)"null cannot be cast to non-null type org.valkyrienskies.clockwork.content.kinetics.sequenced_seat.SequencedSeatValue.AngleValue");
        int targetDegrees = -((SequencedSeatValue.AngleValue)sequencedSeatValue).getDegrees();
        float degreesAway = be.getDegreesAwayFromBase(face);
        float f = diff = matches ? (float)targetDegrees - degreesAway : -degreesAway;
        if (diff > 180.0f) {
            diff -= 360.0f;
        } else if (diff < -180.0f) {
            diff += 360.0f;
        }
        if ((double)diff < 0.1 && (double)diff > -0.1) {
            this.inAction = matches;
            return 0.0f;
        }
        this.inAction = true;
        float metersPerTick = KineticBlockEntity.convertToLinear((float)be.getSpeed());
        return Math.abs(metersPerTick) > Math.abs(diff) ? diff / metersPerTick : (diff * metersPerTick < 0.0f ? -1.0f : 1.0f);
    }

    @NotNull
    public final CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("keys", InputKey.Companion.asInt(this.inputKeys));
        tag.m_128405_("operation", this.operation.ordinal());
        if (this.value != null) {
            tag.m_128365_("value", this.value.serializeNBT());
        }
        return tag;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/SequencedSeatRule$Companion;", "", "Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/SequencedSeatRule;", "empty", "()Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/SequencedSeatRule;", "Lnet/minecraft/nbt/CompoundTag;", "tag", "deserializeNBT", "(Lnet/minecraft/nbt/CompoundTag;)Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/SequencedSeatRule;", "<init>", "()V", "clockwork"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SequencedSeatRule empty() {
            return new SequencedSeatRule(new HashSet(), SequencedSeatOperation.NOTHING, null);
        }

        @NotNull
        public final SequencedSeatRule deserializeNBT(@NotNull CompoundTag tag) {
            SequencedSeatValue value;
            SequencedSeatOperation operation;
            Set<InputKey> keys;
            block0: {
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                keys = InputKey.Companion.fromInt(tag.m_128451_("keys"));
                operation = (SequencedSeatOperation)((Object)SequencedSeatOperation.getEntries().get(tag.m_128451_("operation")));
                SequencedSeatValue sequencedSeatValue = value = operation.defaultValue();
                if (sequencedSeatValue == null) break block0;
                Tag tag2 = tag.m_128423_("value");
                Intrinsics.checkNotNull((Object)tag2);
                sequencedSeatValue.deserializeNBT(tag2);
            }
            return new SequencedSeatRule(keys, operation, value);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SequencedSeatOperation.values().length];
            try {
                nArray[SequencedSeatOperation.NOTHING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SequencedSeatOperation.TURN_ANGLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SequencedSeatOperation.TURN_DISTANCE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SequencedSeatOperation.MULTIPLY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

