/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.generic;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.clockwork.content.forces.MultiInstanceForceApplier;
import org.valkyrienskies.clockwork.content.forces.data.ForceApplierCreateData;
import org.valkyrienskies.clockwork.content.forces.data.ForceApplierData;
import org.valkyrienskies.clockwork.content.forces.data.ForceApplierUpdateData;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\bf\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u0001*\u000e\b\u0001\u0010\u0004*\b\u0012\u0004\u0012\u00028\u00000\u0003*\u000e\b\u0002\u0010\u0006*\b\u0012\u0004\u0012\u00028\u00010\u0005*\u001a\b\u0003\u0010\b*\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00072\u00020\tJ\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00028\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00028\u0002H&\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00028\u0000H&\u00a2\u0006\u0004\b\u0012\u0010\u0013J/\u0010\u001a\u001a\u00020\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00030\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u001c\u0010!\u001a\u00020\u001c8&@&X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\"\u00c0\u0006\u0001"}, d2={"Lorg/valkyrienskies/clockwork/content/generic/IForceApplierBE;", "Lorg/valkyrienskies/clockwork/content/forces/data/ForceApplierUpdateData;", "U", "Lorg/valkyrienskies/clockwork/content/forces/data/ForceApplierData;", "D", "Lorg/valkyrienskies/clockwork/content/forces/data/ForceApplierCreateData;", "C", "Lorg/valkyrienskies/clockwork/content/forces/MultiInstanceForceApplier;", "A", "", "attachment", "", "shouldUpdate", "", "tickData", "(Lorg/valkyrienskies/clockwork/content/forces/MultiInstanceForceApplier;Z)V", "newCreateData", "()Lorg/valkyrienskies/clockwork/content/forces/data/ForceApplierCreateData;", "newUpdateData", "()Lorg/valkyrienskies/clockwork/content/forces/data/ForceApplierUpdateData;", "Ljava/lang/Class;", "clazz", "Lnet/minecraft/world/level/Level;", "level", "Lnet/minecraft/core/BlockPos;", "pos", "removeApplier", "(Ljava/lang/Class;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)V", "", "getPhysID", "()I", "setPhysID", "(I)V", "physID", "clockwork"})
public interface IForceApplierBE<U extends ForceApplierUpdateData, D extends ForceApplierData<? super U>, C extends ForceApplierCreateData<? extends D>, A extends MultiInstanceForceApplier<U, D, C>> {
    public int getPhysID();

    public void setPhysID(int var1);

    default public void tickData(@NotNull A attachment, boolean shouldUpdate) {
        Intrinsics.checkNotNullParameter(attachment, (String)"attachment");
        if (this.getPhysID() < 0) {
            C createData = this.newCreateData();
            this.setPhysID(attachment.createApplier(createData));
        }
        if (this.getPhysID() >= 0 && shouldUpdate) {
            attachment.updateApplier(this.getPhysID(), this.newUpdateData());
        }
    }

    @NotNull
    public C newCreateData();

    @NotNull
    public U newUpdateData();

    default public void removeApplier(@NotNull Class<A> clazz, @Nullable Level level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (level == null || level.f_46443_) {
            return;
        }
        boolean bl = level instanceof ServerLevel;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        LoadedServerShip loadedServerShip = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)((ServerLevel)level), (Vec3i)((Vec3i)pos));
        if (loadedServerShip == null) {
            return;
        }
        LoadedServerShip ship = loadedServerShip;
        MultiInstanceForceApplier multiInstanceForceApplier = (MultiInstanceForceApplier)ship.getAttachment(clazz);
        if (multiInstanceForceApplier == null) {
            return;
        }
        MultiInstanceForceApplier attachment = multiInstanceForceApplier;
        attachment.removeApplier(this.getPhysID());
        this.setPhysID(-1);
    }
}

