/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.forces.contraption;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3dc;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.clockwork.ClockworkConfig;
import org.valkyrienskies.clockwork.content.contraptions.phys.bearing.data.PhysBearingData;
import org.valkyrienskies.clockwork.content.contraptions.phys.bearing.data.PhysBearingUpdateData;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ShipPhysicsListener;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.api.world.PhysLevel;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 <2\u00020\u0001:\u0001<B\u0007\u00a2\u0006\u0004\b:\u0010;J\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ)\u0010\r\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\u0002H\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ'\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J7\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u001aJ\u001f\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ)\u0010!\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u00022\b\u0010 \u001a\u0004\u0018\u00010\u0002H\u0002\u00a2\u0006\u0004\b!\u0010\u000eJ\u0015\u0010#\u001a\u00020\"2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b#\u0010$J\u0015\u0010&\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\"\u00a2\u0006\u0004\b&\u0010'J\u001d\u0010)\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\"2\u0006\u0010\n\u001a\u00020(\u00a2\u0006\u0004\b)\u0010*R#\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\t0+8\u0006\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/R \u00101\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020(008\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b1\u00102R&\u00105\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\t04038\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b5\u00106R\u001a\u00107\u001a\b\u0012\u0004\u0012\u00020\"038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u00106R\u0016\u00108\u001a\u00020\"8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b8\u00109\u00a8\u0006="}, d2={"Lorg/valkyrienskies/clockwork/content/forces/contraption/BearingController;", "Lorg/valkyrienskies/core/api/ships/ShipPhysicsListener;", "Lorg/valkyrienskies/core/api/ships/PhysShip;", "physShip", "Lorg/valkyrienskies/core/api/world/PhysLevel;", "physLevel", "", "physTick", "(Lorg/valkyrienskies/core/api/ships/PhysShip;Lorg/valkyrienskies/core/api/world/PhysLevel;)V", "Lorg/valkyrienskies/clockwork/content/contraptions/phys/bearing/data/PhysBearingData;", "data", "otherPhysShip", "Lorg/joml/Vector3dc;", "computeRotationalForce", "(Lorg/valkyrienskies/clockwork/content/contraptions/phys/bearing/data/PhysBearingData;Lorg/valkyrienskies/core/api/ships/PhysShip;Lorg/valkyrienskies/core/api/ships/PhysShip;)Lorg/joml/Vector3dc;", "localPos", "axisGlobal", "", "getAngularInertia", "(Lorg/valkyrienskies/core/api/ships/PhysShip;Lorg/joml/Vector3dc;Lorg/joml/Vector3dc;)D", "Lorg/joml/Matrix3dc;", "inertiaTensorLocal", "Lorg/joml/Quaterniondc;", "rotation", "mass", "offsetGlobal", "(Lorg/joml/Matrix3dc;Lorg/joml/Quaterniondc;DLorg/joml/Vector3dc;Lorg/joml/Vector3dc;)D", "left", "right", "parallelOperator", "(DD)D", "subShip", "mainShip", "computeUnlockedRotationalForce", "", "addPhysBearing", "(Lorg/valkyrienskies/clockwork/content/contraptions/phys/bearing/data/PhysBearingData;)I", "id", "removePhysBearing", "(I)V", "Lorg/valkyrienskies/clockwork/content/contraptions/phys/bearing/data/PhysBearingUpdateData;", "updatePhysBearing", "(ILorg/valkyrienskies/clockwork/content/contraptions/phys/bearing/data/PhysBearingUpdateData;)V", "Ljava/util/HashMap;", "bearingData", "Ljava/util/HashMap;", "getBearingData", "()Ljava/util/HashMap;", "Ljava/util/concurrent/ConcurrentHashMap;", "bearingUpdateData", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lkotlin/Pair;", "createdBearings", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "removedBearings", "nextBearingID", "I", "<init>", "()V", "Companion", "clockwork"})
@SourceDebugExtension(value={"SMAP\nBearingController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BearingController.kt\norg/valkyrienskies/clockwork/content/forces/contraption/BearingController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 Vector3dUtils.kt\norg/valkyrienskies/clockwork/util/Vector3dUtilsKt\n*L\n1#1,317:1\n1#2:318\n216#3,2:319\n26#4:321\n20#4:322\n*S KotlinDebug\n*F\n+ 1 BearingController.kt\norg/valkyrienskies/clockwork/content/forces/contraption/BearingController\n*L\n41#1:319,2\n171#1:321\n171#1:322\n*E\n"})
public final class BearingController
implements ShipPhysicsListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<Integer, PhysBearingData> bearingData = new HashMap();
    @JsonIgnore
    @NotNull
    private final ConcurrentHashMap<Integer, PhysBearingUpdateData> bearingUpdateData = new ConcurrentHashMap();
    @JsonIgnore
    @NotNull
    private final ConcurrentLinkedQueue<Pair<Integer, PhysBearingData>> createdBearings = new ConcurrentLinkedQueue();
    @NotNull
    private final ConcurrentLinkedQueue<Integer> removedBearings = new ConcurrentLinkedQueue();
    private int nextBearingID;

    @NotNull
    public final HashMap<Integer, PhysBearingData> getBearingData() {
        return this.bearingData;
    }

    public void physTick(@NotNull PhysShip physShip, @NotNull PhysLevel physLevel) {
        Object data;
        Intrinsics.checkNotNullParameter((Object)physShip, (String)"physShip");
        Intrinsics.checkNotNullParameter((Object)physLevel, (String)"physLevel");
        while (!this.createdBearings.isEmpty()) {
            Object e = this.createdBearings.remove();
            Pair pair = (Pair)e;
            boolean bl = false;
            int id = ((Number)pair.component1()).intValue();
            data = (PhysBearingData)pair.component2();
            Integer n = id;
            ((Map)this.bearingData).put(n, data);
        }
        while (!this.removedBearings.isEmpty()) {
            this.bearingData.remove(this.removedBearings.remove());
        }
        Map $this$forEach$iv = this.bearingUpdateData;
        boolean $i$f$forEach = false;
        for (Map.Entry element$iv : $this$forEach$iv.entrySet()) {
            PhysBearingData physData;
            data = element$iv;
            boolean bl = false;
            int id = ((Number)data.getKey()).intValue();
            PhysBearingUpdateData data2 = (PhysBearingUpdateData)data.getValue();
            if (this.bearingData.get(id) == null) continue;
            physData.setBearingAngle(data2.getBearingAngle());
            physData.setAngularSpeed(data2.getBearingRPM());
            physData.setAngleFollowing(data2.getLocked());
        }
        this.bearingUpdateData.clear();
        for (Object e : this.bearingData.values()) {
            Vector3dc torque;
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            PhysBearingData data3 = (PhysBearingData)e;
            if (data3.getAngleFollowing()) continue;
            long physShipBearingIsOnId = data3.getMainShipId();
            if (physShipBearingIsOnId == -1L) {
                Vector3dc torque2 = this.computeRotationalForce(data3, physShip, null);
                physShip.applyWorldTorque(torque2);
                continue;
            }
            PhysShip physShipBearingIsOn = physLevel.getShipById(physShipBearingIsOnId);
            if (physShipBearingIsOn == null) {
                torque = this.computeRotationalForce(data3, physShip, null);
                physShip.applyWorldTorque(torque);
                continue;
            }
            torque = this.computeRotationalForce(data3, physShip, physShipBearingIsOn);
            physShip.applyWorldTorque(torque);
            Vector3d vector3d = torque.mul(-1.0, new Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"mul(...)");
            physShipBearingIsOn.applyWorldTorque((Vector3dc)vector3d);
        }
    }

    private final Vector3dc computeRotationalForce(PhysBearingData data, PhysShip physShip, PhysShip otherPhysShip) {
        float prevRPM = data.getAngularSpeed();
        double prevAngle = data.getBearingAngle();
        Vector3dc vector3dc = data.getBearingAxis();
        Intrinsics.checkNotNull((Object)vector3dc);
        PhysShip physShip2 = otherPhysShip;
        data.setActualAngle(Companion.getAngle(vector3dc, physShip.getTransform(), (ShipTransform)(physShip2 != null ? physShip2.getTransform() : null)));
        if (data.getAligning()) {
            data.setAngularSpeed(Math.abs(prevRPM) * (float)(data.getActualAngle() > 0.0 ? -1 : 1));
            data.setBearingAngle(0.0);
            data.setAngleFollowing(true);
        }
        Vector3dc torque = data.getAngleFollowing() ? (Vector3dc)new Vector3d() : this.computeUnlockedRotationalForce(data, physShip, otherPhysShip);
        data.setAngularSpeed(prevRPM);
        data.setBearingAngle(prevAngle);
        return torque;
    }

    private final double getAngularInertia(PhysShip physShip, Vector3dc localPos, Vector3dc axisGlobal) {
        Vector3d vector3d = physShip.getTransform().getShipToWorld().transformPosition(localPos, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"transformPosition(...)");
        Vector3dc globalPos = (Vector3dc)vector3d;
        Vector3d vector3d2 = globalPos.sub(physShip.getTransform().getPositionInWorld(), new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"sub(...)");
        Vector3dc offset = (Vector3dc)vector3d2;
        return this.getAngularInertia(physShip.getMomentOfInertia(), physShip.getTransform().getShipToWorldRotation(), physShip.getMass(), offset, axisGlobal);
    }

    private final double getAngularInertia(Matrix3dc inertiaTensorLocal, Quaterniondc rotation, double mass, Vector3dc offsetGlobal, Vector3dc axisGlobal) {
        Vector3d vector3d = offsetGlobal.sub((Vector3dc)axisGlobal.mul(axisGlobal.dot(offsetGlobal), new Vector3d()), new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"sub(...)");
        Vector3dc offsetPerpToAxis = (Vector3dc)vector3d;
        Vector3d vector3d2 = rotation.transformInverse(axisGlobal, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"transformInverse(...)");
        Vector3dc axisLocal = (Vector3dc)vector3d2;
        return inertiaTensorLocal.transform(axisLocal, new Vector3d()).dot(axisLocal) + offsetPerpToAxis.lengthSquared() * mass;
    }

    private final double parallelOperator(double left, double right) {
        return 1.0 / (1.0 / left + 1.0 / right);
    }

    /*
     * WARNING - void declaration
     */
    private final Vector3dc computeUnlockedRotationalForce(PhysBearingData data, PhysShip subShip, PhysShip mainShip) {
        void $this$minus$iv;
        void $this$times$iv;
        if (data.getBearingAxis() == null) {
            return (Vector3dc)new Vector3d();
        }
        Vector3d bearingAxisInGlobal = new Vector3d(data.getBearingAxis());
        PhysShip physShip = mainShip;
        if (physShip != null && (physShip = physShip.getTransform()) != null && (physShip = physShip.getShipToWorldRotation()) != null) {
            physShip.transform(bearingAxisInGlobal);
        }
        Vector3d idealRelativeOmega = bearingAxisInGlobal.mul(-((double)data.getAngularSpeed()), new Vector3d());
        Vector3d actualRelativeOmega = !subShip.isStatic() ? new Vector3d(subShip.getAngularVelocity()) : new Vector3d();
        double torqueMassMultiplier = 0.0;
        if (!subShip.isStatic()) {
            if (mainShip != null && !mainShip.isStatic()) {
                double physShipInertia = this.getAngularInertia(subShip, (Vector3dc)data.getSubPos(), (Vector3dc)bearingAxisInGlobal);
                double otherShipInertia = this.getAngularInertia(mainShip, (Vector3dc)data.getMainPos(), (Vector3dc)bearingAxisInGlobal);
                torqueMassMultiplier = this.parallelOperator(physShipInertia, otherShipInertia);
                v1 = actualRelativeOmega.sub(mainShip.getAngularVelocity());
            } else {
                torqueMassMultiplier = this.getAngularInertia(subShip, (Vector3dc)data.getSubPos(), (Vector3dc)bearingAxisInGlobal);
                v1 = Unit.INSTANCE;
            }
        } else if (mainShip != null && !mainShip.isStatic()) {
            torqueMassMultiplier = this.getAngularInertia(mainShip, (Vector3dc)data.getMainPos(), (Vector3dc)bearingAxisInGlobal);
            v1 = actualRelativeOmega.sub(mainShip.getAngularVelocity());
        } else {
            return (Vector3dc)new Vector3d();
        }
        Vector3d vector3d = data.getBearingAxis().rotate(subShip.getTransform().getShipToWorldRotation(), new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"rotate(...)");
        Vector3dc bearingAxisAfterRot = (Vector3dc)vector3d;
        if (mainShip != null) {
            bearingAxisAfterRot = (Vector3dc)mainShip.getTransform().getShipToWorldRotation().transformInverse(bearingAxisAfterRot, new Vector3d());
        }
        if (bearingAxisAfterRot.angleCos(data.getBearingAxis()) < 0.9961947 && bearingAxisAfterRot.angleCos(data.getBearingAxis()) > -0.9961947) {
            return (Vector3dc)new Vector3d();
        }
        Intrinsics.checkNotNull((Object)idealRelativeOmega);
        Vector3d otherShipInertia = idealRelativeOmega;
        Vector3d vector3d2 = actualRelativeOmega;
        double other$iv = (double)Math.abs(data.getAngularSpeed()) > 0.001 ? ClockworkConfig.SERVER.getUnlockedModeRotationResistanceMultiplier() : 0.0;
        boolean $i$f$times = false;
        Vector3d vector3d3 = $this$times$iv.mul(other$iv, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d3, (String)"times(...)");
        Vector3dc other$iv2 = (Vector3dc)vector3d3;
        boolean $i$f$minus = false;
        Vector3d angularVelError = $this$minus$iv.sub(other$iv2, new Vector3d());
        Vector3d vector3d4 = bearingAxisInGlobal.mul(bearingAxisInGlobal.dot((Vector3dc)angularVelError), new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d4, (String)"mul(...)");
        Vector3dc angularVelErrorAlongBearingAxis = (Vector3dc)vector3d4;
        Vector3d vector3d5 = angularVelErrorAlongBearingAxis.mul(torqueMassMultiplier * ClockworkConfig.SERVER.getUnlockedModeOmegaErrorMultiplier(), new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d5, (String)"mul(...)");
        return (Vector3dc)vector3d5;
    }

    public final int addPhysBearing(@NotNull PhysBearingData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int n = this.nextBearingID;
        this.nextBearingID = n + 1;
        int id = n;
        this.createdBearings.add((Pair<Integer, PhysBearingData>)new Pair((Object)id, (Object)data));
        return id;
    }

    public final void removePhysBearing(int id) {
        this.removedBearings.add(id);
    }

    public final void updatePhysBearing(int id, @NotNull PhysBearingUpdateData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Integer n = id;
        ((Map)this.bearingUpdateData).put(n, data);
    }

    @JvmStatic
    public static final double getAngle(@NotNull Vector3dc bearingAxis, @NotNull ShipTransform physShipTransform, @Nullable ShipTransform otherPhysShipTransform) {
        return Companion.getAngle(bearingAxis, physShipTransform, otherPhysShipTransform);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J)\u0010\b\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ4\u0010\u0014\u001a\u00020\u0013\"\u0006\b\u0000\u0010\u000f\u0018\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0086\b\u00a2\u0006\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lorg/valkyrienskies/clockwork/content/forces/contraption/BearingController$Companion;", "", "Lorg/joml/Vector3dc;", "bearingAxis", "Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "physShipTransform", "otherPhysShipTransform", "", "getAngle", "(Lorg/joml/Vector3dc;Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;)D", "Lorg/valkyrienskies/core/api/ships/LoadedServerShip;", "ship", "Lorg/valkyrienskies/clockwork/content/forces/contraption/BearingController;", "getOrCreate", "(Lorg/valkyrienskies/core/api/ships/LoadedServerShip;)Lorg/valkyrienskies/clockwork/content/forces/contraption/BearingController;", "T", "Ljava/util/Queue;", "left", "right", "", "areQueuesEqual", "(Ljava/util/Queue;Ljava/util/Queue;)Z", "<init>", "()V", "clockwork"})
    @SourceDebugExtension(value={"SMAP\nBearingController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BearingController.kt\norg/valkyrienskies/clockwork/content/forces/contraption/BearingController$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,317:1\n37#2:318\n36#2,3:319\n*S KotlinDebug\n*F\n+ 1 BearingController.kt\norg/valkyrienskies/clockwork/content/forces/contraption/BearingController$Companion\n*L\n313#1:318\n313#1:319,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final double getAngle(@NotNull Vector3dc bearingAxis, @NotNull ShipTransform physShipTransform, @Nullable ShipTransform otherPhysShipTransform) {
            Vector3d vector3d;
            Intrinsics.checkNotNullParameter((Object)bearingAxis, (String)"bearingAxis");
            Intrinsics.checkNotNullParameter((Object)physShipTransform, (String)"physShipTransform");
            Vector3d bearingAxisInGlobal = bearingAxis.get(new Vector3d());
            ShipTransform shipTransform = otherPhysShipTransform;
            if (shipTransform != null && (shipTransform = shipTransform.getShipToWorldRotation()) != null) {
                shipTransform.transform(bearingAxisInGlobal);
            }
            if (Math.abs(bearingAxis.x()) == 1.0) {
                vector3d = new Vector3d(0.0, 1.0, 0.0);
            } else if (Math.abs(bearingAxis.y()) == 1.0) {
                vector3d = new Vector3d(1.0, 0.0, 0.0);
            } else if (Math.abs(bearingAxis.z()) == 1.0) {
                vector3d = new Vector3d(0.0, 1.0, 0.0);
            } else {
                throw new RuntimeException("incorrect data");
            }
            Vector3d perpendicularAxis = vector3d;
            Vector3d vector3d2 = perpendicularAxis.rotate(physShipTransform.getShipToWorldRotation(), new Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"rotate(...)");
            Vector3dc perpAfterRot = (Vector3dc)vector3d2;
            ShipTransform shipTransform2 = otherPhysShipTransform;
            perpAfterRot = shipTransform2 != null && (shipTransform2 = shipTransform2.getShipToWorldRotation()) != null && (shipTransform2 = shipTransform2.transformInverse(perpAfterRot, new Vector3d())) != null ? (Vector3dc)shipTransform2 : perpAfterRot;
            Vector3d vector3d3 = perpAfterRot.sub((Vector3dc)bearingAxis.mul(bearingAxis.dot(perpAfterRot), new Vector3d()), new Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d3, (String)"sub(...)");
            Vector3dc perpAfterRotInPlane = (Vector3dc)vector3d3;
            double angleBTShipInRadians = perpAfterRotInPlane.angle((Vector3dc)perpendicularAxis);
            Vector3d vector3d4 = perpAfterRotInPlane.cross((Vector3dc)perpendicularAxis, new Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d4, (String)"cross(...)");
            Vector3dc crossOfYourMother = (Vector3dc)vector3d4;
            double angleWRespectToBearingAxis = crossOfYourMother.lengthSquared() > 1.0E-12 ? angleBTShipInRadians * Math.signum(crossOfYourMother.dot(bearingAxis)) * (double)-1 : 0.0;
            return angleWRespectToBearingAxis;
        }

        @Nullable
        public final BearingController getOrCreate(@NotNull LoadedServerShip ship) {
            Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
            if (ship.getAttachment(BearingController.class) == null) {
                ship.setAttachment((Object)new BearingController());
            }
            return (BearingController)ship.getAttachment(BearingController.class);
        }

        public final /* synthetic */ <T> boolean areQueuesEqual(Queue<T> left, Queue<T> right) {
            Intrinsics.checkNotNullParameter(left, (String)"left");
            Intrinsics.checkNotNullParameter(right, (String)"right");
            boolean $i$f$areQueuesEqual = false;
            Collection $this$toTypedArray$iv = left;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Intrinsics.reifiedOperationMarker((int)0, (String)"T?");
            Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
            Collection $this$toTypedArray$iv2 = right;
            boolean $i$f$toTypedArray2 = false;
            Collection thisCollection$iv2 = $this$toTypedArray$iv2;
            Intrinsics.reifiedOperationMarker((int)0, (String)"T?");
            Object[] objectArray2 = thisCollection$iv2.toArray(new Object[0]);
            return Arrays.equals(objectArray, objectArray2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

