/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.forces;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.valkyrienskies.clockwork.content.propulsion.sugar_rocket.SugarRocketData;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ShipPhysicsListener;
import org.valkyrienskies.core.api.world.PhysLevel;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 &2\u00020\u0001:\u0001&B\u0007\u00a2\u0006\u0004\b$\u0010%J\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ%\u0010\u000f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0011\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0011\u0010\u0012R)\u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00140\u00138\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u001d\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00150\u00138\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0018\u001a\u0004\b\u001c\u0010\u001aR'\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\u001e0\u001dj\b\u0012\u0004\u0012\u00020\u001e`\u001f8\u0006\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#\u00a8\u0006'"}, d2={"Lorg/valkyrienskies/clockwork/content/forces/SugarRocketController;", "Lorg/valkyrienskies/core/api/ships/ShipPhysicsListener;", "Lorg/valkyrienskies/core/api/ships/PhysShip;", "physShip", "Lorg/valkyrienskies/core/api/world/PhysLevel;", "physLevel", "", "physTick", "(Lorg/valkyrienskies/core/api/ships/PhysShip;Lorg/valkyrienskies/core/api/world/PhysLevel;)V", "Lnet/minecraft/core/BlockPos;", "pos", "", "force", "Lnet/minecraft/core/Direction;", "direction", "addRocket", "(Lnet/minecraft/core/BlockPos;DLnet/minecraft/core/Direction;)V", "removeRocket", "(Lnet/minecraft/core/BlockPos;)V", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lkotlin/Pair;", "Lorg/joml/Vector3i;", "Lorg/joml/Vector3d;", "newRockets", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "getNewRockets", "()Ljava/util/concurrent/ConcurrentLinkedQueue;", "removedRockets", "getRemovedRockets", "Ljava/util/HashSet;", "Lorg/valkyrienskies/clockwork/content/propulsion/sugar_rocket/SugarRocketData;", "Lkotlin/collections/HashSet;", "burningRockets", "Ljava/util/HashSet;", "getBurningRockets", "()Ljava/util/HashSet;", "<init>", "()V", "Companion", "clockwork"})
@SourceDebugExtension(value={"SMAP\nSugarRocketController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SugarRocketController.kt\norg/valkyrienskies/clockwork/content/forces/SugarRocketController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n1863#2,2:64\n*S KotlinDebug\n*F\n+ 1 SugarRocketController.kt\norg/valkyrienskies/clockwork/content/forces/SugarRocketController\n*L\n36#1:64,2\n*E\n"})
public final class SugarRocketController
implements ShipPhysicsListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentLinkedQueue<Pair<Vector3i, Vector3d>> newRockets = new ConcurrentLinkedQueue();
    @NotNull
    private final ConcurrentLinkedQueue<Vector3i> removedRockets = new ConcurrentLinkedQueue();
    @NotNull
    private final HashSet<SugarRocketData> burningRockets = new HashSet();

    @NotNull
    public final ConcurrentLinkedQueue<Pair<Vector3i, Vector3d>> getNewRockets() {
        return this.newRockets;
    }

    @NotNull
    public final ConcurrentLinkedQueue<Vector3i> getRemovedRockets() {
        return this.removedRockets;
    }

    @NotNull
    public final HashSet<SugarRocketData> getBurningRockets() {
        return this.burningRockets;
    }

    public void physTick(@NotNull PhysShip physShip, @NotNull PhysLevel physLevel) {
        Vector3i rocket;
        Intrinsics.checkNotNullParameter((Object)physShip, (String)"physShip");
        Intrinsics.checkNotNullParameter((Object)physLevel, (String)"physLevel");
        while (!((Collection)this.newRockets).isEmpty()) {
            rocket = this.newRockets.poll();
            this.burningRockets.add(new SugarRocketData((Vector3ic)rocket.getFirst(), (Vector3dc)rocket.getSecond()));
        }
        while (!((Collection)this.removedRockets).isEmpty()) {
            rocket = this.removedRockets.poll();
            this.burningRockets.removeIf(arg_0 -> SugarRocketController.physTick$lambda$1(arg_0 -> SugarRocketController.physTick$lambda$0(rocket, arg_0), arg_0));
        }
        Iterable $this$forEach$iv = this.burningRockets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SugarRocketData data = (SugarRocketData)element$iv;
            boolean bl = false;
            Vector3d shipPos = new Vector3d(data.getPosition()).add(0.5, 0.5, 0.5, new Vector3d());
            Vector3dc vector3dc = data.getForce();
            Intrinsics.checkNotNull((Object)vector3dc);
            Intrinsics.checkNotNull((Object)shipPos);
            physShip.applyModelForce(vector3dc, (Vector3dc)shipPos);
        }
    }

    public final void addRocket(@NotNull BlockPos pos, double force, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Vector3i vector3i = VectorConversionsMCKt.toJOML((Vec3i)((Vec3i)pos));
        Vec3i vec3i = direction.m_122436_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3i, (String)"getNormal(...)");
        this.newRockets.add((Pair<Vector3i, Vector3d>)new Pair((Object)vector3i, (Object)VectorConversionsMCKt.toJOMLD((Vec3i)vec3i).mul(force * (double)10)));
    }

    public final void removeRocket(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        this.removedRockets.add(VectorConversionsMCKt.toJOML((Vec3i)((Vec3i)pos)));
    }

    private static final boolean physTick$lambda$0(Vector3i $rocket, SugarRocketData data) {
        return Intrinsics.areEqual((Object)data.getPosition(), (Object)$rocket);
    }

    private static final boolean physTick$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/valkyrienskies/clockwork/content/forces/SugarRocketController$Companion;", "", "Lorg/valkyrienskies/core/api/ships/LoadedServerShip;", "ship", "Lorg/valkyrienskies/clockwork/content/forces/SugarRocketController;", "getOrCreate", "(Lorg/valkyrienskies/core/api/ships/LoadedServerShip;)Lorg/valkyrienskies/clockwork/content/forces/SugarRocketController;", "<init>", "()V", "clockwork"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SugarRocketController getOrCreate(@NotNull LoadedServerShip ship) {
            Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
            SugarRocketController attachment = (SugarRocketController)ship.getAttachment(SugarRocketController.class);
            if (attachment == null) {
                SugarRocketController newAttachment = new SugarRocketController();
                ship.setAttachment((Object)newAttachment);
                return newAttachment;
            }
            return attachment;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

