/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.forces;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.AxisAngle4d;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3ic;
import org.valkyrienskies.clockwork.content.contraptions.propeller.blades.BladeData;
import org.valkyrienskies.clockwork.content.contraptions.propeller.data.PropCreateData;
import org.valkyrienskies.clockwork.content.contraptions.propeller.data.PropData;
import org.valkyrienskies.clockwork.content.contraptions.propeller.data.PropUpdateData;
import org.valkyrienskies.clockwork.content.forces.MultiInstanceForceApplier;
import org.valkyrienskies.core.api.ships.DragController;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.api.world.PhysLevel;
import org.valkyrienskies.core.internal.ships.VsiPhysShip;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u001a\b\u0007\u0018\u0000 @2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0001@B\u007f\u0012$\b\u0002\u0010#\u001a\u001e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00030 j\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u0003`\"\u0012\u001a\b\u0002\u0010(\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00020\u00120'\u0012\u001a\b\u0002\u0010,\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00040\u00120'\u0012\u000e\b\u0002\u0010.\u001a\b\u0012\u0004\u0012\u00020!0'\u0012\b\b\u0002\u00100\u001a\u00020!\u00a2\u0006\u0004\b>\u0010?J\u001f\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJK\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u00122\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J/\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J3\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u00122\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001b\u0010\u001e\u001a\u00020\t2\n\u0010\u001d\u001a\u00060\u001bj\u0002`\u001cH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fR6\u0010#\u001a\u001e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00030 j\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u0003`\"8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&R,\u0010(\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00020\u00120'8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+R,\u0010,\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00040\u00120'8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b,\u0010)\u001a\u0004\b-\u0010+R \u0010.\u001a\b\u0012\u0004\u0012\u00020!0'8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b.\u0010)\u001a\u0004\b/\u0010+R\"\u00100\u001a\u00020!8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b0\u00101\u001a\u0004\b2\u00103\"\u0004\b4\u00105R&\u00106\u001a\u00060\u001bj\u0002`\u001c8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b6\u00107\u001a\u0004\b8\u00109\"\u0004\b:\u0010\u001fR\"\u0010;\u001a\u00020!8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b;\u00101\u001a\u0004\b<\u00103\"\u0004\b=\u00105\u00a8\u0006A"}, d2={"Lorg/valkyrienskies/clockwork/content/forces/PropellerController;", "Lorg/valkyrienskies/clockwork/content/forces/MultiInstanceForceApplier;", "Lorg/valkyrienskies/clockwork/content/contraptions/propeller/data/PropUpdateData;", "Lorg/valkyrienskies/clockwork/content/contraptions/propeller/data/PropData;", "Lorg/valkyrienskies/clockwork/content/contraptions/propeller/data/PropCreateData;", "Lorg/valkyrienskies/core/api/ships/PhysShip;", "physShip", "Lorg/valkyrienskies/core/api/world/PhysLevel;", "physLevel", "", "physTick", "(Lorg/valkyrienskies/core/api/ships/PhysShip;Lorg/valkyrienskies/core/api/world/PhysLevel;)V", "Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "physTransform", "physProp", "Lorg/joml/Vector3dc;", "vel", "omega", "Lkotlin/Pair;", "computeForce", "(Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;Lorg/valkyrienskies/clockwork/content/contraptions/propeller/data/PropData;Lorg/joml/Vector3dc;Lorg/joml/Vector3dc;Lorg/valkyrienskies/core/api/ships/PhysShip;Lorg/valkyrienskies/core/api/world/PhysLevel;)Lkotlin/Pair;", "furthestTip", "angVel", "conserveMomentum", "(Lorg/valkyrienskies/core/api/ships/PhysShip;Lorg/valkyrienskies/clockwork/content/contraptions/propeller/data/PropData;Lorg/joml/Vector3dc;Lorg/joml/Vector3dc;)Lorg/joml/Vector3dc;", "computeBladeForce", "(Lorg/valkyrienskies/core/api/ships/PhysShip;Lorg/valkyrienskies/clockwork/content/contraptions/propeller/data/PropData;Lorg/valkyrienskies/core/api/world/PhysLevel;)Lkotlin/Pair;", "", "Lorg/valkyrienskies/core/api/world/properties/DimensionId;", "dimID", "setDimension", "(Ljava/lang/String;)V", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "appliers", "Ljava/util/HashMap;", "getAppliers", "()Ljava/util/HashMap;", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "applierUpdateData", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "getApplierUpdateData", "()Ljava/util/concurrent/ConcurrentLinkedQueue;", "createdAppliers", "getCreatedAppliers", "removedAppliers", "getRemovedAppliers", "nextApplierID", "I", "getNextApplierID", "()I", "setNextApplierID", "(I)V", "dimensionId", "Ljava/lang/String;", "getDimensionId", "()Ljava/lang/String;", "setDimensionId", "ticksSinceLastUpdate", "getTicksSinceLastUpdate", "setTicksSinceLastUpdate", "<init>", "(Ljava/util/HashMap;Ljava/util/concurrent/ConcurrentLinkedQueue;Ljava/util/concurrent/ConcurrentLinkedQueue;Ljava/util/concurrent/ConcurrentLinkedQueue;I)V", "Companion", "clockwork"})
@SourceDebugExtension(value={"SMAP\nPropellerController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropellerController.kt\norg/valkyrienskies/clockwork/content/forces/PropellerController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,373:1\n1#2:374\n*E\n"})
public final class PropellerController
implements MultiInstanceForceApplier<PropUpdateData, PropData, PropCreateData> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<Integer, PropData> appliers;
    @NotNull
    private final ConcurrentLinkedQueue<Pair<Integer, PropUpdateData>> applierUpdateData;
    @NotNull
    private final ConcurrentLinkedQueue<Pair<Integer, PropCreateData>> createdAppliers;
    @NotNull
    private final ConcurrentLinkedQueue<Integer> removedAppliers;
    private int nextApplierID;
    @NotNull
    private String dimensionId;
    private int ticksSinceLastUpdate;

    public PropellerController(@NotNull HashMap<Integer, PropData> appliers, @NotNull ConcurrentLinkedQueue<Pair<Integer, PropUpdateData>> applierUpdateData, @NotNull ConcurrentLinkedQueue<Pair<Integer, PropCreateData>> createdAppliers, @NotNull ConcurrentLinkedQueue<Integer> removedAppliers, int nextApplierID) {
        Intrinsics.checkNotNullParameter(appliers, (String)"appliers");
        Intrinsics.checkNotNullParameter(applierUpdateData, (String)"applierUpdateData");
        Intrinsics.checkNotNullParameter(createdAppliers, (String)"createdAppliers");
        Intrinsics.checkNotNullParameter(removedAppliers, (String)"removedAppliers");
        this.appliers = appliers;
        this.applierUpdateData = applierUpdateData;
        this.createdAppliers = createdAppliers;
        this.removedAppliers = removedAppliers;
        this.nextApplierID = nextApplierID;
        this.dimensionId = "minecraft:dimension:minecraft:overworld";
    }

    public /* synthetic */ PropellerController(HashMap hashMap, ConcurrentLinkedQueue concurrentLinkedQueue, ConcurrentLinkedQueue concurrentLinkedQueue2, ConcurrentLinkedQueue concurrentLinkedQueue3, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            hashMap = new HashMap<Integer, PropData>();
        }
        if ((n2 & 2) != 0) {
            concurrentLinkedQueue = new ConcurrentLinkedQueue<Pair<Integer, PropUpdateData>>();
        }
        if ((n2 & 4) != 0) {
            concurrentLinkedQueue2 = new ConcurrentLinkedQueue<Pair<Integer, PropCreateData>>();
        }
        if ((n2 & 8) != 0) {
            concurrentLinkedQueue3 = new ConcurrentLinkedQueue<Integer>();
        }
        if ((n2 & 0x10) != 0) {
            n = 0;
        }
        this(hashMap, concurrentLinkedQueue, concurrentLinkedQueue2, concurrentLinkedQueue3, n);
    }

    @Override
    @NotNull
    public HashMap<Integer, PropData> getAppliers() {
        return this.appliers;
    }

    @Override
    @NotNull
    public ConcurrentLinkedQueue<Pair<Integer, PropUpdateData>> getApplierUpdateData() {
        return this.applierUpdateData;
    }

    @Override
    @NotNull
    public ConcurrentLinkedQueue<Pair<Integer, PropCreateData>> getCreatedAppliers() {
        return this.createdAppliers;
    }

    @Override
    @NotNull
    public ConcurrentLinkedQueue<Integer> getRemovedAppliers() {
        return this.removedAppliers;
    }

    @Override
    public int getNextApplierID() {
        return this.nextApplierID;
    }

    @Override
    public void setNextApplierID(int n) {
        this.nextApplierID = n;
    }

    @NotNull
    public final String getDimensionId() {
        return this.dimensionId;
    }

    public final void setDimensionId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.dimensionId = string;
    }

    public final int getTicksSinceLastUpdate() {
        return this.ticksSinceLastUpdate;
    }

    public final void setTicksSinceLastUpdate(int n) {
        this.ticksSinceLastUpdate = n;
    }

    @Override
    public void physTick(@NotNull PhysShip physShip, @NotNull PhysLevel physLevel) {
        Intrinsics.checkNotNullParameter((Object)physShip, (String)"physShip");
        Intrinsics.checkNotNullParameter((Object)physLevel, (String)"physLevel");
        if (!((Collection)this.getApplierUpdateData()).isEmpty()) {
            this.ticksSinceLastUpdate = 0;
        }
        MultiInstanceForceApplier.super.physTick(physShip, physLevel);
        Iterator<PropData> iterator = this.getAppliers().values().iterator();
        while (iterator.hasNext()) {
            PropData physData;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            if (!physData.getActive()) continue;
            Pair<Vector3dc, Vector3dc> pair = physData.getBrass() ? this.computeForce(physShip.getTransform(), physData, physShip.getVelocity(), physShip.getOmega(), physShip, physLevel) : this.computeBladeForce(physShip, physData, physLevel);
            Vector3dc force = (Vector3dc)pair.component1();
            Vector3dc torque = (Vector3dc)pair.component2();
            if (!force.isFinite() || !torque.isFinite()) continue;
            if (physData.getBrass()) {
                PhysShip.applyWorldForceToBodyPos$default((PhysShip)physShip, (Vector3dc)force, null, (int)2, null);
                physShip.applyWorldTorque(torque);
                continue;
            }
            Vector3d vector3d = new Vector3d(physData.getPosition()).add(0.5, 0.5, 0.5);
            Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"add(...)");
            physShip.applyWorldForceToModelPos(force, (Vector3dc)vector3d);
            physShip.applyWorldTorque(torque);
        }
        int n = this.ticksSinceLastUpdate;
        this.ticksSinceLastUpdate = n + 1;
    }

    private final Pair<Vector3dc, Vector3dc> computeForce(ShipTransform physTransform, PropData physProp, Vector3dc vel, Vector3dc omega, PhysShip physShip, PhysLevel physLevel) {
        Vector3dc vector3dc;
        double estAngle = (physProp.getBearingAngle() + physProp.getBearingSpeed() / 3.0 * (double)this.ticksSinceLastUpdate) % 360.0;
        Intrinsics.checkNotNull((Object)physShip, (String)"null cannot be cast to non-null type org.valkyrienskies.core.internal.ships.VsiPhysShip");
        VsiPhysShip internal = (VsiPhysShip)physShip;
        DragController dragController = internal.getDragController();
        DragController dragController2 = dragController;
        if (dragController2 == null || (dragController2 = dragController2.getWindVector()) == null) {
            dragController2 = (Vector3dc)new Vector3d();
        }
        DragController wind = dragController2;
        double it = Math.signum(physProp.getBearingSpeed());
        boolean bl = false;
        double omegaSign = it == 0.0 ? 1.0 : it;
        Vector3d vector3d = new Vector3d(physProp.getPosition()).add(0.5, 0.5, 0.5);
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"add(...)");
        Vector3dc bearingVector = (Vector3dc)vector3d;
        if (physProp.getBearingAxisRot() != null) {
            Vector3dc vector3dc2 = physProp.getBearingAxisRot();
            vector3dc = vector3dc2;
            Intrinsics.checkNotNull((Object)vector3dc2);
        } else {
            Vector3dc vector3dc3 = physProp.getBearingAxis();
            vector3dc = vector3dc3;
            Intrinsics.checkNotNull((Object)vector3dc3);
        }
        Vector3dc referencePropAxis = vector3dc;
        Vector3d vector3d2 = referencePropAxis.mul(omegaSign, new Vector3d()).normalize();
        Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"normalize(...)");
        Vector3dc axis = (Vector3dc)vector3d2;
        Quaterniondc rotation = (Quaterniondc)new Quaterniond(new AxisAngle4d(Math.toRadians(estAngle), axis));
        Vector3d vector3d3 = axis.mul(Math.abs(physProp.getBearingSpeed()), new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d3, (String)"mul(...)");
        Vector3dc angVel = (Vector3dc)vector3d3;
        Vector3d furthestTip = new Vector3d();
        Vector3d worldAxis = physShip.getTransform().getShipToWorld().transformDirection(axis, new Vector3d()).normalize(new Vector3d());
        double axialVelocity = physShip.getVelocity().dot((Vector3dc)worldAxis);
        double pretendPitch = 12.0;
        Vector3d netForce = new Vector3d();
        Vector3d netTorque = new Vector3d();
        Quaterniondc quaterniondc = physProp.getBearingTiltQuat();
        if (quaterniondc == null) {
            quaterniondc = (Quaterniondc)new Quaterniond();
        }
        Quaterniondc tiltQuat = quaterniondc;
        double eps = 1.0E-6;
        List<Vector3ic> list = physProp.getSailPositions();
        Intrinsics.checkNotNull(list);
        for (Vector3ic pos : list) {
            Vector3d vector3d4 = new Vector3d(pos).add(bearingVector);
            Intrinsics.checkNotNullExpressionValue((Object)vector3d4, (String)"add(...)");
            Vector3dc sailVector = (Vector3dc)vector3d4;
            Vector3dc diff = (Vector3dc)new Vector3d(pos);
            double offsetFalloff = new Vector3d(referencePropAxis).dot(diff);
            if (offsetFalloff > 4.0) continue;
            Vector3d vector3d5 = tiltQuat.transform((Vector3dc)rotation.transform(diff, new Vector3d()), new Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d5, (String)"transform(...)");
            Vector3dc rotatedDiffShip = (Vector3dc)vector3d5;
            Vector3d rotatedPosShip = rotatedDiffShip.add(bearingVector, new Vector3d());
            Vector3d vector3d6 = physTransform.getShipToWorld().transformPosition((Vector3dc)rotatedPosShip, new Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d6, (String)"transformPosition(...)");
            Vector3dc sailPosWorld = (Vector3dc)vector3d6;
            Vector3d rWorld = new Vector3d(sailPosWorld).sub(physTransform.getPositionInWorld(), new Vector3d());
            Vector3d vShipAtSailWorld = new Vector3d((Vector3dc)vel.add((Vector3dc)wind, new Vector3d())).add((Vector3dc)new Vector3d(omega).cross((Vector3dc)rWorld, new Vector3d()), new Vector3d());
            Vector3d vPropAtBladeShip = new Vector3d(angVel).cross(rotatedDiffShip, new Vector3d());
            Vector3d vPropAtBladeWorld = physTransform.getShipToWorld().transformDirection((Vector3dc)vPropAtBladeShip, new Vector3d());
            Vector3d vRelWorld = new Vector3d((Vector3dc)vShipAtSailWorld).add((Vector3dc)vPropAtBladeWorld).negate();
            if (rotatedDiffShip.length() > furthestTip.length()) {
                furthestTip.set(rotatedDiffShip);
            }
            double vAxial = vRelWorld.dot((Vector3dc)worldAxis);
            Vector3d vAxialVec = new Vector3d((Vector3dc)worldAxis).mul(vAxial);
            Vector3d vTanVec = new Vector3d((Vector3dc)vRelWorld).sub((Vector3dc)vAxialVec);
            double vTan = vTanVec.length();
            double inflowAngle = Math.atan2(vAxial, Math.max(vTan, eps));
            double optimalAngleOfAttack = Math.toRadians(4.0);
            double optimalPitch = inflowAngle + optimalAngleOfAttack;
            double minPitch = Math.toRadians(-5.0);
            double maxPitch = Math.toRadians(30.0);
            double pitch = RangesKt.coerceIn((double)(physProp.getBrass() ? (double)Mth.m_14179_((float)0.05f, (float)((float)physProp.getCurrentBladePitch()), (float)((float)optimalPitch)) : Math.toRadians(12.0)), (double)minPitch, (double)maxPitch);
            physProp.setCurrentBladePitch(pitch);
            double angleOfAttack = physProp.getCurrentBladePitch() - inflowAngle;
            double vUseful = Math.max(Math.abs(vAxial), 1.0);
            double maxSailPowerWatts = 10000.0;
            double rho = physLevel.getAerodynamicUtils().getAirDensityForY(sailPosWorld.y(), this.dimensionId);
            double v2 = vRelWorld.lengthSquared();
            double liftCoefficient = Math.PI * 2 * angleOfAttack;
            double dragCoefficient = 0.01 + 0.01 * Math.pow(liftCoefficient, 2.0);
            double q = 0.5 * rho * v2;
            double dLift = q * liftCoefficient;
            double dDrag = q * dragCoefficient;
            double vtMin = 0.5;
            double vtFade = 2.0;
            double spinFactor = RangesKt.coerceIn((double)((Math.abs(physProp.getBearingSpeed()) - vtMin) / vtFade), (double)0.0, (double)1.0);
            double sf = spinFactor * spinFactor * (3.0 - 2.0 * spinFactor);
            double dThrust = (dLift * Math.cos(-inflowAngle) - dDrag * Math.sin(-inflowAngle)) * sf;
            double thrustCap = maxSailPowerWatts / vUseful;
            double dThrustCapped = RangesKt.coerceIn((double)dThrust, (double)(-thrustCap), (double)thrustCap);
            Vector3d force = worldAxis.mul(dThrustCapped, new Vector3d());
            Vector3d torque = rWorld.cross((Vector3dc)force.mul(omegaSign, new Vector3d()), new Vector3d());
            force.mul(10.0);
            if (offsetFalloff > 1.0E-4) {
                force.div(offsetFalloff);
            }
            if (offsetFalloff > 1.0E-4) {
                torque.div(offsetFalloff);
            }
            if (force.isFinite()) {
                netForce.add((Vector3dc)force.mul(omegaSign, new Vector3d()));
            }
            if (!torque.isFinite()) continue;
            netTorque.add((Vector3dc)torque);
        }
        return new Pair((Object)netForce, (Object)netTorque);
    }

    private final Vector3dc conserveMomentum(PhysShip physShip, PropData physProp, Vector3dc furthestTip, Vector3dc angVel) {
        Vector3dc prevAngMomentumRelProp = (Vector3dc)new Vector3d();
        if (physProp.getPrevAngularMomentum() != null) {
            Vector3dc vector3dc = physProp.getPrevAngularMomentum();
            Intrinsics.checkNotNull((Object)vector3dc);
            prevAngMomentumRelProp = vector3dc;
        }
        if (Math.abs(angVel.length()) < 1.0E-4) {
            return (Vector3dc)new Vector3d();
        }
        Vector3dc propAxis = (Vector3dc)new Vector3d(physProp.getBearingAxis());
        double propSpeed = physProp.getBearingSpeed();
        Vector3d rotVel = angVel.mul(-1.0, new Vector3d());
        Vector3d vector3d = new Vector3d(propAxis).mul((Vector3dc)rotVel);
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"mul(...)");
        Vector3dc angularVelocityPropeller = (Vector3dc)vector3d;
        Vector3d vector3d2 = angularVelocityPropeller.mul(physShip.getMomentOfInertia(), new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"mul(...)");
        Vector3dc angularMomentumRelProp = (Vector3dc)vector3d2;
        Vector3dc centerOfMassInShip = physShip.getTransform().getPositionInShip();
        Vector3d vector3d3 = new Vector3d((Vector3dc)centerOfMassInShip.add((Vector3dc)new Vector3d(physProp.getPosition()), new Vector3d())).sub(physShip.getTransform().getPositionInShip()).rotate(physShip.getTransform().getShipToWorldRotation());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d3, (String)"rotate(...)");
        Vector3dc r = (Vector3dc)vector3d3;
        Vector3d vector3d4 = new Vector3d(physShip.getOmega()).cross(r).mul(physShip.getMass());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d4, (String)"mul(...)");
        Vector3dc momentumModifier = (Vector3dc)vector3d4;
        Vector3d vector3d5 = new Vector3d(angularMomentumRelProp).add(momentumModifier);
        Intrinsics.checkNotNullExpressionValue((Object)vector3d5, (String)"add(...)");
        Vector3dc angularMomentumRelShip = (Vector3dc)vector3d5;
        Vector3d vector3d6 = new Vector3d(prevAngMomentumRelProp).add(momentumModifier);
        Intrinsics.checkNotNullExpressionValue((Object)vector3d6, (String)"add(...)");
        Vector3dc prevAngularMomentumRelShip = (Vector3dc)vector3d6;
        Vector3d vector3d7 = new Vector3d(prevAngularMomentumRelShip).sub(angularMomentumRelShip).div(60.0);
        Intrinsics.checkNotNullExpressionValue((Object)vector3d7, (String)"div(...)");
        Vector3dc torque = (Vector3dc)vector3d7;
        physProp.setPrevAngularMomentum(angularMomentumRelProp);
        if (!torque.isFinite() || Double.isNaN(torque.length())) {
            return (Vector3dc)new Vector3d();
        }
        return torque;
    }

    private final Pair<Vector3dc, Vector3dc> computeBladeForce(PhysShip physShip, PropData physProp, PhysLevel physLevel) {
        Vector3dc vector3dc;
        Vector3dc vector3dc2;
        double estAngle = (physProp.getBearingAngle() + physProp.getBearingSpeed() / 3.0 * (double)this.ticksSinceLastUpdate) % 360.0;
        List<BladeData> blades = physProp.getBlades();
        int bladeCount = blades.size();
        double angleBetweenBlades = Math.PI * 2 / (double)bladeCount;
        Intrinsics.checkNotNull((Object)physShip, (String)"null cannot be cast to non-null type org.valkyrienskies.core.internal.ships.VsiPhysShip");
        VsiPhysShip internal = (VsiPhysShip)physShip;
        DragController dragController = internal.getDragController();
        DragController dragController2 = dragController;
        if (dragController2 == null || (dragController2 = dragController2.getWindVector()) == null) {
            dragController2 = (Vector3dc)new Vector3d();
        }
        DragController wind = dragController2;
        double airDensityAtY = physLevel.getAerodynamicUtils().getAirDensityForY(physShip.getTransform().getPositionInWorld().y(), this.dimensionId);
        double airTemperatureAtY = physLevel.getAerodynamicUtils().getAirTemperatureForY(physShip.getTransform().getPositionInWorld().y(), this.dimensionId);
        Vector3dc vector3dc3 = physProp.getBearingAxis();
        Vec3i vec3i = Direction.UP.m_122436_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3i, (String)"getNormal(...)");
        if (Intrinsics.areEqual((Object)vector3dc3, (Object)VectorConversionsMCKt.toJOMLD((Vec3i)vec3i))) {
            Vec3i vec3i2 = Direction.NORTH.m_122436_();
            Intrinsics.checkNotNullExpressionValue((Object)vec3i2, (String)"getNormal(...)");
            vector3dc2 = (Vector3dc)VectorConversionsMCKt.toJOMLD((Vec3i)vec3i2);
        } else {
            Vec3i vec3i3 = Direction.UP.m_122436_();
            Intrinsics.checkNotNullExpressionValue((Object)vec3i3, (String)"getNormal(...)");
            vector3dc2 = (Vector3dc)VectorConversionsMCKt.toJOMLD((Vec3i)vec3i3);
        }
        Vector3dc clockwiseAxis = vector3dc2;
        double it = Math.signum(physProp.getBearingSpeed());
        boolean bl = false;
        double omegaSign = it == 0.0 ? 1.0 : it;
        if (physProp.getBearingAxisRot() != null) {
            Vector3dc vector3dc4 = physProp.getBearingAxisRot();
            vector3dc = vector3dc4;
            Intrinsics.checkNotNull((Object)vector3dc4);
        } else {
            Vector3dc vector3dc5 = physProp.getBearingAxis();
            vector3dc = vector3dc5;
            Intrinsics.checkNotNull((Object)vector3dc5);
        }
        Vector3dc referencePropAxis = vector3dc;
        Vector3d worldAxis = physShip.getTransform().getShipToWorld().transformDirection(referencePropAxis, new Vector3d()).normalize(new Vector3d());
        Vector3d vector3d = physShip.getVelocity().add((Vector3dc)wind, new Vector3d());
        Vector3dc vector3dc6 = physShip.getAngularVelocity();
        Vector3ic vector3ic = physProp.getPosition();
        Intrinsics.checkNotNull((Object)vector3ic);
        Vector3d totalVelocityAtProp = vector3d.add((Vector3dc)vector3dc6.cross((Vector3dc)new Vector3d(vector3ic).sub(physShip.getCenterOfMass(), new Vector3d()).add(0.5, 0.5, 0.5), new Vector3d()), new Vector3d());
        double velocityTowardsPropellerDir = totalVelocityAtProp.dot((Vector3dc)worldAxis);
        if (Double.isNaN(velocityTowardsPropellerDir) || Double.isInfinite(velocityTowardsPropellerDir)) {
            return TuplesKt.to((Object)new Vector3d(), (Object)new Vector3d());
        }
        double velocityFalloff = 1.0 - 1.0 / (1.0 + Math.exp(((double)331 - Math.abs(velocityTowardsPropellerDir)) / 30.0));
        double induced = 0.5;
        Vector3d netForce = new Vector3d();
        Vector3d netTorque = new Vector3d();
        int n = ((Collection)blades).size();
        for (int i = 0; i < n; ++i) {
            BladeData blade = blades.get(i);
            double bladeAngle = Math.toRadians(estAngle + angleBetweenBlades * (double)i);
            double bladePitch = -Math.toRadians(blade.getAngle());
            double bladeWidth = blade.getWide() ? 0.375 : 0.25;
            double r = blade.getLength();
            Vector3d rotatedDist = clockwiseAxis.mul(r, new Vector3d()).rotateAxis(bladeAngle, referencePropAxis.x(), referencePropAxis.y(), referencePropAxis.z(), new Vector3d());
            double rotationalVelocity = Math.abs(physProp.getBearingSpeed()) * r;
            double absVt = Math.abs(rotationalVelocity);
            if (absVt < 1.0E-4) continue;
            double vtMin = 0.5;
            double vtFade = 2.0;
            double spinFactor = RangesKt.coerceIn((double)((Math.abs(rotationalVelocity) - vtMin) / vtFade), (double)0.0, (double)1.0);
            double sf = spinFactor * spinFactor * (3.0 - 2.0 * spinFactor);
            double phi = Math.atan2(velocityTowardsPropellerDir, rotationalVelocity);
            double angleOfAttack = bladePitch - phi;
            double liftCoefficient = Math.PI * 2 * angleOfAttack;
            double dragCoefficient = 0.01 + 0.01 * Math.pow(liftCoefficient, 2.0);
            double vA = -velocityTowardsPropellerDir + induced;
            double effectiveVelocity = Math.sqrt(vA * vA + rotationalVelocity * rotationalVelocity);
            double dA = bladeWidth * r;
            double q = 0.5 * airDensityAtY * Math.pow(effectiveVelocity, 2.0);
            double dLift = q * dA * liftCoefficient;
            double dDrag = q * dA * dragCoefficient;
            double dThrust = (dLift * Math.cos(phi) - dDrag * Math.sin(phi)) * sf * velocityFalloff;
            Vector3d force = worldAxis.mul(dThrust * (double)10, new Vector3d()).mul(omegaSign, new Vector3d());
            netForce.add((Vector3dc)force);
            netTorque.add((Vector3dc)new Vector3d());
        }
        return TuplesKt.to((Object)netForce, (Object)netTorque);
    }

    private final void setDimension(String dimID) {
        this.dimensionId = dimID;
    }

    public PropellerController() {
        this(null, null, null, null, 0, 31, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J5\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lorg/valkyrienskies/clockwork/content/forces/PropellerController$Companion;", "", "Lorg/valkyrienskies/core/api/ships/LoadedServerShip;", "ship", "Lorg/valkyrienskies/clockwork/content/forces/PropellerController;", "getOrCreate", "(Lorg/valkyrienskies/core/api/ships/LoadedServerShip;)Lorg/valkyrienskies/clockwork/content/forces/PropellerController;", "", "velocityTowardsPropellerDir", "bladeRotationalSpeed", "bladeLength", "bladeAngle", "bladeWidth", "calculateBladePower", "(DDDDD)D", "<init>", "()V", "clockwork"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final PropellerController getOrCreate(@NotNull LoadedServerShip ship) {
            Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
            if (ship.getAttachment(PropellerController.class) == null) {
                PropellerController controller = new PropellerController(null, null, null, null, 0, 31, null);
                controller.setDimension(ship.getChunkClaimDimension());
                ship.setAttachment((Object)controller);
            }
            return (PropellerController)ship.getAttachment(PropellerController.class);
        }

        public final double calculateBladePower(double velocityTowardsPropellerDir, double bladeRotationalSpeed, double bladeLength, double bladeAngle, double bladeWidth) {
            double b = 1.0;
            double c = 4.0;
            double a = Math.log(Mth.m_14008_((double)Math.abs(bladeAngle), (double)0.0, (double)90.0) + 1.0) / 2.3;
            if (a == 0.0) {
                return 0.0;
            }
            double airspeed = Mth.m_14008_((double)velocityTowardsPropellerDir, (double)0.0, (double)331.0);
            double advanceRatio = airspeed / (bladeRotationalSpeed * bladeLength);
            double powerCoefficient = b * (a - 1.0 - advanceRatio / (Math.pow(a, 3.0) * Math.pow(c, 2.0)));
            double machPowerMultiplier = 1.0 - 1.0 / (1.0 + Math.exp(((double)331 - airspeed) / 30.0));
            double power = powerCoefficient * Math.pow(bladeRotationalSpeed, 3) * Math.pow((double)2 * bladeLength, 5) * bladeWidth * (double)4 * machPowerMultiplier;
            return Math.max(power, 0.0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

