/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.forces;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.valkyrienskies.clockwork.ClockworkAugmentations;
import org.valkyrienskies.clockwork.ClockworkConfig;
import org.valkyrienskies.clockwork.ClockworkMod;
import org.valkyrienskies.clockwork.content.logistics.gas.utilities.PocketForcesQueueable;
import org.valkyrienskies.clockwork.util.ClockworkUtils;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ShipPhysicsListener;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.api.world.PhysLevel;
import org.valkyrienskies.core.api.world.connectivity.ConnectionStatus;
import org.valkyrienskies.core.api.world.connectivity.DoubleAugmentation;
import org.valkyrienskies.core.api.world.connectivity.DoubleComponentAugmentation;
import org.valkyrienskies.kelvin.KelvinMod;
import org.valkyrienskies.kelvin.api.DuctNetwork;
import org.valkyrienskies.kelvin.api.GasType;
import org.valkyrienskies.kelvin.impl.DuctNetworkServer;
import org.valkyrienskies.kelvin.impl.registry.GasTypeRegistry;
import org.valkyrienskies.mod.api.ValkyrienSkies;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 '2\u00020\u0001:\u0001'B\u0007\u00a2\u0006\u0004\b%\u0010&J\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ)\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001f\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018R&\u0010\u001b\u001a\u00060\u0019j\u0002`\u001a8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0!8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$\u00a8\u0006("}, d2={"Lorg/valkyrienskies/clockwork/content/forces/PocketForcesController;", "Lorg/valkyrienskies/core/api/ships/ShipPhysicsListener;", "Lorg/valkyrienskies/core/api/ships/PhysShip;", "physShip", "Lorg/valkyrienskies/core/api/world/PhysLevel;", "physLevel", "", "physTick", "(Lorg/valkyrienskies/core/api/ships/PhysShip;Lorg/valkyrienskies/core/api/world/PhysLevel;)V", "", "Lorg/joml/Vector3dc;", "", "calculateBuoyancyForce", "(Lorg/valkyrienskies/core/api/ships/PhysShip;Lorg/valkyrienskies/core/api/world/PhysLevel;)Ljava/util/Map;", "Lnet/minecraft/server/level/ServerLevel;", "level", "", "id", "gameTick", "(Lnet/minecraft/server/level/ServerLevel;J)V", "Lorg/joml/Vector3i;", "pos", "Lorg/joml/Vector3d;", "getPocketCenter", "(Lnet/minecraft/server/level/ServerLevel;Lorg/joml/Vector3i;)Lorg/joml/Vector3d;", "", "Lorg/valkyrienskies/core/api/world/properties/DimensionId;", "dimensionId", "Ljava/lang/String;", "getDimensionId", "()Ljava/lang/String;", "setDimensionId", "(Ljava/lang/String;)V", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lorg/valkyrienskies/clockwork/content/logistics/gas/utilities/PocketForcesQueueable;", "pocketQueue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "<init>", "()V", "Companion", "clockwork"})
@SourceDebugExtension(value={"SMAP\nPocketForcesController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PocketForcesController.kt\norg/valkyrienskies/clockwork/content/forces/PocketForcesController\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 Util.kt\norg/valkyrienskies/core/util/UtilKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,218:1\n216#2,2:219\n216#2,2:224\n216#2,2:226\n42#3,2:221\n1#4:223\n*S KotlinDebug\n*F\n+ 1 PocketForcesController.kt\norg/valkyrienskies/clockwork/content/forces/PocketForcesController\n*L\n53#1:219,2\n160#1:224,2\n185#1:226,2\n70#1:221,2\n*E\n"})
public final class PocketForcesController
implements ShipPhysicsListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String dimensionId = "minecraft:dimension:minecraft:overworld";
    @JsonIgnore
    @NotNull
    private final ConcurrentLinkedQueue<PocketForcesQueueable> pocketQueue = new ConcurrentLinkedQueue();

    @NotNull
    public final String getDimensionId() {
        return this.dimensionId;
    }

    public final void setDimensionId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.dimensionId = string;
    }

    public void physTick(@NotNull PhysShip physShip, @NotNull PhysLevel physLevel) {
        Map<Vector3dc, Double> buoyancyForce;
        Intrinsics.checkNotNullParameter((Object)physShip, (String)"physShip");
        Intrinsics.checkNotNullParameter((Object)physLevel, (String)"physLevel");
        PhysShip physShipImpl = physShip;
        Map<Vector3dc, Double> $this$forEach$iv = buoyancyForce = this.calculateBuoyancyForce(physShip, physLevel);
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Vector3dc, Double>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Vector3dc, Double> element$iv;
            Map.Entry<Vector3dc, Double> it = element$iv = iterator.next();
            boolean bl = false;
            double d = ((Number)it.getValue()).doubleValue();
            if (!(!Double.isInfinite(d) && !Double.isNaN(d)) || Double.isNaN(((Number)it.getValue()).doubleValue())) continue;
            PhysShip.applyWorldForceToModelPos$default((PhysShip)physShipImpl, (Vector3dc)((Vector3dc)new Vector3d(0.0, ((Number)it.getValue()).doubleValue(), 0.0)), null, (int)2, null);
        }
    }

    @NotNull
    public final Map<Vector3dc, Double> calculateBuoyancyForce(@NotNull PhysShip physShip, @NotNull PhysLevel physLevel) {
        Intrinsics.checkNotNullParameter((Object)physShip, (String)"physShip");
        Intrinsics.checkNotNullParameter((Object)physLevel, (String)"physLevel");
        PhysShip physShipImpl = physShip;
        HashMap totalBuoyantForce = null;
        totalBuoyantForce = new HashMap();
        Queue $this$pollUntilEmpty$iv = this.pocketQueue;
        boolean $i$f$pollUntilEmpty = false;
        while (true) {
            Object e = $this$pollUntilEmpty$iv.poll();
            if (e == null) break;
            PocketForcesQueueable it = (PocketForcesQueueable)e;
            boolean bl = false;
            double yHeight = physShip.getTransform().getShipToWorld().transformPosition(it.getPocketCenter(), new Vector3d()).y();
            double atmoDensity = physLevel.getAerodynamicUtils().getAirDensityForY(yHeight, this.dimensionId);
            double atmoGravity = ((Number)physLevel.getAerodynamicUtils().getAtmosphereForDimension(this.dimensionId).getThird()).doubleValue();
            double buoyantForce = it.getPocketVolume() * (atmoDensity - it.getHotDensity()) * atmoGravity * ClockworkConfig.SERVER.getBalloonForceMult();
            ((Map)totalBuoyantForce).put(it.getPocketCenter(), Math.max(buoyantForce, 0.0));
        }
        this.pocketQueue.clear();
        return totalBuoyantForce;
    }

    /*
     * WARNING - void declaration
     */
    public final void gameTick(@NotNull ServerLevel level, long id) {
        Vector3i root;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        LoadedServerShip loadedServerShip = (LoadedServerShip)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getLoadedShips().getById(id);
        if (loadedServerShip == null) {
            return;
        }
        LoadedServerShip ship = loadedServerShip;
        Map roots = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getFromEachAirComponent((DoubleAugmentation)ClockworkAugmentations.INSTANCE.getComponentAugmentation("heatEnergy"), VSGameUtilsKt.getDimensionId((Level)((Level)level)), ship.getChunkClaim());
        for (Triple r : roots.keySet()) {
            root = new Vector3i(((Number)r.getFirst()).intValue(), ((Number)r.getSecond()).intValue(), ((Number)r.getThird()).intValue());
            if (VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).isIsolatedAir(root.x, root.y, root.z, this.dimensionId) != ConnectionStatus.DISCONNECTED) continue;
            Pair<HashMap<GasType, Double>, Double> pair = ClockworkUtils.INSTANCE.retrieveGasInfoFromPocket((Vector3ic)root, level);
            HashMap gasMasses = (HashMap)pair.component1();
            double heatEnergy = ((Number)pair.component2()).doubleValue();
            long volume = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAirComponentSize(root.x(), root.y(), root.z(), this.dimensionId);
            Collection collection = gasMasses.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            double totalInternalDensity = CollectionsKt.sumOfDouble((Iterable)collection) / (double)volume;
            this.pocketQueue.add(new PocketForcesQueueable((Vector3dc)this.getPocketCenter(level, root), volume, totalInternalDensity));
        }
        for (Triple r : roots.keySet()) {
            Object object;
            Object object22;
            double d;
            double d2;
            root = new Vector3i(((Number)r.getFirst()).intValue(), ((Number)r.getSecond()).intValue(), ((Number)r.getThird()).intValue());
            double rootYInWorld = ValkyrienSkies.positionToWorld((ShipTransform)ship.getTransform(), (Vector3d)new Vector3d((double)((double)root.x()), (double)((double)root.y()), (double)((double)root.z()))).y + 0.5;
            double atmoDensity = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAerodynamicUtils().getAirDensityForY(rootYInWorld, VSGameUtilsKt.getDimensionId((Level)((Level)level)));
            double atmoPressure = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAerodynamicUtils().getAirPressureForY(rootYInWorld, this.dimensionId);
            double atmoTemperature = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAerodynamicUtils().getAirTemperatureForY(rootYInWorld, VSGameUtilsKt.getDimensionId((Level)((Level)level)));
            double volume = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAirComponentSize(root.x(), root.y(), root.z(), this.dimensionId);
            boolean isSealed = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).collectAirAugmentation(ClockworkAugmentations.INSTANCE.getAugmentation("sealed"), root.x(), root.y(), root.z(), VSGameUtilsKt.getDimensionId((Level)((Level)level))) > 0.0;
            if (isSealed) continue;
            Pair<HashMap<GasType, Double>, Double> pair = ClockworkUtils.INSTANCE.retrieveGasInfoFromPocket((Vector3ic)root, level);
            Object gasMasses = null;
            gasMasses = pair.component1();
            double currentHeatEnergy = ((Number)pair.component2()).doubleValue();
            if (Double.isNaN(currentHeatEnergy)) {
                GasType air;
                DoubleComponentAugmentation key = ClockworkAugmentations.INSTANCE.getComponentAugmentation("gas/kelvin:air");
                VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).setAirComponentAugmentation(key, root.x, root.y, root.z, this.dimensionId, volume * atmoDensity);
                Intrinsics.checkNotNull((Object)GasTypeRegistry.INSTANCE.getGasType("kelvin", "air"));
                double capacity = (double)1000 * air.getSpecificHeatCapacity() / air.getAdiabaticIndex();
                VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).setAirComponentAugmentation(ClockworkAugmentations.INSTANCE.getComponentAugmentation("heatEnergy"), root.x, root.y, root.z, this.dimensionId, atmoTemperature * volume * atmoDensity * capacity);
                continue;
            }
            Collection collection = ((HashMap)gasMasses).values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            double totalMass = CollectionsKt.sumOfDouble((Iterable)collection);
            Set set = ((HashMap)gasMasses).entrySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
            Iterable iterable = set;
            double d3 = 0.0;
            for (Object t : iterable) {
                void it;
                Map.Entry entry = (Map.Entry)t;
                d2 = d3;
                boolean bl = false;
                GasType gasType = (GasType)it.getKey();
                Object v = it.getValue();
                Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                d = gasType.massToMoles(((Number)v).doubleValue());
                d3 = d2 + d;
            }
            double moles = d3;
            DuctNetwork ductNetwork = KelvinMod.INSTANCE.getKelvin();
            Intrinsics.checkNotNull((Object)ductNetwork, (String)"null cannot be cast to non-null type org.valkyrienskies.kelvin.impl.DuctNetworkServer");
            double capacity = ((DuctNetworkServer)ductNetwork).mixtureCapacity((Map)gasMasses);
            double currentTemperature = currentHeatEnergy / capacity;
            double currentPressure = moles * 8.314 * currentTemperature / volume;
            Set set2 = ((HashMap)gasMasses).entrySet();
            Intrinsics.checkNotNullExpressionValue(set2, (String)"<get-entries>(...)");
            Iterable iterable2 = set2;
            double d4 = 0.0;
            for (Object t : iterable2) {
                void it;
                Map.Entry entry = (Map.Entry)t;
                d2 = d4;
                boolean bl = false;
                double d5 = ((GasType)it.getKey()).getDensity() * 0.0224;
                Object v = it.getValue();
                Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                d = d5 * ((Number)v).doubleValue();
                d4 = d2 + d;
            }
            double molarMass = d4 / totalMass;
            double estimatedSurfaceArea = 4.84 * Math.pow(volume, 0.6666666666666666);
            double gasExitRate = Math.max(0.0, currentPressure - atmoPressure) * estimatedSurfaceArea * ClockworkConfig.SERVER.getPermeabilityConstant() / Math.sqrt(currentTemperature * 8.314 / molarMass);
            double exitGas = gasExitRate * 0.05;
            HashMap exitGasMasses = new HashMap();
            Map $this$forEach$iv = (Map)gasMasses;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry it = element$iv = iterator.next();
                boolean bl = false;
                Map map = (Map)gasMasses;
                Object k = it.getKey();
                Object v = ((HashMap)gasMasses).get(it.getKey());
                Intrinsics.checkNotNull(v);
                map.put(k, ((Number)v).doubleValue() - exitGas * ((Number)it.getValue()).doubleValue() / totalMass);
                ((Map)exitGasMasses).put(it.getKey(), exitGas * ((Number)it.getValue()).doubleValue() / totalMass);
            }
            double exitHeat = currentTemperature * ClockworkMod.getKelvin().mixtureCapacity((Map)exitGasMasses);
            currentTemperature = (currentHeatEnergy -= exitHeat) / capacity;
            double heatFlow = ClockworkConfig.SERVER.getHeatTransferCoefficient() * estimatedSurfaceArea * (atmoTemperature - currentTemperature);
            double newHeatEnergy = currentHeatEnergy + heatFlow * 0.05;
            DuctNetwork ductNetwork2 = KelvinMod.INSTANCE.getKelvin();
            Intrinsics.checkNotNull((Object)ductNetwork2, (String)"null cannot be cast to non-null type org.valkyrienskies.kelvin.impl.DuctNetworkServer");
            double newCapacity = ((DuctNetworkServer)ductNetwork2).mixtureCapacity((Map)gasMasses);
            double newTemperature = newHeatEnergy / newCapacity;
            Object v = GasTypeRegistry.INSTANCE.getGAS_TYPES().get(new ResourceLocation("kelvin", "air"));
            Intrinsics.checkNotNull(v);
            GasType air = (GasType)v;
            Set set3 = ((HashMap)gasMasses).entrySet();
            Intrinsics.checkNotNullExpressionValue(set3, (String)"<get-entries>(...)");
            Iterable iterable3 = set3;
            double d6 = 0.0;
            for (Object object22 : iterable3) {
                void it;
                object = (Map.Entry)object22;
                d2 = d6;
                boolean bl = false;
                GasType gasType = (GasType)it.getKey();
                Object v2 = it.getValue();
                Intrinsics.checkNotNullExpressionValue(v2, (String)"<get-value>(...)");
                d = gasType.massToMoles(((Number)v2).doubleValue());
                d6 = d2 + d;
            }
            double newMoles = d6;
            double newPressure = newMoles * 8.314 * newTemperature / volume;
            double addMoles = Math.max(0.0, atmoPressure - newPressure) * volume / (newTemperature * 8.314);
            object22 = (Map)gasMasses;
            Double d7 = (Double)((HashMap)gasMasses).get(air);
            object = (d7 != null ? d7 : 0.0) + air.molesToMass(addMoles);
            object22.put((GasType)air, (Object)object);
            double addedHeat = air.molesToMass(addMoles) * atmoTemperature * (air.getSpecificHeatCapacity() * (double)1000 / air.getAdiabaticIndex());
            newHeatEnergy += addedHeat;
            Map $this$forEach$iv2 = (Map)gasMasses;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry it = element$iv = iterator2.next();
                boolean bl = false;
                DoubleComponentAugmentation key = ClockworkAugmentations.INSTANCE.getComponentAugmentation("gas/" + ((GasType)it.getKey()).getResourceLocation());
                VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).setAirComponentAugmentation(key, root.x, root.y, root.z, this.dimensionId, ((Number)it.getValue()).doubleValue());
            }
            VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).setAirComponentAugmentation(ClockworkAugmentations.INSTANCE.getComponentAugmentation("heatEnergy"), root.x, root.y, root.z, this.dimensionId, newHeatEnergy);
        }
    }

    private final Vector3d getPocketCenter(ServerLevel level, Vector3i pos) {
        long pocketSize = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAirComponentSize(pos.x(), pos.y(), pos.z(), VSGameUtilsKt.getDimensionId((Level)((Level)level)));
        double collectX = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).collectAirAugmentation(VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).createDoubleSumAugmentation("core", "x"), pos.x(), pos.y(), pos.z(), VSGameUtilsKt.getDimensionId((Level)((Level)level)));
        double collectY = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).collectAirAugmentation(VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).createDoubleSumAugmentation("core", "y"), pos.x(), pos.y(), pos.z(), VSGameUtilsKt.getDimensionId((Level)((Level)level)));
        double collectZ = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).collectAirAugmentation(VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).createDoubleSumAugmentation("core", "z"), pos.x(), pos.y(), pos.z(), VSGameUtilsKt.getDimensionId((Level)((Level)level)));
        return new Vector3d(collectX / (double)pocketSize, collectY / (double)pocketSize, collectZ / (double)pocketSize);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/valkyrienskies/clockwork/content/forces/PocketForcesController$Companion;", "", "Lorg/valkyrienskies/core/api/ships/LoadedServerShip;", "ship", "Lorg/valkyrienskies/clockwork/content/forces/PocketForcesController;", "getOrCreate", "(Lorg/valkyrienskies/core/api/ships/LoadedServerShip;)Lorg/valkyrienskies/clockwork/content/forces/PocketForcesController;", "<init>", "()V", "clockwork"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final PocketForcesController getOrCreate(@NotNull LoadedServerShip ship) {
            PocketForcesController controller;
            Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
            if (ship.getAttachment(PocketForcesController.class) == null) {
                controller = new PocketForcesController();
                controller.setDimensionId(ship.getChunkClaimDimension());
                ship.setAttachment((Object)controller);
            }
            PocketForcesController pocketForcesController = controller = (PocketForcesController)ship.getAttachment(PocketForcesController.class);
            Intrinsics.checkNotNull((Object)pocketForcesController);
            pocketForcesController.setDimensionId(ship.getChunkClaimDimension());
            return controller;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

