/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.forces;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.clockwork.content.curiosities.tools.gravitron.GravitronForceInducerData;
import org.valkyrienskies.core.api.attachment.AttachmentHolder;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ShipPhysicsListener;
import org.valkyrienskies.core.api.world.PhysLevel;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bR$\u0010\n\u001a\u0004\u0018\u00010\t8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lorg/valkyrienskies/clockwork/content/forces/GravitronController;", "Lorg/valkyrienskies/core/api/ships/ShipPhysicsListener;", "Lorg/valkyrienskies/core/api/ships/PhysShip;", "physShip", "Lorg/valkyrienskies/core/api/world/PhysLevel;", "physLevel", "", "physTick", "(Lorg/valkyrienskies/core/api/ships/PhysShip;Lorg/valkyrienskies/core/api/world/PhysLevel;)V", "Lorg/valkyrienskies/clockwork/content/curiosities/tools/gravitron/GravitronForceInducerData;", "data", "Lorg/valkyrienskies/clockwork/content/curiosities/tools/gravitron/GravitronForceInducerData;", "getData", "()Lorg/valkyrienskies/clockwork/content/curiosities/tools/gravitron/GravitronForceInducerData;", "setData", "(Lorg/valkyrienskies/clockwork/content/curiosities/tools/gravitron/GravitronForceInducerData;)V", "<init>", "()V", "Companion", "clockwork"})
public final class GravitronController
implements ShipPhysicsListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private GravitronForceInducerData data;

    @Nullable
    public final GravitronForceInducerData getData() {
        return this.data;
    }

    public final void setData(@Nullable GravitronForceInducerData gravitronForceInducerData) {
        this.data = gravitronForceInducerData;
    }

    public void physTick(@NotNull PhysShip physShip, @NotNull PhysLevel physLevel) {
        Intrinsics.checkNotNullParameter((Object)physShip, (String)"physShip");
        Intrinsics.checkNotNullParameter((Object)physLevel, (String)"physLevel");
        GravitronForceInducerData gravitronForceInducerData = this.data;
        if (gravitronForceInducerData == null) {
            return;
        }
        GravitronForceInducerData dataCopy = gravitronForceInducerData;
        GravitronController $this$physTick_u24lambda_u240 = this;
        boolean bl = false;
        double pConst = 160.0;
        double dConst = 20.0;
        Vector3d vector3d = physShip.getTransform().getShipToWorld().transformPosition(dataCopy.getGrabbedPos(), new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"transformPosition(...)");
        Vector3dc localGrabPos = (Vector3dc)vector3d;
        Vector3d vector3d2 = dataCopy.getIdealPos().sub(localGrabPos, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"sub(...)");
        Vector3dc idealPosDif = (Vector3dc)vector3d2;
        Vector3d vector3d3 = idealPosDif.mul(pConst, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d3, (String)"mul(...)");
        Vector3d posDif = vector3d3;
        double mass = physShip.getMass();
        posDif.sub((Vector3dc)physShip.getVelocity().mul(dConst, new Vector3d()));
        Vector3d force = posDif.mul(mass, new Vector3d());
        Intrinsics.checkNotNull((Object)force);
        PhysShip.applyWorldForceToBodyPos$default((PhysShip)physShip, (Vector3dc)((Vector3dc)force), null, (int)2, null);
        GravitronController $this$physTick_u24lambda_u241 = this;
        boolean bl2 = false;
        pConst = 160.0;
        dConst = 20.0;
        Quaterniond rotDif = dataCopy.getIdealRot().mul((Quaterniondc)physShip.getTransform().getShipToWorldRotation().invert(new Quaterniond()), new Quaterniond()).normalize().invert();
        Vector3d rotDifVector = new Vector3d(rotDif.x() * 2.0, rotDif.y() * 2.0, rotDif.z() * 2.0).mul(pConst);
        if (rotDif.w() < 0.0) {
            rotDifVector.mul(-1.0);
        }
        rotDifVector.mul(-1.0);
        rotDifVector.sub((Vector3dc)physShip.getAngularVelocity().mul(dConst, new Vector3d()));
        Vector3d torque = physShip.getTransform().getShipToWorldRotation().transform(physShip.getMomentOfInertia().transform(physShip.getTransform().getShipToWorldRotation().transformInverse((Vector3dc)rotDifVector, new Vector3d())));
        Intrinsics.checkNotNull((Object)torque);
        physShip.applyWorldTorque((Vector3dc)torque);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/valkyrienskies/clockwork/content/forces/GravitronController$Companion;", "", "Lorg/valkyrienskies/core/api/ships/LoadedServerShip;", "ship", "Lorg/valkyrienskies/clockwork/content/forces/GravitronController;", "getOrCreate", "(Lorg/valkyrienskies/core/api/ships/LoadedServerShip;)Lorg/valkyrienskies/clockwork/content/forces/GravitronController;", "<init>", "()V", "clockwork"})
    @SourceDebugExtension(value={"SMAP\nGravitronController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GravitronController.kt\norg/valkyrienskies/clockwork/content/forces/GravitronController$Companion\n+ 2 AttachmentHolder.kt\norg/valkyrienskies/core/api/attachment/AttachmentHolderKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n66#2:72\n1#3:73\n*S KotlinDebug\n*F\n+ 1 GravitronController.kt\norg/valkyrienskies/clockwork/content/forces/GravitronController$Companion\n*L\n66#1:72\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GravitronController getOrCreate(@NotNull LoadedServerShip ship) {
            Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
            AttachmentHolder $this$getAttachment$iv = (AttachmentHolder)ship;
            boolean $i$f$getAttachment = false;
            GravitronController gravitronController = (GravitronController)$this$getAttachment$iv.getAttachment(GravitronController.class);
            if (gravitronController == null) {
                GravitronController gravitronController2;
                GravitronController it = gravitronController2 = new GravitronController();
                boolean bl = false;
                ship.setAttachment((Object)it);
                gravitronController = gravitronController2;
            }
            return gravitronController;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

