/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.forces;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4dc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.clockwork.ClockworkConfig;
import org.valkyrienskies.clockwork.content.forces.MultiInstanceForceApplier;
import org.valkyrienskies.clockwork.content.propulsion.singleton.fan.EncasedFanCreateData;
import org.valkyrienskies.clockwork.content.propulsion.singleton.fan.EncasedFanData;
import org.valkyrienskies.clockwork.content.propulsion.singleton.fan.EncasedFanUpdateData;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.world.PhysLevel;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\b\u0007\u0018\u0000 22\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u00012B\u007f\u0012$\b\u0002\u0010\u0018\u001a\u001e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00030\u0015j\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0003`\u0017\u0012\u001a\b\u0002\u0010\u001e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00020\u001d0\u001c\u0012\u001a\b\u0002\u0010\"\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00040\u001d0\u001c\u0012\u000e\b\u0002\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00160\u001c\u0012\b\b\u0002\u0010&\u001a\u00020\u0016\u00a2\u0006\u0004\b0\u00101J\u001f\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ'\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001b\u0010\u0013\u001a\u00020\t2\n\u0010\u0012\u001a\u00060\u0010j\u0002`\u0011H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014R6\u0010\u0018\u001a\u001e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00030\u0015j\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0003`\u00178\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR,\u0010\u001e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00020\u001d0\u001c8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!R,\u0010\"\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00040\u001d0\u001c8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\"\u0010\u001f\u001a\u0004\b#\u0010!R \u0010$\u001a\b\u0012\u0004\u0012\u00020\u00160\u001c8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b$\u0010\u001f\u001a\u0004\b%\u0010!R\"\u0010&\u001a\u00020\u00168\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R&\u0010\u0012\u001a\u00060\u0010j\u0002`\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0012\u0010,\u001a\u0004\b-\u0010.\"\u0004\b/\u0010\u0014\u00a8\u00063"}, d2={"Lorg/valkyrienskies/clockwork/content/forces/EncasedFanController;", "Lorg/valkyrienskies/clockwork/content/forces/MultiInstanceForceApplier;", "Lorg/valkyrienskies/clockwork/content/propulsion/singleton/fan/EncasedFanUpdateData;", "Lorg/valkyrienskies/clockwork/content/propulsion/singleton/fan/EncasedFanData;", "Lorg/valkyrienskies/clockwork/content/propulsion/singleton/fan/EncasedFanCreateData;", "Lorg/valkyrienskies/core/api/ships/PhysShip;", "physShip", "Lorg/valkyrienskies/core/api/world/PhysLevel;", "physLevel", "", "physTick", "(Lorg/valkyrienskies/core/api/ships/PhysShip;Lorg/valkyrienskies/core/api/world/PhysLevel;)V", "physData", "Lorg/joml/Vector3dc;", "computeForce", "(Lorg/valkyrienskies/clockwork/content/propulsion/singleton/fan/EncasedFanData;Lorg/valkyrienskies/core/api/ships/PhysShip;Lorg/valkyrienskies/core/api/world/PhysLevel;)Lorg/joml/Vector3dc;", "", "Lorg/valkyrienskies/core/api/world/properties/DimensionId;", "dimensionId", "setDimension", "(Ljava/lang/String;)V", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "appliers", "Ljava/util/HashMap;", "getAppliers", "()Ljava/util/HashMap;", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lkotlin/Pair;", "applierUpdateData", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "getApplierUpdateData", "()Ljava/util/concurrent/ConcurrentLinkedQueue;", "createdAppliers", "getCreatedAppliers", "removedAppliers", "getRemovedAppliers", "nextApplierID", "I", "getNextApplierID", "()I", "setNextApplierID", "(I)V", "Ljava/lang/String;", "getDimensionId", "()Ljava/lang/String;", "setDimensionId", "<init>", "(Ljava/util/HashMap;Ljava/util/concurrent/ConcurrentLinkedQueue;Ljava/util/concurrent/ConcurrentLinkedQueue;Ljava/util/concurrent/ConcurrentLinkedQueue;I)V", "Companion", "clockwork"})
public final class EncasedFanController
implements MultiInstanceForceApplier<EncasedFanUpdateData, EncasedFanData, EncasedFanCreateData> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<Integer, EncasedFanData> appliers;
    @NotNull
    private final ConcurrentLinkedQueue<Pair<Integer, EncasedFanUpdateData>> applierUpdateData;
    @NotNull
    private final ConcurrentLinkedQueue<Pair<Integer, EncasedFanCreateData>> createdAppliers;
    @NotNull
    private final ConcurrentLinkedQueue<Integer> removedAppliers;
    private int nextApplierID;
    @NotNull
    private String dimensionId;

    public EncasedFanController(@NotNull HashMap<Integer, EncasedFanData> appliers, @NotNull ConcurrentLinkedQueue<Pair<Integer, EncasedFanUpdateData>> applierUpdateData, @NotNull ConcurrentLinkedQueue<Pair<Integer, EncasedFanCreateData>> createdAppliers, @NotNull ConcurrentLinkedQueue<Integer> removedAppliers, int nextApplierID) {
        Intrinsics.checkNotNullParameter(appliers, (String)"appliers");
        Intrinsics.checkNotNullParameter(applierUpdateData, (String)"applierUpdateData");
        Intrinsics.checkNotNullParameter(createdAppliers, (String)"createdAppliers");
        Intrinsics.checkNotNullParameter(removedAppliers, (String)"removedAppliers");
        this.appliers = appliers;
        this.applierUpdateData = applierUpdateData;
        this.createdAppliers = createdAppliers;
        this.removedAppliers = removedAppliers;
        this.nextApplierID = nextApplierID;
        this.dimensionId = "minecraft:dimension:minecraft:overworld";
    }

    public /* synthetic */ EncasedFanController(HashMap hashMap, ConcurrentLinkedQueue concurrentLinkedQueue, ConcurrentLinkedQueue concurrentLinkedQueue2, ConcurrentLinkedQueue concurrentLinkedQueue3, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            hashMap = new HashMap<Integer, EncasedFanData>();
        }
        if ((n2 & 2) != 0) {
            concurrentLinkedQueue = new ConcurrentLinkedQueue<Pair<Integer, EncasedFanUpdateData>>();
        }
        if ((n2 & 4) != 0) {
            concurrentLinkedQueue2 = new ConcurrentLinkedQueue<Pair<Integer, EncasedFanCreateData>>();
        }
        if ((n2 & 8) != 0) {
            concurrentLinkedQueue3 = new ConcurrentLinkedQueue<Integer>();
        }
        if ((n2 & 0x10) != 0) {
            n = 0;
        }
        this(hashMap, concurrentLinkedQueue, concurrentLinkedQueue2, concurrentLinkedQueue3, n);
    }

    @Override
    @NotNull
    public HashMap<Integer, EncasedFanData> getAppliers() {
        return this.appliers;
    }

    @Override
    @NotNull
    public ConcurrentLinkedQueue<Pair<Integer, EncasedFanUpdateData>> getApplierUpdateData() {
        return this.applierUpdateData;
    }

    @Override
    @NotNull
    public ConcurrentLinkedQueue<Pair<Integer, EncasedFanCreateData>> getCreatedAppliers() {
        return this.createdAppliers;
    }

    @Override
    @NotNull
    public ConcurrentLinkedQueue<Integer> getRemovedAppliers() {
        return this.removedAppliers;
    }

    @Override
    public int getNextApplierID() {
        return this.nextApplierID;
    }

    @Override
    public void setNextApplierID(int n) {
        this.nextApplierID = n;
    }

    @NotNull
    public final String getDimensionId() {
        return this.dimensionId;
    }

    public final void setDimensionId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.dimensionId = string;
    }

    @Override
    public void physTick(@NotNull PhysShip physShip, @NotNull PhysLevel physLevel) {
        Intrinsics.checkNotNullParameter((Object)physShip, (String)"physShip");
        Intrinsics.checkNotNullParameter((Object)physLevel, (String)"physLevel");
        MultiInstanceForceApplier.super.physTick(physShip, physLevel);
        Iterator<EncasedFanData> iterator = this.getAppliers().values().iterator();
        while (iterator.hasNext()) {
            EncasedFanData physData;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            Vector3dc force = this.computeForce(physData, physShip, physLevel);
            Vector3d vector3d = new Vector3d(physData.getPosition()).add(0.5, 0.5, 0.5, new Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"add(...)");
            Vector3dc fanVector = (Vector3dc)vector3d;
            physShip.applyModelForce(force, fanVector);
        }
    }

    private final Vector3dc computeForce(EncasedFanData physData, PhysShip physShip, PhysLevel physLevel) {
        double speed = physData.getFanSpeed() * 2.0 * Math.PI / 60.0;
        double bladePitch = 15.0;
        Vector3d vector3d = physShip.getTransform().getShipToWorld().transformPosition((Vector3dc)new Vector3d(physData.getPosition()).add(0.5, 0.5, 0.5, new Vector3d()), new Vector3d()).sub(physShip.getTransform().getPositionInWorld(), new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"sub(...)");
        Vector3dc fanPosRelCenterMass = (Vector3dc)vector3d;
        Vector3d vector3d2 = physShip.getOmega().cross(fanPosRelCenterMass, new Vector3d()).add(physShip.getVelocity(), new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"add(...)");
        Vector3dc worldVelAtFan = (Vector3dc)vector3d2;
        double airDensityAtY = physLevel.getAerodynamicUtils().getAirDensityForY(physShip.getTransform().getPositionInWorld().y(), this.dimensionId);
        Matrix4dc matrix4dc = physShip.getTransform().getShipToWorld();
        Vector3dc vector3dc = physData.getFanDir();
        Intrinsics.checkNotNull((Object)vector3dc);
        double velocityTowardsPropellerDir = worldVelAtFan.dot((Vector3dc)matrix4dc.transformDirection(vector3dc, new Vector3d()).normalize());
        Vector3d netForce = new Vector3d(physData.getFanDir()).normalize();
        double effectiveVelocity = Math.sqrt(Math.pow(velocityTowardsPropellerDir, 2.0) + Math.pow(physData.getFanSpeed() * 0.5, 2.0));
        double inflowAngle = Math.atan(velocityTowardsPropellerDir / speed);
        double angleOfAttack = Math.toRadians(bladePitch) - inflowAngle;
        double liftCoefficient = Math.PI * 2 * angleOfAttack;
        double dragCoefficient = 0.01 * liftCoefficient;
        double dLift = 0.5 * airDensityAtY * Math.pow(effectiveVelocity, 2.0) * 0.15 * 0.5 * liftCoefficient;
        double dDrag = 0.5 * airDensityAtY * Math.pow(effectiveVelocity, 2.0) * 0.15 * 0.5 * dragCoefficient;
        double dThrust = dLift * Math.cos(inflowAngle) - dDrag * Math.sin(inflowAngle);
        netForce.mul(dThrust * ClockworkConfig.SERVER.getEncasedFanForceMul());
        Intrinsics.checkNotNull((Object)netForce);
        return (Vector3dc)netForce;
    }

    private final void setDimension(String dimensionId) {
        this.dimensionId = dimensionId;
    }

    public EncasedFanController() {
        this(null, null, null, null, 0, 31, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/valkyrienskies/clockwork/content/forces/EncasedFanController$Companion;", "", "Lorg/valkyrienskies/core/api/ships/LoadedServerShip;", "ship", "Lorg/valkyrienskies/clockwork/content/forces/EncasedFanController;", "getOrCreate", "(Lorg/valkyrienskies/core/api/ships/LoadedServerShip;)Lorg/valkyrienskies/clockwork/content/forces/EncasedFanController;", "<init>", "()V", "clockwork"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final EncasedFanController getOrCreate(@NotNull LoadedServerShip ship) {
            EncasedFanController attachment;
            Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
            if (ship.getAttachment(EncasedFanController.class) == null) {
                EncasedFanController controller = new EncasedFanController(null, null, null, null, 0, 31, null);
                controller.setDimension(ship.getChunkClaimDimension());
                ship.setAttachment((Object)controller);
            }
            EncasedFanController encasedFanController = attachment = (EncasedFanController)ship.getAttachment(EncasedFanController.class);
            Intrinsics.checkNotNull((Object)encasedFanController);
            encasedFanController.setDimensionId(ship.getChunkClaimDimension());
            return attachment;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

