/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.curiosities.tools.wanderwand;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModel;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.PartialItemModelRenderer;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.valkyrienskies.clockwork.ClockworkItems;
import org.valkyrienskies.clockwork.content.curiosities.tools.wanderwand.WanderwandItem;
import org.valkyrienskies.clockwork.util.EaseHelper;
import org.valkyrienskies.clockwork.util.render.RenderUtil;
import org.valkyrienskies.clockwork.util.render.TransformData;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001eJS\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0014\u00a2\u0006\u0004\b\u0012\u0010\u0013J7\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001b\u00a8\u0006\u001f"}, d2={"Lorg/valkyrienskies/clockwork/content/curiosities/tools/wanderwand/WanderwandItemRenderer;", "Lcom/simibubi/create/foundation/item/render/CustomRenderedItemModelRenderer;", "Lnet/minecraft/world/item/ItemStack;", "stack", "Lcom/simibubi/create/foundation/item/render/CustomRenderedItemModel;", "model", "Lcom/simibubi/create/foundation/item/render/PartialItemModelRenderer;", "renderer", "Lnet/minecraft/world/item/ItemDisplayContext;", "transformType", "Lcom/mojang/blaze3d/vertex/PoseStack;", "ms", "Lnet/minecraft/client/renderer/MultiBufferSource;", "buffer", "", "light", "overlay", "", "render", "(Lnet/minecraft/world/item/ItemStack;Lcom/simibubi/create/foundation/item/render/CustomRenderedItemModel;Lcom/simibubi/create/foundation/item/render/PartialItemModelRenderer;Lnet/minecraft/world/item/ItemDisplayContext;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V", "Ldev/engine_room/flywheel/lib/transform/PoseTransformStack;", "stacker", "", "progress", "animateIdle", "(Lcom/mojang/blaze3d/vertex/PoseStack;Ldev/engine_room/flywheel/lib/transform/PoseTransformStack;IFLcom/simibubi/create/foundation/item/render/PartialItemModelRenderer;)V", "crystalAngle", "F", "idleProgress", "<init>", "()V", "clockwork"})
public final class WanderwandItemRenderer
extends CustomRenderedItemModelRenderer {
    private float crystalAngle;
    private float idleProgress;

    protected void render(@NotNull ItemStack stack, @Nullable CustomRenderedItemModel model, @Nullable PartialItemModelRenderer renderer, @NotNull ItemDisplayContext transformType, @NotNull PoseStack ms, @NotNull MultiBufferSource buffer, int light, int overlay) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)transformType, (String)"transformType");
        Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (stack.m_150930_((Item)ClockworkItems.INCOMPLETE_WANDERWAND.get())) {
            ms.m_85836_();
            PartialItemModelRenderer partialItemModelRenderer = renderer;
            Intrinsics.checkNotNull((Object)partialItemModelRenderer);
            CustomRenderedItemModel customRenderedItemModel = model;
            Intrinsics.checkNotNull((Object)customRenderedItemModel);
            partialItemModelRenderer.renderSolid(customRenderedItemModel.getOriginalModel(), light);
            ms.m_85849_();
        }
        if (stack.m_150930_((Item)ClockworkItems.WANDERWAND.get())) {
            PoseTransformStack stacker = TransformStack.of((PoseStack)ms);
            ms.m_85836_();
            PartialItemModelRenderer partialItemModelRenderer = renderer;
            Intrinsics.checkNotNull((Object)partialItemModelRenderer);
            CustomRenderedItemModel customRenderedItemModel = model;
            Intrinsics.checkNotNull((Object)customRenderedItemModel);
            partialItemModelRenderer.renderSolid(customRenderedItemModel.getOriginalModel(), light);
            Item item = stack.m_41720_();
            Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type org.valkyrienskies.clockwork.content.curiosities.tools.wanderwand.WanderwandItem");
            WanderwandItem ww = (WanderwandItem)item;
            Intrinsics.checkNotNull((Object)stacker);
            this.animateIdle(ms, stacker, light, this.idleProgress, renderer);
            this.idleProgress += 0.01f;
            if (this.idleProgress > 2.0f) {
                this.idleProgress = 0.0f;
            }
            ms.m_85849_();
        }
    }

    private final void animateIdle(PoseStack ms, PoseTransformStack stacker, int light, float progress, PartialItemModelRenderer renderer) {
        float partialTicks = AnimationTickHolder.getPartialTicks() - 1.0f;
        float nextCrystalAngle = this.crystalAngle + 0.1f;
        float i = Mth.m_14189_((float)partialTicks, (float)this.crystalAngle, (float)nextCrystalAngle);
        TransformData innerData = new TransformData(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(i, i, 0.0f));
        TransformData data = new TransformData(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, i, 0.0f));
        float heightAlt = -0.375f + (float)Math.sin(EaseHelper.INSTANCE.easeInOutSine(progress)) / 16.0f;
        stacker.translateY(heightAlt * 0.05f);
        ms.m_85837_(0.0, (double)heightAlt + 0.5, 0.0);
        ms.m_85836_();
        RenderUtil.INSTANCE.renderCubeMatrix(ms, renderer, innerData, data, 1.5f, light);
        ms.m_85849_();
        this.crystalAngle = nextCrystalAngle;
    }
}

