/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.curiosities.tools.wanderwand;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.clockwork.ClockworkItems;
import org.valkyrienskies.clockwork.content.curiosities.tools.wanderwand.WanderwandItem;
import org.valkyrienskies.clockwork.content.curiosities.tools.wanderwand.tool.ToolType;
import org.valkyrienskies.clockwork.platform.api.network.C2SCWPacket;
import org.valkyrienskies.clockwork.platform.api.network.ServerNetworkContext;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\u0018\u00002\u00020\u0001B5\b\u0016\u0012\u0006\u0010\"\u001a\u00020\u000b\u0012\b\u0010#\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u0012\u0006\u0010\u001b\u001a\u00020\u0017\u0012\b\b\u0002\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b$\u0010%B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b$\u0010\nJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\t\u0010\nR\u0017\u0010\f\u001a\u00020\u000b8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\u00020\u000b8\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010\r\u001a\u0004\b\u0011\u0010\u000fR\u0017\u0010\u0013\u001a\u00020\u00128\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0018\u001a\u00020\u00178\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0018\u0010\u001aR\u0017\u0010\u001b\u001a\u00020\u00178\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0019\u001a\u0004\b\u001c\u0010\u001aR\u0017\u0010\u001e\u001a\u00020\u001d8\u0006\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!\u00a8\u0006&"}, d2={"Lorg/valkyrienskies/clockwork/content/curiosities/tools/wanderwand/WandSelectionPacket;", "Lorg/valkyrienskies/clockwork/platform/api/network/C2SCWPacket;", "Lorg/valkyrienskies/clockwork/platform/api/network/ServerNetworkContext;", "context", "", "handle", "(Lorg/valkyrienskies/clockwork/platform/api/network/ServerNetworkContext;)V", "Lnet/minecraft/network/FriendlyByteBuf;", "buffer", "write", "(Lnet/minecraft/network/FriendlyByteBuf;)V", "Lnet/minecraft/core/BlockPos;", "firstPos", "Lnet/minecraft/core/BlockPos;", "getFirstPos", "()Lnet/minecraft/core/BlockPos;", "secondPos", "getSecondPos", "Lorg/valkyrienskies/clockwork/content/curiosities/tools/wanderwand/tool/ToolType;", "tool", "Lorg/valkyrienskies/clockwork/content/curiosities/tools/wanderwand/tool/ToolType;", "getTool", "()Lorg/valkyrienskies/clockwork/content/curiosities/tools/wanderwand/tool/ToolType;", "", "isSecond", "Z", "()Z", "leftClick", "getLeftClick", "", "clickedFace", "I", "getClickedFace", "()I", "pos1", "pos2", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;Lorg/valkyrienskies/clockwork/content/curiosities/tools/wanderwand/tool/ToolType;ZI)V", "clockwork"})
public final class WandSelectionPacket
implements C2SCWPacket {
    @NotNull
    private final BlockPos firstPos;
    @NotNull
    private final BlockPos secondPos;
    @NotNull
    private final ToolType tool;
    private final boolean isSecond;
    private final boolean leftClick;
    private final int clickedFace;

    @NotNull
    public final BlockPos getFirstPos() {
        return this.firstPos;
    }

    @NotNull
    public final BlockPos getSecondPos() {
        return this.secondPos;
    }

    @NotNull
    public final ToolType getTool() {
        return this.tool;
    }

    public final boolean isSecond() {
        return this.isSecond;
    }

    public final boolean getLeftClick() {
        return this.leftClick;
    }

    public final int getClickedFace() {
        return this.clickedFace;
    }

    public WandSelectionPacket(@NotNull BlockPos pos1, @Nullable BlockPos pos2, @NotNull ToolType tool, boolean leftClick, int clickedFace) {
        Intrinsics.checkNotNullParameter((Object)pos1, (String)"pos1");
        Intrinsics.checkNotNullParameter((Object)((Object)tool), (String)"tool");
        this.firstPos = pos1;
        BlockPos blockPos = pos2;
        if (blockPos == null) {
            blockPos = pos1;
        }
        this.secondPos = blockPos;
        this.tool = tool;
        this.isSecond = pos2 != null;
        this.leftClick = leftClick;
        this.clickedFace = clickedFace;
    }

    public /* synthetic */ WandSelectionPacket(BlockPos blockPos, BlockPos blockPos2, ToolType toolType, boolean bl, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            n = -1;
        }
        this(blockPos, blockPos2, toolType, bl, n);
    }

    public WandSelectionPacket(@NotNull FriendlyByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.firstPos = buffer.m_130135_();
        this.secondPos = buffer.m_130135_();
        this.tool = (ToolType)buffer.m_130066_(ToolType.class);
        this.isSecond = buffer.readBoolean();
        this.leftClick = buffer.readBoolean();
        this.clickedFace = buffer.readInt();
    }

    @Override
    public void handle(@NotNull ServerNetworkContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.enqueueWork(() -> WandSelectionPacket.handle$lambda$0(context, this));
        context.setPacketHandled(true);
    }

    @Override
    public void write(@NotNull FriendlyByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        buffer.m_130064_(this.firstPos);
        buffer.m_130064_(this.secondPos);
        buffer.m_130068_((Enum)this.tool);
        buffer.writeBoolean(this.isSecond);
        buffer.writeBoolean(this.leftClick);
        buffer.writeInt(this.clickedFace);
    }

    private static final void handle$lambda$0(ServerNetworkContext $context, WandSelectionPacket this$0) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ServerPlayer serverPlayer = $context.getSender();
        if (serverPlayer.m_9236_() instanceof ServerLevel) {
            Level level = serverPlayer.m_9236_();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack stack = serverPlayer.m_21205_();
            boolean bl = stack.m_150930_(((WanderwandItem)((Object)ClockworkItems.WANDERWAND.get())).m_5456_());
            if (bl) {
                switch (WhenMappings.$EnumSwitchMapping$0[this$0.tool.ordinal()]) {
                    case 1: 
                    case 2: {
                        WanderwandItem.Companion.select(serverLevel, serverPlayer, this$0.firstPos, this$0.secondPos, this$0.isSecond, this$0.tool == ToolType.DESELECT, this$0.leftClick);
                        break;
                    }
                    case 3: {
                        if (this$0.isSecond) {
                            BlockPos blockPos = this$0.secondPos;
                            Intrinsics.checkNotNull((Object)blockPos);
                            BlockPos.MutableBlockPos mutableBlockPos = blockPos.m_122032_();
                            Intrinsics.checkNotNullExpressionValue((Object)mutableBlockPos, (String)"mutable(...)");
                            WanderwandItem.Companion.weld(serverLevel, serverPlayer, (BlockPos)mutableBlockPos, this$0.clickedFace);
                            break;
                        }
                        BlockPos blockPos = this$0.firstPos;
                        Intrinsics.checkNotNull((Object)blockPos);
                        BlockPos.MutableBlockPos mutableBlockPos = blockPos.m_122032_();
                        Intrinsics.checkNotNullExpressionValue((Object)mutableBlockPos, (String)"mutable(...)");
                        WanderwandItem.Companion.startWeld(serverLevel, serverPlayer, (BlockPos)mutableBlockPos, this$0.clickedFace);
                        break;
                    }
                    case 4: {
                        BlockPos.MutableBlockPos mutableBlockPos;
                        if (this$0.isSecond) {
                            BlockPos blockPos = this$0.secondPos;
                            Intrinsics.checkNotNull((Object)blockPos);
                            mutableBlockPos = blockPos.m_122032_();
                        } else {
                            BlockPos blockPos = this$0.firstPos;
                            Intrinsics.checkNotNull((Object)blockPos);
                            mutableBlockPos = blockPos.m_122032_();
                        }
                        BlockPos.MutableBlockPos posToSend = mutableBlockPos;
                        BlockPos.MutableBlockPos mutableBlockPos2 = posToSend.m_122032_();
                        Intrinsics.checkNotNullExpressionValue((Object)mutableBlockPos2, (String)"mutable(...)");
                        WanderwandItem.Companion.attach(serverLevel, serverPlayer, (BlockPos)mutableBlockPos2);
                        break;
                    }
                    case 5: {
                        if (this$0.isSecond) {
                            BlockPos blockPos = this$0.secondPos;
                            Intrinsics.checkNotNull((Object)blockPos);
                            BlockPos.MutableBlockPos mutableBlockPos = blockPos.m_122032_();
                            Intrinsics.checkNotNullExpressionValue((Object)mutableBlockPos, (String)"mutable(...)");
                            WanderwandItem.Companion.bind(serverLevel, serverPlayer, (BlockPos)mutableBlockPos);
                            break;
                        }
                        BlockPos blockPos = this$0.firstPos;
                        Intrinsics.checkNotNull((Object)blockPos);
                        BlockPos.MutableBlockPos mutableBlockPos = blockPos.m_122032_();
                        Intrinsics.checkNotNullExpressionValue((Object)mutableBlockPos, (String)"mutable(...)");
                        WanderwandItem.Companion.startBind(serverLevel, serverPlayer, (BlockPos)mutableBlockPos);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ToolType.values().length];
            try {
                nArray[ToolType.SELECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolType.DESELECT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolType.WELD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolType.ATTACH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolType.BIND.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

