/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.curiosities.solver;

import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4dc;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.clockwork.ClockworkDamageTypes;
import org.valkyrienskies.clockwork.ClockworkModClient;
import org.valkyrienskies.clockwork.content.curiosities.IArcConnector;
import org.valkyrienskies.clockwork.util.KNodeBlockEntity;
import org.valkyrienskies.clockwork.util.arc.ArcBias;
import org.valkyrienskies.clockwork.util.arc.LightningBolt;
import org.valkyrienskies.clockwork.util.arc.LightningManager;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.kelvin.api.DuctNodePos;
import org.valkyrienskies.kelvin.util.KelvinExtensions;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\n\u0010V\u001a\u0006\u0012\u0002\b\u00030U\u0012\u0006\u0010W\u001a\u00020A\u0012\u0006\u0010Y\u001a\u00020X\u00a2\u0006\u0004\bZ\u0010[J\u000f\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0006\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0005J\u0015\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\r\u001a\u00020\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0005J\u000f\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001b\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\r\u0010\u001d\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001d\u0010\u001cJ\u000f\u0010\u001f\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J3\u0010(\u001a\u0004\u0018\u00010'2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u001a2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010%\u00a2\u0006\u0004\b(\u0010)R\u001d\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00020*8\u0006\u00a2\u0006\f\n\u0004\b+\u0010,\u001a\u0004\b-\u0010.R\u0017\u00100\u001a\u00020/8\u0006\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b2\u00103R\"\u00104\u001a\u00020\u00138\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b4\u00105\u001a\u0004\b6\u0010\u0015\"\u0004\b7\u00108R$\u00109\u001a\u0004\u0018\u00010\u001a8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b9\u0010:\u001a\u0004\b;\u0010\u001c\"\u0004\b<\u0010=R$\u0010>\u001a\u0004\u0018\u00010\u001a8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b>\u0010:\u001a\u0004\b?\u0010\u001c\"\u0004\b@\u0010=R$\u0010B\u001a\u0004\u0018\u00010A8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bB\u0010C\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR$\u0010H\u001a\u0004\u0018\u00010A8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bH\u0010C\u001a\u0004\bI\u0010E\"\u0004\bJ\u0010GR\"\u0010L\u001a\u00020K8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bL\u0010M\u001a\u0004\bN\u0010O\"\u0004\bP\u0010QR\"\u0010R\u001a\u00020K8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bR\u0010M\u001a\u0004\bS\u0010O\"\u0004\bT\u0010Q\u00a8\u0006\\"}, d2={"Lorg/valkyrienskies/clockwork/content/curiosities/solver/SolverBlockEntity;", "Lorg/valkyrienskies/clockwork/util/KNodeBlockEntity;", "Lorg/valkyrienskies/clockwork/content/curiosities/IArcConnector;", "", "initialize", "()V", "remove", "", "getConnectedArcs", "()Ljava/util/List;", "", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BlockEntityBehaviour;", "behaviours", "addBehaviours", "(Ljava/util/List;)V", "", "getMaxRange", "()D", "tick", "", "getMaxConnections", "()I", "other", "", "canConnect", "(Lorg/valkyrienskies/clockwork/content/curiosities/IArcConnector;)Z", "Lnet/minecraft/world/phys/Vec3;", "getWorldPos", "()Lnet/minecraft/world/phys/Vec3;", "getWorldFacing", "Lorg/valkyrienskies/kelvin/api/DuctNodePos;", "getDuctNodePosition", "()Lorg/valkyrienskies/kelvin/api/DuctNodePos;", "Lnet/minecraft/world/level/Level;", "level", "start", "desiredEnd", "Lnet/minecraft/world/entity/Entity;", "entity", "Lnet/minecraft/world/phys/BlockHitResult;", "raycastBeam", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/entity/Entity;)Lnet/minecraft/world/phys/BlockHitResult;", "Ljava/util/ArrayList;", "connectedArcNodes", "Ljava/util/ArrayList;", "getConnectedArcNodes", "()Ljava/util/ArrayList;", "Lkotlin/ULong;", "beamSeed", "J", "getBeamSeed-s-VKNKU", "()J", "ticksTillLightning", "I", "getTicksTillLightning", "setTicksTillLightning", "(I)V", "lastHitPosition", "Lnet/minecraft/world/phys/Vec3;", "getLastHitPosition", "setLastHitPosition", "(Lnet/minecraft/world/phys/Vec3;)V", "previousHitPosition", "getPreviousHitPosition", "setPreviousHitPosition", "Lnet/minecraft/core/BlockPos;", "lastHitBlock", "Lnet/minecraft/core/BlockPos;", "getLastHitBlock", "()Lnet/minecraft/core/BlockPos;", "setLastHitBlock", "(Lnet/minecraft/core/BlockPos;)V", "previousHitBlock", "getPreviousHitBlock", "setPreviousHitBlock", "", "destroyProgress", "F", "getDestroyProgress", "()F", "setDestroyProgress", "(F)V", "clientTime", "getClientTime", "setClientTime", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "type", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "clockwork"})
public final class SolverBlockEntity
extends KNodeBlockEntity
implements IArcConnector {
    @NotNull
    private final ArrayList<IArcConnector> connectedArcNodes;
    private final long beamSeed;
    private int ticksTillLightning;
    @Nullable
    private Vec3 lastHitPosition;
    @Nullable
    private Vec3 previousHitPosition;
    @Nullable
    private BlockPos lastHitBlock;
    @Nullable
    private BlockPos previousHitBlock;
    private float destroyProgress;
    private float clientTime;

    public SolverBlockEntity(@NotNull BlockEntityType<?> type, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, pos, state);
        this.connectedArcNodes = new ArrayList();
        this.beamSeed = ULong.constructor-impl((long)(ULong.constructor-impl((long)this.m_58899_().m_121878_()) * -7046029254386353131L));
    }

    @NotNull
    public final ArrayList<IArcConnector> getConnectedArcNodes() {
        return this.connectedArcNodes;
    }

    public final long getBeamSeed-s-VKNKU() {
        return this.beamSeed;
    }

    public final int getTicksTillLightning() {
        return this.ticksTillLightning;
    }

    public final void setTicksTillLightning(int n) {
        this.ticksTillLightning = n;
    }

    @Nullable
    public final Vec3 getLastHitPosition() {
        return this.lastHitPosition;
    }

    public final void setLastHitPosition(@Nullable Vec3 vec3) {
        this.lastHitPosition = vec3;
    }

    @Nullable
    public final Vec3 getPreviousHitPosition() {
        return this.previousHitPosition;
    }

    public final void setPreviousHitPosition(@Nullable Vec3 vec3) {
        this.previousHitPosition = vec3;
    }

    @Nullable
    public final BlockPos getLastHitBlock() {
        return this.lastHitBlock;
    }

    public final void setLastHitBlock(@Nullable BlockPos blockPos) {
        this.lastHitBlock = blockPos;
    }

    @Nullable
    public final BlockPos getPreviousHitBlock() {
        return this.previousHitBlock;
    }

    public final void setPreviousHitBlock(@Nullable BlockPos blockPos) {
        this.previousHitBlock = blockPos;
    }

    public final float getDestroyProgress() {
        return this.destroyProgress;
    }

    public final void setDestroyProgress(float f) {
        this.destroyProgress = f;
    }

    public final float getClientTime() {
        return this.clientTime;
    }

    public final void setClientTime(float f) {
        this.clientTime = f;
    }

    public void initialize() {
        super.initialize();
        Level level = this.f_58857_;
        boolean bl = level != null ? level.f_46443_ : false;
        if (bl) {
            ((Map)ClockworkModClient.getLIGHTNING_NODES()).put(this.f_58858_, this);
        }
    }

    @Override
    public void remove() {
        Level level = this.f_58857_;
        boolean bl = level != null ? level.f_46443_ : false;
        if (bl) {
            ClockworkModClient.getLIGHTNING_NODES().remove(this.f_58858_);
        }
        super.remove();
    }

    @Override
    @NotNull
    public List<IArcConnector> getConnectedArcs() {
        return this.connectedArcNodes;
    }

    public void addBehaviours(@NotNull List<? extends BlockEntityBehaviour> behaviours) {
        Intrinsics.checkNotNullParameter(behaviours, (String)"behaviours");
    }

    @Override
    public double getMaxRange() {
        return 16.0;
    }

    public void tick() {
        super.tick();
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        Vec3 vec3 = this.getWorldPos();
        Vec3 vec32 = this.getWorldPos().m_82549_(this.getWorldFacing().m_82490_(64.0));
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"add(...)");
        BlockHitResult hitResult = SolverBlockEntity.raycastBeam$default(this, level, vec3, vec32, null, 8, null);
        BlockHitResult blockHitResult = hitResult;
        if (blockHitResult == null || (blockHitResult = blockHitResult.m_82450_()) == null) {
            blockHitResult = this.getWorldPos().m_82549_(this.getWorldFacing().m_82490_(64.0));
        }
        this.lastHitPosition = blockHitResult;
        this.lastHitBlock = hitResult != null ? hitResult.m_82425_() : null;
        Level level2 = this.f_58857_;
        boolean bl = level2 != null ? level2.f_46443_ : false;
        if (bl) {
            this.clientTime += 0.05f;
            if (this.ticksTillLightning > 0) {
                int n = this.ticksTillLightning;
                this.ticksTillLightning = n + -1;
            } else {
                Vec3 vec33 = this.getWorldPos();
                Vec3 vec34 = this.lastHitPosition;
                Intrinsics.checkNotNull((Object)vec34);
                double len = vec33.m_82554_(vec34);
                double turns = len * 4.25;
                long l = this.beamSeed;
                Level level3 = this.f_58857_;
                Intrinsics.checkNotNull((Object)level3);
                long l2 = level3.m_46467_();
                Level level4 = this.f_58857_;
                Intrinsics.checkNotNull((Object)level4);
                ArcBias.DoubleHelix doubleHelix = new ArcBias.DoubleHelix(turns, 0.0, (double)level4.m_46467_() * 0.4, null, 0.0, 26, null);
                LightningManager.INSTANCE.spawn(new LightningBolt(() -> SolverBlockEntity.tick$lambda$0(this), () -> SolverBlockEntity.tick$lambda$1(this), l, l2, 12, 0.0f, 0.0, 0, 0.0, 0.01, true, doubleHelix, 480, null));
                this.ticksTillLightning = 3;
            }
            return;
        }
        if (hitResult != null && this.f_58857_ instanceof ServerLevel) {
            Level level5 = this.f_58857_;
            Intrinsics.checkNotNull((Object)level5, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel sLevel = (ServerLevel)level5;
            BlockState hitBlock = sLevel.m_8055_(hitResult.m_82425_());
            if (!Intrinsics.areEqual((Object)this.lastHitBlock, (Object)this.previousHitBlock)) {
                this.destroyProgress = 0.0f;
            }
            float targetResistance = Math.max(hitBlock.m_60734_().m_7325_(), 0.01f);
            this.destroyProgress += Mth.m_14036_((float)(0.5f * Math.abs(4.0f * Mth.m_14036_((float)(1.0f / targetResistance), (float)0.1f, (float)1.0f))), (float)0.0f, (float)2.0f);
            this.destroyProgress = Mth.m_14036_((float)this.destroyProgress, (float)0.0f, (float)1.0f);
            sLevel.m_8767_((ParticleOptions)ParticleTypes.f_123799_, (double)hitResult.m_82425_().m_123341_() + 0.5, (double)hitResult.m_82425_().m_123342_() + 0.5, (double)hitResult.m_82425_().m_123343_() + 0.5, 10, Math.random(), Math.random(), Math.random(), 1.0);
            sLevel.m_6801_(0, hitResult.m_82425_(), (int)(this.destroyProgress * 10.0f));
            for (int dx = -1; dx < 2; ++dx) {
                for (int dy = -1; dy < 2; ++dy) {
                    for (int dz = -1; dz < 2; ++dz) {
                        BlockPos neighborPos = hitResult.m_82425_().m_7918_(dx, dy, dz);
                        if (Intrinsics.areEqual((Object)neighborPos, (Object)hitResult.m_82425_())) continue;
                        BlockState neighborBlock = sLevel.m_8055_(neighborPos);
                        float neighborResistance = Math.max(neighborBlock.m_60734_().m_7325_(), 0.01f);
                        float neighborProgress = Mth.m_14036_((float)(this.destroyProgress - 0.2f * Math.abs(4.0f * Mth.m_14036_((float)(1.0f / neighborResistance), (float)0.1f, (float)1.0f))), (float)0.0f, (float)1.0f);
                        sLevel.m_6801_(0, neighborPos, (int)(neighborProgress * 10.0f));
                        if (!(neighborProgress >= 1.0f)) continue;
                        sLevel.m_46961_(neighborPos, true);
                    }
                }
            }
            if (this.destroyProgress >= 1.0f) {
                sLevel.m_46961_(hitResult.m_82425_(), true);
                this.destroyProgress = 0.0f;
            }
            Vec3 vec35 = this.getWorldPos();
            Vec3 vec36 = this.lastHitPosition;
            Intrinsics.checkNotNull((Object)vec36);
            BlockHitResult entityCastResult = sLevel.m_45547_(new ClipContext(vec35, vec36, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
            if (entityCastResult.m_6662_() == HitResult.Type.ENTITY) {
                Intrinsics.checkNotNull((Object)entityCastResult, (String)"null cannot be cast to non-null type net.minecraft.world.phys.EntityHitResult");
                Entity entity = ((EntityHitResult)entityCastResult).m_82443_();
                RegistryAccess registryAccess = sLevel.m_9598_();
                Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
                entity.m_6469_(ClockworkDamageTypes.INSTANCE.solver(registryAccess, entity), 4.0f);
            }
        } else {
            this.destroyProgress = 0.0f;
        }
        this.previousHitPosition = this.lastHitPosition;
        this.previousHitBlock = this.lastHitBlock;
    }

    @Override
    public int getMaxConnections() {
        return 4;
    }

    @Override
    public boolean canConnect(@NotNull IArcConnector other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return IArcConnector.super.canConnect(other);
    }

    @Override
    @NotNull
    public Vec3 getWorldPos() {
        BlockPos blockPos = this.f_58858_;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
        LoadedShip loadedShip = VSGameUtilsKt.getLoadedShipManagingPos((Level)this.f_58857_, (Vec3i)((Vec3i)blockPos));
        if (loadedShip == null) {
            Vec3i vec3i = ((Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_)).m_122436_();
            Intrinsics.checkNotNullExpressionValue((Object)vec3i, (String)"getNormal(...)");
            return VectorConversionsMCKt.toDoubles((Vec3i)vec3i);
        }
        LoadedShip ship = loadedShip;
        ShipTransform transform = ship instanceof ClientShip ? ((ClientShip)ship).getRenderTransform() : ship.getTransform();
        Matrix4dc matrix4dc = transform.getShipToWorld();
        Vec3 vec3 = Vec3.m_82512_((Vec3i)((Vec3i)this.f_58858_));
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"atCenterOf(...)");
        Vector3d vector3d = matrix4dc.transformPosition(VectorConversionsMCKt.toJOML((Vec3)vec3));
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"transformPosition(...)");
        Vec3 vec32 = VectorConversionsMCKt.toMinecraft((Vector3dc)((Vector3dc)vector3d)).m_82549_(this.getWorldFacing().m_82490_(1.5));
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"add(...)");
        return vec32;
    }

    @NotNull
    public final Vec3 getWorldFacing() {
        BlockPos blockPos = this.f_58858_;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
        LoadedShip loadedShip = VSGameUtilsKt.getLoadedShipManagingPos((Level)this.f_58857_, (Vec3i)((Vec3i)blockPos));
        if (loadedShip == null) {
            Vec3i vec3i = ((Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_)).m_122436_();
            Intrinsics.checkNotNullExpressionValue((Object)vec3i, (String)"getNormal(...)");
            return VectorConversionsMCKt.toDoubles((Vec3i)vec3i);
        }
        LoadedShip ship = loadedShip;
        ShipTransform transform = ship instanceof ClientShip ? ((ClientShip)ship).getRenderTransform() : ship.getTransform();
        Quaterniondc quaterniondc = transform.getShipToWorldRotation();
        Vec3i vec3i = ((Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_)).m_122436_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3i, (String)"getNormal(...)");
        Vector3d vector3d = quaterniondc.transform(VectorConversionsMCKt.toJOMLD((Vec3i)vec3i));
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"transform(...)");
        return VectorConversionsMCKt.toMinecraft((Vector3dc)((Vector3dc)vector3d));
    }

    @Override
    @NotNull
    public DuctNodePos getDuctNodePosition() {
        BlockPos blockPos = this.f_58858_;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        ResourceLocation resourceLocation = level.m_46472_().m_135782_();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"location(...)");
        return KelvinExtensions.INSTANCE.toDuctNodePos(blockPos, resourceLocation);
    }

    @Nullable
    public final BlockHitResult raycastBeam(@NotNull Level level, @NotNull Vec3 start, @NotNull Vec3 desiredEnd, @Nullable Entity entity) {
        BlockHitResult blockHitResult;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)desiredEnd, (String)"desiredEnd");
        ClipContext ctx = new ClipContext(start, desiredEnd, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity);
        BlockHitResult r = level.m_45547_(ctx);
        if (r.m_6662_() == HitResult.Type.BLOCK) {
            Intrinsics.checkNotNull((Object)r, (String)"null cannot be cast to non-null type net.minecraft.world.phys.BlockHitResult");
            blockHitResult = r;
        } else {
            blockHitResult = null;
        }
        return blockHitResult;
    }

    public static /* synthetic */ BlockHitResult raycastBeam$default(SolverBlockEntity solverBlockEntity, Level level, Vec3 vec3, Vec3 vec32, Entity entity, int n, Object object) {
        if ((n & 8) != 0) {
            entity = null;
        }
        return solverBlockEntity.raycastBeam(level, vec3, vec32, entity);
    }

    private static final Vec3 tick$lambda$0(SolverBlockEntity this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.getWorldPos();
    }

    private static final Vec3 tick$lambda$1(SolverBlockEntity this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Vec3 vec3 = this$0.lastHitPosition;
        if (vec3 == null) {
            Vec3 vec32 = this$0.getWorldPos().m_82549_(this$0.getWorldFacing().m_82490_(64.0));
            vec3 = vec32;
            Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"add(...)");
        }
        return vec3;
    }
}

