/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.curiosities.sensor.rotation;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B)\u0012\f\u0010<\u001a\b\u0012\u0002\b\u0003\u0018\u00010;\u0012\b\u0010=\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010?\u001a\u0004\u0018\u00010>\u00a2\u0006\u0004\b@\u0010AJ\u001f\u0010\u0007\u001a\u00020\u00062\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u000e\u0010\rJ\r\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000f\u0010\nJ\u000f\u0010\u0010\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0010\u0010\nJ\u000f\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001f\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001aJ\u001f\u0010 \u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b \u0010!J\u0017\u0010$\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\"H\u0016\u00a2\u0006\u0004\b$\u0010%J\u0017\u0010)\u001a\u00020(2\u0006\u0010'\u001a\u00020&H\u0016\u00a2\u0006\u0004\b)\u0010*J)\u0010.\u001a\u00020\u00142\u0006\u0010+\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u00182\b\u0010-\u001a\u0004\u0018\u00010&H\u0016\u00a2\u0006\u0004\b.\u0010/J'\u00100\u001a\u00020\u00142\u0006\u0010+\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u00182\u0006\u0010-\u001a\u00020&H\u0016\u00a2\u0006\u0004\b0\u0010/R\u001d\u00102\u001a\b\u0012\u0004\u0012\u00020\u0018018\u0006\u00a2\u0006\f\n\u0004\b2\u00103\u001a\u0004\b4\u00105R\"\u00106\u001a\u00020\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b6\u00107\u001a\u0004\b8\u0010\u0013\"\u0004\b9\u0010:\u00a8\u0006B"}, d2={"Lorg/valkyrienskies/clockwork/content/curiosities/sensor/rotation/LodefocusBlockEntity;", "Lcom/simibubi/create/foundation/blockEntity/SmartBlockEntity;", "Lnet/minecraft/world/WorldlyContainer;", "", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BlockEntityBehaviour;", "behaviours", "", "addBehaviours", "(Ljava/util/List;)V", "tick", "()V", "Lnet/minecraft/core/BlockPos;", "getTargetPosition", "()Lnet/minecraft/core/BlockPos;", "getWorldspaceTargetPosition", "dropCompass", "clearContent", "", "getContainerSize", "()I", "", "isEmpty", "()Z", "slot", "Lnet/minecraft/world/item/ItemStack;", "getItem", "(I)Lnet/minecraft/world/item/ItemStack;", "amount", "removeItem", "(II)Lnet/minecraft/world/item/ItemStack;", "removeItemNoUpdate", "stack", "setItem", "(ILnet/minecraft/world/item/ItemStack;)V", "Lnet/minecraft/world/entity/player/Player;", "player", "stillValid", "(Lnet/minecraft/world/entity/player/Player;)Z", "Lnet/minecraft/core/Direction;", "side", "", "getSlotsForFace", "(Lnet/minecraft/core/Direction;)[I", "index", "itemStack", "direction", "canPlaceItemThroughFace", "(ILnet/minecraft/world/item/ItemStack;Lnet/minecraft/core/Direction;)Z", "canTakeItemThroughFace", "Lnet/minecraft/core/NonNullList;", "inventory", "Lnet/minecraft/core/NonNullList;", "getInventory", "()Lnet/minecraft/core/NonNullList;", "insertionCooldown", "I", "getInsertionCooldown", "setInsertionCooldown", "(I)V", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "type", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "clockwork"})
public final class LodefocusBlockEntity
extends SmartBlockEntity
implements WorldlyContainer {
    @NotNull
    private final NonNullList<ItemStack> inventory;
    private int insertionCooldown;

    public LodefocusBlockEntity(@Nullable BlockEntityType<?> type, @Nullable BlockPos pos, @Nullable BlockState state) {
        super(type, pos, state);
        NonNullList nonNullList = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"withSize(...)");
        this.inventory = nonNullList;
    }

    @NotNull
    public final NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public final int getInsertionCooldown() {
        return this.insertionCooldown;
    }

    public final void setInsertionCooldown(int n) {
        this.insertionCooldown = n;
    }

    public void addBehaviours(@Nullable List<BlockEntityBehaviour> behaviours) {
    }

    public void tick() {
        super.tick();
        if (this.insertionCooldown > 0) {
            int n = this.insertionCooldown;
            this.insertionCooldown = n + -1;
        }
    }

    @Nullable
    public final BlockPos getTargetPosition() {
        Object object = this.inventory.get(0);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        ItemStack stack = (ItemStack)object;
        if (stack.m_41619_()) {
            return null;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_("LodestoneTracked")) {
            return null;
        }
        CompoundTag pos = tag.m_128469_("LodestonePos");
        int x = pos.m_128451_("X");
        int y = pos.m_128451_("Y");
        int z = pos.m_128451_("Z");
        return new BlockPos(x, y, z);
    }

    @Nullable
    public final BlockPos getWorldspaceTargetPosition() {
        BlockPos targetPosition = this.getTargetPosition();
        if (targetPosition == null) {
            return null;
        }
        if (this.f_58857_ == null) {
            return targetPosition;
        }
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        return BlockPos.m_274446_((Position)((Position)VSGameUtilsKt.toWorldCoordinates((Level)level, (BlockPos)targetPosition)));
    }

    public final void dropCompass() {
        if (!((ItemStack)this.inventory.get(0)).m_41619_()) {
            Object object = this.inventory.get(0);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            ItemStack oldItem = (ItemStack)object;
            if (this.f_58857_ != null) {
                Level level = this.f_58857_;
                Intrinsics.checkNotNull((Object)level);
                if (!level.f_46443_) {
                    Level level2 = this.f_58857_;
                    Intrinsics.checkNotNull((Object)level2, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                    ServerLevel sLevel = (ServerLevel)level2;
                    Random random = new Random();
                    double launchX = random.nextDouble(0.0, 0.5);
                    double launchY = random.nextDouble(0.0, 1.5);
                    double launchZ = random.nextDouble(0.0, 0.5);
                    Level level3 = (Level)sLevel;
                    BlockPos blockPos = this.f_58858_;
                    Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
                    Vec3 worldPos = VSGameUtilsKt.toWorldCoordinates((Level)level3, (BlockPos)blockPos);
                    ItemEntity itemEntity = new ItemEntity((Level)sLevel, worldPos.f_82479_, worldPos.f_82480_, worldPos.f_82481_, oldItem, launchX, launchY, launchZ);
                    sLevel.m_7967_((Entity)itemEntity);
                    sLevel.m_6263_(null, worldPos.f_82479_, worldPos.f_82480_, worldPos.f_82481_, SoundEvents.f_12016_, SoundSource.BLOCKS, 0.65f, 1.0f);
                    this.m_6211_();
                }
            }
        }
    }

    public void m_6211_() {
        this.inventory.clear();
    }

    public int m_6643_() {
        return 1;
    }

    public boolean m_7983_() {
        return ((ItemStack)this.inventory.get(0)).m_41619_();
    }

    @NotNull
    public ItemStack m_8020_(int slot) {
        Object object = this.inventory.get(slot);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (ItemStack)object;
    }

    @NotNull
    public ItemStack m_7407_(int slot, int amount) {
        if (((ItemStack)this.inventory.get(slot)).m_41619_()) {
            ItemStack itemStack = ItemStack.f_41583_;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        ItemStack result = ((ItemStack)this.inventory.get(slot)).m_41620_(amount);
        if (((ItemStack)this.inventory.get(slot)).m_41619_()) {
            this.inventory.set(slot, (Object)ItemStack.f_41583_);
        }
        Intrinsics.checkNotNull((Object)result);
        return result;
    }

    @NotNull
    public ItemStack m_8016_(int slot) {
        Object object = this.inventory.get(slot);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        ItemStack result = (ItemStack)object;
        this.inventory.set(slot, (Object)ItemStack.f_41583_);
        return result;
    }

    public void m_6836_(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (stack.m_150930_(Items.f_42522_)) {
            CompoundTag compoundTag = stack.m_41783_();
            boolean bl = compoundTag != null ? compoundTag.m_128471_("LodestoneTracked") : false;
            if (bl) {
                if (!((ItemStack)this.inventory.get(slot)).m_41619_()) {
                    Object object = this.inventory.get(slot);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                    ItemStack oldItem = (ItemStack)object;
                    if (this.f_58857_ != null) {
                        Level level = this.f_58857_;
                        Intrinsics.checkNotNull((Object)level);
                        if (!level.f_46443_) {
                            Level level2 = this.f_58857_;
                            Intrinsics.checkNotNull((Object)level2, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                            ServerLevel sLevel = (ServerLevel)level2;
                            Random random = new Random();
                            double launchX = random.nextDouble(0.0, 0.5);
                            double launchY = random.nextDouble(0.0, 1.5);
                            double launchZ = random.nextDouble(0.0, 0.5);
                            Level level3 = (Level)sLevel;
                            BlockPos blockPos = this.f_58858_;
                            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
                            Vec3 worldPos = VSGameUtilsKt.toWorldCoordinates((Level)level3, (BlockPos)blockPos);
                            ItemEntity itemEntity = new ItemEntity((Level)sLevel, worldPos.f_82479_, worldPos.f_82480_, worldPos.f_82481_, oldItem, launchX, launchY, launchZ);
                            sLevel.m_7967_((Entity)itemEntity);
                            sLevel.m_6263_(null, worldPos.f_82479_, worldPos.f_82480_, worldPos.f_82481_, SoundEvents.f_12016_, SoundSource.BLOCKS, 0.65f, 1.0f);
                        }
                    }
                }
                this.inventory.set(slot, (Object)stack);
                this.insertionCooldown = 10;
            }
        }
    }

    public boolean m_6542_(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return true;
    }

    @NotNull
    public int[] m_7071_(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return new int[1];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean m_7155_(int index, @NotNull ItemStack itemStack, @Nullable Direction direction) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        if (!itemStack.m_150930_(Items.f_42522_)) return false;
        CompoundTag compoundTag = itemStack.m_41783_();
        if (compoundTag == null) return false;
        if (!compoundTag.m_128471_("LodestoneTracked")) return false;
        return true;
    }

    public boolean m_7157_(int index, @NotNull ItemStack stack, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        return true;
    }
}

