/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.curiosities.sensor.distance;

import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3dc;
import org.valkyrienskies.clockwork.ClockworkItems;
import org.valkyrienskies.clockwork.ClockworkSounds;
import org.valkyrienskies.clockwork.ClockworkTags;
import org.valkyrienskies.clockwork.content.curiosities.sensor.ISensorBlock;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.mod.common.world.RaycastUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 G2\u00020\u00012\u00020\u0002:\u0001GB\u0011\u0012\b\u0010D\u001a\u0004\u0018\u00010C\u00a2\u0006\u0004\bE\u0010FJ'\u0010\b\u001a\u00020\u00072\u0016\u0010\u0006\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003H\u0014\u00a2\u0006\u0004\b\b\u0010\tJ7\u0010\u0012\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001f\u0010\u0016\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001f\u0010\u0019\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ/\u0010\u001e\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ/\u0010\"\u001a\u00020!2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020 H\u0016\u00a2\u0006\u0004\b\"\u0010#J?\u0010+\u001a\u00020*2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010%\u001a\u00020$2\u0006\u0010'\u001a\u00020&2\u0006\u0010)\u001a\u00020(H\u0016\u00a2\u0006\u0004\b+\u0010,J?\u00103\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u00020\u00052\u0006\u0010\f\u001a\u0002002\u0006\u00101\u001a\u00020\r2\u0006\u00102\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b3\u00104J\u001f\u00105\u001a\u00020\u00072\u0006\u0010\f\u001a\u0002002\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b5\u00106J'\u00107\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0005H\u0004\u00a2\u0006\u0004\b7\u00108J\u0017\u00109\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b9\u0010:J/\u0010<\u001a\u00020!2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020;2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010.\u001a\u00020-H\u0016\u00a2\u0006\u0004\b<\u0010=J/\u0010>\u001a\u00020!2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020;2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010.\u001a\u00020-H\u0016\u00a2\u0006\u0004\b>\u0010=J\u0017\u0010A\u001a\u00020\u00052\u0006\u0010@\u001a\u00020?H\u0016\u00a2\u0006\u0004\bA\u0010B\u00a8\u0006H"}, d2={"Lorg/valkyrienskies/clockwork/content/curiosities/sensor/distance/DistanceSensorBlock;", "Lnet/minecraft/world/level/block/DirectionalBlock;", "Lorg/valkyrienskies/clockwork/content/curiosities/sensor/ISensorBlock;", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/state/BlockState;", "builder", "", "createBlockStateDefinition", "(Lnet/minecraft/world/level/block/state/StateDefinition$Builder;)V", "state", "Lnet/minecraft/world/level/Level;", "level", "Lnet/minecraft/core/BlockPos;", "pos", "oldState", "", "isMoving", "onPlace", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Z)V", "Lnet/minecraft/world/level/block/Rotation;", "rotation", "rotate", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/Rotation;)Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/world/level/block/Mirror;", "mirror", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/Mirror;)Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/server/level/ServerLevel;", "Lnet/minecraft/util/RandomSource;", "random", "tick", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V", "Ljava/util/Random;", "", "updatePower", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Ljava/util/Random;)I", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/InteractionHand;", "hand", "Lnet/minecraft/world/phys/BlockHitResult;", "hit", "Lnet/minecraft/world/InteractionResult;", "use", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;", "Lnet/minecraft/core/Direction;", "direction", "neighborState", "Lnet/minecraft/world/level/LevelAccessor;", "currentPos", "neighborPos", "updateShape", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/Direction;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;", "startSignal", "(Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;)V", "updateNeighborsInFront", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "isSignalSource", "(Lnet/minecraft/world/level/block/state/BlockState;)Z", "Lnet/minecraft/world/level/BlockGetter;", "getDirectSignal", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)I", "getSignal", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "context", "getStateForPlacement", "(Lnet/minecraft/world/item/context/BlockPlaceContext;)Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "properties", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "Companion", "clockwork"})
public final class DistanceSensorBlock
extends DirectionalBlock
implements ISensorBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final IntegerProperty MAX_DISTANCE = IntegerProperty.m_61631_((String)"max_distance", (int)1, (int)4);

    public DistanceSensorBlock(@Nullable BlockBehaviour.Properties properties) {
        super(properties);
        StateHolder stateHolder = this.f_49792_.m_61090_();
        Intrinsics.checkNotNull((Object)stateHolder, (String)"null cannot be cast to non-null type net.minecraft.world.level.block.state.BlockState");
        Object object = ((BlockState)stateHolder).m_61124_((Property)DirectionalBlock.f_52588_, (Comparable)Direction.SOUTH);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.minecraft.world.level.block.state.BlockState");
        Object object2 = ((BlockState)((BlockState)object).m_61124_((Property)ISensorBlock.Companion.getPOWER(), (Comparable)Integer.valueOf(0))).m_61124_((Property)MAX_DISTANCE, (Comparable)Integer.valueOf(1));
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type net.minecraft.world.level.block.state.BlockState");
        this.m_49959_((BlockState)object2);
    }

    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{DirectionalBlock.f_52588_, ISensorBlock.Companion.getPOWER(), MAX_DISTANCE};
        builder.m_61104_(propertyArray);
    }

    public void m_6807_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean isMoving) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
        if (!level.f_46443_) {
            level.m_186460_(pos, (Block)this, 2);
        }
        super.m_6807_(state, level, pos, oldState, isMoving);
    }

    @NotNull
    public BlockState m_6843_(@NotNull BlockState state, @NotNull Rotation rotation) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)rotation, (String)"rotation");
        Object object = state.m_61124_((Property)DirectionalBlock.f_52588_, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)DirectionalBlock.f_52588_)));
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.minecraft.world.level.block.state.BlockState");
        return (BlockState)object;
    }

    @NotNull
    public BlockState m_6943_(@NotNull BlockState state, @NotNull Mirror mirror) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)mirror, (String)"mirror");
        BlockState blockState = state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)DirectionalBlock.f_52588_)));
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"rotate(...)");
        return blockState;
    }

    public void m_213897_(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        int power;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Integer n = (Integer)state.m_61143_((Property)ISensorBlock.Companion.getPOWER());
        if (n == null || (power = this.updatePower(state, level, pos, new Random())) != n) {
            Object object = state.m_61124_((Property)ISensorBlock.Companion.getPOWER(), (Comparable)Integer.valueOf(power));
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.minecraft.world.level.block.state.BlockState");
            level.m_7731_(pos, (BlockState)object, 2);
            level.m_46672_(pos, (Block)this);
        }
        level.m_186460_(pos, (Block)this, 2);
        this.updateNeighborsInFront((Level)level, pos, state);
    }

    @Override
    public int updatePower(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull Random random) {
        int n;
        block12: {
            boolean spotAllFluids;
            boolean spotWater;
            boolean hasAdjacentLens;
            block11: {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
                Intrinsics.checkNotNullParameter((Object)random, (String)"random");
                BlockState adjacentState = level.m_8055_(pos.m_121945_((Direction)state.m_61143_((Property)DirectionalBlock.f_52588_)));
                hasAdjacentLens = adjacentState.m_204336_(ClockworkTags.AllBlockTags.SENSOR_LENS.getTag());
                spotWater = adjacentState.m_60713_(Blocks.f_50211_);
                spotAllFluids = adjacentState.m_60713_(Blocks.f_50214_);
                if (adjacentState.m_60795_() || !adjacentState.m_60831_((BlockGetter)level, pos)) break block11;
                n = 0;
                break block12;
            }
            LoadedServerShip ship = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)level, (Vec3i)((Vec3i)pos));
            boolean offsetModifier = hasAdjacentLens;
            Vec3 vec3 = Vec3.m_82512_((Vec3i)((Vec3i)pos));
            Vec3i vec3i = ((Direction)state.m_61143_((Property)DirectionalBlock.f_52588_)).m_122436_();
            Intrinsics.checkNotNullExpressionValue((Object)vec3i, (String)"getNormal(...)");
            Vec3 refPos = vec3.m_82549_(VectorConversionsMCKt.toDoubles((Vec3i)vec3i).m_82542_(0.5, 0.5, 0.5));
            if (offsetModifier) {
                Vec3i vec3i2 = ((Direction)state.m_61143_((Property)DirectionalBlock.f_52588_)).m_122436_();
                Intrinsics.checkNotNullExpressionValue((Object)vec3i2, (String)"getNormal(...)");
                refPos = refPos.m_82549_(VectorConversionsMCKt.toDoubles((Vec3i)vec3i2));
            }
            int distance = ((Number)((Object)state.m_61143_((Property)MAX_DISTANCE))).intValue() * 16 - 1;
            Vec3 targetPos = Vec3.m_82512_((Vec3i)((Vec3i)pos.m_5484_((Direction)state.m_61143_((Property)DirectionalBlock.f_52588_), distance)));
            if (offsetModifier) {
                Vec3i vec3i3 = ((Direction)state.m_61143_((Property)DirectionalBlock.f_52588_)).m_122436_();
                Intrinsics.checkNotNullExpressionValue((Object)vec3i3, (String)"getNormal(...)");
                targetPos = targetPos.m_82549_(VectorConversionsMCKt.toDoubles((Vec3i)vec3i3));
            }
            if (ship != null) {
                Ship ship2 = (Ship)ship;
                Vec3 vec32 = refPos;
                Intrinsics.checkNotNull((Object)vec32);
                refPos = VSGameUtilsKt.toWorldCoordinates((Ship)ship2, (Vec3)vec32);
                Ship ship3 = (Ship)ship;
                vec32 = targetPos;
                Intrinsics.checkNotNull((Object)vec32);
                targetPos = VSGameUtilsKt.toWorldCoordinates((Ship)ship3, (Vec3)vec32);
            }
            boolean shouldCast = true;
            int result = 0;
            do {
                BlockHitResult castResult;
                block13: {
                    LoadedServerShip loadedServerShip;
                    block15: {
                        block14: {
                            ClipContext.Fluid fluidContext = spotAllFluids ? ClipContext.Fluid.ANY : (spotWater ? ClipContext.Fluid.WATER : ClipContext.Fluid.NONE);
                            ClipContext clipContext = new ClipContext(refPos, targetPos, ClipContext.Block.COLLIDER, fluidContext, null);
                            LoadedServerShip loadedServerShip2 = ship;
                            castResult = RaycastUtilsKt.clipIncludeShips$default((Level)((Level)level), (ClipContext)clipContext, (boolean)true, (Long)(loadedServerShip2 != null ? Long.valueOf(loadedServerShip2.getId()) : null), (boolean)false, (int)8, null);
                            if (castResult.m_6662_() == HitResult.Type.MISS) {
                                result = 15;
                                shouldCast = false;
                                continue;
                            }
                            if (!level.m_8055_(castResult.m_82425_()).m_204336_(ClockworkTags.AllBlockTags.SENSOR_LENS.getTag())) break block13;
                            if (level.m_8055_(castResult.m_82425_()).m_60713_(Blocks.f_50211_)) {
                                spotWater = true;
                            } else if (level.m_8055_(castResult.m_82425_()).m_60713_(Blocks.f_50214_)) {
                                spotAllFluids = true;
                            }
                            if ((loadedServerShip = ship) == null || (loadedServerShip = loadedServerShip.getWorldToShip()) == null) break block14;
                            Vec3 vec33 = castResult.m_82450_();
                            Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"getLocation(...)");
                            if ((loadedServerShip = loadedServerShip.transformPosition(VectorConversionsMCKt.toJOML((Vec3)vec33))) == null) break block14;
                            Vec3i vec3i4 = ((Direction)state.m_61143_((Property)DirectionalBlock.f_52588_)).m_122436_();
                            Intrinsics.checkNotNullExpressionValue((Object)vec3i4, (String)"getNormal(...)");
                            if ((loadedServerShip = loadedServerShip.add((Vector3dc)VectorConversionsMCKt.toJOML((Vec3)VectorConversionsMCKt.toDoubles((Vec3i)vec3i4)))) != null && (loadedServerShip = VectorConversionsMCKt.toMinecraft((Vector3dc)((Vector3dc)loadedServerShip))) != null) break block15;
                        }
                        Vec3 vec34 = castResult.m_82450_();
                        Vec3i vec3i5 = ((Direction)state.m_61143_((Property)DirectionalBlock.f_52588_)).m_122436_();
                        Intrinsics.checkNotNullExpressionValue((Object)vec3i5, (String)"getNormal(...)");
                        loadedServerShip = vec34.m_82549_(VectorConversionsMCKt.toDoubles((Vec3i)vec3i5));
                    }
                    refPos = loadedServerShip;
                    Vec3i vec3i6 = ((Direction)state.m_61143_((Property)DirectionalBlock.f_52588_)).m_122436_();
                    Intrinsics.checkNotNullExpressionValue((Object)vec3i6, (String)"getNormal(...)");
                    targetPos = refPos.m_82549_(VectorConversionsMCKt.toDoubles((Vec3i)vec3i6).m_82490_((double)distance));
                    if (ship == null) continue;
                    Ship ship4 = (Ship)ship;
                    Vec3 vec35 = refPos;
                    Intrinsics.checkNotNull((Object)vec35);
                    refPos = VSGameUtilsKt.toWorldCoordinates((Ship)ship4, (Vec3)vec35);
                    Ship ship5 = (Ship)ship;
                    vec35 = targetPos;
                    Intrinsics.checkNotNull((Object)vec35);
                    targetPos = VSGameUtilsKt.toWorldCoordinates((Ship)ship5, (Vec3)vec35);
                    continue;
                }
                double dist = refPos.m_82554_(castResult.m_82450_());
                result = Math.min((int)(dist / (double)((Number)((Object)state.m_61143_((Property)MAX_DISTANCE))).intValue()), 15);
                shouldCast = false;
            } while (shouldCast);
            n = result;
        }
        return n;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)hit, (String)"hit");
        if (!level.f_46443_ && player.m_21120_(hand).m_150930_((Item)ClockworkItems.SCREWDRIVER.get())) {
            Integer currentMax;
            Integer n = currentMax = (Integer)state.m_61143_((Property)MAX_DISTANCE);
            int n2 = 4;
            int nextMax = n != null && n == n2 ? 1 : currentMax + 1;
            Object object = state.m_61124_((Property)MAX_DISTANCE, (Comparable)Integer.valueOf(nextMax));
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.minecraft.world.level.block.state.BlockState");
            level.m_7731_(pos, (BlockState)object, 2);
            float pitch = level.f_46441_.m_188501_() * 0.2f + 0.9f;
            SoundEvent soundEvent = ClockworkSounds.INSTANCE.getWAND_WELD().getMainEvent();
            Intrinsics.checkNotNull((Object)soundEvent);
            level.m_5594_(null, pos, soundEvent, player.m_5720_(), 1.0f, pitch);
            level.m_186460_(pos, (Block)this, 2);
            return InteractionResult.SUCCESS;
        }
        InteractionResult interactionResult = super.m_6227_(state, level, pos, player, hand, hit);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"use(...)");
        return interactionResult;
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos neighborPos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)neighborState, (String)"neighborState");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)currentPos, (String)"currentPos");
        Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
        if (state.m_61143_((Property)DirectionalBlock.f_52588_) == direction) {
            Integer n = (Integer)state.m_61143_((Property)ISensorBlock.Companion.getPOWER());
            if (n == null || n != 0) {
                this.startSignal(level, currentPos);
            }
        }
        BlockState blockState = super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"updateShape(...)");
        return blockState;
    }

    private final void startSignal(LevelAccessor level, BlockPos pos) {
        if (!level.m_5776_() && !level.m_183326_().m_183582_(pos, (Object)this)) {
            level.m_186460_(pos, (Block)this, 2);
        }
    }

    protected final void updateNeighborsInFront(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Direction direction = (Direction)state.m_61143_((Property)DirectionalBlock.f_52588_);
        BlockPos blockPos = pos.m_121945_(direction.m_122424_());
        level.m_46586_(blockPos, (Block)this, pos);
        level.m_46590_(blockPos, (Block)this, direction);
    }

    public boolean m_7899_(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return true;
    }

    public int m_6376_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        return state.m_60746_(level, pos, direction);
    }

    public int m_6378_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Integer n = (Integer)state.m_61143_((Property)ISensorBlock.Companion.getPOWER());
        if ((n == null || n != 0) && state.m_61143_((Property)DirectionalBlock.f_52588_) == direction) {
            Comparable comparable = state.m_61143_((Property)ISensorBlock.Companion.getPOWER());
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
            return ((Number)((Object)comparable)).intValue();
        }
        return 0;
    }

    @NotNull
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = this.m_49966_().m_61124_((Property)DirectionalBlock.f_52588_, (Comparable)context.m_7820_().m_122424_().m_122424_());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
        return (BlockState)object;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\b\u0010\tR\u001f\u0010\u0004\u001a\n \u0003*\u0004\u0018\u00010\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/valkyrienskies/clockwork/content/curiosities/sensor/distance/DistanceSensorBlock$Companion;", "", "Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "kotlin.jvm.PlatformType", "MAX_DISTANCE", "Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "getMAX_DISTANCE", "()Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "<init>", "()V", "clockwork"})
    public static final class Companion {
        private Companion() {
        }

        public final IntegerProperty getMAX_DISTANCE() {
            return MAX_DISTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

