/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.curiosities.meteor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.clockwork.ClockworkRenderTypes;
import org.valkyrienskies.clockwork.content.curiosities.meteor.MeteorVfxState;
import org.valkyrienskies.clockwork.content.curiosities.meteor.TrailSample;
import org.valkyrienskies.core.api.ships.ClientShip;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b;\u0010<J5\u0010\r\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ5\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000f\u0010\u000eJc\u0010\u001f\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\n\u00a2\u0006\u0004\b\u001f\u0010 J\u001d\u0010#\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020!\u00a2\u0006\u0004\b#\u0010$J\u0085\u0001\u00103\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020\n2\u0006\u0010-\u001a\u00020\n2\u0006\u0010.\u001a\u00020\n2\b\b\u0002\u00100\u001a\u00020/2\b\b\u0002\u00101\u001a\u00020/2\b\b\u0002\u00102\u001a\u00020/H\u0002\u00a2\u0006\u0004\b3\u00104R#\u00107\u001a\u000e\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u00020!058\u0006\u00a2\u0006\f\n\u0004\b7\u00108\u001a\u0004\b9\u0010:\u00a8\u0006="}, d2={"Lorg/valkyrienskies/clockwork/content/curiosities/meteor/MeteorRenderer;", "", "Lorg/valkyrienskies/core/api/ships/ClientShip;", "ship", "Lcom/mojang/blaze3d/vertex/PoseStack;", "ms", "Lnet/minecraft/client/Camera;", "camera", "Lnet/minecraft/client/renderer/MultiBufferSource;", "bufferSource", "", "pt", "", "onShipRender", "(Lorg/valkyrienskies/core/api/ships/ClientShip;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/MultiBufferSource;F)V", "renderMeteor", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "vc", "Lorg/joml/Matrix4f;", "pose", "Lkotlin/collections/ArrayDeque;", "Lorg/valkyrienskies/clockwork/content/curiosities/meteor/TrailSample;", "samples", "", "camPosX", "camPosY", "camPosZ", "camLookX", "camLookY", "camLookZ", "time", "renderTrailRibbon", "(Lcom/mojang/blaze3d/vertex/VertexConsumer;Lorg/joml/Matrix4f;Lkotlin/collections/ArrayDeque;DDDDDDF)V", "Lorg/valkyrienskies/clockwork/content/curiosities/meteor/MeteorVfxState;", "state", "updateMeteorStateWorld", "(Lorg/valkyrienskies/core/api/ships/ClientShip;Lorg/valkyrienskies/clockwork/content/curiosities/meteor/MeteorVfxState;)V", "poseStack", "x", "y", "z", "u", "v", "a", "normalX", "normalY", "normalZ", "", "r", "g", "b", "putVert", "(Lcom/mojang/blaze3d/vertex/VertexConsumer;Lorg/joml/Matrix4f;DDDFFFFFFIII)V", "Ljava/util/HashMap;", "", "meteorList", "Ljava/util/HashMap;", "getMeteorList", "()Ljava/util/HashMap;", "<init>", "()V", "clockwork"})
public final class MeteorRenderer {
    @NotNull
    public static final MeteorRenderer INSTANCE = new MeteorRenderer();
    @NotNull
    private static final HashMap<Long, MeteorVfxState> meteorList = new HashMap();

    private MeteorRenderer() {
    }

    @NotNull
    public final HashMap<Long, MeteorVfxState> getMeteorList() {
        return meteorList;
    }

    public final void onShipRender(@NotNull ClientShip ship, @NotNull PoseStack ms, @NotNull Camera camera, @NotNull MultiBufferSource bufferSource, float pt) {
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
        Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
    }

    public final void renderMeteor(@NotNull ClientShip ship, @NotNull PoseStack ms, @NotNull Camera camera, @NotNull MultiBufferSource bufferSource, float pt) {
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
        Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        double x = ship.getRenderTransform().getPositionInWorld().x();
        double y = ship.getRenderTransform().getPositionInWorld().y();
        double z = ship.getRenderTransform().getPositionInWorld().z();
        if (!meteorList.keySet().contains(ship.getId())) {
            MeteorVfxState newState = new MeteorVfxState();
            newState.setLastX(ship.getRenderTransform().getPositionInWorld().x());
            newState.setLastY(ship.getRenderTransform().getPositionInWorld().y());
            newState.setLastZ(ship.getRenderTransform().getPositionInWorld().z());
            Vector3d shipVelNormal = ship.getVelocity().normalize(new Vector3d());
            newState.setVelDirX(shipVelNormal.x);
            newState.setVelDirY(shipVelNormal.y);
            newState.setVelDirZ(shipVelNormal.z);
            newState.setSpeed(Math.abs(ship.getVelocity().length()));
            newState.setHasLast(true);
            newState.getSamples().clear();
            newState.getSamples().addFirst((Object)new TrailSample(x, y, z, 0.0f, 0.0f));
            ((Map)meteorList).put(ship.getId(), newState);
            return;
        }
        MeteorVfxState meteorVfxState = meteorList.get(ship.getId());
        Intrinsics.checkNotNull((Object)meteorVfxState);
        MeteorVfxState state = meteorVfxState;
        Minecraft mc = Minecraft.m_91087_();
        Camera cam = camera;
        Vec3 camPos = cam.m_90583_();
        double dx = ship.getRenderTransform().getPositionInWorld().x() - camPos.f_82479_;
        double dy = ship.getRenderTransform().getPositionInWorld().y() - camPos.f_82480_;
        double dz = ship.getRenderTransform().getPositionInWorld().z() - camPos.f_82481_;
        double dist2 = dx * dx + dy * dy + dz * dz;
        if (dist2 > 16384.0) {
            return;
        }
        if (state.getSpeed() < 0.75) {
            if (Double.isNaN(state.getVelDirX())) {
                Vector3d shipVelNormal = ship.getVelocity().normalize(new Vector3d());
                state.setVelDirX(shipVelNormal.x);
                state.setVelDirY(shipVelNormal.y);
                state.setVelDirZ(shipVelNormal.z);
                state.setSpeed(Math.abs(ship.getVelocity().length()));
            }
            return;
        }
        PoseStack poseStack = ms;
        MultiBufferSource buffers = bufferSource;
        ms.m_85836_();
        ms.m_85837_(-camPos.f_82479_, -camPos.f_82480_, -camPos.f_82481_);
        float partial = mc.m_91296_();
        ClientLevel clientLevel = mc.f_91073_;
        float time = (float)(clientLevel != null ? clientLevel.m_46467_() : 0L) + partial;
        PoseStack.Pose pose = ms.m_85850_();
        VertexConsumer vertexConsumer = buffers.m_6299_(ClockworkRenderTypes.Companion.getMETEOR_TRAIL());
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer, (String)"getBuffer(...)");
        Matrix4f matrix4f = pose.m_252922_();
        Intrinsics.checkNotNullExpressionValue((Object)matrix4f, (String)"pose(...)");
        this.renderTrailRibbon(vertexConsumer, matrix4f, state.getSamples(), camPos.f_82479_, camPos.f_82480_, camPos.f_82481_, cam.m_253058_().x, cam.m_253058_().y, cam.m_253058_().z, time);
        Vector3dc head = ship.getRenderTransform().getPosition();
        double radius = Math.abs(ship.getWorldAABB().extent(new Vector3d()).length()) * 0.5;
        ms.m_85849_();
    }

    public final void renderTrailRibbon(@NotNull VertexConsumer vc, @NotNull Matrix4f pose, @NotNull ArrayDeque<TrailSample> samples, double camPosX, double camPosY, double camPosZ, double camLookX, double camLookY, double camLookZ, float time) {
        Intrinsics.checkNotNullParameter((Object)vc, (String)"vc");
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        Intrinsics.checkNotNullParameter(samples, (String)"samples");
        if (samples.size() < 2) {
            return;
        }
        double lx = 0.0;
        lx = camLookX;
        double ly = 0.0;
        ly = camLookY;
        double lz = 0.0;
        lz = camLookZ;
        MeteorRenderer $this$renderTrailRibbon_u24lambda_u240 = this;
        boolean bl = false;
        double inv = 1.0 / Math.sqrt(lx * lx + ly * ly + lz * lz + 1.0E-12);
        lx *= inv;
        ly *= inv;
        lz *= inv;
        Iterator it = samples.iterator();
        TrailSample prev = (TrailSample)it.next();
        int segIndex = 0;
        int total = samples.size() - 1;
        while (it.hasNext()) {
            double rz;
            double ry;
            double rLen2;
            double p1z;
            double dz;
            double p1y;
            double dy;
            TrailSample cur2 = (TrailSample)it.next();
            double p0x = prev.getX();
            double p0y = prev.getY();
            double p0z = prev.getZ();
            double p1x = cur2.getX();
            double dx = p1x - p0x;
            double dLen2 = dx * dx + (dy = (p1y = cur2.getY()) - p0y) * dy + (dz = (p1z = cur2.getZ()) - p0z) * dz;
            if (dLen2 < 1.0E-8) {
                prev = cur2;
                ++segIndex;
                continue;
            }
            double invD = 1.0 / Math.sqrt(dLen2);
            double rx = (dy *= invD) * lz - (dz *= invD) * ly;
            if ((rLen2 = rx * rx + (ry = dz * lx - (dx *= invD) * lz) * ry + (rz = dx * ly - dy * lx) * rz) < 1.0E-8) {
                prev = cur2;
                ++segIndex;
                continue;
            }
            double invR = 1.0 / Math.sqrt(rLen2);
            rx *= invR;
            ry *= invR;
            rz *= invR;
            float t0 = (float)segIndex / (float)total;
            float t1 = (float)(segIndex + 1) / (float)total;
            float headness0 = 1.0f - t0;
            float headness1 = 1.0f - t1;
            double w0 = (0.18 + (double)prev.getSpeed() * 0.01) * (0.35 + 0.65 * (double)headness0);
            double w1 = (0.18 + (double)cur2.getSpeed() * 0.01) * (0.35 + 0.65 * (double)headness1);
            double ww0 = RangesKt.coerceIn((double)w0, (double)0.12, (double)0.9);
            double ww1 = RangesKt.coerceIn((double)w1, (double)0.12, (double)0.9);
            double wob0 = Math.sin(time * 8.0f + (float)segIndex * 0.7f) * 0.06 * RangesKt.coerceIn((double)((double)prev.getSpeed() * 0.01), (double)0.0, (double)1.0);
            double wob1 = Math.sin(time * 8.0f + (float)(segIndex + 1) * 0.7f) * 0.06 * RangesKt.coerceIn((double)((double)cur2.getSpeed() * 0.01), (double)0.0, (double)1.0);
            double off0 = ww0 + wob0;
            double off1 = ww1 + wob1;
            double v00x = p0x - rx * off0;
            double v00y = p0y - ry * off0;
            double v00z = p0z - rz * off0;
            double v01x = p0x + rx * off0;
            double v01y = p0y + ry * off0;
            double v01z = p0z + rz * off0;
            double v10x = p1x - rx * off1;
            double v10y = p1y - ry * off1;
            double v10z = p1z - rz * off1;
            double v11x = p1x + rx * off1;
            double v11y = p1y + ry * off1;
            double v11z = p1z + rz * off1;
            float a0 = RangesKt.coerceIn((float)((1.0f - prev.getAge() / 2.0f) * (0.25f + 0.75f * headness0)), (float)0.0f, (float)1.0f);
            float a1 = RangesKt.coerceIn((float)((1.0f - cur2.getAge() / 2.0f) * (0.25f + 0.75f * headness1)), (float)0.0f, (float)1.0f);
            float scroll = time * 0.05f;
            float v0 = MeteorRenderer.renderTrailRibbon$fract(t0 + scroll);
            float v1 = MeteorRenderer.renderTrailRibbon$fract(t1 + scroll);
            float nnx = (float)(-lx);
            float nny = (float)(-ly);
            float nnz = (float)(-lz);
            MeteorRenderer.putVert$default(this, vc, pose, v00x, v00y, v00z, 0.0f, v0, a0, nnx, nny, nnz, 0, 0, 0, 14336, null);
            MeteorRenderer.putVert$default(this, vc, pose, v10x, v10y, v10z, 0.0f, v1, a1, nnx, nny, nnz, 0, 0, 0, 14336, null);
            MeteorRenderer.putVert$default(this, vc, pose, v11x, v11y, v11z, 1.0f, v1, a1, nnx, nny, nnz, 0, 0, 0, 14336, null);
            MeteorRenderer.putVert$default(this, vc, pose, v00x, v00y, v00z, 0.0f, v0, a0, nnx, nny, nnz, 0, 0, 0, 14336, null);
            MeteorRenderer.putVert$default(this, vc, pose, v11x, v11y, v11z, 1.0f, v1, a1, nnx, nny, nnz, 0, 0, 0, 14336, null);
            MeteorRenderer.putVert$default(this, vc, pose, v01x, v01y, v01z, 1.0f, v0, a0, nnx, nny, nnz, 0, 0, 0, 14336, null);
            prev = cur2;
            ++segIndex;
        }
    }

    public final void updateMeteorStateWorld(@NotNull ClientShip ship, @NotNull MeteorVfxState state) {
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Vector3dc p = ship.getRenderTransform().getPositionInWorld();
        double x = p.x();
        double y = p.y();
        double z = p.z();
        Vector3dc v = ship.getVelocity();
        double sp = Math.abs(v.length());
        state.setSpeed(sp);
        if (sp > 1.0E-6) {
            Vector3d n = v.normalize(new Vector3d());
            state.setVelDirX(n.x);
            state.setVelDirY(n.y);
            state.setVelDirZ(n.z);
        }
        state.getSamples().addFirst((Object)new TrailSample(x, y, z, 0.0f, (float)sp));
        while (state.getSamples().size() > 40) {
            state.getSamples().removeLast();
        }
        ArrayDeque tmp = new ArrayDeque(state.getSamples().size());
        while (!((Collection)state.getSamples()).isEmpty()) {
            TrailSample s = (TrailSample)state.getSamples().removeLast();
            TrailSample aged = TrailSample.copy$default(s, 0.0, 0.0, 0.0, s.getAge() + 0.05f, 0.0f, 23, null);
            if (!(aged.getAge() <= 2.0f)) continue;
            tmp.addFirst((Object)aged);
        }
        state.getSamples().addAll((Collection)tmp);
    }

    private final void putVert(VertexConsumer vc, Matrix4f poseStack, double x, double y, double z, float u, float v, float a, float normalX, float normalY, float normalZ, int r, int g, int b) {
        vc.m_252986_(poseStack, (float)x, (float)y, (float)z).m_6122_(r, g, b, (int)(a * 255.0f)).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(normalX, normalY, normalZ).m_5752_();
    }

    static /* synthetic */ void putVert$default(MeteorRenderer meteorRenderer, VertexConsumer vertexConsumer, Matrix4f matrix4f, double d, double d2, double d3, float f, float f2, float f3, float f4, float f5, float f6, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 0x800) != 0) {
            n = 255;
        }
        if ((n4 & 0x1000) != 0) {
            n2 = 255;
        }
        if ((n4 & 0x2000) != 0) {
            n3 = 255;
        }
        meteorRenderer.putVert(vertexConsumer, matrix4f, d, d2, d3, f, f2, f3, f4, f5, f6, n, n2, n3);
    }

    private static final float renderTrailRibbon$fract(float x) {
        return x - (float)Math.floor(x);
    }
}

