/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.curiosities.altmeter;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.valkyrienskies.clockwork.content.curiosities.altmeter.AltMeterBlock;
import org.valkyrienskies.clockwork.util.ClockworkConstants;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.kelvin.util.KelvinExtensions;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u00012B%\u0012\f\u0010+\u001a\b\u0012\u0002\b\u0003\u0018\u00010*\u0012\u0006\u0010-\u001a\u00020,\u0012\u0006\u0010/\u001a\u00020.\u00a2\u0006\u0004\b0\u00101J\u001d\u0010\u0006\u001a\u00020\u00052\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\b\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u000fJ!\u0010\u0015\u001a\u00020\u0011*\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0015\u0010\u0016R\"\u0010\u0017\u001a\u00020\u00118\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\"\u0010\u001d\u001a\u00020\u00118\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u0018\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001cR\"\u0010!\u001a\u00020 8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\"\u0010'\u001a\u00020\u00118\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b'\u0010\u0018\u001a\u0004\b(\u0010\u001a\"\u0004\b)\u0010\u001c\u00a8\u00063"}, d2={"Lorg/valkyrienskies/clockwork/content/curiosities/altmeter/AltMeterBlockEntity;", "Lcom/simibubi/create/foundation/blockEntity/SmartBlockEntity;", "", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BlockEntityBehaviour;", "behaviours", "", "addBehaviours", "(Ljava/util/List;)V", "tick", "()V", "Lnet/minecraft/nbt/CompoundTag;", "compound", "", "clientPacket", "write", "(Lnet/minecraft/nbt/CompoundTag;Z)V", "read", "", "Lkotlin/ranges/IntRange;", "source", "target", "toRange", "(ILkotlin/ranges/IntRange;Lkotlin/ranges/IntRange;)I", "triggerHeight", "I", "getTriggerHeight$clockwork", "()I", "setTriggerHeight$clockwork", "(I)V", "triggerSensitivity", "getTriggerSensitivity$clockwork", "setTriggerSensitivity$clockwork", "Lorg/valkyrienskies/clockwork/content/curiosities/altmeter/AltMeterBlockEntity$AltMeterDirection;", "triggerDirection", "Lorg/valkyrienskies/clockwork/content/curiosities/altmeter/AltMeterBlockEntity$AltMeterDirection;", "getTriggerDirection$clockwork", "()Lorg/valkyrienskies/clockwork/content/curiosities/altmeter/AltMeterBlockEntity$AltMeterDirection;", "setTriggerDirection$clockwork", "(Lorg/valkyrienskies/clockwork/content/curiosities/altmeter/AltMeterBlockEntity$AltMeterDirection;)V", "signalStrength", "getSignalStrength$clockwork", "setSignalStrength$clockwork", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "typeIn", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "AltMeterDirection", "clockwork"})
public final class AltMeterBlockEntity
extends SmartBlockEntity {
    private int triggerHeight;
    private int triggerSensitivity;
    @NotNull
    private AltMeterDirection triggerDirection;
    private int signalStrength;

    public AltMeterBlockEntity(@Nullable BlockEntityType<?> typeIn, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(typeIn, pos, state);
        this.triggerSensitivity = 1;
        this.triggerDirection = AltMeterDirection.UP;
    }

    public final int getTriggerHeight$clockwork() {
        return this.triggerHeight;
    }

    public final void setTriggerHeight$clockwork(int n) {
        this.triggerHeight = n;
    }

    public final int getTriggerSensitivity$clockwork() {
        return this.triggerSensitivity;
    }

    public final void setTriggerSensitivity$clockwork(int n) {
        this.triggerSensitivity = n;
    }

    @NotNull
    public final AltMeterDirection getTriggerDirection$clockwork() {
        return this.triggerDirection;
    }

    public final void setTriggerDirection$clockwork(@NotNull AltMeterDirection altMeterDirection) {
        Intrinsics.checkNotNullParameter((Object)((Object)altMeterDirection), (String)"<set-?>");
        this.triggerDirection = altMeterDirection;
    }

    public final int getSignalStrength$clockwork() {
        return this.signalStrength;
    }

    public final void setSignalStrength$clockwork(int n) {
        this.signalStrength = n;
    }

    public void addBehaviours(@NotNull List<BlockEntityBehaviour> behaviours) {
        Intrinsics.checkNotNullParameter(behaviours, (String)"behaviours");
    }

    public void tick() {
        Integer currentPower;
        super.tick();
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (level.f_46443_) {
            return;
        }
        BlockPos blockPos = this.m_58899_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        Vector3d posInWorld = KelvinExtensions.INSTANCE.toVector3d(blockPos).add(0.5, 0.5, 0.5);
        BlockPos blockPos2 = this.m_58899_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"getBlockPos(...)");
        Ship ship = VSGameUtilsKt.getShipManagingPos((Level)this.f_58857_, (BlockPos)blockPos2);
        if (ship != null && (ship = ship.getTransform()) != null && (ship = ship.getShipToWorld()) != null) {
            ship.transformPosition(posInWorld);
        }
        double distance = posInWorld.y - (double)this.triggerHeight;
        this.signalStrength = this.toRange(RangesKt.coerceIn((int)(switch (WhenMappings.$EnumSwitchMapping$0[this.triggerDirection.ordinal()]) {
            case 1 -> this.triggerSensitivity - (int)Math.abs(distance);
            case 2 -> this.triggerSensitivity - (int)distance;
            case 3 -> this.triggerSensitivity + (int)distance;
            default -> throw new NoWhenBranchMatchedException();
        }), (ClosedRange)((ClosedRange)new IntRange(0, this.triggerSensitivity))), new IntRange(0, this.triggerSensitivity), new IntRange(0, 15));
        Integer n = currentPower = (Integer)this.m_58900_().m_61143_((Property)AltMeterBlock.Companion.getPOWER());
        int n2 = this.signalStrength;
        if (n == null || n != n2) {
            Level level2 = this.f_58857_;
            Intrinsics.checkNotNull((Object)level2);
            level2.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)AltMeterBlock.Companion.getPOWER(), (Comparable)Integer.valueOf(this.signalStrength)), 3);
        }
    }

    public void write(@NotNull CompoundTag compound, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.write(compound, clientPacket);
        compound.m_128405_(ClockworkConstants.Nbt.INSTANCE.getTRIGGER_HEIGHT(), this.triggerHeight);
        compound.m_128405_(ClockworkConstants.Nbt.INSTANCE.getTRIGGER_SENSITIVITY(), this.triggerSensitivity);
        compound.m_128359_(ClockworkConstants.Nbt.INSTANCE.getTRIGGER_DIRECTION(), this.triggerDirection.name());
        compound.m_128405_("Signal Strength", this.signalStrength);
    }

    public void read(@NotNull CompoundTag compound, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.read(compound, clientPacket);
        this.triggerHeight = compound.m_128451_(ClockworkConstants.Nbt.INSTANCE.getTRIGGER_HEIGHT());
        this.triggerSensitivity = compound.m_128451_(ClockworkConstants.Nbt.INSTANCE.getTRIGGER_SENSITIVITY());
        String string = compound.m_128461_(ClockworkConstants.Nbt.INSTANCE.getTRIGGER_DIRECTION());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        this.triggerDirection = AltMeterDirection.valueOf(string);
        this.signalStrength = compound.m_128451_("Signal Strength");
    }

    public final int toRange(int $this$toRange, @NotNull IntRange source, @NotNull IntRange target) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return (int)((float)$this$toRange / (float)(source.getLast() - source.getFirst()) * (float)(target.getLast() - target.getFirst()));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/valkyrienskies/clockwork/content/curiosities/altmeter/AltMeterBlockEntity$AltMeterDirection;", "", "<init>", "(Ljava/lang/String;I)V", "UP", "DOWN", "BOTH", "clockwork"})
    public static final class AltMeterDirection
    extends Enum<AltMeterDirection> {
        public static final /* enum */ AltMeterDirection UP = new AltMeterDirection();
        public static final /* enum */ AltMeterDirection DOWN = new AltMeterDirection();
        public static final /* enum */ AltMeterDirection BOTH = new AltMeterDirection();
        private static final /* synthetic */ AltMeterDirection[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static AltMeterDirection[] values() {
            return (AltMeterDirection[])$VALUES.clone();
        }

        public static AltMeterDirection valueOf(String value) {
            return Enum.valueOf(AltMeterDirection.class, value);
        }

        @NotNull
        public static EnumEntries<AltMeterDirection> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = altMeterDirectionArray = new AltMeterDirection[]{AltMeterDirection.UP, AltMeterDirection.DOWN, AltMeterDirection.BOTH};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AltMeterDirection.values().length];
            try {
                nArray[AltMeterDirection.BOTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AltMeterDirection.DOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AltMeterDirection.UP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

