/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.curiosities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4dc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.clockwork.content.forces.WanderShipControl;
import org.valkyrienskies.clockwork.util.ClockworkUtils;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.mod.common.assembly.ShipAssembler;
import org.valkyrienskies.mod.common.config.MassDatapackResolver;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\b\u0007\bf\u0018\u00002\u00020\u0001J'\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ=\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000f2\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0018\u00c0\u0006\u0001"}, d2={"Lorg/valkyrienskies/clockwork/content/curiosities/IWanderliteBlock;", "", "Lnet/minecraft/server/level/ServerLevel;", "level", "Lorg/valkyrienskies/core/api/ships/LoadedServerShip;", "ship", "Lnet/minecraft/core/BlockPos;", "pos", "", "addToShip", "(Lnet/minecraft/server/level/ServerLevel;Lorg/valkyrienskies/core/api/ships/LoadedServerShip;Lnet/minecraft/core/BlockPos;)V", "removeFromShip", "(Lorg/valkyrienskies/core/api/ships/LoadedServerShip;Lnet/minecraft/core/BlockPos;)V", "Lnet/minecraft/world/level/Level;", "worldIn", "", "depth", "", "collectedPositions", "collectBlockPositions", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;ILjava/util/List;)Ljava/util/List;", "blockPos", "shipifyBlock", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;)V", "clockwork"})
@SourceDebugExtension(value={"SMAP\nIWanderliteBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IWanderliteBlock.kt\norg/valkyrienskies/clockwork/content/curiosities/IWanderliteBlock\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n1755#2,3:76\n*S KotlinDebug\n*F\n+ 1 IWanderliteBlock.kt\norg/valkyrienskies/clockwork/content/curiosities/IWanderliteBlock\n*L\n56#1:76,3\n*E\n"})
public interface IWanderliteBlock {
    default public void addToShip(@NotNull ServerLevel level, @NotNull LoadedServerShip ship, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        BlockState blockState = level.m_8055_(pos);
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
        Double d = MassDatapackResolver.INSTANCE.getBlockStateMass(blockState);
        if (d == null) {
            return;
        }
        double weight = d;
        WanderShipControl.Companion.getOrCreate(ship).addBlock(pos, weight);
    }

    default public void removeFromShip(@NotNull LoadedServerShip ship, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        WanderShipControl.Companion.getOrCreate(ship).removeBlock(pos);
    }

    @NotNull
    default public List<BlockPos> collectBlockPositions(@NotNull Level worldIn, @NotNull BlockPos pos, int depth, @NotNull List<BlockPos> collectedPositions) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter(collectedPositions, (String)"collectedPositions");
        if (depth == 0) {
            return new ArrayList();
        }
        collectedPositions.add(pos);
        BlockPos[] blockPosArray = new BlockPos[]{pos};
        List positionsInThisIteration = CollectionsKt.mutableListOf((Object[])blockPosArray);
        for (Direction direction : EntriesMappings.entries$0) {
            BlockPos neighborPos = pos.m_121945_(direction);
            if (!worldIn.m_46739_(neighborPos) || collectedPositions.contains(neighborPos) || !(worldIn.m_8055_(neighborPos).m_60734_() instanceof IWanderliteBlock)) continue;
            Intrinsics.checkNotNull((Object)neighborPos);
            positionsInThisIteration.addAll((Collection)this.collectBlockPositions(worldIn, neighborPos, depth - 1, collectedPositions));
        }
        return positionsInThisIteration;
    }

    public static /* synthetic */ List collectBlockPositions$default(IWanderliteBlock iWanderliteBlock, Level level, BlockPos blockPos, int n, List list, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: collectBlockPositions");
        }
        if ((n2 & 8) != 0) {
            list = new ArrayList();
        }
        return iWanderliteBlock.collectBlockPositions(level, blockPos, n, list);
    }

    default public void shipifyBlock(@NotNull ServerLevel level, @NotNull BlockPos blockPos) {
        boolean notAllAir;
        List blockList;
        block6: {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
            blockList = IWanderliteBlock.collectBlockPositions$default(this, (Level)level, blockPos, 4, null, 8, null);
            Iterable $this$any$iv = blockList;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v0 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    BlockPos it = (BlockPos)element$iv;
                    boolean bl = false;
                    if (!(!level.m_8055_(it).m_60795_())) continue;
                    v0 = true;
                    break block6;
                }
                v0 = notAllAir = false;
            }
        }
        if (!notAllAir) {
            return;
        }
        ServerShip ship = ShipAssembler.assembleToShip((ServerLevel)level, (Set)CollectionsKt.toSet((Iterable)blockList), (double)1.0);
        for (BlockPos pos : blockList) {
            Matrix4dc matrix4dc = ship.getTransform().getWorldToShip();
            Vec3 vec3 = pos.m_252807_();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getCenter(...)");
            BlockPos shipBlockPos = BlockPos.m_274446_((Position)((Position)VectorConversionsMCKt.transformPosition((Matrix4dc)matrix4dc, (Vec3)vec3)));
            BlockState blockState = level.m_8055_(shipBlockPos);
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
            Double d = MassDatapackResolver.INSTANCE.getBlockStateMass(blockState);
            if (d == null) {
                continue;
            }
            double weight = d;
            Map map = ClockworkUtils.INSTANCE.getWanderliteNodesToAdd();
            Vector3d vector3d = ship.getWorldToShip().transformPosition(VectorConversionsMCKt.toJOMLD((Vec3i)((Vec3i)pos)));
            Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"transformPosition(...)");
            BlockPos blockPos2 = BlockPos.m_274446_((Position)((Position)VectorConversionsMCKt.toMinecraft((Vector3dc)((Vector3dc)vector3d))));
            Double d2 = weight;
            map.put(blockPos2, d2);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Direction> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Direction.values()));
        }
    }
}

