/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.contraptions.propeller.copter;

import com.simibubi.create.content.contraptions.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.IControlContraption;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.clockwork.content.contraptions.propeller.PropellerBearingBlockEntity;
import org.valkyrienskies.clockwork.content.contraptions.propeller.contraption.CopterContraptionEntity;
import org.valkyrienskies.clockwork.content.contraptions.propeller.contraption.PropellerContraption;
import org.valkyrienskies.clockwork.content.contraptions.propeller.data.PropUpdateData;
import org.valkyrienskies.clockwork.util.MathFunctions;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.world.PhysLevel;
import org.valkyrienskies.mod.api.BlockEntityPhysicsListener;
import org.valkyrienskies.mod.api.ValkyrienSkies;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.mod.util.NbtUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\n\u0010s\u001a\u0006\u0012\u0002\b\u00030r\u0012\u0006\u0010u\u001a\u00020t\u0012\u0006\u0010w\u001a\u00020v\u00a2\u0006\u0004\bx\u0010yJ\u001f\u0010\b\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0005H\u0014\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\n\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0005H\u0014\u00a2\u0006\u0004\b\n\u0010\tJ\u000f\u0010\u000b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0010\u0010\u0011Je\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00162\b\b\u0002\u0010\u001b\u001a\u00020\u00162\b\b\u0002\u0010\u001c\u001a\u00020\u00162\b\b\u0002\u0010\u001d\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ!\u0010$\u001a\u00020\u00072\b\u0010!\u001a\u0004\u0018\u00010 2\u0006\u0010#\u001a\u00020\"H\u0016\u00a2\u0006\u0004\b$\u0010%J\u000f\u0010&\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b&\u0010\fJ\u000f\u0010'\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b'\u0010\fJ\u000f\u0010(\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b(\u0010\fJ\u000f\u0010)\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b)\u0010\fJ\u000f\u0010*\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b*\u0010\fJ\u0017\u0010.\u001a\u00020-2\u0006\u0010,\u001a\u00020+H\u0016\u00a2\u0006\u0004\b.\u0010/J\r\u00101\u001a\u000200\u00a2\u0006\u0004\b1\u00102J\u000f\u00104\u001a\u000203H\u0016\u00a2\u0006\u0004\b4\u00105R&\u00108\u001a\u000606j\u0002`78\u0016@\u0016X\u0096.\u00a2\u0006\u0012\n\u0004\b8\u00109\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u0011\u0010A\u001a\u00020>8F\u00a2\u0006\u0006\u001a\u0004\b?\u0010@R\"\u0010B\u001a\u00020\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bB\u0010C\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR\"\u0010H\u001a\u00020\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bH\u0010C\u001a\u0004\bI\u0010E\"\u0004\bJ\u0010GR\"\u0010K\u001a\u00020\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bK\u0010C\u001a\u0004\bL\u0010E\"\u0004\bM\u0010GR\u0016\u0010O\u001a\u00020N8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bO\u0010PR\"\u0010Q\u001a\u00020\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bQ\u0010C\u001a\u0004\bR\u0010E\"\u0004\bS\u0010GR\"\u0010U\u001a\u00020T8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bU\u0010V\u001a\u0004\bW\u0010X\"\u0004\bY\u0010ZR\"\u0010[\u001a\u00020T8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b[\u0010V\u001a\u0004\b\\\u0010X\"\u0004\b]\u0010ZR\"\u0010^\u001a\u00020T8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b^\u0010V\u001a\u0004\b_\u0010X\"\u0004\b`\u0010ZR\"\u0010a\u001a\u00020T8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\ba\u0010V\u001a\u0004\bb\u0010X\"\u0004\bc\u0010ZR$\u0010d\u001a\u0004\u0018\u00010\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bd\u0010C\u001a\u0004\be\u0010E\"\u0004\bf\u0010GR\"\u0010h\u001a\u00020g8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bh\u0010i\u001a\u0004\bj\u0010k\"\u0004\bl\u0010mR\u0016\u0010n\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bn\u0010oR\u0016\u0010p\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bp\u0010q\u00a8\u0006z"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/propeller/copter/CopterBearingBlockEntity;", "Lorg/valkyrienskies/clockwork/content/contraptions/propeller/PropellerBearingBlockEntity;", "Lorg/valkyrienskies/mod/api/BlockEntityPhysicsListener;", "Lnet/minecraft/nbt/CompoundTag;", "compound", "", "clientPacket", "", "write", "(Lnet/minecraft/nbt/CompoundTag;Z)V", "read", "lerpTarget", "()V", "Lnet/minecraft/world/phys/Vec3;", "target", "serverSide", "setTiltTarget", "(Lnet/minecraft/world/phys/Vec3;Z)V", "Lorg/joml/Vector3d;", "blockAxis", "desiredUp", "omegaShipLocal", "", "kp", "ki", "kd", "dt", "iClampRad", "integrateBelowRad", "leakPerSec", "computeStabilizedTarget", "(Lorg/joml/Vector3d;Lorg/joml/Vector3d;Lorg/joml/Vector3d;DDDDDDD)Lorg/joml/Vector3d;", "Lorg/valkyrienskies/core/api/ships/PhysShip;", "physShip", "Lorg/valkyrienskies/core/api/world/PhysLevel;", "physLevel", "physTick", "(Lorg/valkyrienskies/core/api/ships/PhysShip;Lorg/valkyrienskies/core/api/world/PhysLevel;)V", "tick", "assemble", "disassemble", "clientTick", "applyPowerEffect", "Lorg/valkyrienskies/clockwork/content/contraptions/propeller/contraption/PropellerContraption;", "contraption", "Lcom/simibubi/create/content/contraptions/ControlledContraptionEntity;", "createContraptionEntity", "(Lorg/valkyrienskies/clockwork/content/contraptions/propeller/contraption/PropellerContraption;)Lcom/simibubi/create/content/contraptions/ControlledContraptionEntity;", "", "getDirectionScale", "()F", "Lorg/valkyrienskies/clockwork/content/contraptions/propeller/data/PropUpdateData;", "newUpdateData", "()Lorg/valkyrienskies/clockwork/content/contraptions/propeller/data/PropUpdateData;", "", "Lorg/valkyrienskies/core/api/world/properties/DimensionId;", "dimension", "Ljava/lang/String;", "getDimension", "()Ljava/lang/String;", "setDimension", "(Ljava/lang/String;)V", "Lnet/minecraft/core/Direction;", "getFacing", "()Lnet/minecraft/core/Direction;", "facing", "tiltVector", "Lnet/minecraft/world/phys/Vec3;", "getTiltVector", "()Lnet/minecraft/world/phys/Vec3;", "setTiltVector", "(Lnet/minecraft/world/phys/Vec3;)V", "targetTiltVector", "getTargetTiltVector", "setTargetTiltVector", "clientTargetTiltVector", "getClientTargetTiltVector", "setClientTargetTiltVector", "", "tiltCooldown", "I", "thrustDirection", "getThrustDirection", "setThrustDirection", "Lorg/joml/Quaternionf;", "tiltQuaternion", "Lorg/joml/Quaternionf;", "getTiltQuaternion", "()Lorg/joml/Quaternionf;", "setTiltQuaternion", "(Lorg/joml/Quaternionf;)V", "targetTiltQuaternion", "getTargetTiltQuaternion", "setTargetTiltQuaternion", "clientTargetTiltQuat", "getClientTargetTiltQuat", "setClientTargetTiltQuat", "clientTiltQuat", "getClientTiltQuat", "setClientTiltQuat", "blockNormalVector", "getBlockNormalVector", "setBlockNormalVector", "Lorg/joml/Vector3dc;", "desiredLocalOffset", "Lorg/joml/Vector3dc;", "getDesiredLocalOffset", "()Lorg/joml/Vector3dc;", "setDesiredLocalOffset", "(Lorg/joml/Vector3dc;)V", "iAngle", "D", "lastErrAxis", "Lorg/joml/Vector3d;", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "type", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "clockwork"})
public final class CopterBearingBlockEntity
extends PropellerBearingBlockEntity
implements BlockEntityPhysicsListener {
    public String dimension;
    @NotNull
    private volatile Vec3 tiltVector;
    @NotNull
    private volatile Vec3 targetTiltVector;
    @NotNull
    private Vec3 clientTargetTiltVector;
    private volatile int tiltCooldown;
    @NotNull
    private volatile Vec3 thrustDirection;
    @NotNull
    private volatile Quaternionf tiltQuaternion;
    @NotNull
    private volatile Quaternionf targetTiltQuaternion;
    @NotNull
    private Quaternionf clientTargetTiltQuat;
    @NotNull
    private Quaternionf clientTiltQuat;
    @Nullable
    private volatile Vec3 blockNormalVector;
    @NotNull
    private volatile Vector3dc desiredLocalOffset;
    private double iAngle;
    @NotNull
    private Vector3d lastErrAxis;

    public CopterBearingBlockEntity(@NotNull BlockEntityType<?> type, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, pos, state, true);
        this.targetTiltVector = this.tiltVector = new Vec3(0.0, 1.0, 0.0);
        this.clientTargetTiltVector = new Vec3(0.0, 1.0, 0.0);
        this.thrustDirection = this.tiltVector;
        this.tiltQuaternion = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
        this.targetTiltQuaternion = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
        this.clientTargetTiltQuat = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
        this.clientTiltQuat = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
        this.desiredLocalOffset = (Vector3dc)new Vector3d(0.0, 0.0, 0.0);
        this.lastErrAxis = new Vector3d(0.0, 0.0, 0.0);
        this.tiltQuaternion.normalize();
        this.targetTiltQuaternion.normalize();
    }

    @NotNull
    public String getDimension() {
        String string = this.dimension;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"dimension");
        return null;
    }

    public void setDimension(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.dimension = string;
    }

    @NotNull
    public final Direction getFacing() {
        Comparable comparable = this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
        return (Direction)comparable;
    }

    @NotNull
    public final Vec3 getTiltVector() {
        return this.tiltVector;
    }

    public final void setTiltVector(@NotNull Vec3 vec3) {
        Intrinsics.checkNotNullParameter((Object)vec3, (String)"<set-?>");
        this.tiltVector = vec3;
    }

    @NotNull
    public final Vec3 getTargetTiltVector() {
        return this.targetTiltVector;
    }

    public final void setTargetTiltVector(@NotNull Vec3 vec3) {
        Intrinsics.checkNotNullParameter((Object)vec3, (String)"<set-?>");
        this.targetTiltVector = vec3;
    }

    @NotNull
    public final Vec3 getClientTargetTiltVector() {
        return this.clientTargetTiltVector;
    }

    public final void setClientTargetTiltVector(@NotNull Vec3 vec3) {
        Intrinsics.checkNotNullParameter((Object)vec3, (String)"<set-?>");
        this.clientTargetTiltVector = vec3;
    }

    @NotNull
    public final Vec3 getThrustDirection() {
        return this.thrustDirection;
    }

    public final void setThrustDirection(@NotNull Vec3 vec3) {
        Intrinsics.checkNotNullParameter((Object)vec3, (String)"<set-?>");
        this.thrustDirection = vec3;
    }

    @NotNull
    public final Quaternionf getTiltQuaternion() {
        return this.tiltQuaternion;
    }

    public final void setTiltQuaternion(@NotNull Quaternionf quaternionf) {
        Intrinsics.checkNotNullParameter((Object)quaternionf, (String)"<set-?>");
        this.tiltQuaternion = quaternionf;
    }

    @NotNull
    public final Quaternionf getTargetTiltQuaternion() {
        return this.targetTiltQuaternion;
    }

    public final void setTargetTiltQuaternion(@NotNull Quaternionf quaternionf) {
        Intrinsics.checkNotNullParameter((Object)quaternionf, (String)"<set-?>");
        this.targetTiltQuaternion = quaternionf;
    }

    @NotNull
    public final Quaternionf getClientTargetTiltQuat() {
        return this.clientTargetTiltQuat;
    }

    public final void setClientTargetTiltQuat(@NotNull Quaternionf quaternionf) {
        Intrinsics.checkNotNullParameter((Object)quaternionf, (String)"<set-?>");
        this.clientTargetTiltQuat = quaternionf;
    }

    @NotNull
    public final Quaternionf getClientTiltQuat() {
        return this.clientTiltQuat;
    }

    public final void setClientTiltQuat(@NotNull Quaternionf quaternionf) {
        Intrinsics.checkNotNullParameter((Object)quaternionf, (String)"<set-?>");
        this.clientTiltQuat = quaternionf;
    }

    @Nullable
    public final Vec3 getBlockNormalVector() {
        return this.blockNormalVector;
    }

    public final void setBlockNormalVector(@Nullable Vec3 vec3) {
        this.blockNormalVector = vec3;
    }

    @NotNull
    public final Vector3dc getDesiredLocalOffset() {
        return this.desiredLocalOffset;
    }

    public final void setDesiredLocalOffset(@NotNull Vector3dc vector3dc) {
        Intrinsics.checkNotNullParameter((Object)vector3dc, (String)"<set-?>");
        this.desiredLocalOffset = vector3dc;
    }

    @Override
    protected void write(@NotNull CompoundTag compound, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        NbtUtilKt.putVector3d((CompoundTag)compound, (String)"DesiredOffsetFromPower", (Vector3dc)this.desiredLocalOffset);
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(@NotNull CompoundTag compound, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        Vector3d vector3d = NbtUtilKt.getVector3d((CompoundTag)compound, (String)"DesiredOffsetFromPower");
        this.desiredLocalOffset = vector3d != null ? (Vector3dc)vector3d : (Vector3dc)new Vector3d(0.0, 0.0, 0.0);
        super.read(compound, clientPacket);
    }

    private final void lerpTarget() {
        if (this.getStopping()) {
            this.thrustDirection = this.tiltVector = VecHelper.lerp((float)((float)(this.getDisassemblyProgress() / this.getTotalDisassemblyTime())), (Vec3)this.blockNormalVector, (Vec3)this.tiltVector);
            Vec3 vec3 = this.blockNormalVector;
            Intrinsics.checkNotNull((Object)vec3);
            this.tiltQuaternion = MathFunctions.INSTANCE.quatFromVecRot(vec3, this.tiltVector);
            return;
        }
        double a = 1.0 - Math.exp(-0.06666666666666667);
        Quaternionf resultQuat = this.tiltQuaternion;
        Quaterniond delta = new Quaterniond((Quaternionfc)this.tiltQuaternion).conjugate().mul((Quaterniondc)new Quaterniond((Quaternionfc)this.targetTiltQuaternion));
        delta.normalize();
        double angle = 2.0 * Math.acos(RangesKt.coerceIn((double)delta.w, (double)-1.0, (double)1.0));
        if (angle < 1.0E-9) {
            resultQuat = new Quaternionf((Quaternionfc)this.targetTiltQuaternion);
        } else {
            double maxRadPerSec = Math.toRadians(120.0);
            double maxStep = maxRadPerSec * 0.016666666666666666;
            double t = RangesKt.coerceIn((double)(maxStep / angle), (double)0.0, (double)1.0);
            resultQuat = this.tiltQuaternion.slerp((Quaternionfc)this.targetTiltQuaternion, (float)t, new Quaternionf());
        }
        Vec3 vec3 = this.blockNormalVector;
        Intrinsics.checkNotNull((Object)vec3);
        double d = vec3.f_82479_;
        Vec3 vec32 = this.blockNormalVector;
        Intrinsics.checkNotNull((Object)vec32);
        double d2 = vec32.f_82480_;
        Vec3 vec33 = this.blockNormalVector;
        Intrinsics.checkNotNull((Object)vec33);
        Vector3d n = new Vector3d(d, d2, vec33.f_82481_).normalize();
        Vector3d v = new Vector3d((Vector3dc)n).rotate((Quaterniondc)new Quaterniond((Quaternionfc)resultQuat)).normalize();
        this.thrustDirection = this.tiltVector = new Vec3(v.x, v.y, v.z);
        this.tiltQuaternion = resultQuat;
    }

    public final void setTiltTarget(@NotNull Vec3 target, boolean serverSide) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (serverSide) {
            Vec3 clampedTiltVector;
            Direction direction = this.getFacing();
            Vec3 vec3 = this.blockNormalVector = new Vec3((double)direction.m_122429_(), (double)direction.m_122430_(), (double)direction.m_122431_());
            Intrinsics.checkNotNull((Object)vec3);
            this.targetTiltVector = clampedTiltVector = MathFunctions.INSTANCE.clampVecIntoCone(target, vec3, Math.toRadians(24.0));
            Vec3 vec32 = this.blockNormalVector;
            Intrinsics.checkNotNull((Object)vec32);
            this.targetTiltQuaternion = MathFunctions.INSTANCE.quatFromVecRot(vec32, this.targetTiltVector);
        } else {
            Vec3 clampedTiltVector;
            Comparable comparable = this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
            Direction direction = (Direction)comparable;
            Vec3 vec3 = this.blockNormalVector = new Vec3((double)direction.m_122429_(), (double)direction.m_122430_(), (double)direction.m_122431_());
            Intrinsics.checkNotNull((Object)vec3);
            this.clientTargetTiltVector = clampedTiltVector = MathFunctions.INSTANCE.clampVecIntoCone(target, vec3, Math.toRadians(24.0));
            Vec3 vec33 = this.blockNormalVector;
            Intrinsics.checkNotNull((Object)vec33);
            this.clientTargetTiltQuat = MathFunctions.INSTANCE.quatFromVecRot(vec33, this.clientTargetTiltVector);
        }
    }

    public static /* synthetic */ void setTiltTarget$default(CopterBearingBlockEntity copterBearingBlockEntity, Vec3 vec3, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        copterBearingBlockEntity.setTiltTarget(vec3, bl);
    }

    private final Vector3d computeStabilizedTarget(Vector3d blockAxis, Vector3d desiredUp, Vector3d omegaShipLocal, double kp, double ki, double kd, double dt, double iClampRad, double integrateBelowRad, double leakPerSec) {
        double maxStep = Math.toRadians(120.0) * dt;
        Vector3d currentAxis = new Vector3d((Vector3dc)blockAxis).normalize();
        Vector3d errAxis = new Vector3d((Vector3dc)currentAxis).cross((Vector3dc)desiredUp);
        double sinErr = errAxis.length();
        if (sinErr < 1.0E-9) {
            this.iAngle *= Math.exp(-leakPerSec * dt);
            return desiredUp;
        }
        errAxis.div(sinErr);
        double cosErr = RangesKt.coerceIn((double)currentAxis.dot((Vector3dc)desiredUp), (double)-1.0, (double)1.0);
        double errAngle = Math.atan2(sinErr, cosErr);
        double angRateAlongErr = omegaShipLocal.dot((Vector3dc)errAxis);
        double uPD = kp * errAngle - kd * angRateAlongErr;
        double stepPD = uPD * dt;
        boolean wouldSaturate = Math.abs(stepPD) >= maxStep * 0.999;
        boolean nearEnough = errAngle < integrateBelowRad;
        this.iAngle *= Math.exp(-leakPerSec * dt);
        if (nearEnough && !wouldSaturate) {
            this.iAngle += errAngle * dt;
            this.iAngle = RangesKt.coerceIn((double)this.iAngle, (double)(-iClampRad), (double)iClampRad);
        }
        double commandedRate = kp * errAngle + ki * this.iAngle - kd * angRateAlongErr;
        double step = commandedRate * dt;
        step = RangesKt.coerceIn((double)step, (double)(-maxStep), (double)maxStep);
        Quaterniond qStep = new Quaterniond().fromAxisAngleRad(errAxis.x, errAxis.y, errAxis.z, step);
        Vector3d vector3d = new Vector3d((Vector3dc)currentAxis).rotate((Quaterniondc)qStep).normalize();
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"normalize(...)");
        return vector3d;
    }

    static /* synthetic */ Vector3d computeStabilizedTarget$default(CopterBearingBlockEntity copterBearingBlockEntity, Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, double d, double d2, double d3, double d4, double d5, double d6, double d7, int n, Object object) {
        if ((n & 0x80) != 0) {
            d5 = Math.toRadians(6.0);
        }
        if ((n & 0x100) != 0) {
            d6 = Math.toRadians(12.0);
        }
        if ((n & 0x200) != 0) {
            d7 = 0.5;
        }
        return copterBearingBlockEntity.computeStabilizedTarget(vector3d, vector3d2, vector3d3, d, d2, d3, d4, d5, d6, d7);
    }

    public void physTick(@Nullable PhysShip physShip, @NotNull PhysLevel physLevel) {
        Intrinsics.checkNotNullParameter((Object)physLevel, (String)"physLevel");
        if (physShip == null) {
            return;
        }
        if (!this.getRunning()) {
            return;
        }
        Quaterniond invRotation = physShip.getTransform().getShipToWorldRotation().invert(new Quaterniond());
        Vec3i vec3i = this.getFacing().m_122436_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3i, (String)"getNormal(...)");
        Vector3d facingNormal = VectorConversionsMCKt.toJOMLD((Vec3i)vec3i);
        if (this.getFacing() == Direction.DOWN || this.getFacing() == Direction.NORTH || this.getFacing() == Direction.WEST) {
            // empty if block
        }
        Vector3d desiredLocal = new Vector3d((Vector3dc)facingNormal).rotate((Quaterniondc)invRotation).mul((double)this.getDirectionScale()).normalize().add(this.desiredLocalOffset).normalize();
        Vector3d blockAxis = ValkyrienSkies.toJOML((Vec3)this.tiltVector).normalize();
        if (this.getFacing() == Direction.DOWN || this.getFacing() == Direction.NORTH || this.getFacing() == Direction.WEST) {
            blockAxis.mul(-1.0);
        }
        Vector3d omegaLocal = new Vector3d(physShip.getAngularVelocity()).rotate((Quaterniondc)invRotation);
        Intrinsics.checkNotNull((Object)blockAxis);
        Intrinsics.checkNotNull((Object)desiredLocal);
        Intrinsics.checkNotNull((Object)omegaLocal);
        Vector3d stabilized = CopterBearingBlockEntity.computeStabilizedTarget$default(this, blockAxis, desiredLocal, omegaLocal, 2.0, 0.8, 6.0, 0.016666666666666666, 0.0, 0.0, 0.0, 896, null);
        this.setTiltTarget(new Vec3(stabilized.x, stabilized.y, stabilized.z), true);
        this.lerpTarget();
        int n = this.tiltCooldown;
        this.tiltCooldown = n + 1;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.f_58857_ == null) {
            return;
        }
        if (this.getPropellerContraption() instanceof CopterContraptionEntity) {
            ControlledContraptionEntity controlledContraptionEntity = this.getPropellerContraption();
            Intrinsics.checkNotNull((Object)controlledContraptionEntity, (String)"null cannot be cast to non-null type org.valkyrienskies.clockwork.content.contraptions.propeller.contraption.CopterContraptionEntity");
            CopterContraptionEntity copterContraption = (CopterContraptionEntity)controlledContraptionEntity;
            copterContraption.setTiltQuaternion(this.clientTiltQuat);
            copterContraption.setSuperDirection((Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_));
        }
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (level.f_46443_) {
            this.clientTick();
            return;
        }
        if (this.getRunning() && this.f_58857_ instanceof ServerLevel && !this.isVirtual()) {
            Level level2 = this.f_58857_;
            Intrinsics.checkNotNull((Object)level2, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel serverLevel = (ServerLevel)level2;
            BlockPos blockPos = this.m_58899_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            LoadedServerShip ship = VSGameUtilsKt.getLoadedShipManagingPos((ServerLevel)serverLevel, (Vec3i)((Vec3i)blockPos));
            if (ship != null) {
                // empty if block
            }
        }
    }

    @Override
    public void assemble() {
        super.assemble();
        this.iAngle = 0.0;
    }

    @Override
    public void disassemble() {
        super.disassemble();
        this.iAngle = 0.0;
    }

    private final void clientTick() {
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (level.f_46443_) {
            Level level2 = this.f_58857_;
            Intrinsics.checkNotNull((Object)level2, (String)"null cannot be cast to non-null type net.minecraft.client.multiplayer.ClientLevel");
            ClientLevel clientLevel = (ClientLevel)level2;
            BlockPos blockPos = this.m_58899_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            ClientShip ship = VSGameUtilsKt.getLoadedShipManagingPos((ClientLevel)clientLevel, (Vec3i)((Vec3i)blockPos));
            if (ship != null && this.getRunning()) {
                Quaterniond invRotation = ship.getRenderTransform().getShipToWorldRotation().invert(new Quaterniond());
                Vec3i vec3i = this.getFacing().m_122436_();
                Intrinsics.checkNotNullExpressionValue((Object)vec3i, (String)"getNormal(...)");
                Vector3d facingNormal = VectorConversionsMCKt.toJOMLD((Vec3i)vec3i);
                if (this.getFacing() == Direction.DOWN || this.getFacing() == Direction.NORTH || this.getFacing() == Direction.WEST) {
                    // empty if block
                }
                Vector3d desiredLocal = new Vector3d((Vector3dc)facingNormal).rotate((Quaterniondc)invRotation).mul((double)this.getDirectionScale()).add(this.desiredLocalOffset).normalize();
                Vec3 trueTarget = this.getStopping() ? VecHelper.lerp((float)((float)(this.getDisassemblyProgress() / this.getTotalDisassemblyTime())), (Vec3)this.blockNormalVector, (Vec3)this.clientTargetTiltVector) : (this.getFacing() == Direction.DOWN || this.getFacing() == Direction.NORTH || this.getFacing() == Direction.WEST ? new Vec3(-desiredLocal.x, -desiredLocal.y, -desiredLocal.z) : new Vec3(desiredLocal.x, desiredLocal.y, desiredLocal.z));
                Intrinsics.checkNotNull((Object)trueTarget);
                CopterBearingBlockEntity.setTiltTarget$default(this, trueTarget, false, 2, null);
            } else {
                Vec3 vec3 = this.blockNormalVector;
                if (vec3 == null) {
                    vec3 = new Vec3(0.0, 1.0, 0.0);
                }
                CopterBearingBlockEntity.setTiltTarget$default(this, vec3, false, 2, null);
            }
        }
    }

    @Override
    public void applyPowerEffect() {
        Pair<Direction.Axis, Direction.Axis> pair = this.getPowerDirections();
        Direction.Axis axisOne = (Direction.Axis)pair.component1();
        Direction.Axis axisTwo = (Direction.Axis)pair.component2();
        Vec3i vec3i = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axisOne).m_122436_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3i, (String)"getNormal(...)");
        Vector3d positiveNormalOne = VectorConversionsMCKt.toJOMLD((Vec3i)vec3i);
        Vec3i vec3i2 = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axisTwo).m_122436_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3i2, (String)"getNormal(...)");
        Vector3d positiveNormalTwo = VectorConversionsMCKt.toJOMLD((Vec3i)vec3i2);
        this.desiredLocalOffset = (Vector3dc)positiveNormalOne.mul((double)this.getPowerOne() / 16.0 * (double)this.getDirectionScale(), new Vector3d()).add((Vector3dc)positiveNormalTwo.mul((double)this.getPowerTwo() / 16.0 * (double)this.getDirectionScale(), new Vector3d()));
    }

    @Override
    @NotNull
    public ControlledContraptionEntity createContraptionEntity(@NotNull PropellerContraption contraption) {
        Intrinsics.checkNotNullParameter((Object)((Object)contraption), (String)"contraption");
        return CopterContraptionEntity.Companion.create(this.f_58857_, (IControlContraption)this, contraption);
    }

    public final float getDirectionScale() {
        float speed = this.getSpeed();
        if (speed == 0.0f) {
            return 1.0f;
        }
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        speed = KineticBlockEntity.convertToDirection((float)speed, (Direction)facing);
        if (this.getRotationDirection().value == 1) {
            speed *= -1.0f;
        }
        return speed > 0.0f ? 1.0f : -1.0f;
    }

    @Override
    @NotNull
    public PropUpdateData newUpdateData() {
        return new PropUpdateData(this.getCurrentOmega(), this.getAngle(), this.isInverted(), this.getActive(), new ArrayList(this.getBlades()), (Vector3dc)ValkyrienSkies.toJOML((Vec3)this.tiltVector), (Quaterniondc)new Quaterniond((Quaternionfc)this.tiltQuaternion), this.lastStressApplied);
    }
}

