/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.contraptions.propeller.contraption;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.IControlContraption;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.valkyrienskies.clockwork.ClockworkEntities;
import org.valkyrienskies.clockwork.util.MathFunctions;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 &2\u00020\u0001:\u0001&B\u001d\u0012\n\u0010!\u001a\u0006\u0012\u0002\b\u00030 \u0012\b\u0010#\u001a\u0004\u0018\u00010\"\u00a2\u0006\u0004\b$\u0010%J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\r\u0010\fJ!\u0010\u0010\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011R\"\u0010\u0013\u001a\u00020\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\"\u0010\u001a\u001a\u00020\u00198\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006'"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/propeller/contraption/CopterContraptionEntity;", "Lcom/simibubi/create/content/contraptions/ControlledContraptionEntity;", "Lnet/minecraft/core/BlockPos;", "controllerPos", "", "setControllerPos", "(Lnet/minecraft/core/BlockPos;)V", "Lnet/minecraft/world/phys/Vec3;", "localPos", "", "partialTicks", "applyRotation", "(Lnet/minecraft/world/phys/Vec3;F)Lnet/minecraft/world/phys/Vec3;", "reverseRotation", "Lcom/mojang/blaze3d/vertex/PoseStack;", "matrixStack", "applyLocalTransforms", "(Lcom/mojang/blaze3d/vertex/PoseStack;F)V", "Lorg/joml/Quaternionf;", "tiltQuaternion", "Lorg/joml/Quaternionf;", "getTiltQuaternion", "()Lorg/joml/Quaternionf;", "setTiltQuaternion", "(Lorg/joml/Quaternionf;)V", "Lnet/minecraft/core/Direction;", "superDirection", "Lnet/minecraft/core/Direction;", "getSuperDirection", "()Lnet/minecraft/core/Direction;", "setSuperDirection", "(Lnet/minecraft/core/Direction;)V", "Lnet/minecraft/world/entity/EntityType;", "type", "Lnet/minecraft/world/level/Level;", "world", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "Companion", "clockwork"})
public final class CopterContraptionEntity
extends ControlledContraptionEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Quaternionf tiltQuaternion;
    @NotNull
    private Direction superDirection;

    public CopterContraptionEntity(@NotNull EntityType<?> type, @Nullable Level world) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        super(type, world);
        this.tiltQuaternion = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
        this.superDirection = Direction.UP;
    }

    @NotNull
    public final Quaternionf getTiltQuaternion() {
        return this.tiltQuaternion;
    }

    public final void setTiltQuaternion(@NotNull Quaternionf quaternionf) {
        Intrinsics.checkNotNullParameter((Object)quaternionf, (String)"<set-?>");
        this.tiltQuaternion = quaternionf;
    }

    @NotNull
    public final Direction getSuperDirection() {
        return this.superDirection;
    }

    public final void setSuperDirection(@NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)direction, (String)"<set-?>");
        this.superDirection = direction;
    }

    public final void setControllerPos(@NotNull BlockPos controllerPos) {
        Intrinsics.checkNotNullParameter((Object)controllerPos, (String)"controllerPos");
        this.controllerPos = controllerPos;
    }

    @NotNull
    public Vec3 applyRotation(@NotNull Vec3 localPos, float partialTicks) {
        Intrinsics.checkNotNullParameter((Object)localPos, (String)"localPos");
        Vec3 newLocalPos = localPos;
        newLocalPos = VecHelper.rotate((Vec3)newLocalPos, (double)this.getAngle(partialTicks), (Direction.Axis)this.rotationAxis);
        newLocalPos = MathFunctions.INSTANCE.reverseRotateVecWithQuat(newLocalPos, this.tiltQuaternion);
        return newLocalPos;
    }

    @NotNull
    public Vec3 reverseRotation(@NotNull Vec3 localPos, float partialTicks) {
        Intrinsics.checkNotNullParameter((Object)localPos, (String)"localPos");
        Vec3 newLocalPos = localPos;
        newLocalPos = MathFunctions.INSTANCE.rotateVecWithQuat(newLocalPos, this.tiltQuaternion);
        newLocalPos = VecHelper.rotate((Vec3)newLocalPos, (double)(-((double)this.getAngle(partialTicks))), (Direction.Axis)this.rotationAxis);
        return newLocalPos;
    }

    public void applyLocalTransforms(@Nullable PoseStack matrixStack, float partialTicks) {
        float angle = this.getAngle(partialTicks);
        Direction.Axis axis = this.getRotationAxis();
        Vec3 normal = new Vec3((double)this.superDirection.m_122429_(), (double)this.superDirection.m_122430_(), (double)this.superDirection.m_122431_());
        normal = normal.m_82490_(0.0625);
        Vec3 pivotOffset = new Vec3((double)this.superDirection.m_122429_() * -0.9, (double)this.superDirection.m_122430_() * -0.9, (double)this.superDirection.m_122431_() * -0.9);
        ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of((PoseStack)matrixStack).nudge(this.m_19879_())).center()).translate(pivotOffset.f_82479_, pivotOffset.f_82480_, pivotOffset.f_82481_)).translate(normal.m_82490_(-1.0))).rotate((Quaternionfc)this.tiltQuaternion).translate(normal)).translate(-pivotOffset.f_82479_, -pivotOffset.f_82480_, -pivotOffset.f_82481_)).rotateDegrees(angle, axis)).uncenter();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ)\u0010\t\u001a\u00020\b2\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/propeller/contraption/CopterContraptionEntity$Companion;", "", "Lnet/minecraft/world/level/Level;", "level", "Lcom/simibubi/create/content/contraptions/IControlContraption;", "controller", "Lcom/simibubi/create/content/contraptions/Contraption;", "contraption", "Lorg/valkyrienskies/clockwork/content/contraptions/propeller/contraption/CopterContraptionEntity;", "create", "(Lnet/minecraft/world/level/Level;Lcom/simibubi/create/content/contraptions/IControlContraption;Lcom/simibubi/create/content/contraptions/Contraption;)Lorg/valkyrienskies/clockwork/content/contraptions/propeller/contraption/CopterContraptionEntity;", "<init>", "()V", "clockwork"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CopterContraptionEntity create(@Nullable Level level, @NotNull IControlContraption controller, @Nullable Contraption contraption) {
            Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
            Object object = ClockworkEntities.INSTANCE.getCOPTER_CONTRAPTION().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            CopterContraptionEntity entity = new CopterContraptionEntity((EntityType)object, level);
            BlockPos blockPos = controller.getBlockPosition();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPosition(...)");
            entity.setControllerPos(blockPos);
            entity.setContraption(contraption);
            return entity;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

