/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.contraptions.propeller.blades.item;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.clockwork.ClockworkConfig;
import org.valkyrienskies.clockwork.ClockworkItems;
import org.valkyrienskies.clockwork.ClockworkRecipes;
import org.valkyrienskies.clockwork.content.contraptions.propeller.blades.item.BladeItem;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0017\u001a\u00020\u0016\u0012\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ!\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0014\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0013H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001c"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/propeller/blades/item/CraftingTableBladeRecipe;", "Lnet/minecraft/world/item/crafting/CustomRecipe;", "Lnet/minecraft/world/inventory/CraftingContainer;", "container", "Lnet/minecraft/world/level/Level;", "level", "", "matches", "(Lnet/minecraft/world/inventory/CraftingContainer;Lnet/minecraft/world/level/Level;)Z", "Lnet/minecraft/core/RegistryAccess;", "registryAccess", "Lnet/minecraft/world/item/ItemStack;", "assemble", "(Lnet/minecraft/world/inventory/CraftingContainer;Lnet/minecraft/core/RegistryAccess;)Lnet/minecraft/world/item/ItemStack;", "", "width", "height", "canCraftInDimensions", "(II)Z", "Lnet/minecraft/world/item/crafting/RecipeSerializer;", "getSerializer", "()Lnet/minecraft/world/item/crafting/RecipeSerializer;", "Lnet/minecraft/resources/ResourceLocation;", "id", "Lnet/minecraft/world/item/crafting/CraftingBookCategory;", "category", "<init>", "(Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/world/item/crafting/CraftingBookCategory;)V", "clockwork"})
@SourceDebugExtension(value={"SMAP\nCraftingTableBladeRecipe.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CraftingTableBladeRecipe.kt\norg/valkyrienskies/clockwork/content/contraptions/propeller/blades/item/CraftingTableBladeRecipe\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n774#2:67\n865#2,2:68\n1557#2:70\n1628#2,3:71\n1797#2,3:74\n1#3:77\n*S KotlinDebug\n*F\n+ 1 CraftingTableBladeRecipe.kt\norg/valkyrienskies/clockwork/content/contraptions/propeller/blades/item/CraftingTableBladeRecipe\n*L\n46#1:67\n46#1:68,2\n50#1:70\n50#1:71,3\n51#1:74,3\n*E\n"})
public final class CraftingTableBladeRecipe
extends CustomRecipe {
    public CraftingTableBladeRecipe(@NotNull ResourceLocation id, @NotNull CraftingBookCategory category) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        super(id, category);
    }

    public boolean matches(@NotNull CraftingContainer container, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        boolean isWide = false;
        int numBlades = 0;
        double length = 0.0;
        for (ItemStack item : container.m_280657_()) {
            if (item.m_41619_()) continue;
            if (!(item.m_41720_() instanceof BladeItem)) {
                return false;
            }
            if (item.m_150930_((Item)ClockworkItems.WIDE_PROPELLER_BLADE.get()) && !isWide) {
                if (numBlades > 0) {
                    return false;
                }
                isWide = true;
            } else if (item.m_150930_((Item)ClockworkItems.PROPELLER_BLADE.get()) && isWide) {
                return false;
            }
            CompoundTag compoundTag = item.m_41783_();
            length += compoundTag != null ? compoundTag.m_128459_("BladeLength") : 0.0;
            ++numBlades;
        }
        return numBlades >= 2 && length <= ClockworkConfig.SERVER.getMaxBladeSize();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public ItemStack assemble(@NotNull CraftingContainer container, @NotNull RegistryAccess registryAccess) {
        ItemStack itemStack;
        void $this$fold$iv;
        void $this$mapTo$iv$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        List list = container.m_280657_();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ItemStack i = (ItemStack)element$iv$iv;
            boolean bl = false;
            if (!(i.m_41720_() instanceof BladeItem)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List items = (List)destination$iv$iv;
        if (items.size() < 2) {
            return ItemStack.f_41583_;
        }
        ItemStack newItem = new ItemStack((ItemLike)((ItemStack)CollectionsKt.first((List)items)).m_41720_());
        Iterable $this$map$iv = items;
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void i;
            ItemStack itemStack2 = (ItemStack)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            CompoundTag compoundTag = i.m_41783_();
            collection.add(compoundTag != null ? compoundTag.m_128459_("BladeLength") : 0.0);
        }
        $this$map$iv = (List)destination$iv$iv2;
        double initial$iv = 0.0;
        boolean $i$f$fold = false;
        double accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void d;
            double item$iv$iv = ((Number)element$iv).doubleValue();
            double acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc + d;
        }
        double length = accumulator$iv;
        ItemStack $this$assemble_u24lambda_u243 = itemStack = newItem;
        boolean bl = false;
        $this$assemble_u24lambda_u243.m_41784_().m_128347_("BladeLength", length);
        return itemStack;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @Nullable
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ClockworkRecipes.INSTANCE.getBLADE_CRAFTING_SERIALIZER().get();
    }
}

