/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.contraptions.propeller.blades;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import java.util.ArrayList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.clockwork.ClockworkItems;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0087\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u001f\u0012\u0006\u0010\t\u001a\u00020\u0002\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\u0007J.\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\t\u001a\u00020\u00022\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u000f\u001a\u00020\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0012\u001a\u00020\u0011H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0015\u001a\u00020\u0014H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0017\u0010\t\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0017\u001a\u0004\b\u0018\u0010\u0004R\u0017\u0010\n\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u0019\u001a\u0004\b\u001a\u0010\u0007R\u0017\u0010\u000b\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\u0019\u001a\u0004\b\u001b\u0010\u0007\u00a8\u0006\u001f"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/propeller/blades/BladeData;", "", "", "component1", "()Z", "", "component2", "()D", "component3", "wide", "angle", "length", "copy", "(ZDD)Lorg/valkyrienskies/clockwork/content/contraptions/propeller/blades/BladeData;", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Z", "getWide", "D", "getAngle", "getLength", "<init>", "(ZDD)V", "Companion", "clockwork"})
public final class BladeData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean wide;
    private final double angle;
    private final double length;

    public BladeData(boolean wide, double angle, double length) {
        this.wide = wide;
        this.angle = angle;
        this.length = length;
    }

    public final boolean getWide() {
        return this.wide;
    }

    public final double getAngle() {
        return this.angle;
    }

    public final double getLength() {
        return this.length;
    }

    public final boolean component1() {
        return this.wide;
    }

    public final double component2() {
        return this.angle;
    }

    public final double component3() {
        return this.length;
    }

    @NotNull
    public final BladeData copy(boolean wide, double angle, double length) {
        return new BladeData(wide, angle, length);
    }

    public static /* synthetic */ BladeData copy$default(BladeData bladeData, boolean bl, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = bladeData.wide;
        }
        if ((n & 2) != 0) {
            d = bladeData.angle;
        }
        if ((n & 4) != 0) {
            d2 = bladeData.length;
        }
        return bladeData.copy(bl, d, d2);
    }

    @NotNull
    public String toString() {
        return "BladeData(wide=" + this.wide + ", angle=" + this.angle + ", length=" + this.length + ")";
    }

    public int hashCode() {
        int result = Boolean.hashCode(this.wide);
        result = result * 31 + Double.hashCode(this.angle);
        result = result * 31 + Double.hashCode(this.length);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BladeData)) {
            return false;
        }
        BladeData bladeData = (BladeData)other;
        if (this.wide != bladeData.wide) {
            return false;
        }
        if (Double.compare(this.angle, bladeData.angle) != 0) {
            return false;
        }
        return Double.compare(this.length, bladeData.length) == 0;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\t\u0010\nJ%\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u00062\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/propeller/blades/BladeData$Companion;", "", "Lnet/minecraft/nbt/CompoundTag;", "nbt", "Ljava/util/ArrayList;", "Lorg/valkyrienskies/clockwork/content/contraptions/propeller/blades/BladeData;", "Lkotlin/collections/ArrayList;", "fromTag", "(Lnet/minecraft/nbt/CompoundTag;)Ljava/util/ArrayList;", "<init>", "()V", "clockwork"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ArrayList<BladeData> fromTag(@NotNull CompoundTag nbt) {
            Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
            CompoundTag compoundTag = nbt.m_128469_("Blades");
            if (compoundTag == null) {
                return new ArrayList<BladeData>();
            }
            CompoundTag tagBlades = compoundTag;
            int tagBladesSize = nbt.m_128451_("BladeCount");
            NonNullList nonNullList = NonNullList.m_122780_((int)8, (Object)ItemStack.f_41583_);
            Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"withSize(...)");
            NonNullList newList = nonNullList;
            ContainerHelper.m_18980_((CompoundTag)tagBlades, (NonNullList)newList);
            ArrayList<BladeData> blades = new ArrayList<BladeData>();
            double bladeAngle = nbt.m_128459_("BladeAngle");
            Iterator iterator = newList.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                ItemStack blade = (ItemStack)iterator2.next();
                if (blade.m_41619_()) continue;
                boolean wide = blade.m_150930_((Item)ClockworkItems.WIDE_PROPELLER_BLADE.get());
                CompoundTag compoundTag2 = blade.m_41783_();
                double length = compoundTag2 != null ? compoundTag2.m_128459_("BladeLength") : 1.0;
                blades.add(new BladeData(wide, bladeAngle, length));
            }
            return blades;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

