/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.contraptions.propeller.blades;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.clockwork.ClockworkConfig;
import org.valkyrienskies.clockwork.content.contraptions.propeller.blades.BladeControllerRenderer;
import org.valkyrienskies.clockwork.content.contraptions.propeller.contraption.PropellerContraption;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J/\u0010\r\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eR*\u0010\u0011\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\"\u0010\u0018\u001a\u00020\u00178\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006 "}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/propeller/blades/BladeControllerMovementBehaviour;", "Lcom/simibubi/create/api/behaviour/movement/MovementBehaviour;", "Lcom/simibubi/create/content/contraptions/behaviour/MovementContext;", "context", "", "tick", "(Lcom/simibubi/create/content/contraptions/behaviour/MovementContext;)V", "Lcom/simibubi/create/foundation/virtualWorld/VirtualRenderWorld;", "renderWorld", "Lcom/simibubi/create/content/contraptions/render/ContraptionMatrices;", "matrices", "Lnet/minecraft/client/renderer/MultiBufferSource;", "buffer", "renderInContraption", "(Lcom/simibubi/create/content/contraptions/behaviour/MovementContext;Lcom/simibubi/create/foundation/virtualWorld/VirtualRenderWorld;Lcom/simibubi/create/content/contraptions/render/ContraptionMatrices;Lnet/minecraft/client/renderer/MultiBufferSource;)V", "Lnet/minecraft/world/phys/Vec3;", "kotlin.jvm.PlatformType", "previousRotation", "Lnet/minecraft/world/phys/Vec3;", "getPreviousRotation", "()Lnet/minecraft/world/phys/Vec3;", "setPreviousRotation", "(Lnet/minecraft/world/phys/Vec3;)V", "", "durabilityTick", "I", "getDurabilityTick", "()I", "setDurabilityTick", "(I)V", "<init>", "()V", "clockwork"})
@SourceDebugExtension(value={"SMAP\nBladeControllerMovementBehaviour.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BladeControllerMovementBehaviour.kt\norg/valkyrienskies/clockwork/content/contraptions/propeller/blades/BladeControllerMovementBehaviour\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n1863#2,2:104\n1863#2,2:106\n*S KotlinDebug\n*F\n+ 1 BladeControllerMovementBehaviour.kt\norg/valkyrienskies/clockwork/content/contraptions/propeller/blades/BladeControllerMovementBehaviour\n*L\n51#1:104,2\n55#1:106,2\n*E\n"})
public final class BladeControllerMovementBehaviour
implements MovementBehaviour {
    private Vec3 previousRotation = Vec3.f_82478_;
    private int durabilityTick = 600;

    public final Vec3 getPreviousRotation() {
        return this.previousRotation;
    }

    public final void setPreviousRotation(Vec3 vec3) {
        this.previousRotation = vec3;
    }

    public final int getDurabilityTick() {
        return this.durabilityTick;
    }

    public final void setDurabilityTick(int n) {
        this.durabilityTick = n;
    }

    public void tick(@NotNull MovementContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CompoundTag blockEntityData = context.blockEntityData;
        CompoundTag blades = blockEntityData.m_128469_("Blades");
        if (!blades.m_128456_()) {
            int bladeCount = blockEntityData.m_128451_("BladeCount");
            NonNullList bladeList = NonNullList.m_122780_((int)8, (Object)ItemStack.f_41583_);
            for (int i = 0; i < bladeCount; ++i) {
                bladeList.set(i, (Object)ItemStack.m_41712_((CompoundTag)blades.m_128469_("Blade" + (i + 1))));
            }
            int currentBladeCount = 0;
            currentBladeCount = bladeCount;
            Vec3 rotation = (Vec3)context.rotation.apply(Vec3.f_82478_);
            Vec3 deltaRotation = rotation.m_82546_(this.previousRotation);
            if (Math.abs(deltaRotation.m_82553_()) >= 128.0 && ClockworkConfig.SERVER.getBladeControllerUsesDurability() && context.contraption instanceof PropellerContraption) {
                Contraption contraption = context.contraption;
                Intrinsics.checkNotNull((Object)contraption, (String)"null cannot be cast to non-null type org.valkyrienskies.clockwork.content.contraptions.propeller.contraption.PropellerContraption");
                if (!((PropellerContraption)contraption).getBrass()) {
                    int n = this.durabilityTick;
                    this.durabilityTick = n + -1;
                    if (this.durabilityTick <= 0) {
                        ItemStack it;
                        this.durabilityTick = 600;
                        ArrayList<ItemStack> toRemove = new ArrayList<ItemStack>();
                        Intrinsics.checkNotNull((Object)bladeList);
                        Iterable $this$forEach$iv = (Iterable)bladeList;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            it = (ItemStack)element$iv;
                            boolean bl = false;
                            boolean broken = it.m_220157_(1, context.world.f_46441_, null);
                            if (!broken) continue;
                            toRemove.add(it);
                        }
                        $this$forEach$iv = toRemove;
                        $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            it = (ItemStack)element$iv;
                            boolean bl = false;
                            bladeList.remove((Object)it);
                            currentBladeCount += -1;
                        }
                    }
                }
            }
            if (currentBladeCount != bladeCount) {
                blockEntityData.m_128405_("BladeCount", currentBladeCount);
                blades.m_128473_("Blades");
                CompoundTag newBlades = new CompoundTag();
                ContainerHelper.m_18973_((CompoundTag)newBlades, (NonNullList)bladeList);
                blockEntityData.m_128365_("Blades", (Tag)newBlades);
                blockEntityData.m_128379_("ShouldUpdatePhys", true);
            }
        }
    }

    public void renderInContraption(@NotNull MovementContext context, @NotNull VirtualRenderWorld renderWorld, @NotNull ContraptionMatrices matrices, @NotNull MultiBufferSource buffer) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)renderWorld, (String)"renderWorld");
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        CompoundTag blockEntityData = context.blockEntityData;
        CompoundTag blades = blockEntityData.m_128469_("Blades");
        int bladeCount = blockEntityData.m_128451_("BladeCount");
        NonNullList bladeNonNullList = NonNullList.m_122780_((int)bladeCount, (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)blades, (NonNullList)bladeNonNullList);
        List bladeList = new ArrayList();
        for (int i = 0; i < bladeCount; ++i) {
            if (bladeNonNullList.size() <= i) continue;
            Object object = bladeNonNullList.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            bladeList.add(object);
        }
        double bladeAngle = blockEntityData.m_128441_("BladeAngle") ? blockEntityData.m_128459_("BladeAngle") : 0.0;
        ArrayList<Float> bladeRotations = new ArrayList<Float>();
        int n = ((Collection)bladeList).size();
        for (int i = 0; i < n; ++i) {
            bladeRotations.add(Float.valueOf(360.0f / (float)bladeCount * (float)i));
        }
        int light = LevelRenderer.m_109541_((BlockAndTintGetter)((BlockAndTintGetter)renderWorld), (BlockPos)context.localPos);
        float f = (float)bladeAngle;
        BlockState blockState = context.state;
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"state");
        float f2 = AnimationTickHolder.getPartialTicks((LevelAccessor)((LevelAccessor)context.world));
        PoseStack poseStack = matrices.getViewProjection();
        Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"getViewProjection(...)");
        BladeControllerRenderer.Companion.renderShared(bladeList, f, blockState, f2, poseStack, buffer, light, (List<Float>)bladeRotations, true, matrices, (BlockAndTintGetter)context.world);
    }
}

