/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.contraptions.phys.slicker;

import com.fasterxml.jackson.dataformat.cbor.databind.CBORMapper;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.chassis.StickerBlock;
import com.simibubi.create.content.contraptions.glue.SuperGlueItem;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.clockwork.ClockworkBlocks;
import org.valkyrienskies.clockwork.ClockworkMod;
import org.valkyrienskies.clockwork.ClockworkSounds;
import org.valkyrienskies.clockwork.content.contraptions.phys.slicker.SlickerBlock;
import org.valkyrienskies.clockwork.content.contraptions.phys.slicker.SlickerMovementBehavior;
import org.valkyrienskies.clockwork.platform.PlatformUtils;
import org.valkyrienskies.clockwork.util.ClockworkConstants;
import org.valkyrienskies.clockwork.util.GetGTFAKt;
import org.valkyrienskies.core.impl.util.serialization.VSJacksonUtil;
import org.valkyrienskies.core.internal.joints.VSFixedJoint;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u001d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 i2\u00020\u0001:\u0001iB#\u0012\n\u0010b\u001a\u0006\u0012\u0002\b\u00030a\u0012\u0006\u0010d\u001a\u00020c\u0012\u0006\u0010f\u001a\u00020e\u00a2\u0006\u0004\bg\u0010hJ!\u0010\u0007\u001a\u00020\u00062\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0015\u0010\r\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u0012\u001a\u00020\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0014\u0010\nJ\r\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0017\u0010\nJ\r\u0010\u0018\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0018\u0010\u0016J\u001f\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0004H\u0014\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001f\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0004H\u0014\u00a2\u0006\u0004\b\u001f\u0010\u001dJ\u0015\u0010!\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0004\u00a2\u0006\u0004\b!\u0010\"R$\u0010$\u001a\u0004\u0018\u00010#8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\"\u0010*\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b*\u0010+\u001a\u0004\b,\u0010\u0016\"\u0004\b-\u0010\"R\"\u0010/\u001a\u00020.8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b/\u00100\u001a\u0004\b1\u00102\"\u0004\b3\u00104R$\u00106\u001a\u0004\u0018\u0001058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b6\u00107\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\"\u0010=\u001a\u00020<8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b=\u0010>\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\"\u0010D\u001a\u00020C8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bD\u0010E\u001a\u0004\bF\u0010G\"\u0004\bH\u0010IR\"\u0010J\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bJ\u0010+\u001a\u0004\bK\u0010\u0016\"\u0004\bL\u0010\"R\"\u0010M\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bM\u0010+\u001a\u0004\bN\u0010\u0016\"\u0004\bO\u0010\"R\"\u0010P\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bP\u0010+\u001a\u0004\bQ\u0010\u0016\"\u0004\bR\u0010\"R\"\u0010S\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bS\u0010+\u001a\u0004\bT\u0010\u0016\"\u0004\bU\u0010\"R\"\u0010V\u001a\u00020C8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bV\u0010E\u001a\u0004\bW\u0010G\"\u0004\bX\u0010IR\"\u0010Y\u001a\u00020C8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bY\u0010E\u001a\u0004\bZ\u0010G\"\u0004\b[\u0010IR\"\u0010\\\u001a\u00020C8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\\\u0010E\u001a\u0004\b]\u0010G\"\u0004\b^\u0010IR\u001a\u0010_\u001a\u00020C8\u0006X\u0086D\u00a2\u0006\f\n\u0004\b_\u0010E\u001a\u0004\b`\u0010G\u00a8\u0006j"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/phys/slicker/SlickerBlockEntity;", "Lcom/simibubi/create/foundation/blockEntity/SmartBlockEntity;", "Lnet/minecraft/server/level/ServerLevel;", "level", "", "removeTags", "", "removeConstraint", "(Lnet/minecraft/server/level/ServerLevel;Z)V", "doTick", "()V", "destroy", "reset", "isAlreadyPowered", "(Z)Z", "", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BlockEntityBehaviour;", "behaviours", "addBehaviours", "(Ljava/util/List;)V", "initialize", "isBlockStateExtended", "()Z", "tick", "isAttachedToShip", "Lnet/minecraft/nbt/CompoundTag;", "tag", "clientPacket", "write", "(Lnet/minecraft/nbt/CompoundTag;Z)V", "compound", "read", "attach", "playSound", "(Z)V", "Lnet/createmod/catnip/animation/LerpedFloat;", "piston", "Lnet/createmod/catnip/animation/LerpedFloat;", "getPiston", "()Lnet/createmod/catnip/animation/LerpedFloat;", "setPiston", "(Lnet/createmod/catnip/animation/LerpedFloat;)V", "update", "Z", "getUpdate", "setUpdate", "", "attachedShipId", "J", "getAttachedShipId", "()J", "setAttachedShipId", "(J)V", "Lorg/valkyrienskies/core/internal/joints/VSFixedJoint;", "attachmentConstraintData", "Lorg/valkyrienskies/core/internal/joints/VSFixedJoint;", "getAttachmentConstraintData", "()Lorg/valkyrienskies/core/internal/joints/VSFixedJoint;", "setAttachmentConstraintData", "(Lorg/valkyrienskies/core/internal/joints/VSFixedJoint;)V", "", "attachmentConstraintId", "I", "getAttachmentConstraintId", "()I", "setAttachmentConstraintId", "(I)V", "", "distance", "D", "getDistance", "()D", "setDistance", "(D)V", "shipStuck", "getShipStuck", "setShipStuck", "waitForNoPower", "getWaitForNoPower", "setWaitForNoPower", "wasAttached", "getWasAttached", "setWasAttached", "shouldRenderDoink", "getShouldRenderDoink", "setShouldRenderDoink", "currentDoinkSize", "getCurrentDoinkSize", "setCurrentDoinkSize", "currentDoinkTransparency", "getCurrentDoinkTransparency", "setCurrentDoinkTransparency", "targetDoinkSize", "getTargetDoinkSize", "setTargetDoinkSize", "targetDoinkTransparency", "getTargetDoinkTransparency", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "type", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "Companion", "clockwork"})
public final class SlickerBlockEntity
extends SmartBlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private LerpedFloat piston;
    private boolean update;
    private long attachedShipId;
    @Nullable
    private VSFixedJoint attachmentConstraintData;
    private int attachmentConstraintId;
    private double distance;
    private boolean shipStuck;
    private boolean waitForNoPower;
    private boolean wasAttached;
    private boolean shouldRenderDoink;
    private double currentDoinkSize;
    private double currentDoinkTransparency;
    private double targetDoinkSize;
    private final double targetDoinkTransparency;
    @NotNull
    private static final CBORMapper mapper = VSJacksonUtil.INSTANCE.getDefaultMapper();

    public SlickerBlockEntity(@NotNull BlockEntityType<?> type, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, pos, state);
        this.attachedShipId = -1L;
        this.attachmentConstraintId = -1;
        this.currentDoinkTransparency = 1.0;
        this.piston = LerpedFloat.linear();
        this.update = false;
    }

    @Nullable
    public final LerpedFloat getPiston() {
        return this.piston;
    }

    public final void setPiston(@Nullable LerpedFloat lerpedFloat) {
        this.piston = lerpedFloat;
    }

    public final boolean getUpdate() {
        return this.update;
    }

    public final void setUpdate(boolean bl) {
        this.update = bl;
    }

    public final long getAttachedShipId() {
        return this.attachedShipId;
    }

    public final void setAttachedShipId(long l) {
        this.attachedShipId = l;
    }

    @Nullable
    public final VSFixedJoint getAttachmentConstraintData() {
        return this.attachmentConstraintData;
    }

    public final void setAttachmentConstraintData(@Nullable VSFixedJoint vSFixedJoint) {
        this.attachmentConstraintData = vSFixedJoint;
    }

    public final int getAttachmentConstraintId() {
        return this.attachmentConstraintId;
    }

    public final void setAttachmentConstraintId(int n) {
        this.attachmentConstraintId = n;
    }

    public final double getDistance() {
        return this.distance;
    }

    public final void setDistance(double d) {
        this.distance = d;
    }

    public final boolean getShipStuck() {
        return this.shipStuck;
    }

    public final void setShipStuck(boolean bl) {
        this.shipStuck = bl;
    }

    public final boolean getWaitForNoPower() {
        return this.waitForNoPower;
    }

    public final void setWaitForNoPower(boolean bl) {
        this.waitForNoPower = bl;
    }

    public final boolean getWasAttached() {
        return this.wasAttached;
    }

    public final void setWasAttached(boolean bl) {
        this.wasAttached = bl;
    }

    public final boolean getShouldRenderDoink() {
        return this.shouldRenderDoink;
    }

    public final void setShouldRenderDoink(boolean bl) {
        this.shouldRenderDoink = bl;
    }

    public final double getCurrentDoinkSize() {
        return this.currentDoinkSize;
    }

    public final void setCurrentDoinkSize(double d) {
        this.currentDoinkSize = d;
    }

    public final double getCurrentDoinkTransparency() {
        return this.currentDoinkTransparency;
    }

    public final void setCurrentDoinkTransparency(double d) {
        this.currentDoinkTransparency = d;
    }

    public final double getTargetDoinkSize() {
        return this.targetDoinkSize;
    }

    public final void setTargetDoinkSize(double d) {
        this.targetDoinkSize = d;
    }

    public final double getTargetDoinkTransparency() {
        return this.targetDoinkTransparency;
    }

    private final void removeConstraint(ServerLevel level, boolean removeTags) {
        CompoundTag extraData = PlatformUtils.getExtraData(this).m_128469_(ClockworkConstants.Nbt.INSTANCE.getCONDENSED_DATA());
        if (extraData.m_128441_(ClockworkConstants.Nbt.INSTANCE.getATTACHMENT_CONSTRAINT())) {
            if (level != null) {
                GetGTFAKt.getGtpa(level).removeJoint(extraData.m_128451_(ClockworkConstants.Nbt.INSTANCE.getATTACHMENT_CONSTRAINT_ID()));
            }
            if (removeTags) {
                extraData.m_128473_(ClockworkConstants.Nbt.INSTANCE.getATTACHMENT_CONSTRAINT_ID());
                extraData.m_128473_(ClockworkConstants.Nbt.INSTANCE.getATTACHMENT_CONSTRAINT());
                extraData.m_128473_(ClockworkConstants.Nbt.INSTANCE.getSHIP_SLICKER_DISTANCE());
            }
        }
    }

    private final void doTick() {
        block16: {
            block15: {
                if (this.f_58857_ == null) break block15;
                Level level = this.f_58857_;
                Intrinsics.checkNotNull((Object)level);
                if (!level.f_46443_) break block16;
            }
            return;
        }
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        ServerLevel slevel = (ServerLevel)level;
        Comparable comparable = this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_);
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
        Direction myDir = (Direction)comparable;
        Vec3 vec3 = Vec3.m_82528_((Vec3i)myDir.m_122436_());
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"atLowerCornerOf(...)");
        Vector3d vector3d = VectorConversionsMCKt.toJOML((Vec3)vec3).normalize();
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"normalize(...)");
        Vector3d myDirNormal = vector3d;
        Vec3 vec32 = Vec3.m_82512_((Vec3i)((Vec3i)this.m_58899_()));
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"atCenterOf(...)");
        boolean shipAttached = SlickerMovementBehavior.Companion.isAttachedToShipOrWorld(false, slevel, (Vector3dc)VectorConversionsMCKt.toJOML((Vec3)vec32), (Vector3dc)myDirNormal, PlatformUtils.getExtraData(this));
        if (this.isBlockStateExtended() && !this.shipStuck) {
            this.waitForNoPower = false;
            if (shipAttached) {
                Vec3 vec33 = Vec3.m_82512_((Vec3i)((Vec3i)this.m_58899_()));
                Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"atCenterOf(...)");
                if (SlickerMovementBehavior.Companion.isAttachedToShipOrWorld(true, slevel, (Vector3dc)VectorConversionsMCKt.toJOML((Vec3)vec33), (Vector3dc)myDirNormal, PlatformUtils.getExtraData(this))) {
                    this.shipStuck = true;
                    ClockworkSounds.SoundEntry soundEntry = ClockworkSounds.INSTANCE.getDOINK();
                    Level level2 = (Level)slevel;
                    BlockPos blockPos = this.f_58858_;
                    Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
                    BlockPos blockPos2 = BlockPos.m_274446_((Position)((Position)VSGameUtilsKt.toWorldCoordinates((Level)this.f_58857_, (BlockPos)blockPos)));
                    Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"containing(...)");
                    soundEntry.playOnServer(level2, (Vec3i)blockPos2, 0.35f, 0.75f);
                    this.sendData();
                }
            }
        } else if (!this.isBlockStateExtended() && this.shipStuck) {
            Level level3 = this.f_58857_;
            Intrinsics.checkNotNull((Object)level3);
            if (!level3.f_46443_) {
                ClockworkSounds.SoundEntry soundEntry = ClockworkSounds.INSTANCE.getBOING();
                Level level4 = (Level)slevel;
                BlockPos blockPos = this.f_58858_;
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
                BlockPos blockPos3 = BlockPos.m_274446_((Position)((Position)VSGameUtilsKt.toWorldCoordinates((Level)this.f_58857_, (BlockPos)blockPos)));
                Intrinsics.checkNotNullExpressionValue((Object)blockPos3, (String)"containing(...)");
                soundEntry.playOnServer(level4, (Vec3i)blockPos3, 0.35f, 0.75f);
                this.removeConstraint((ServerLevel)this.f_58857_, true);
                this.shipStuck = false;
            }
            this.waitForNoPower = true;
        } else if (this.isBlockStateExtended() && !PlatformUtils.getExtraData(this).m_128469_(ClockworkConstants.Nbt.INSTANCE.getCONDENSED_DATA()).m_128441_(ClockworkConstants.Nbt.INSTANCE.getATTACHMENT_CONSTRAINT_ID()) && !this.shipStuck && shipAttached && ((Boolean)this.m_58900_().m_61143_((Property)SlickerBlock.Companion.getPOWERED())).booleanValue()) {
            this.waitForNoPower = false;
            Vec3 vec34 = Vec3.m_82512_((Vec3i)((Vec3i)this.m_58899_()));
            Intrinsics.checkNotNullExpressionValue((Object)vec34, (String)"atCenterOf(...)");
            if (SlickerMovementBehavior.Companion.isAttachedToShipOrWorld(true, slevel, (Vector3dc)VectorConversionsMCKt.toJOML((Vec3)vec34), (Vector3dc)myDirNormal, PlatformUtils.getExtraData(this))) {
                ClockworkSounds.SoundEntry soundEntry = ClockworkSounds.INSTANCE.getDOINK();
                Level level5 = (Level)slevel;
                BlockPos blockPos = this.f_58858_;
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
                BlockPos blockPos4 = BlockPos.m_274446_((Position)((Position)VSGameUtilsKt.toWorldCoordinates((Level)this.f_58857_, (BlockPos)blockPos)));
                Intrinsics.checkNotNullExpressionValue((Object)blockPos4, (String)"containing(...)");
                soundEntry.playOnServer(level5, (Vec3i)blockPos4, 0.35f, 0.75f);
                this.shipStuck = true;
                this.sendData();
            }
        }
        if (this.waitForNoPower && !((Boolean)this.m_58900_().m_61143_((Property)SlickerBlock.Companion.getPOWERED())).booleanValue()) {
            if (this.shipStuck) {
                ClockworkSounds.SoundEntry soundEntry = ClockworkSounds.INSTANCE.getBOING();
                Level level6 = (Level)slevel;
                BlockPos blockPos = this.f_58858_;
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
                BlockPos blockPos5 = BlockPos.m_274446_((Position)((Position)VSGameUtilsKt.toWorldCoordinates((Level)this.f_58857_, (BlockPos)blockPos)));
                Intrinsics.checkNotNullExpressionValue((Object)blockPos5, (String)"containing(...)");
                soundEntry.playOnServer(level6, (Vec3i)blockPos5, 0.35f, 0.75f);
            }
            this.waitForNoPower = false;
            this.shipStuck = false;
            this.sendData();
        }
    }

    public void destroy() {
        if (this.f_58857_ != null) {
            Level level = this.f_58857_;
            Intrinsics.checkNotNull((Object)level);
            if (!level.f_46443_) {
                this.removeConstraint((ServerLevel)this.f_58857_, true);
            }
        }
    }

    public final boolean isAlreadyPowered(boolean reset) {
        CompoundTag extraData = PlatformUtils.getExtraData(this).m_128469_(ClockworkConstants.Nbt.INSTANCE.getCONDENSED_DATA());
        boolean result = extraData.m_128441_(ClockworkConstants.Nbt.INSTANCE.getSHIP_STICKER_ALREADY_POWERED());
        if (reset) {
            extraData.m_128473_(ClockworkConstants.Nbt.INSTANCE.getSHIP_STICKER_ALREADY_POWERED());
        }
        return result;
    }

    public void addBehaviours(@NotNull List<BlockEntityBehaviour> behaviours) {
        Intrinsics.checkNotNullParameter(behaviours, (String)"behaviours");
    }

    public void initialize() {
        super.initialize();
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (!level.f_46443_) {
            return;
        }
        LerpedFloat lerpedFloat = this.piston;
        Intrinsics.checkNotNull((Object)lerpedFloat);
        lerpedFloat.startWithValue(((Number)(this.isBlockStateExtended() ? (Number)-0.125 : (Number)0)).doubleValue());
    }

    public final boolean isBlockStateExtended() {
        BlockState blockState = this.m_58900_();
        return ClockworkBlocks.SLICKER.has(blockState) && (Boolean)blockState.m_61143_((Property)SlickerBlock.Companion.getEXTENDED()) != false;
    }

    public void tick() {
        super.tick();
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (!level.f_46443_) {
            this.doTick();
            return;
        }
        LerpedFloat lerpedFloat = this.piston;
        Intrinsics.checkNotNull((Object)lerpedFloat);
        lerpedFloat.tickChaser();
        if (this.isAttachedToShip()) {
            LerpedFloat lerpedFloat2 = this.piston;
            Intrinsics.checkNotNull((Object)lerpedFloat2);
            float f = lerpedFloat2.getValue(0.0f);
            LerpedFloat lerpedFloat3 = this.piston;
            Intrinsics.checkNotNull((Object)lerpedFloat3);
            if (!(f == lerpedFloat3.getValue())) {
                LerpedFloat lerpedFloat4 = this.piston;
                Intrinsics.checkNotNull((Object)lerpedFloat4);
                if (lerpedFloat4.getValue() == 1.0f) {
                    SuperGlueItem.spawnParticles((Level)this.f_58857_, (BlockPos)this.f_58858_, (Direction)((Direction)this.m_58900_().m_61143_((Property)StickerBlock.f_52588_)), (boolean)true);
                    this.playSound(true);
                }
            }
        }
        if (this.shipStuck != this.wasAttached) {
            this.shouldRenderDoink = true;
            this.targetDoinkSize = this.shipStuck ? 2.0 : 0.0;
            this.currentDoinkTransparency = 1.0;
            this.wasAttached = this.shipStuck;
        }
        if (this.shouldRenderDoink) {
            // empty if block
        }
        if (!this.update) {
            return;
        }
        this.update = false;
        double target = this.isBlockStateExtended() ? 0.125 : 0.0;
        ClockworkMod.INSTANCE.getLOGGER().info(String.valueOf(this.isBlockStateExtended()));
        if (this.isAttachedToShip() && target == 0.0) {
            LerpedFloat lerpedFloat5 = this.piston;
            Intrinsics.checkNotNull((Object)lerpedFloat5);
            if (lerpedFloat5.getChaseTarget() == 1.0f) {
                this.playSound(false);
            }
        }
        LerpedFloat lerpedFloat6 = this.piston;
        Intrinsics.checkNotNull((Object)lerpedFloat6);
        lerpedFloat6.chase(target, 0.4, LerpedFloat.Chaser.LINEAR);
    }

    public final boolean isAttachedToShip() {
        BlockState blockState = this.m_58900_();
        if (!AllBlocks.STICKER.has(blockState)) {
            return false;
        }
        return this.shipStuck;
    }

    protected void write(@NotNull CompoundTag tag, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        super.write(tag, clientPacket);
        CompoundTag condensedTag = new CompoundTag();
        if (this.attachedShipId != -1L) {
            condensedTag.m_128356_(ClockworkConstants.Nbt.INSTANCE.getATTACHED_SHIP(), this.attachedShipId);
        }
        if (this.attachmentConstraintData != null) {
            condensedTag.m_128382_(ClockworkConstants.Nbt.INSTANCE.getATTACHMENT_CONSTRAINT(), mapper.writeValueAsBytes((Object)this.attachmentConstraintData));
        }
        if (this.attachmentConstraintId != -1) {
            condensedTag.m_128405_(ClockworkConstants.Nbt.INSTANCE.getATTACHMENT_CONSTRAINT_ID(), this.attachmentConstraintId);
        }
        condensedTag.m_128347_(ClockworkConstants.Nbt.INSTANCE.getSHIP_SLICKER_DISTANCE(), this.distance);
        condensedTag.m_128379_(ClockworkConstants.Nbt.INSTANCE.getSHIP_STUCK(), this.shipStuck);
        tag.m_128365_(ClockworkConstants.Nbt.INSTANCE.getCONDENSED_DATA(), (Tag)condensedTag);
    }

    protected void read(@NotNull CompoundTag compound, boolean clientPacket) {
        CompoundTag tag;
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.read(compound, clientPacket);
        if (clientPacket) {
            this.update = true;
        }
        if ((tag = compound.m_128469_(ClockworkConstants.Nbt.INSTANCE.getCONDENSED_DATA())).m_128441_(ClockworkConstants.Nbt.INSTANCE.getATTACHED_SHIP())) {
            this.attachedShipId = compound.m_128454_(ClockworkConstants.Nbt.INSTANCE.getATTACHED_SHIP());
        }
        if (tag.m_128441_(ClockworkConstants.Nbt.INSTANCE.getATTACHMENT_CONSTRAINT())) {
            this.attachmentConstraintData = (VSFixedJoint)mapper.readValue(compound.m_128463_(ClockworkConstants.Nbt.INSTANCE.getATTACHMENT_CONSTRAINT()), VSFixedJoint.class);
        }
        if (tag.m_128441_(ClockworkConstants.Nbt.INSTANCE.getATTACHMENT_CONSTRAINT_ID())) {
            this.attachmentConstraintId = compound.m_128451_(ClockworkConstants.Nbt.INSTANCE.getATTACHMENT_CONSTRAINT_ID());
        }
        this.distance = compound.m_128459_(ClockworkConstants.Nbt.INSTANCE.getSHIP_SLICKER_DISTANCE());
        this.shipStuck = compound.m_128471_(ClockworkConstants.Nbt.INSTANCE.getSHIP_STUCK());
    }

    public final void playSound(boolean attach) {
        ClockworkSounds.SoundEntry soundEntry = ClockworkSounds.INSTANCE.getDOINK();
        BlockPos blockPos = this.f_58858_;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
        soundEntry.playAt(this.f_58857_, (Vec3i)blockPos, 0.35f, attach ? 0.75f : 0.2f, false);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/phys/slicker/SlickerBlockEntity$Companion;", "", "Lcom/fasterxml/jackson/dataformat/cbor/databind/CBORMapper;", "mapper", "Lcom/fasterxml/jackson/dataformat/cbor/databind/CBORMapper;", "getMapper", "()Lcom/fasterxml/jackson/dataformat/cbor/databind/CBORMapper;", "<init>", "()V", "clockwork"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CBORMapper getMapper() {
            return mapper;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

