/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.contraptions.phys.infuser;

import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBic;
import org.valkyrienskies.clockwork.ClockworkConfig;
import org.valkyrienskies.clockwork.ClockworkPackets;
import org.valkyrienskies.clockwork.ClockworkSounds;
import org.valkyrienskies.clockwork.client.render.scanner.ScannerRenderer;
import org.valkyrienskies.clockwork.content.contraptions.phys.infuser.PhysicsInfuserSyncPacket;
import org.valkyrienskies.clockwork.content.curiosities.tools.wanderwand.WanderwandItem;
import org.valkyrienskies.clockwork.util.ClockworkConstants;
import org.valkyrienskies.clockwork.util.EaseHelper;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.assembly.ShipAssembler;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00a8\u00012\u00020\u00012\u00020\u0002:\u0004\u00a9\u0001\u00a8\u0001B1\u0012\u000e\u0010\u00a1\u0001\u001a\t\u0012\u0002\b\u0003\u0018\u00010\u00a0\u0001\u0012\n\u0010\u00a3\u0001\u001a\u0005\u0018\u00010\u00a2\u0001\u0012\n\u0010\u00a5\u0001\u001a\u0005\u0018\u00010\u00a4\u0001\u00a2\u0006\u0006\b\u00a6\u0001\u0010\u00a7\u0001J\u0017\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J)\u0010\u000e\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ'\u0010\u0011\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u000fJ\u000f\u0010\u0012\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u0018J\u001f\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010 \u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b \u0010!J\u0017\u0010$\u001a\u00020\r2\u0006\u0010#\u001a\u00020\"H\u0016\u00a2\u0006\u0004\b$\u0010%J\u000f\u0010&\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b&\u0010!J\u000f\u0010'\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b'\u0010!J\u000f\u0010(\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b(\u0010!J\r\u0010)\u001a\u00020\u001d\u00a2\u0006\u0004\b)\u0010!J\r\u0010*\u001a\u00020\u001d\u00a2\u0006\u0004\b*\u0010!J\r\u0010+\u001a\u00020\u001d\u00a2\u0006\u0004\b+\u0010!J\u001d\u00100\u001a\u00020.2\u0006\u0010-\u001a\u00020,2\u0006\u0010/\u001a\u00020.\u00a2\u0006\u0004\b0\u00101J\r\u00102\u001a\u00020\u001d\u00a2\u0006\u0004\b2\u0010!J\r\u00103\u001a\u00020\u001d\u00a2\u0006\u0004\b3\u0010!J\u0015\u00106\u001a\u00020\u001d2\u0006\u00105\u001a\u000204\u00a2\u0006\u0004\b6\u00107J\u0015\u00109\u001a\u00020.2\u0006\u00108\u001a\u00020.\u00a2\u0006\u0004\b9\u0010:J\u0015\u0010;\u001a\u00020.2\u0006\u00108\u001a\u00020.\u00a2\u0006\u0004\b;\u0010:J\u001f\u0010?\u001a\u00020\u001d2\u0006\u0010=\u001a\u00020<2\u0006\u0010>\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b?\u0010@J\u001f\u0010A\u001a\u00020\u001d2\u0006\u0010=\u001a\u00020<2\u0006\u0010>\u001a\u00020\rH\u0014\u00a2\u0006\u0004\bA\u0010@J\u001d\u0010E\u001a\u00020\u001d2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020C0BH\u0016\u00a2\u0006\u0004\bE\u0010FR\u0014\u0010H\u001a\u00020G8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bH\u0010IR\"\u0010J\u001a\u00020\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bJ\u0010K\u001a\u0004\bJ\u0010\u0015\"\u0004\bL\u0010MR\"\u0010N\u001a\u00020\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bN\u0010K\u001a\u0004\bO\u0010\u0015\"\u0004\bP\u0010MR\"\u0010Q\u001a\u00020\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bQ\u0010K\u001a\u0004\bR\u0010\u0015\"\u0004\bS\u0010MR$\u0010T\u001a\u0004\u0018\u0001048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bT\u0010U\u001a\u0004\bV\u0010W\"\u0004\bX\u00107R*\u0010[\u001a\n Z*\u0004\u0018\u00010Y0Y8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b[\u0010\\\u001a\u0004\b]\u0010^\"\u0004\b_\u0010`R*\u0010a\u001a\n Z*\u0004\u0018\u00010Y0Y8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\ba\u0010\\\u001a\u0004\bb\u0010^\"\u0004\bc\u0010`R*\u0010d\u001a\n Z*\u0004\u0018\u00010Y0Y8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bd\u0010\\\u001a\u0004\be\u0010^\"\u0004\bf\u0010`R$\u0010h\u001a\u0004\u0018\u00010g8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\bh\u0010i\u001a\u0004\bj\u0010k\"\u0004\bl\u0010mR\"\u0010n\u001a\u00020\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bn\u0010K\u001a\u0004\bo\u0010\u0015\"\u0004\bp\u0010MR\"\u0010q\u001a\u00020.8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bq\u0010r\u001a\u0004\bs\u0010t\"\u0004\bu\u0010vR\"\u0010w\u001a\u00020.8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bw\u0010r\u001a\u0004\bx\u0010t\"\u0004\by\u0010vR\"\u0010z\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bz\u0010{\u001a\u0004\b|\u0010\u0013\"\u0004\b}\u0010~R$\u0010\u007f\u001a\u00020\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0014\n\u0004\b\u007f\u0010K\u001a\u0005\b\u0080\u0001\u0010\u0015\"\u0005\b\u0081\u0001\u0010MR&\u0010\u0082\u0001\u001a\u00020\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0015\n\u0005\b\u0082\u0001\u0010K\u001a\u0005\b\u0083\u0001\u0010\u0015\"\u0005\b\u0084\u0001\u0010MR0\u0010\u0087\u0001\u001a\u0005\u0018\u00010\u0085\u00012\n\u0010\u0086\u0001\u001a\u0005\u0018\u00010\u0085\u00018\u0006@BX\u0086\u000e\u00a2\u0006\u0010\n\u0006\b\u0087\u0001\u0010\u0088\u0001\u001a\u0006\b\u0089\u0001\u0010\u008a\u0001R\u001f\u0010\u008c\u0001\u001a\n\u0012\u0005\u0012\u00030\u0085\u00010\u008b\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u008c\u0001\u0010\u008d\u0001R\u0018\u0010\u008e\u0001\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u008e\u0001\u0010KR\u0018\u0010\u008f\u0001\u001a\u00020\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u008f\u0001\u0010{R&\u0010\u0090\u0001\u001a\u00020\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0015\n\u0005\b\u0090\u0001\u0010K\u001a\u0005\b\u0091\u0001\u0010\u0015\"\u0005\b\u0092\u0001\u0010MRO\u0010\u0094\u0001\u001a(\u0012\f\u0012\n Z*\u0004\u0018\u00010\n0\n Z*\u0013\u0012\f\u0012\n Z*\u0004\u0018\u00010\n0\n\u0018\u00010\u0093\u00010\u0093\u00018\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0018\n\u0006\b\u0094\u0001\u0010\u0095\u0001\u001a\u0006\b\u0096\u0001\u0010\u0097\u0001\"\u0006\b\u0098\u0001\u0010\u0099\u0001R\u0015\u0010\u009d\u0001\u001a\u00030\u009a\u00018F\u00a2\u0006\b\u001a\u0006\b\u009b\u0001\u0010\u009c\u0001R\u0013\u0010\u009f\u0001\u001a\u00020\b8F\u00a2\u0006\u0007\u001a\u0005\b\u009e\u0001\u0010\u0013\u00a8\u0006\u00aa\u0001"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/phys/infuser/PhysicsInfuserBlockEntity;", "Lcom/simibubi/create/foundation/blockEntity/SmartBlockEntity;", "Lnet/minecraft/world/WorldlyContainer;", "Lnet/minecraft/core/Direction;", "side", "", "getSlotsForFace", "(Lnet/minecraft/core/Direction;)[I", "", "index", "Lnet/minecraft/world/item/ItemStack;", "itemStack", "direction", "", "canPlaceItemThroughFace", "(ILnet/minecraft/world/item/ItemStack;Lnet/minecraft/core/Direction;)Z", "stack", "canTakeItemThroughFace", "getContainerSize", "()I", "isEmpty", "()Z", "slot", "getItem", "(I)Lnet/minecraft/world/item/ItemStack;", "amount", "removeItem", "(II)Lnet/minecraft/world/item/ItemStack;", "removeItemNoUpdate", "", "setItem", "(ILnet/minecraft/world/item/ItemStack;)V", "setChanged", "()V", "Lnet/minecraft/world/entity/player/Player;", "player", "stillValid", "(Lnet/minecraft/world/entity/player/Player;)Z", "clearContent", "tick", "resetAfterAssemble", "startAssembly", "skipAssembly", "startDisassembly", "", "start", "", "duration", "computeRadius", "(JF)F", "assemble", "disassemble", "Lorg/valkyrienskies/clockwork/content/contraptions/phys/infuser/PhysicsInfuserBlockEntity$Animation;", "animation", "startAnimation", "(Lorg/valkyrienskies/clockwork/content/contraptions/phys/infuser/PhysicsInfuserBlockEntity$Animation;)V", "partialTicks", "getInterpolatedCoreAngle", "(F)F", "getCoreOffset", "Lnet/minecraft/nbt/CompoundTag;", "compound", "clientPacket", "write", "(Lnet/minecraft/nbt/CompoundTag;Z)V", "read", "", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BlockEntityBehaviour;", "behaviours", "addBehaviours", "(Ljava/util/List;)V", "Lnet/minecraft/world/phys/Vec3;", "thisposition", "Lnet/minecraft/world/phys/Vec3;", "isAssembled", "Z", "setAssembled", "(Z)V", "assembling", "getAssembling", "setAssembling", "disassembling", "getDisassembling", "setDisassembling", "animationType", "Lorg/valkyrienskies/clockwork/content/contraptions/phys/infuser/PhysicsInfuserBlockEntity$Animation;", "getAnimationType", "()Lorg/valkyrienskies/clockwork/content/contraptions/phys/infuser/PhysicsInfuserBlockEntity$Animation;", "setAnimationType", "Lnet/createmod/catnip/animation/LerpedFloat;", "kotlin.jvm.PlatformType", "assemblyProgress", "Lnet/createmod/catnip/animation/LerpedFloat;", "getAssemblyProgress", "()Lnet/createmod/catnip/animation/LerpedFloat;", "setAssemblyProgress", "(Lnet/createmod/catnip/animation/LerpedFloat;)V", "disassemblyProgress", "getDisassemblyProgress", "setDisassemblyProgress", "idleProgress", "getIdleProgress", "setIdleProgress", "Lcom/simibubi/create/content/contraptions/AssemblyException;", "lastException", "Lcom/simibubi/create/content/contraptions/AssemblyException;", "getLastException", "()Lcom/simibubi/create/content/contraptions/AssemblyException;", "setLastException", "(Lcom/simibubi/create/content/contraptions/AssemblyException;)V", "skippingAssembly", "getSkippingAssembly", "setSkippingAssembly", "coreAngle", "F", "getCoreAngle", "()F", "setCoreAngle", "(F)V", "previousCoreAngle", "getPreviousCoreAngle", "setPreviousCoreAngle", "useCooldown", "I", "getUseCooldown", "setUseCooldown", "(I)V", "onCooldown", "getOnCooldown", "setOnCooldown", "initPlayed", "getInitPlayed", "setInitPlayed", "Lorg/valkyrienskies/core/api/ships/Ship;", "value", "connectedShip", "Lorg/valkyrienskies/core/api/ships/Ship;", "getConnectedShip", "()Lorg/valkyrienskies/core/api/ships/Ship;", "", "createdShips", "Ljava/util/Set;", "sendAnimationUpdate", "launchForce", "shouldEjectDesignator", "getShouldEjectDesignator", "setShouldEjectDesignator", "Lnet/minecraft/core/NonNullList;", "inventory", "Lnet/minecraft/core/NonNullList;", "getInventory", "()Lnet/minecraft/core/NonNullList;", "setInventory", "(Lnet/minecraft/core/NonNullList;)V", "", "getPulseRange", "()D", "pulseRange", "getScanGrowthDuration", "scanGrowthDuration", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "type", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "Companion", "Animation", "clockwork"})
@SourceDebugExtension(value={"SMAP\nPhysicsInfuserBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhysicsInfuserBlockEntity.kt\norg/valkyrienskies/clockwork/content/contraptions/phys/infuser/PhysicsInfuserBlockEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,456:1\n295#2,2:457\n1755#2,3:459\n*S KotlinDebug\n*F\n+ 1 PhysicsInfuserBlockEntity.kt\norg/valkyrienskies/clockwork/content/contraptions/phys/infuser/PhysicsInfuserBlockEntity\n*L\n273#1:457,2\n274#1:459,3\n*E\n"})
public final class PhysicsInfuserBlockEntity
extends SmartBlockEntity
implements WorldlyContainer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Vec3 thisposition;
    private boolean isAssembled;
    private boolean assembling;
    private boolean disassembling;
    @Nullable
    private Animation animationType;
    private LerpedFloat assemblyProgress;
    private LerpedFloat disassemblyProgress;
    private LerpedFloat idleProgress;
    @Nullable
    private AssemblyException lastException;
    private boolean skippingAssembly;
    private float coreAngle;
    private float previousCoreAngle;
    private int useCooldown;
    private boolean onCooldown;
    private boolean initPlayed;
    @Nullable
    private Ship connectedShip;
    @NotNull
    private final Set<Ship> createdShips;
    private boolean sendAnimationUpdate;
    private int launchForce;
    private boolean shouldEjectDesignator;
    private NonNullList<ItemStack> inventory;
    public static final int ASSEMBLY_TIME = 500;
    public static final int DISASSEMBLY_TIME = 1000;

    public PhysicsInfuserBlockEntity(@Nullable BlockEntityType<?> type, @Nullable BlockPos pos, @Nullable BlockState state) {
        super(type, pos, state);
        BlockPos blockPos = this.f_58858_;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
        this.thisposition = VectorConversionsMCKt.toMinecraft((Vector3dc)((Vector3dc)VectorConversionsMCKt.toJOMLD((Vec3i)((Vec3i)blockPos))));
        this.animationType = Animation.IDLE;
        this.assemblyProgress = LerpedFloat.linear();
        this.disassemblyProgress = LerpedFloat.linear();
        this.idleProgress = LerpedFloat.linear();
        this.createdShips = new HashSet();
        this.inventory = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
    }

    public final boolean isAssembled() {
        return this.isAssembled;
    }

    public final void setAssembled(boolean bl) {
        this.isAssembled = bl;
    }

    public final boolean getAssembling() {
        return this.assembling;
    }

    public final void setAssembling(boolean bl) {
        this.assembling = bl;
    }

    public final boolean getDisassembling() {
        return this.disassembling;
    }

    public final void setDisassembling(boolean bl) {
        this.disassembling = bl;
    }

    @Nullable
    public final Animation getAnimationType() {
        return this.animationType;
    }

    public final void setAnimationType(@Nullable Animation animation) {
        this.animationType = animation;
    }

    public final LerpedFloat getAssemblyProgress() {
        return this.assemblyProgress;
    }

    public final void setAssemblyProgress(LerpedFloat lerpedFloat) {
        this.assemblyProgress = lerpedFloat;
    }

    public final LerpedFloat getDisassemblyProgress() {
        return this.disassemblyProgress;
    }

    public final void setDisassemblyProgress(LerpedFloat lerpedFloat) {
        this.disassemblyProgress = lerpedFloat;
    }

    public final LerpedFloat getIdleProgress() {
        return this.idleProgress;
    }

    public final void setIdleProgress(LerpedFloat lerpedFloat) {
        this.idleProgress = lerpedFloat;
    }

    @Nullable
    protected final AssemblyException getLastException() {
        return this.lastException;
    }

    protected final void setLastException(@Nullable AssemblyException assemblyException) {
        this.lastException = assemblyException;
    }

    public final boolean getSkippingAssembly() {
        return this.skippingAssembly;
    }

    public final void setSkippingAssembly(boolean bl) {
        this.skippingAssembly = bl;
    }

    public final float getCoreAngle() {
        return this.coreAngle;
    }

    public final void setCoreAngle(float f) {
        this.coreAngle = f;
    }

    public final float getPreviousCoreAngle() {
        return this.previousCoreAngle;
    }

    public final void setPreviousCoreAngle(float f) {
        this.previousCoreAngle = f;
    }

    public final int getUseCooldown() {
        return this.useCooldown;
    }

    public final void setUseCooldown(int n) {
        this.useCooldown = n;
    }

    public final boolean getOnCooldown() {
        return this.onCooldown;
    }

    public final void setOnCooldown(boolean bl) {
        this.onCooldown = bl;
    }

    public final boolean getInitPlayed() {
        return this.initPlayed;
    }

    public final void setInitPlayed(boolean bl) {
        this.initPlayed = bl;
    }

    @Nullable
    public final Ship getConnectedShip() {
        return this.connectedShip;
    }

    public final boolean getShouldEjectDesignator() {
        return this.shouldEjectDesignator;
    }

    public final void setShouldEjectDesignator(boolean bl) {
        this.shouldEjectDesignator = bl;
    }

    public final NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public final void setInventory(NonNullList<ItemStack> nonNullList) {
        this.inventory = nonNullList;
    }

    @NotNull
    public int[] m_7071_(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return new int[0];
    }

    public boolean m_7155_(int index, @NotNull ItemStack itemStack, @Nullable Direction direction) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        return false;
    }

    public boolean m_7157_(int index, @NotNull ItemStack stack, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        return true;
    }

    public int m_6643_() {
        return 1;
    }

    public boolean m_7983_() {
        return ((ItemStack)this.inventory.get(0)).m_41619_();
    }

    @NotNull
    public ItemStack m_8020_(int slot) {
        Object object = this.inventory.get(0);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (ItemStack)object;
    }

    @NotNull
    public ItemStack m_7407_(int slot, int amount) {
        Object object = this.inventory.remove(0);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"removeAt(...)");
        return (ItemStack)object;
    }

    @NotNull
    public ItemStack m_8016_(int slot) {
        Object object = this.inventory.remove(0);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"removeAt(...)");
        return (ItemStack)object;
    }

    public void m_6836_(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        this.inventory.set(0, (Object)stack);
    }

    public void m_6596_() {
        ClockworkPackets.Companion.sendToNear(this.m_58904_(), this.f_58858_, 64, new PhysicsInfuserSyncPacket(this));
        super.m_6596_();
    }

    public boolean m_6542_(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return true;
    }

    public void m_6211_() {
        this.inventory.set(0, (Object)ItemStack.f_41583_);
    }

    public void tick() {
        super.tick();
        if (this.f_58857_ == null) {
            return;
        }
        if (this.shouldEjectDesignator) {
            this.shouldEjectDesignator = false;
            if (((ItemStack)this.inventory.get(0)).m_41619_()) {
                return;
            }
            ItemEntity ejected = new ItemEntity(this.f_58857_, (double)this.m_58899_().m_123341_(), (double)(this.m_58899_().m_123342_() + 1), (double)this.m_58899_().m_123343_(), (ItemStack)this.inventory.get(0));
            this.inventory.set(0, (Object)ItemStack.f_41583_);
            ejected.m_20256_(new Vec3(0.0, (double)this.launchForce / 10.0, 0.0));
            Level level = this.f_58857_;
            Intrinsics.checkNotNull((Object)level);
            level.m_7967_((Entity)ejected);
        }
        if (this.f_58857_ instanceof ServerLevel) {
            BlockPos blockPos = this.f_58858_;
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
            this.connectedShip = (Ship)VSGameUtilsKt.getShipObjectManagingPos((Level)this.f_58857_, (Vec3i)((Vec3i)blockPos));
        }
        if (this.useCooldown > 0) {
            this.onCooldown = true;
            int ejected = this.useCooldown;
            this.useCooldown = ejected + -1;
        }
        if (this.useCooldown == 0) {
            this.onCooldown = false;
        }
        if (this.animationType == null) {
            this.animationType = Animation.IDLE;
        }
        if (this.animationType == Animation.IDLE) {
            this.startAnimation(Animation.IDLE);
        }
        if (this.assembling) {
            this.assemblyProgress.setValue((double)(this.assemblyProgress.getValue() + 1.0f));
        }
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        RandomSource rand = level.m_213780_();
        if (this.assembling) {
            if (this.skippingAssembly && this.assemblyProgress.getValue() < 455.0f) {
                this.assemblyProgress.setValue(455.0);
            }
            if (this.assemblyProgress.getValue() == 0.0f) {
                Level level2 = this.f_58857_;
                Intrinsics.checkNotNull((Object)level2);
                Companion.playInitializeSound(level2, this.thisposition);
            }
            if (this.assemblyProgress.getValue() == 100.0f) {
                Level level3 = this.f_58857_;
                Intrinsics.checkNotNull((Object)level3);
                Companion.playWindupSound(level3, this.thisposition);
            }
            if (this.assemblyProgress.getValue() == 160.0f || this.assemblyProgress.getValue() == 220.0f || this.assemblyProgress.getValue() == 240.0f || this.assemblyProgress.getValue() == 300.0f || this.assemblyProgress.getValue() == 320.0f || this.assemblyProgress.getValue() == 360.0f || this.assemblyProgress.getValue() == 400.0f || this.assemblyProgress.getValue() == 410.0f || this.assemblyProgress.getValue() == 420.0f) {
                Level level4 = this.f_58857_;
                Intrinsics.checkNotNull((Object)level4);
                Intrinsics.checkNotNull((Object)rand);
                Companion.playZapSound(level4, this.thisposition, rand);
            }
            if (this.assemblyProgress.getValue() == 455.0f) {
                this.assemble();
            }
            if (this.assemblyProgress.getValue() == 460.0f) {
                Level level5 = this.f_58857_;
                Intrinsics.checkNotNull((Object)level5);
                Companion.playFinishSound(level5, this.thisposition);
                Level level6 = this.f_58857_;
                Intrinsics.checkNotNull((Object)level6);
                if (level6.f_46443_) {
                    for (Ship cship : this.createdShips) {
                        ScannerRenderer scannerRenderer = ScannerRenderer.Companion.getINSTANCE();
                        Intrinsics.checkNotNull((Object)cship, (String)"null cannot be cast to non-null type org.valkyrienskies.core.api.ships.ClientShip");
                        scannerRenderer.ping((ClientShip)cship, this.thisposition, this);
                        this.createdShips.remove(cship);
                    }
                }
            }
            if (this.assemblyProgress.getValue() == 500.0f) {
                this.resetAfterAssemble();
            }
        }
    }

    private final void resetAfterAssemble() {
        this.assembling = false;
        this.skippingAssembly = false;
        this.initPlayed = false;
        this.animationType = Animation.IDLE;
        this.startAnimation(Animation.IDLE);
        this.assemblyProgress.startWithValue(0.0);
        this.useCooldown = 400;
        this.shouldEjectDesignator = true;
    }

    public final void startAssembly() {
        this.assembling = true;
        this.animationType = Animation.ASSEMBLY;
        this.startAnimation(Animation.ASSEMBLY);
    }

    public final void skipAssembly() {
        this.skippingAssembly = true;
    }

    public final void startDisassembly() {
        this.disassembling = true;
        this.animationType = Animation.DISASSEMBLY;
        this.startAnimation(Animation.DISASSEMBLY);
    }

    public final double getPulseRange() {
        double d;
        if (this.connectedShip != null) {
            AABBic shipAABB;
            Ship ship = this.connectedShip;
            Intrinsics.checkNotNull((Object)ship);
            AABBic aABBic = shipAABB = ship.getShipAABB();
            Intrinsics.checkNotNull((Object)aABBic);
            Vector3d max = new Vector3d((double)aABBic.maxX(), (double)shipAABB.maxY(), (double)shipAABB.maxZ());
            Vector3d min = new Vector3d((double)shipAABB.minX(), (double)shipAABB.minY(), (double)shipAABB.minZ());
            d = max.distance((Vector3dc)min);
        } else {
            d = Minecraft.m_91087_().f_91063_.m_109152_();
        }
        return d;
    }

    public final int getScanGrowthDuration() {
        if (this.connectedShip != null) {
            double range = this.getPulseRange();
            return 2000 * (int)range / 12;
        }
        return 2000 * (((Number)Minecraft.m_91087_().f_91066_.m_231984_().m_231551_()).intValue() / 12);
    }

    public final float computeRadius(long start, float duration) {
        float r1 = (float)this.getPulseRange();
        float b = 200.0f;
        float n = 1.0f / ((duration + b) * (duration + b) - b * b);
        float a = -r1 * b * b * n;
        float c = r1 * n;
        float t = System.currentTimeMillis() - start;
        return (float)10 + a + (t + b) * (t + b) * c;
    }

    public final void assemble() {
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (level.f_46443_) {
            return;
        }
        if (!(((ItemStack)this.inventory.get(0)).m_41720_() instanceof WanderwandItem)) {
            return;
        }
        Object object = this.inventory.get(0);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        ItemStack item = (ItemStack)object;
        CompoundTag compoundTag = item.m_41783_();
        Object object2 = compoundTag != null ? compoundTag.m_128423_("selectedBlocks") : null;
        CompoundTag compoundTag2 = object2 instanceof CompoundTag ? (CompoundTag)object2 : null;
        if (compoundTag2 == null) {
            return;
        }
        CompoundTag selectedTag = compoundTag2;
        ArrayList<AABBic> blockposSet = WanderwandItem.Companion.readAABBSetFromNBT(selectedTag);
        this.launchForce = 0;
        List list = blockposSet;
        Level level2 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level2);
        Iterator<HashSet<BlockPos>> iterator = WanderwandItem.Companion.findIsolatedComponents(list, level2).iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        object2 = iterator;
        while (object2.hasNext()) {
            boolean bl;
            HashSet component;
            block9: {
                Object v9;
                block8: {
                    Object e = object2.next();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    component = (HashSet)e;
                    Iterable $this$firstOrNull$iv = component;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        BlockPos pos = (BlockPos)element$iv;
                        boolean bl2 = false;
                        Level level3 = this.f_58857_;
                        Intrinsics.checkNotNull((Object)level3);
                        if (!(!level3.m_8055_(pos).m_60795_())) continue;
                        v9 = element$iv;
                        break block8;
                    }
                    v9 = null;
                }
                if (v9 == null) continue;
                Iterable $this$any$iv = component;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        BlockPos it = (BlockPos)element$iv;
                        boolean bl3 = false;
                        Set<String> set = ClockworkConfig.SERVER.getBlockBlacklist();
                        Level level4 = this.f_58857_;
                        Intrinsics.checkNotNull((Object)level4);
                        if (!set.contains(level4.m_8055_(it).m_60734_().m_7705_())) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (bl) continue;
            int n = this.launchForce;
            this.launchForce = n + 1;
            Level level5 = this.f_58857_;
            Intrinsics.checkNotNull((Object)level5, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ShipAssembler.assembleToShip((ServerLevel)((ServerLevel)level5), (Set)component, (double)1.0);
        }
    }

    public final void disassemble() {
    }

    public final void startAnimation(@NotNull Animation animation) {
        Intrinsics.checkNotNullParameter((Object)((Object)animation), (String)"animation");
        this.animationType = animation;
        if (animation == Animation.ASSEMBLY) {
            this.assemblyProgress.startWithValue(0.0);
        } else if (animation == Animation.DISASSEMBLY) {
            this.disassemblyProgress.startWithValue(0.0);
        } else if (animation == Animation.IDLE) {
            this.idleProgress.startWithValue(0.0);
        }
        this.sendAnimationUpdate = true;
        this.sendData();
    }

    public final float getInterpolatedCoreAngle(float partialTicks) {
        this.previousCoreAngle = this.coreAngle;
        float f = this.coreAngle;
        this.coreAngle = f + 1.0f;
        if (this.coreAngle == 360.0f) {
            this.coreAngle = 0.0f;
        }
        return this.isVirtual() ? Mth.m_14179_((float)(partialTicks + 0.5f), (float)this.previousCoreAngle, (float)this.coreAngle) : Mth.m_14179_((float)partialTicks, (float)this.coreAngle, (float)(this.coreAngle + 4.0f));
    }

    public final float getCoreOffset(float partialTicks) {
        if (this.animationType == Animation.IDLE) {
            return 0.0f;
        }
        if (this.animationType == Animation.ASSEMBLY) {
            int runningTicks = (int)Math.abs(this.assemblyProgress.getValue());
            int prevRunningTicks = (int)Math.abs(this.assemblyProgress.getValue() - 1.0f);
            float ticks = Mth.m_14179_((float)partialTicks, (float)prevRunningTicks, (float)runningTicks);
            return runningTicks < 375 ? (float)Mth.m_14008_((double)Math.pow(ticks / (float)500 * (float)3, 4.0), (double)0.0, (double)1.0) : Mth.m_14036_((float)EaseHelper.INSTANCE.easeInBounce(Mth.m_14036_((float)(((float)500 - ticks) / (float)500 * (float)8), (float)0.0f, (float)1.0f)), (float)0.0f, (float)1.0f);
        }
        if (this.animationType == Animation.DISASSEMBLY) {
            return this.disassemblyProgress.getValue(partialTicks);
        }
        return 0.0f;
    }

    public void write(@NotNull CompoundTag compound, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        compound.m_128359_(ClockworkConstants.Nbt.INSTANCE.getANIMATION_STATE(), String.valueOf((Object)this.animationType));
        compound.m_128350_(ClockworkConstants.Nbt.INSTANCE.getASSEMBLY_PROGRESS(), this.assemblyProgress.getValue());
        compound.m_128350_(ClockworkConstants.Nbt.INSTANCE.getDISASSEMBLY_PROGRESS(), this.disassemblyProgress.getValue());
        compound.m_128350_(ClockworkConstants.Nbt.INSTANCE.getIDLE_PROGRESS(), this.idleProgress.getValue());
        compound.m_128379_(ClockworkConstants.Nbt.INSTANCE.getIS_ASSEMBLED(), this.isAssembled);
        compound.m_128379_(ClockworkConstants.Nbt.INSTANCE.getASSEMBLING(), this.assembling);
        compound.m_128379_(ClockworkConstants.Nbt.INSTANCE.getDISASSEMBLING(), this.disassembling);
        ContainerHelper.m_18973_((CompoundTag)compound, this.inventory);
        super.write(compound, clientPacket);
    }

    protected void read(@NotNull CompoundTag compound, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        this.animationType = Intrinsics.areEqual((Object)compound.m_128461_(ClockworkConstants.Nbt.INSTANCE.getANIMATION_STATE()), (Object)"ASSEMBLY") ? Animation.ASSEMBLY : (Intrinsics.areEqual((Object)compound.m_128461_(ClockworkConstants.Nbt.INSTANCE.getANIMATION_STATE()), (Object)"DISASSEMBLY") ? Animation.DISASSEMBLY : Animation.IDLE);
        this.assemblyProgress.setValueNoUpdate((double)compound.m_128457_(ClockworkConstants.Nbt.INSTANCE.getASSEMBLY_PROGRESS()));
        this.disassemblyProgress.setValueNoUpdate((double)compound.m_128457_(ClockworkConstants.Nbt.INSTANCE.getDISASSEMBLY_PROGRESS()));
        this.idleProgress.setValueNoUpdate((double)compound.m_128457_(ClockworkConstants.Nbt.INSTANCE.getIDLE_PROGRESS()));
        this.isAssembled = compound.m_128471_(ClockworkConstants.Nbt.INSTANCE.getIS_ASSEMBLED());
        this.assembling = compound.m_128471_(ClockworkConstants.Nbt.INSTANCE.getASSEMBLING());
        this.disassembling = compound.m_128471_(ClockworkConstants.Nbt.INSTANCE.getDISASSEMBLING());
        this.inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)compound, this.inventory);
        super.read(compound, clientPacket);
    }

    public void addBehaviours(@NotNull List<? extends BlockEntityBehaviour> behaviours) {
        Intrinsics.checkNotNullParameter(behaviours, (String)"behaviours");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/phys/infuser/PhysicsInfuserBlockEntity$Animation;", "", "<init>", "(Ljava/lang/String;I)V", "ASSEMBLY", "DISASSEMBLY", "IDLE", "clockwork"})
    public static final class Animation
    extends Enum<Animation> {
        public static final /* enum */ Animation ASSEMBLY = new Animation();
        public static final /* enum */ Animation DISASSEMBLY = new Animation();
        public static final /* enum */ Animation IDLE = new Animation();
        private static final /* synthetic */ Animation[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Animation[] values() {
            return (Animation[])$VALUES.clone();
        }

        public static Animation valueOf(String value) {
            return Enum.valueOf(Animation.class, value);
        }

        @NotNull
        public static EnumEntries<Animation> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = animationArray = new Animation[]{Animation.ASSEMBLY, Animation.DISASSEMBLY, Animation.IDLE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001d\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\t\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\bJ%\u0010\f\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000e\u0010\bJ%\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0014\u001a\u00020\u00138\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00138\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0015\u00a8\u0006\u0019"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/phys/infuser/PhysicsInfuserBlockEntity$Companion;", "", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/world/phys/Vec3;", "location", "", "playInitializeSound", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/phys/Vec3;)V", "playWindupSound", "Lnet/minecraft/util/RandomSource;", "rand", "playZapSound", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/util/RandomSource;)V", "playFinishSound", "pos", "Ljava/util/Random;", "spawnParticlesAssembly", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/phys/Vec3;Ljava/util/Random;)V", "", "ASSEMBLY_TIME", "I", "DISASSEMBLY_TIME", "<init>", "()V", "clockwork"})
    public static final class Companion {
        private Companion() {
        }

        public final void playInitializeSound(@NotNull Level world, @NotNull Vec3 location) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            ClockworkSounds.INSTANCE.getPHYSICS_INFUSER_INITIALIZE().playAt(world, location, 0.5f, 1.0f, false);
        }

        public final void playWindupSound(@NotNull Level world, @NotNull Vec3 location) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            ClockworkSounds.INSTANCE.getPHYSICS_INFUSER_WINDUP().playAt(world, location, 0.5f, 1.0f, false);
        }

        public final void playZapSound(@NotNull Level world, @NotNull Vec3 location, @NotNull RandomSource rand) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
            float pitch = 0.6f + rand.m_188501_() * 0.4f;
            ClockworkSounds.INSTANCE.getPHYSICS_INFUSER_LIGHTNING().playAt(world, location, 0.5f, 1.0f, false);
        }

        public final void playFinishSound(@NotNull Level world, @NotNull Vec3 location) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            ClockworkSounds.INSTANCE.getPHYSICS_INFUSER_FINISH().playAt(world, location, 0.5f, 1.0f, false);
        }

        public final void spawnParticlesAssembly(@NotNull Level world, @NotNull Vec3 pos, @NotNull Random rand) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
            double degrees = rand.nextDouble() * (double)360;
            double angle = Math.toRadians(degrees);
            double radius = 2.0;
            double x = radius * Math.cos(angle);
            double y = 0.5;
            double z = radius * Math.sin(angle);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

