/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.contraptions.phys.bearing;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.valkyrienskies.clockwork.ClockworkPartials;
import org.valkyrienskies.clockwork.content.contraptions.phys.bearing.PhysBearingBlockEntity;
import org.valkyrienskies.clockwork.util.render.RenderUtil;
import org.valkyrienskies.clockwork.util.render.TransformData;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010*\u001a\u00020)\u00a2\u0006\u0004\b+\u0010,JA\u0010\u000e\u001a\u00020\r2\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000fJ-\u0010\u0014\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0018J/\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001f\u0010 \u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b \u0010\u0018J\u001f\u0010!\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b!\u0010\u0018J/\u0010\"\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b\"\u0010\u001fJ\u001f\u0010&\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u00022\u0006\u0010%\u001a\u00020$H\u0014\u00a2\u0006\u0004\b&\u0010'J\u001d\u0010(\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u00022\u0006\u0010%\u001a\u00020$\u00a2\u0006\u0004\b(\u0010'\u00a8\u0006-"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/phys/bearing/PhysBearingRenderer;", "Lcom/simibubi/create/content/kinetics/base/KineticBlockEntityRenderer;", "Lorg/valkyrienskies/clockwork/content/contraptions/phys/bearing/PhysBearingBlockEntity;", "blockEntity", "", "partialTicks", "Lcom/mojang/blaze3d/vertex/PoseStack;", "matrices", "Lnet/minecraft/client/renderer/MultiBufferSource;", "buffer", "", "light", "overlay", "", "renderSafe", "(Lorg/valkyrienskies/clockwork/content/contraptions/phys/bearing/PhysBearingBlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V", "Lnet/createmod/catnip/render/SuperByteBuffer;", "Lcom/simibubi/create/content/kinetics/base/KineticBlockEntity;", "be", "angle", "coolKineticRotationTransform", "(Lnet/createmod/catnip/render/SuperByteBuffer;Lcom/simibubi/create/content/kinetics/base/KineticBlockEntity;FI)Lnet/createmod/catnip/render/SuperByteBuffer;", "physPartial", "rotateAndRiseNorth", "(Lnet/createmod/catnip/render/SuperByteBuffer;Lorg/valkyrienskies/clockwork/content/contraptions/phys/bearing/PhysBearingBlockEntity;)V", "rotateAndRiseSouth", "Lnet/minecraft/world/phys/Vec3;", "pivot", "Lnet/minecraft/core/Direction;", "axl", "rotateAndRise", "(Lnet/createmod/catnip/render/SuperByteBuffer;Lorg/valkyrienskies/clockwork/content/contraptions/phys/bearing/PhysBearingBlockEntity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/core/Direction;)V", "rotateWestWing", "rotateEastWing", "rotateWing", "te", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "getRotatedModel", "(Lorg/valkyrienskies/clockwork/content/contraptions/phys/bearing/PhysBearingBlockEntity;Lnet/minecraft/world/level/block/state/BlockState;)Lnet/createmod/catnip/render/SuperByteBuffer;", "getRotatedModelAttacher", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "context", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "clockwork"})
public final class PhysBearingRenderer
extends KineticBlockEntityRenderer<PhysBearingBlockEntity> {
    public PhysBearingRenderer(@NotNull BlockEntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
    }

    protected void renderSafe(@Nullable PhysBearingBlockEntity blockEntity, float partialTicks, @NotNull PoseStack matrices, @NotNull MultiBufferSource buffer, int light, int overlay) {
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        super.renderSafe((KineticBlockEntity)blockEntity, partialTicks, matrices, buffer, light, overlay);
        if (blockEntity == null) {
            return;
        }
        BlockState blockState = blockEntity.m_58900_();
        Direction facing = (Direction)blockState.m_61143_((Property)BlockStateProperties.f_61372_);
        SuperByteBuffer phys_north = CachedBuffers.partial((PartialModel)ClockworkPartials.INSTANCE.getPHYS_NORTH_WING(), (BlockState)blockState);
        SuperByteBuffer phys_south = CachedBuffers.partial((PartialModel)ClockworkPartials.INSTANCE.getPHYS_SOUTH_WING(), (BlockState)blockState);
        SuperByteBuffer phys_west = CachedBuffers.partial((PartialModel)ClockworkPartials.INSTANCE.getPHYS_WEST_WING(), (BlockState)blockState);
        SuperByteBuffer phys_east = CachedBuffers.partial((PartialModel)ClockworkPartials.INSTANCE.getPHYS_EAST_WING(), (BlockState)blockState);
        matrices.m_85836_();
        matrices.m_85837_(0.5, 0.5, 0.5);
        matrices.m_252781_(new Quaternionf().rotateXYZ(0.0f, (float)Math.toRadians(-180.0), 0.0f));
        Direction direction = facing;
        switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1: {
                matrices.m_252781_(new Quaternionf(new AxisAngle4f(AngleHelper.rad((double)270.0), 1.0f, 0.0f, 0.0f)));
                break;
            }
            case 2: {
                matrices.m_252781_(new Quaternionf(new AxisAngle4f(AngleHelper.rad((double)270.0), 0.0f, 0.0f, 1.0f)));
                matrices.m_252781_(new Quaternionf(new AxisAngle4f(AngleHelper.rad((double)90.0), 0.0f, 1.0f, 0.0f)));
                break;
            }
            case 3: {
                matrices.m_252781_(new Quaternionf(new AxisAngle4f(AngleHelper.rad((double)90.0), 1.0f, 0.0f, 0.0f)));
                break;
            }
            case 4: {
                matrices.m_252781_(new Quaternionf(new AxisAngle4f(AngleHelper.rad((double)90.0), 0.0f, 0.0f, 1.0f)));
                matrices.m_252781_(new Quaternionf(new AxisAngle4f(AngleHelper.rad((double)90.0), 0.0f, 1.0f, 0.0f)));
                break;
            }
            case 5: {
                matrices.m_252781_(new Quaternionf(new AxisAngle4f(AngleHelper.rad((double)0.0), 1.0f, 0.0f, 0.0f)));
                break;
            }
            case 6: {
                matrices.m_252781_(new Quaternionf(new AxisAngle4f(AngleHelper.rad((double)180.0), -1.0f, 0.0f, 0.0f)));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        matrices.m_85837_(-0.5, -0.5, -0.5);
        float interpolatedAngle = blockEntity.getInterpolatedCoreAngle(AnimationTickHolder.getPartialTicks() - 1.0f);
        Direction direction2 = facing;
        Vector3f offset = switch (direction2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction2.ordinal()]) {
            case 1 -> new Vector3f(0.0f, 0.0f, 0.1f);
            case 2 -> new Vector3f(0.1f, 0.0f, 0.0f);
            case 3 -> new Vector3f(0.0f, 0.0f, 0.1f);
            case 4 -> new Vector3f(0.1f, 0.0f, 0.0f);
            case 5 -> new Vector3f(0.0f, 0.1f, 0.0f);
            case 6 -> new Vector3f(0.0f, 0.1f, 0.0f);
            default -> throw new NoWhenBranchMatchedException();
        };
        TransformData innerData = new TransformData(offset, new Vector3f(interpolatedAngle, interpolatedAngle, 0.0f));
        TransformData data = new TransformData(offset, new Vector3f(0.0f, 0.0f, 0.0f));
        TransformData outerData = new TransformData(offset, new Vector3f(0.0f, 0.0f, 0.0f));
        Intrinsics.checkNotNull((Object)blockState);
        RenderUtil.INSTANCE.renderCubeMatrix(matrices, buffer, blockState, innerData, data, outerData, 1.5f, light, overlay);
        VertexConsumer vb = buffer.m_6299_(RenderType.m_110466_());
        Intrinsics.checkNotNull((Object)phys_north);
        this.rotateAndRiseNorth(phys_north, blockEntity);
        Intrinsics.checkNotNull((Object)phys_south);
        this.rotateAndRiseSouth(phys_south, blockEntity);
        Intrinsics.checkNotNull((Object)phys_west);
        this.rotateWestWing(phys_west, blockEntity);
        Intrinsics.checkNotNull((Object)phys_east);
        this.rotateEastWing(phys_east, blockEntity);
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110466_());
        phys_north.renderInto(matrices, vertexConsumer);
        phys_south.renderInto(matrices, vertexConsumer);
        phys_west.renderInto(matrices, vertexConsumer);
        phys_east.renderInto(matrices, vertexConsumer);
        matrices.m_85849_();
        matrices.m_85836_();
        SuperByteBuffer at = this.getRotatedModelAttacher(blockEntity, blockState);
        SuperByteBuffer shaf = this.getRotatedModel(blockEntity, blockState);
        Block block = blockState.m_60734_();
        Intrinsics.checkNotNull((Object)block, (String)"null cannot be cast to non-null type com.simibubi.create.content.kinetics.base.IRotate");
        Direction.Axis axis = ((IRotate)block).getRotationAxis(blockState);
        float angle = KineticBlockEntityRenderer.getAngleForBe((KineticBlockEntity)((KineticBlockEntity)blockEntity), (BlockPos)blockEntity.m_58899_(), (Direction.Axis)axis);
        this.coolKineticRotationTransform(at, (KineticBlockEntity)blockEntity, angle, light).renderInto(matrices, vertexConsumer);
        this.coolKineticRotationTransform(shaf, (KineticBlockEntity)blockEntity, angle, light).renderInto(matrices, vertexConsumer);
        matrices.m_85849_();
    }

    @NotNull
    public final SuperByteBuffer coolKineticRotationTransform(@NotNull SuperByteBuffer buffer, @NotNull KineticBlockEntity be, float angle, int light) {
        Direction facing;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)be, (String)"be");
        buffer.light(light);
        Direction direction = facing = (Direction)be.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 5: 
            case 6: {
                buffer.rotateDegrees(90.0f, Direction.Axis.X);
                SuperByteBuffer superByteBuffer = (SuperByteBuffer)buffer.translate(0.0, 0.0, -1.0);
                break;
            }
            case 3: {
                buffer.rotateDegrees(-90.0f, Direction.Axis.X);
                SuperByteBuffer superByteBuffer = (SuperByteBuffer)buffer.translate(0.0, -1.0, 0.0);
                break;
            }
            case 1: {
                buffer.rotateDegrees(90.0f, Direction.Axis.X);
                SuperByteBuffer superByteBuffer = (SuperByteBuffer)buffer.translate(0.0, 0.0, -1.0);
                break;
            }
            case 2: {
                buffer.rotateDegrees(90.0f, Direction.Axis.Z);
                SuperByteBuffer superByteBuffer = (SuperByteBuffer)buffer.translate(0.0, -1.0, 0.0);
                break;
            }
            case 4: {
                buffer.rotateDegrees(-90.0f, Direction.Axis.Z);
                SuperByteBuffer superByteBuffer = (SuperByteBuffer)buffer.translate(-1.0, 0.0, 0.0);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Direction.AxisDirection axlDir = Direction.AxisDirection.NEGATIVE;
        Direction.Axis axl = Direction.Axis.Y;
        if (facing == Direction.UP || facing == Direction.DOWN) {
            axl = Direction.Axis.Z;
        }
        if (facing == Direction.EAST || facing == Direction.SOUTH) {
            axlDir = Direction.AxisDirection.POSITIVE;
        }
        buffer.rotateCentered(angle, Direction.m_122390_((Direction.AxisDirection)axlDir, (Direction.Axis)axl));
        return buffer;
    }

    private final void rotateAndRiseNorth(SuperByteBuffer physPartial, PhysBearingBlockEntity blockEntity) {
        Vec3 pivot = new Vec3(0.0, -0.4375, -0.34375);
        this.rotateAndRise(physPartial, blockEntity, pivot, Direction.WEST);
    }

    private final void rotateAndRiseSouth(SuperByteBuffer physPartial, PhysBearingBlockEntity blockEntity) {
        Vec3 pivot = new Vec3(0.0, -0.4375, 0.34375);
        this.rotateAndRise(physPartial, blockEntity, pivot, Direction.EAST);
    }

    private final void rotateAndRise(SuperByteBuffer physPartial, PhysBearingBlockEntity blockEntity, Vec3 pivot, Direction axl) {
        float interpolatedAngle = blockEntity.getWingRotOffset();
        physPartial.translate(pivot);
        physPartial.rotateCentered((float)((double)(interpolatedAngle / (float)360) * Math.PI), axl);
        physPartial.translateBack(pivot);
    }

    private final void rotateWestWing(SuperByteBuffer physPartial, PhysBearingBlockEntity blockEntity) {
        Vec3 pivot = new Vec3(-0.4375, 0.0625, 0.0);
        this.rotateWing(physPartial, blockEntity, pivot, Direction.SOUTH);
    }

    private final void rotateEastWing(SuperByteBuffer physPartial, PhysBearingBlockEntity blockEntity) {
        Vec3 pivot = new Vec3(0.4375, 0.0625, 0.0);
        this.rotateWing(physPartial, blockEntity, pivot, Direction.NORTH);
    }

    private final void rotateWing(SuperByteBuffer physPartial, PhysBearingBlockEntity blockEntity, Vec3 pivot, Direction axl) {
        float interpolatedAngle = blockEntity.getWingRotOffset();
        physPartial.translate(pivot);
        physPartial.rotateCentered((float)((double)(interpolatedAngle / (float)360) * Math.PI), axl);
        physPartial.translateBack(pivot);
    }

    @NotNull
    protected SuperByteBuffer getRotatedModel(@NotNull PhysBearingBlockEntity te, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)te, (String)"te");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        SuperByteBuffer superByteBuffer = CachedBuffers.partialFacing((PartialModel)ClockworkPartials.INSTANCE.getPHYS_SHAFT(), (BlockState)state, (Direction)((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)));
        Intrinsics.checkNotNullExpressionValue((Object)superByteBuffer, (String)"partialFacing(...)");
        return superByteBuffer;
    }

    @NotNull
    public final SuperByteBuffer getRotatedModelAttacher(@NotNull PhysBearingBlockEntity te, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)te, (String)"te");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        SuperByteBuffer superByteBuffer = CachedBuffers.partialFacing((PartialModel)ClockworkPartials.INSTANCE.getPHYS_ATTACHER(), (BlockState)state, (Direction)((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)));
        Intrinsics.checkNotNullExpressionValue((Object)superByteBuffer, (String)"partialFacing(...)");
        return superByteBuffer;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.SOUTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.NORTH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.UP.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.DOWN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

