/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.contraptions.flap.dual_link;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.redstone.link.RedstoneLinkNetworkHandler;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBox;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxRenderer;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.outliner.Outline;
import net.createmod.catnip.outliner.Outliner;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4dc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.clockwork.content.contraptions.flap.FlapBearingBlock;
import org.valkyrienskies.clockwork.content.contraptions.flap.dual_link.DualLinkBehaviour;
import org.valkyrienskies.clockwork.content.contraptions.flap.dual_link.DualLinkHandler;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.api.ValkyrienSkies;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0004J\u000f\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004JC\u0010\u0010\u001a\u00020\u00022\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/flap/dual_link/DualLinkRenderer;", "", "", "tick", "()V", "Lcom/simibubi/create/foundation/blockEntity/SmartBlockEntity;", "be", "", "partialTicks", "Lcom/mojang/blaze3d/vertex/PoseStack;", "ms", "Lnet/minecraft/client/renderer/MultiBufferSource;", "buffer", "", "light", "overlay", "renderOnBlockEntity", "(Lcom/simibubi/create/foundation/blockEntity/SmartBlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V", "<init>", "clockwork"})
public final class DualLinkRenderer {
    @NotNull
    public static final DualLinkRenderer INSTANCE = new DualLinkRenderer();

    private DualLinkRenderer() {
    }

    @JvmStatic
    public static final void tick() {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel clientLevel = mc.f_91073_;
        if (clientLevel == null) {
            return;
        }
        ClientLevel world = clientLevel;
        HitResult target = mc.f_91077_;
        if (target == null || !(target instanceof BlockHitResult)) {
            return;
        }
        HitResult result = target;
        BlockPos pos = ((BlockHitResult)result).m_82425_();
        BlockState state = world.m_8055_(((BlockHitResult)result).m_82425_());
        if (!(state.m_60734_() instanceof FlapBearingBlock)) {
            return;
        }
        BehaviourType<DualLinkBehaviour> type = null;
        Direction direction = ((BlockHitResult)result).m_82434_();
        Intrinsics.checkNotNull((Object)state);
        type = direction == DualLinkHandler.getFrontFacing(state) ? DualLinkBehaviour.Companion.getFRONT_TYPE() : DualLinkBehaviour.Companion.getBACK_TYPE();
        DualLinkBehaviour dualLinkBehaviour = (DualLinkBehaviour)BlockEntityBehaviour.get((BlockGetter)((BlockGetter)world), (BlockPos)pos, type);
        if (dualLinkBehaviour == null) {
            return;
        }
        DualLinkBehaviour behaviour = dualLinkBehaviour;
        MutableComponent mutableComponent = CreateLang.translateDirect((String)"logistics.firstFrequency", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translateDirect(...)");
        Component freq1 = (Component)mutableComponent;
        MutableComponent mutableComponent2 = CreateLang.translateDirect((String)"logistics.secondFrequency", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"translateDirect(...)");
        Component freq2 = (Component)mutableComponent2;
        for (boolean first : Iterate.trueAndFalse) {
            AABB bb = new AABB(Vec3.f_82478_, Vec3.f_82478_).m_82400_(0.25);
            Component label = first ? freq1 : freq2;
            Vec3 vec3 = ((BlockHitResult)target).m_82450_();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getLocation(...)");
            boolean hit = behaviour.testHit(first, vec3);
            ValueBoxTransform transform = first ? behaviour.getFirstSlot() : behaviour.getSecondSlot();
            ValueBox box = new ValueBox(label, bb, pos).passive(!hit);
            boolean empty = ((RedstoneLinkNetworkHandler.Frequency)behaviour.getNetworkKey().get(first)).getStack().m_41619_();
            if (!empty) {
                box.wideOutline();
            }
            Outliner.getInstance().showOutline((Object)Pair.of((Object)first, (Object)pos), (Outline)box.transform(transform)).highlightFace(((BlockHitResult)result).m_82434_());
            if (!hit) continue;
            List tip = new ArrayList();
            MutableComponent mutableComponent3 = label.m_6881_();
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent3, (String)"copy(...)");
            tip.add(mutableComponent3);
            MutableComponent mutableComponent4 = CreateLang.translateDirect((String)(empty ? "logistics.filter.click_to_set" : "logistics.filter.click_to_replace"), (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent4, (String)"translateDirect(...)");
            tip.add(mutableComponent4);
            CreateClient.VALUE_SETTINGS_HANDLER.showHoverTip(tip);
        }
    }

    @JvmStatic
    public static final void renderOnBlockEntity(@Nullable SmartBlockEntity be, float partialTicks, @NotNull PoseStack ms, @Nullable MultiBufferSource buffer, int light, int overlay) {
        Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
        if (be == null || be.m_58901_()) {
            return;
        }
        Entity cameraEntity = Minecraft.m_91087_().f_91075_;
        Vec3 bePos = VecHelper.getCenterOf((Vec3i)((Vec3i)be.m_58899_()));
        Level level = be.m_58904_();
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.client.multiplayer.ClientLevel");
        Ship ship = ValkyrienSkies.getShipManagingBlock((Level)((Level)((ClientLevel)level)), (BlockPos)be.m_58899_());
        if (ship != null) {
            Matrix4dc matrix4dc = ((ClientShip)ship).getRenderTransform().getShipToWorld();
            Vec3 vec3 = bePos;
            Intrinsics.checkNotNull((Object)vec3);
            Vector3d vector3d = matrix4dc.transformPosition(VectorConversionsMCKt.toJOML((Vec3)vec3));
            Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"transformPosition(...)");
            bePos = VectorConversionsMCKt.toMinecraft((Vector3dc)((Vector3dc)vector3d));
        }
        float max = AllConfigs.client().filterItemRenderDistance.getF();
        if (!be.isVirtual() && cameraEntity != null && cameraEntity.m_20182_().m_82557_(bePos) > (double)(max * max)) {
            return;
        }
        Object[] objectArray = new BehaviourType[]{DualLinkBehaviour.Companion.getFRONT_TYPE(), DualLinkBehaviour.Companion.getBACK_TYPE()};
        for (BehaviourType type : CollectionsKt.mutableListOf((Object[])objectArray)) {
            if ((DualLinkBehaviour)be.getBehaviour(type) == null) continue;
            for (boolean first : Iterate.trueAndFalse) {
                DualLinkBehaviour behaviour;
                ValueBoxTransform transform = first ? behaviour.getFirstSlot() : behaviour.getSecondSlot();
                ItemStack stack = first ? ((RedstoneLinkNetworkHandler.Frequency)behaviour.getNetworkKey().getFirst()).getStack() : ((RedstoneLinkNetworkHandler.Frequency)behaviour.getNetworkKey().getSecond()).getStack();
                ms.m_85836_();
                transform.transform((LevelAccessor)be.m_58904_(), be.m_58899_(), be.m_58900_(), ms);
                ValueBoxRenderer.renderItemIntoValueBox((ItemStack)stack, (PoseStack)ms, (MultiBufferSource)buffer, (int)light, (int)overlay);
                ms.m_85849_();
            }
        }
    }
}

