/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.contraptions.flap.dual_link;

import com.simibubi.create.Create;
import com.simibubi.create.content.equipment.clipboard.ClipboardCloneable;
import com.simibubi.create.content.redstone.link.IRedstoneLinkable;
import com.simibubi.create.content.redstone.link.RedstoneLinkNetworkHandler;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import java.util.function.Function;
import java.util.function.IntConsumer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.data.Couple;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4dc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 m2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002nmB7\u0012\b\u0010h\u001a\u0004\u0018\u00010g\u0012\u0014\u0010j\u001a\u0010\u0012\u0004\u0012\u00020O\u0012\u0006\u0012\u0004\u0018\u00010O0i\u0012\u0006\u0010A\u001a\u00020@\u0012\u0006\u0010C\u001a\u00020\f\u00a2\u0006\u0004\bk\u0010lJ\u0015\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\n\u001a\u00020\t2\b\u0010\b\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\r\u0010\u0015\u001a\u00020\t\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0016J\u0015\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001c\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u0016J\u000f\u0010\u001d\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u000eJ\u001f\u0010!\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\fH\u0016\u00a2\u0006\u0004\b!\u0010\"J\u001f\u0010#\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\fH\u0016\u00a2\u0006\u0004\b#\u0010\"J\u001d\u0010'\u001a\u00020\t2\u0006\u0010$\u001a\u00020\f2\u0006\u0010&\u001a\u00020%\u00a2\u0006\u0004\b'\u0010(J\u0013\u0010*\u001a\u0006\u0012\u0002\b\u00030)H\u0016\u00a2\u0006\u0004\b*\u0010+J\u001d\u0010-\u001a\u00020\f2\u0006\u0010$\u001a\u00020\f2\u0006\u0010,\u001a\u00020\u0004\u00a2\u0006\u0004\b-\u0010.J\u000f\u0010/\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b/\u0010\u000eJ\u000f\u00101\u001a\u000200H\u0016\u00a2\u0006\u0004\b1\u00102J\u000f\u00104\u001a\u000203H\u0016\u00a2\u0006\u0004\b4\u00105J\u001f\u00109\u001a\u00020\f2\u0006\u00106\u001a\u00020\u001e2\u0006\u00108\u001a\u000207H\u0016\u00a2\u0006\u0004\b9\u0010:J/\u0010>\u001a\u00020\f2\u0006\u00106\u001a\u00020\u001e2\u0006\u0010<\u001a\u00020;2\u0006\u00108\u001a\u0002072\u0006\u0010=\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b>\u0010?R\u0014\u0010A\u001a\u00020@8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bA\u0010BR\u0017\u0010C\u001a\u00020\f8\u0006\u00a2\u0006\f\n\u0004\bC\u0010D\u001a\u0004\bE\u0010\u000eR\"\u0010F\u001a\u00020\u00198\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bF\u0010G\u001a\u0004\bH\u0010I\"\u0004\bJ\u0010KR\"\u0010L\u001a\u00020\u00198\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bL\u0010G\u001a\u0004\bM\u0010I\"\u0004\bN\u0010KR\"\u0010P\u001a\u00020O8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bP\u0010Q\u001a\u0004\bR\u0010S\"\u0004\bT\u0010UR\"\u0010V\u001a\u00020O8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bV\u0010Q\u001a\u0004\bW\u0010S\"\u0004\bX\u0010UR\"\u0010Y\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bY\u0010Z\u001a\u0004\b[\u0010\\\"\u0004\b]\u0010^R\"\u0010_\u001a\u00020\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b_\u0010D\u001a\u0004\b`\u0010\u000e\"\u0004\ba\u0010bR\u0014\u0010f\u001a\u00020c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bd\u0010e\u00a8\u0006o"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/flap/dual_link/DualLinkBehaviour;", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BlockEntityBehaviour;", "Lcom/simibubi/create/content/redstone/link/IRedstoneLinkable;", "Lcom/simibubi/create/content/equipment/clipboard/ClipboardCloneable;", "Lnet/minecraft/world/phys/Vec3;", "shift", "moveText", "(Lnet/minecraft/world/phys/Vec3;)Lorg/valkyrienskies/clockwork/content/contraptions/flap/dual_link/DualLinkBehaviour;", "behaviour", "", "copyItemsFrom", "(Lorg/valkyrienskies/clockwork/content/contraptions/flap/dual_link/DualLinkBehaviour;)V", "", "isListening", "()Z", "", "getTransmittedStrength", "()I", "networkPower", "setReceivedStrength", "(I)V", "notifySignalChange", "()V", "initialize", "Lnet/createmod/catnip/data/Couple;", "Lcom/simibubi/create/content/redstone/link/RedstoneLinkNetworkHandler$Frequency;", "getNetworkKey", "()Lnet/createmod/catnip/data/Couple;", "unload", "isSafeNBT", "Lnet/minecraft/nbt/CompoundTag;", "nbt", "clientPacket", "write", "(Lnet/minecraft/nbt/CompoundTag;Z)V", "read", "first", "Lnet/minecraft/world/item/ItemStack;", "stack", "setFrequency", "(ZLnet/minecraft/world/item/ItemStack;)V", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BehaviourType;", "getType", "()Lcom/simibubi/create/foundation/blockEntity/behaviour/BehaviourType;", "hit", "testHit", "(ZLnet/minecraft/world/phys/Vec3;)Z", "isAlive", "Lnet/minecraft/core/BlockPos;", "getLocation", "()Lnet/minecraft/core/BlockPos;", "", "getClipboardKey", "()Ljava/lang/String;", "tag", "Lnet/minecraft/core/Direction;", "side", "writeToClipboard", "(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/Direction;)Z", "Lnet/minecraft/world/entity/player/Player;", "player", "simulate", "readFromClipboard", "(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/core/Direction;Z)Z", "Ljava/util/function/IntConsumer;", "signalCallback", "Ljava/util/function/IntConsumer;", "front", "Z", "getFront", "frequencyFirst", "Lcom/simibubi/create/content/redstone/link/RedstoneLinkNetworkHandler$Frequency;", "getFrequencyFirst", "()Lcom/simibubi/create/content/redstone/link/RedstoneLinkNetworkHandler$Frequency;", "setFrequencyFirst", "(Lcom/simibubi/create/content/redstone/link/RedstoneLinkNetworkHandler$Frequency;)V", "frequencyLast", "getFrequencyLast", "setFrequencyLast", "Lcom/simibubi/create/foundation/blockEntity/behaviour/ValueBoxTransform;", "firstSlot", "Lcom/simibubi/create/foundation/blockEntity/behaviour/ValueBoxTransform;", "getFirstSlot", "()Lcom/simibubi/create/foundation/blockEntity/behaviour/ValueBoxTransform;", "setFirstSlot", "(Lcom/simibubi/create/foundation/blockEntity/behaviour/ValueBoxTransform;)V", "secondSlot", "getSecondSlot", "setSecondSlot", "textShift", "Lnet/minecraft/world/phys/Vec3;", "getTextShift", "()Lnet/minecraft/world/phys/Vec3;", "setTextShift", "(Lnet/minecraft/world/phys/Vec3;)V", "newPosition", "getNewPosition", "setNewPosition", "(Z)V", "Lcom/simibubi/create/content/redstone/link/RedstoneLinkNetworkHandler;", "getHandler", "()Lcom/simibubi/create/content/redstone/link/RedstoneLinkNetworkHandler;", "handler", "Lcom/simibubi/create/foundation/blockEntity/SmartBlockEntity;", "be", "Lorg/apache/commons/lang3/tuple/Pair;", "slots", "<init>", "(Lcom/simibubi/create/foundation/blockEntity/SmartBlockEntity;Lorg/apache/commons/lang3/tuple/Pair;Ljava/util/function/IntConsumer;Z)V", "Companion", "SlotPositioning", "clockwork"})
public class DualLinkBehaviour
extends BlockEntityBehaviour
implements IRedstoneLinkable,
ClipboardCloneable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IntConsumer signalCallback;
    private final boolean front;
    @NotNull
    private RedstoneLinkNetworkHandler.Frequency frequencyFirst;
    @NotNull
    private RedstoneLinkNetworkHandler.Frequency frequencyLast;
    @NotNull
    private ValueBoxTransform firstSlot;
    @NotNull
    private ValueBoxTransform secondSlot;
    @NotNull
    private Vec3 textShift;
    private boolean newPosition;
    @NotNull
    private static final BehaviourType<DualLinkBehaviour> FRONT_TYPE = new BehaviourType("front_flap_bearing_behaviour");
    @NotNull
    private static final BehaviourType<DualLinkBehaviour> BACK_TYPE = new BehaviourType("back_flap_bearing_behaviour");

    public DualLinkBehaviour(@Nullable SmartBlockEntity be, @NotNull Pair<ValueBoxTransform, ValueBoxTransform> slots, @NotNull IntConsumer signalCallback, boolean front) {
        Intrinsics.checkNotNullParameter(slots, (String)"slots");
        Intrinsics.checkNotNullParameter((Object)signalCallback, (String)"signalCallback");
        super(be);
        this.signalCallback = signalCallback;
        this.front = front;
        this.newPosition = true;
        this.frequencyFirst = RedstoneLinkNetworkHandler.Frequency.EMPTY;
        this.frequencyLast = RedstoneLinkNetworkHandler.Frequency.EMPTY;
        this.firstSlot = (ValueBoxTransform)slots.getLeft();
        Object object = slots.getRight();
        Intrinsics.checkNotNull((Object)object);
        this.secondSlot = (ValueBoxTransform)object;
        this.textShift = Vec3.f_82478_;
    }

    public final boolean getFront() {
        return this.front;
    }

    @NotNull
    public final RedstoneLinkNetworkHandler.Frequency getFrequencyFirst() {
        return this.frequencyFirst;
    }

    public final void setFrequencyFirst(@NotNull RedstoneLinkNetworkHandler.Frequency frequency) {
        Intrinsics.checkNotNullParameter((Object)frequency, (String)"<set-?>");
        this.frequencyFirst = frequency;
    }

    @NotNull
    public final RedstoneLinkNetworkHandler.Frequency getFrequencyLast() {
        return this.frequencyLast;
    }

    public final void setFrequencyLast(@NotNull RedstoneLinkNetworkHandler.Frequency frequency) {
        Intrinsics.checkNotNullParameter((Object)frequency, (String)"<set-?>");
        this.frequencyLast = frequency;
    }

    @NotNull
    public final ValueBoxTransform getFirstSlot() {
        return this.firstSlot;
    }

    public final void setFirstSlot(@NotNull ValueBoxTransform valueBoxTransform) {
        Intrinsics.checkNotNullParameter((Object)valueBoxTransform, (String)"<set-?>");
        this.firstSlot = valueBoxTransform;
    }

    @NotNull
    public final ValueBoxTransform getSecondSlot() {
        return this.secondSlot;
    }

    public final void setSecondSlot(@NotNull ValueBoxTransform valueBoxTransform) {
        Intrinsics.checkNotNullParameter((Object)valueBoxTransform, (String)"<set-?>");
        this.secondSlot = valueBoxTransform;
    }

    @NotNull
    public final Vec3 getTextShift() {
        return this.textShift;
    }

    public final void setTextShift(@NotNull Vec3 vec3) {
        Intrinsics.checkNotNullParameter((Object)vec3, (String)"<set-?>");
        this.textShift = vec3;
    }

    public final boolean getNewPosition() {
        return this.newPosition;
    }

    public final void setNewPosition(boolean bl) {
        this.newPosition = bl;
    }

    @NotNull
    public final DualLinkBehaviour moveText(@NotNull Vec3 shift) {
        Intrinsics.checkNotNullParameter((Object)shift, (String)"shift");
        this.textShift = shift;
        return this;
    }

    public final void copyItemsFrom(@Nullable DualLinkBehaviour behaviour) {
        if (behaviour == null) {
            return;
        }
        this.frequencyFirst = behaviour.frequencyFirst;
        this.frequencyLast = behaviour.frequencyLast;
    }

    public boolean isListening() {
        return true;
    }

    public int getTransmittedStrength() {
        return 0;
    }

    public void setReceivedStrength(int networkPower) {
        if (!this.newPosition) {
            return;
        }
        IntConsumer intConsumer = this.signalCallback;
        Intrinsics.checkNotNull((Object)intConsumer);
        intConsumer.accept(networkPower);
    }

    public final void notifySignalChange() {
        Create.REDSTONE_LINK_NETWORK_HANDLER.updateNetworkOf((LevelAccessor)this.getWorld(), (IRedstoneLinkable)this);
    }

    public void initialize() {
        super.initialize();
        if (this.getWorld().f_46443_) {
            return;
        }
        this.getHandler().addToNetwork((LevelAccessor)this.getWorld(), (IRedstoneLinkable)this);
        this.newPosition = true;
    }

    @NotNull
    public Couple<RedstoneLinkNetworkHandler.Frequency> getNetworkKey() {
        Couple couple = Couple.create((Object)this.frequencyFirst, (Object)this.frequencyLast);
        Intrinsics.checkNotNullExpressionValue((Object)couple, (String)"create(...)");
        return couple;
    }

    public void unload() {
        super.unload();
        if (this.getWorld().f_46443_) {
            return;
        }
        this.getHandler().removeFromNetwork((LevelAccessor)this.getWorld(), (IRedstoneLinkable)this);
    }

    public boolean isSafeNBT() {
        return true;
    }

    public void write(@NotNull CompoundTag nbt, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.write(nbt, clientPacket);
        nbt.m_128365_("FrequencyFirst" + this.front, (Tag)this.frequencyFirst.getStack().m_41739_(new CompoundTag()));
        nbt.m_128365_("FrequencyLast" + this.front, (Tag)this.frequencyLast.getStack().m_41739_(new CompoundTag()));
        nbt.m_128356_("LastKnownPosition", this.blockEntity.m_58899_().m_121878_());
    }

    public void read(@NotNull CompoundTag nbt, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        long positionInTag = this.blockEntity.m_58899_().m_121878_();
        long positionKey = nbt.m_128454_("LastKnownPosition");
        this.newPosition = positionInTag != positionKey;
        super.read(nbt, clientPacket);
        this.frequencyFirst = RedstoneLinkNetworkHandler.Frequency.of((ItemStack)ItemStack.m_41712_((CompoundTag)nbt.m_128469_("FrequencyFirst" + this.front)));
        this.frequencyLast = RedstoneLinkNetworkHandler.Frequency.of((ItemStack)ItemStack.m_41712_((CompoundTag)nbt.m_128469_("FrequencyLast" + this.front)));
    }

    public final void setFrequency(boolean first, @NotNull ItemStack stack) {
        boolean changed;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        ItemStack stack2 = stack;
        stack2 = stack2.m_41777_();
        stack2.m_41764_(1);
        ItemStack toCompare = first ? this.frequencyFirst.getStack() : this.frequencyLast.getStack();
        boolean bl = changed = !ItemStack.m_41656_((ItemStack)stack2, (ItemStack)toCompare) || !ItemStack.m_150942_((ItemStack)stack2, (ItemStack)toCompare);
        if (changed) {
            this.getHandler().removeFromNetwork((LevelAccessor)this.getWorld(), (IRedstoneLinkable)this);
        }
        if (first) {
            this.frequencyFirst = RedstoneLinkNetworkHandler.Frequency.of((ItemStack)stack2);
        } else {
            this.frequencyLast = RedstoneLinkNetworkHandler.Frequency.of((ItemStack)stack2);
        }
        if (!changed) {
            return;
        }
        this.blockEntity.sendData();
        this.getHandler().addToNetwork((LevelAccessor)this.getWorld(), (IRedstoneLinkable)this);
    }

    @NotNull
    public BehaviourType<?> getType() {
        return this.front ? FRONT_TYPE : BACK_TYPE;
    }

    private final RedstoneLinkNetworkHandler getHandler() {
        RedstoneLinkNetworkHandler redstoneLinkNetworkHandler = Create.REDSTONE_LINK_NETWORK_HANDLER;
        Intrinsics.checkNotNullExpressionValue((Object)redstoneLinkNetworkHandler, (String)"REDSTONE_LINK_NETWORK_HANDLER");
        return redstoneLinkNetworkHandler;
    }

    public final boolean testHit(boolean first, @NotNull Vec3 hit) {
        Intrinsics.checkNotNullParameter((Object)hit, (String)"hit");
        BlockState state = this.blockEntity.m_58900_();
        Vec3 pos1 = hit;
        Vec3 pos2 = Vec3.m_82528_((Vec3i)((Vec3i)this.blockEntity.m_58899_()));
        Level level = this.blockEntity.m_58904_();
        if (level != null) {
            Ship ship1 = VSGameUtilsKt.getShipManagingPos((Level)level, (Position)((Position)pos1));
            Vec3 vec3 = pos2;
            Intrinsics.checkNotNull((Object)vec3);
            Ship ship2 = VSGameUtilsKt.getShipManagingPos((Level)level, (Position)((Position)vec3));
            if (ship1 != null && ship2 == null) {
                Matrix4dc matrix4dc = ship1.getWorldToShip();
                Vec3 vec32 = pos2;
                Intrinsics.checkNotNull((Object)vec32);
                Vector3d vector3d = matrix4dc.transformPosition(VectorConversionsMCKt.toJOML((Vec3)vec32));
                Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"transformPosition(...)");
                pos2 = VectorConversionsMCKt.toMinecraft((Vector3dc)((Vector3dc)vector3d));
            } else if (ship1 == null && ship2 != null) {
                Vector3d vector3d = ship2.getWorldToShip().transformPosition(VectorConversionsMCKt.toJOML((Vec3)pos1));
                Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"transformPosition(...)");
                pos1 = VectorConversionsMCKt.toMinecraft((Vector3dc)((Vector3dc)vector3d));
            }
        }
        Vec3 localHit = pos1.m_82546_(pos2);
        ValueBoxTransform slot = first ? this.firstSlot : this.secondSlot;
        return slot.testHit((LevelAccessor)level, this.blockEntity.m_58899_(), state, localHit);
    }

    public boolean isAlive() {
        Level level = this.getWorld();
        BlockPos pos = this.getPos();
        if (this.blockEntity.isChunkUnloaded()) {
            return false;
        }
        if (this.blockEntity.m_58901_()) {
            return false;
        }
        if (!level.m_46749_(pos)) {
            return false;
        }
        return level.m_7702_(pos) == this.blockEntity;
    }

    @NotNull
    public BlockPos getLocation() {
        BlockPos blockPos = this.getPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getPos(...)");
        return blockPos;
    }

    @NotNull
    public String getClipboardKey() {
        return "Frequencies";
    }

    public boolean writeToClipboard(@NotNull CompoundTag tag, @NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        tag.m_128365_("First", (Tag)this.frequencyFirst.getStack().m_41739_(new CompoundTag()));
        tag.m_128365_("Last", (Tag)this.frequencyLast.getStack().m_41739_(new CompoundTag()));
        return true;
    }

    public boolean readFromClipboard(@NotNull CompoundTag tag, @NotNull Player player, @NotNull Direction side, boolean simulate) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        if (!tag.m_128441_("First") || !tag.m_128441_("Last")) {
            return false;
        }
        if (simulate) {
            return true;
        }
        ItemStack itemStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("First"));
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"of(...)");
        this.setFrequency(true, itemStack);
        ItemStack itemStack2 = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Last"));
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"of(...)");
        this.setFrequency(false, itemStack2);
        return true;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\n\u0010\u000bR\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u0005\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/flap/dual_link/DualLinkBehaviour$Companion;", "", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BehaviourType;", "Lorg/valkyrienskies/clockwork/content/contraptions/flap/dual_link/DualLinkBehaviour;", "FRONT_TYPE", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BehaviourType;", "getFRONT_TYPE", "()Lcom/simibubi/create/foundation/blockEntity/behaviour/BehaviourType;", "BACK_TYPE", "getBACK_TYPE", "<init>", "()V", "clockwork"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BehaviourType<DualLinkBehaviour> getFRONT_TYPE() {
            return FRONT_TYPE;
        }

        @NotNull
        public final BehaviourType<DualLinkBehaviour> getBACK_TYPE() {
            return BACK_TYPE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u00002\u00020\u0001B;\u0012\u001e\u0010\t\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00070\u0005\u0012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004R:\u0010\t\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00070\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR.\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b0\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\n\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/flap/dual_link/DualLinkBehaviour$SlotPositioning;", "", "", "scale", "(F)Lorg/valkyrienskies/clockwork/content/contraptions/flap/dual_link/DualLinkBehaviour$SlotPositioning;", "Ljava/util/function/Function;", "Lnet/minecraft/world/level/block/state/BlockState;", "Lorg/apache/commons/lang3/tuple/Pair;", "Lnet/minecraft/world/phys/Vec3;", "offsets", "Ljava/util/function/Function;", "getOffsets", "()Ljava/util/function/Function;", "setOffsets", "(Ljava/util/function/Function;)V", "rotation", "getRotation", "setRotation", "F", "getScale", "()F", "setScale", "(F)V", "<init>", "(Ljava/util/function/Function;Ljava/util/function/Function;)V", "clockwork"})
    public static final class SlotPositioning {
        @NotNull
        private Function<BlockState, Pair<Vec3, Vec3>> offsets;
        @NotNull
        private Function<BlockState, Vec3> rotation;
        private float scale;

        public SlotPositioning(@NotNull Function<BlockState, Pair<Vec3, Vec3>> offsets, @NotNull Function<BlockState, Vec3> rotation) {
            Intrinsics.checkNotNullParameter(offsets, (String)"offsets");
            Intrinsics.checkNotNullParameter(rotation, (String)"rotation");
            this.offsets = offsets;
            this.rotation = rotation;
            this.scale = 1.0f;
        }

        @NotNull
        public final Function<BlockState, Pair<Vec3, Vec3>> getOffsets() {
            return this.offsets;
        }

        public final void setOffsets(@NotNull Function<BlockState, Pair<Vec3, Vec3>> function) {
            Intrinsics.checkNotNullParameter(function, (String)"<set-?>");
            this.offsets = function;
        }

        @NotNull
        public final Function<BlockState, Vec3> getRotation() {
            return this.rotation;
        }

        public final void setRotation(@NotNull Function<BlockState, Vec3> function) {
            Intrinsics.checkNotNullParameter(function, (String)"<set-?>");
            this.rotation = function;
        }

        public final float getScale() {
            return this.scale;
        }

        public final void setScale(float f) {
            this.scale = f;
        }

        @NotNull
        public final SlotPositioning scale(float scale) {
            this.scale = scale;
            return this;
        }
    }
}

