/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.client.render.scanner;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.shaders.AbstractUniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.opengl.GL30;
import org.valkyrienskies.clockwork.ClockworkMod;
import org.valkyrienskies.clockwork.client.render.scanner.ScannerRenderer;
import org.valkyrienskies.clockwork.content.contraptions.phys.infuser.PhysicsInfuserBlockEntity;
import org.valkyrienskies.core.api.ships.ClientShip;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b4\u0010\u001dJ+\u0010\t\u001a\u00020\b2\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0019\u0010\r\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u0016J\u000f\u0010\u001c\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001e\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001dJ7\u0010%\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u001fH\u0002\u00a2\u0006\u0004\b%\u0010&R\u0016\u0010'\u001a\u00020\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u0016\u0010)\u001a\u00020\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010(R\u0016\u0010*\u001a\u00020\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010(R\u0016\u0010,\u001a\u00020+8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u0018\u0010/\u001a\u0004\u0018\u00010.8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b/\u00100R\u0018\u00101\u001a\u0004\u0018\u00010\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b1\u00102R\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0003\u00103\u00a8\u00065"}, d2={"Lorg/valkyrienskies/clockwork/client/render/scanner/ShipScannerRenderer;", "Lorg/valkyrienskies/clockwork/client/render/scanner/ScannerRenderer;", "Lorg/valkyrienskies/core/api/ships/ClientShip;", "ship", "Lnet/minecraft/world/phys/Vec3;", "pos", "Lorg/valkyrienskies/clockwork/content/contraptions/phys/infuser/PhysicsInfuserBlockEntity;", "te", "", "ping", "(Lorg/valkyrienskies/core/api/ships/ClientShip;Lnet/minecraft/world/phys/Vec3;Lorg/valkyrienskies/clockwork/content/contraptions/phys/infuser/PhysicsInfuserBlockEntity;)V", "Lcom/mojang/blaze3d/vertex/PoseStack;", "poseStack", "doRender", "(Lcom/mojang/blaze3d/vertex/PoseStack;)V", "Lorg/joml/Matrix4f;", "viewMatrix", "render", "(Lorg/joml/Matrix4f;)V", "Lcom/mojang/blaze3d/pipeline/RenderTarget;", "target", "updateDepthTexture", "(Lcom/mojang/blaze3d/pipeline/RenderTarget;)V", "Lnet/minecraft/client/renderer/ShaderInstance;", "shader", "updateShaderUniforms", "(Lnet/minecraft/client/renderer/ShaderInstance;Lorg/joml/Matrix4f;)V", "blit", "createDepthCopyBuffer", "()V", "deleteDepthCopyBuffer", "", "width", "height", "internalFormat", "format", "type", "createTexture", "(IIIII)I", "depthCopyFbo", "I", "depthCopyColorBuffer", "depthCopyDepthBuffer", "", "currentStart", "J", "Lorg/joml/Vector3f;", "currentCenter", "Lorg/joml/Vector3f;", "currentBlockEntity", "Lorg/valkyrienskies/clockwork/content/contraptions/phys/infuser/PhysicsInfuserBlockEntity;", "Lorg/valkyrienskies/core/api/ships/ClientShip;", "<init>", "clockwork"})
@OnlyIn(value=Dist.CLIENT)
public final class ShipScannerRenderer
implements ScannerRenderer {
    private int depthCopyFbo;
    private int depthCopyColorBuffer;
    private int depthCopyDepthBuffer;
    private long currentStart;
    @Nullable
    private Vector3f currentCenter;
    @Nullable
    private PhysicsInfuserBlockEntity currentBlockEntity;
    @Nullable
    private ClientShip ship;

    @Override
    public void ping(@Nullable ClientShip ship, @Nullable Vec3 pos, @NotNull PhysicsInfuserBlockEntity te) {
        Intrinsics.checkNotNullParameter((Object)((Object)te), (String)"te");
        this.currentStart = System.currentTimeMillis();
        Vec3 vec3 = pos;
        Intrinsics.checkNotNull((Object)vec3);
        this.currentCenter = new Vector3f((float)vec3.f_82479_, (float)pos.f_82480_, (float)pos.f_82481_);
        this.currentBlockEntity = te;
        if (ship == null) {
            return;
        }
        ClockworkMod.INSTANCE.getLOGGER().info("Pinging ship: " + ship.getId());
        this.ship = ship;
    }

    @Override
    public void doRender(@Nullable PoseStack poseStack) {
        boolean shouldRender;
        int n;
        int adjustedDuration = 0;
        if (this.currentBlockEntity != null) {
            PhysicsInfuserBlockEntity physicsInfuserBlockEntity = this.currentBlockEntity;
            Intrinsics.checkNotNull((Object)((Object)physicsInfuserBlockEntity));
            n = physicsInfuserBlockEntity.getScanGrowthDuration();
        } else {
            Object object = Minecraft.m_91087_().f_91066_.m_231984_().m_231551_();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            n = 2000 * ((Number)object).intValue() / 12;
        }
        adjustedDuration = n;
        boolean bl = shouldRender = this.currentStart > 0L && adjustedDuration > (int)(System.currentTimeMillis() - this.currentStart);
        if (shouldRender) {
            if (this.depthCopyFbo == 0) {
                this.createDepthCopyBuffer();
            }
            PoseStack poseStack2 = poseStack;
            Intrinsics.checkNotNull((Object)poseStack2);
            Matrix4f matrix4f = poseStack2.m_85850_().m_252922_();
            Intrinsics.checkNotNullExpressionValue((Object)matrix4f, (String)"pose(...)");
            this.render(matrix4f);
        } else {
            if (this.depthCopyFbo != 0) {
                this.deleteDepthCopyBuffer();
            }
            this.currentStart = 0L;
        }
    }

    private final void render(Matrix4f viewMatrix) {
    }

    private final void updateDepthTexture(RenderTarget target) {
        int oldBuffer = GlStateManager.getBoundFramebuffer();
        GlStateManager._glBindFramebuffer((int)36008, (int)target.f_83920_);
        GlStateManager._glBindFramebuffer((int)36009, (int)this.depthCopyFbo);
        GL30.glBlitFramebuffer((int)0, (int)0, (int)target.f_83915_, (int)target.f_83916_, (int)0, (int)0, (int)target.f_83915_, (int)target.f_83916_, (int)256, (int)9728);
        GlStateManager._glBindFramebuffer((int)36160, (int)oldBuffer);
    }

    private final void updateShaderUniforms(ShaderInstance shader, Matrix4f viewMatrix) {
        Matrix4f invertedViewMatrix = new Matrix4f((Matrix4fc)viewMatrix);
        invertedViewMatrix.invert();
        Matrix4f invertedProjectionMatrix = new Matrix4f((Matrix4fc)RenderSystem.getProjectionMatrix());
        invertedProjectionMatrix.invert();
        Vec3 cameraPosition = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        int adjustedDuration = 0;
        float radius = 0.0f;
        if (this.currentBlockEntity != null) {
            PhysicsInfuserBlockEntity physicsInfuserBlockEntity = this.currentBlockEntity;
            Intrinsics.checkNotNull((Object)((Object)physicsInfuserBlockEntity));
            adjustedDuration = physicsInfuserBlockEntity.getScanGrowthDuration();
            PhysicsInfuserBlockEntity physicsInfuserBlockEntity2 = this.currentBlockEntity;
            Intrinsics.checkNotNull((Object)((Object)physicsInfuserBlockEntity2));
            radius = physicsInfuserBlockEntity2.computeRadius(this.currentStart, adjustedDuration);
        } else {
            Object object = Minecraft.m_91087_().f_91066_.m_231984_().m_231551_();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            adjustedDuration = 2000 * ((Number)object).intValue() / 12;
            radius = 0.0f;
        }
        shader.m_173350_("depthTex", (Object)this.depthCopyDepthBuffer);
        AbstractUniform abstractUniform = shader.m_173356_("center");
        Vector3f vector3f = this.currentCenter;
        Intrinsics.checkNotNull((Object)vector3f);
        abstractUniform.m_142276_(new Vector3f((Vector3fc)vector3f));
        shader.m_173356_("invViewMat").m_5679_(invertedViewMatrix);
        shader.m_173356_("invProjMat").m_5679_(invertedProjectionMatrix);
        shader.m_173356_("pos").m_142276_(new Vector3f((float)cameraPosition.f_82479_, (float)cameraPosition.f_82480_, (float)cameraPosition.f_82481_));
        shader.m_173356_("radius").m_5985_(radius);
    }

    private final void blit(RenderTarget target) {
    }

    private final void createDepthCopyBuffer() {
        RenderTarget target = Minecraft.m_91087_().m_91385_();
        this.depthCopyFbo = GlStateManager.glGenFramebuffers();
        this.depthCopyColorBuffer = this.createTexture(target.f_83915_, target.f_83916_, 32856, 6408, 5121);
        this.depthCopyDepthBuffer = this.createTexture(target.f_83915_, target.f_83916_, 6402, 6402, 5126);
        int oldBuffer = GlStateManager.getBoundFramebuffer();
        GlStateManager._glBindFramebuffer((int)36160, (int)this.depthCopyFbo);
        GlStateManager._glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.depthCopyColorBuffer, (int)0);
        GlStateManager._glFramebufferTexture2D((int)36160, (int)36096, (int)3553, (int)this.depthCopyDepthBuffer, (int)0);
        GlStateManager._glBindFramebuffer((int)36160, (int)oldBuffer);
    }

    private final void deleteDepthCopyBuffer() {
        GlStateManager._glDeleteFramebuffers((int)this.depthCopyFbo);
        this.depthCopyFbo = 0;
        TextureUtil.releaseTextureId((int)this.depthCopyColorBuffer);
        this.depthCopyColorBuffer = 0;
        TextureUtil.releaseTextureId((int)this.depthCopyDepthBuffer);
        this.depthCopyDepthBuffer = 0;
    }

    private final int createTexture(int width, int height, int internalFormat, int format, int type) {
        int texture = TextureUtil.generateTextureId();
        GlStateManager._bindTexture((int)texture);
        GlStateManager._texParameter((int)3553, (int)10242, (int)10497);
        GlStateManager._texParameter((int)3553, (int)10243, (int)10497);
        GlStateManager._texParameter((int)3553, (int)10241, (int)9728);
        GlStateManager._texParameter((int)3553, (int)10240, (int)9728);
        GlStateManager._texImage2D((int)3553, (int)0, (int)internalFormat, (int)width, (int)height, (int)0, (int)format, (int)type, null);
        GlStateManager._bindTexture((int)0);
        return texture;
    }
}

