/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.client.render.debug;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.architectury.platform.Platform;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.valkyrienskies.clockwork.ClockworkMod;
import org.valkyrienskies.clockwork.ClockworkModClient;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.kelvin.api.DuctNetwork;
import org.valkyrienskies.kelvin.api.DuctNodePos;
import org.valkyrienskies.kelvin.api.edges.PipeDuctEdge;
import org.valkyrienskies.mod.api.ValkyrienSkies;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J'\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\nJE\u0010\u0016\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001a"}, d2={"Lorg/valkyrienskies/clockwork/client/render/debug/KelvinEdgeRenderer;", "", "Lnet/minecraft/client/multiplayer/ClientLevel;", "level", "Lcom/mojang/blaze3d/vertex/PoseStack;", "poseStack", "Lnet/minecraft/client/Camera;", "camera", "", "render", "(Lnet/minecraft/client/multiplayer/ClientLevel;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/Camera;)V", "Lorg/joml/Matrix4f;", "matrix", "Lcom/mojang/blaze3d/vertex/BufferBuilder;", "buf", "Lorg/joml/Vector3f;", "A", "B", "", "r", "g", "b", "renderLine", "(Lorg/joml/Matrix4f;Lcom/mojang/blaze3d/vertex/BufferBuilder;Lorg/joml/Vector3f;Lorg/joml/Vector3f;III)V", "<init>", "()V", "clockwork"})
public final class KelvinEdgeRenderer {
    @NotNull
    public static final KelvinEdgeRenderer INSTANCE = new KelvinEdgeRenderer();

    private KelvinEdgeRenderer() {
    }

    @JvmStatic
    public static final void render(@NotNull ClientLevel level, @NotNull PoseStack poseStack, @NotNull Camera camera) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        if (!Minecraft.m_91087_().f_91066_.f_92063_) {
            return;
        }
        DuctNetwork network = Minecraft.m_91087_().m_91090_() && Platform.isFabric() ? (DuctNetwork)ClockworkMod.getKelvin() : (DuctNetwork)ClockworkModClient.getKelvin();
        Vec3 cameraPos = camera.m_90583_();
        poseStack.m_85836_();
        poseStack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buf = tesselator.m_85915_();
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableDepthTest();
        buf.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85816_);
        int r = 0;
        int g = 255;
        HashMap edges = new HashMap(network.getEdges());
        for (Map.Entry edge : ((Map)edges).entrySet()) {
            Vector3d firstPosition = new Vector3d(((DuctNodePos)((Pair)edge.getKey()).getFirst()).getX() + 0.5, ((DuctNodePos)((Pair)edge.getKey()).getFirst()).getY() + 0.5, ((DuctNodePos)((Pair)edge.getKey()).getFirst()).getZ() + 0.5);
            Ship firstShip = ValkyrienSkies.api().getShipManagingBlock((Level)level, new BlockPos((int)((DuctNodePos)((Pair)edge.getKey()).getFirst()).getX(), (int)((DuctNodePos)((Pair)edge.getKey()).getFirst()).getY(), (int)((DuctNodePos)((Pair)edge.getKey()).getFirst()).getZ()));
            if (firstShip != null) {
                firstPosition = ((ClientShip)firstShip).getRenderTransform().getShipToWorld().transformPosition(firstPosition);
            }
            Vector3d secondPosition = new Vector3d(((DuctNodePos)((Pair)edge.getKey()).getSecond()).getX() + 0.5, ((DuctNodePos)((Pair)edge.getKey()).getSecond()).getY() + 0.5, ((DuctNodePos)((Pair)edge.getKey()).getSecond()).getZ() + 0.5);
            Ship secondShip = ValkyrienSkies.api().getShipManagingBlock((Level)level, new BlockPos((int)((DuctNodePos)((Pair)edge.getKey()).getSecond()).getX(), (int)((DuctNodePos)((Pair)edge.getKey()).getSecond()).getY(), (int)((DuctNodePos)((Pair)edge.getKey()).getSecond()).getZ()));
            if (secondShip != null) {
                secondPosition = ((ClientShip)secondShip).getRenderTransform().getShipToWorld().transformPosition(secondPosition);
            }
            int b = edge.getValue() instanceof PipeDuctEdge ? 0 : 255;
            Vector3f A = new Vector3f((float)firstPosition.x, (float)firstPosition.y, (float)firstPosition.z);
            Vector3f B = new Vector3f((float)secondPosition.x, (float)secondPosition.y, (float)secondPosition.z);
            Intrinsics.checkNotNull((Object)matrix);
            Intrinsics.checkNotNull((Object)buf);
            INSTANCE.renderLine(matrix, buf, A, B, r, g, b);
        }
        tesselator.m_85914_();
        poseStack.m_85849_();
    }

    public final void renderLine(@NotNull Matrix4f matrix, @NotNull BufferBuilder buf, @NotNull Vector3f A, @NotNull Vector3f B, int r, int g, int b) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        Intrinsics.checkNotNullParameter((Object)A, (String)"A");
        Intrinsics.checkNotNullParameter((Object)B, (String)"B");
        int light = Integer.MAX_VALUE;
        buf.m_252986_(matrix, A.x(), A.y(), A.z()).m_6122_(r, g, b, 255).m_85969_(light).m_5752_();
        buf.m_252986_(matrix, B.x(), B.y(), B.z()).m_6122_(r, g, b, 255).m_85969_(light).m_5752_();
    }
}

