/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.clockwork.util.gui.DuctUnits;
import org.valkyrienskies.core.internal.config.ConfigEntry;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\n\u000bB\t\b\u0002\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u0003\u001a\u00020\u00028\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004R\u0014\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/valkyrienskies/clockwork/ClockworkConfig;", "", "Lorg/valkyrienskies/clockwork/ClockworkConfig$Client;", "CLIENT", "Lorg/valkyrienskies/clockwork/ClockworkConfig$Client;", "Lorg/valkyrienskies/clockwork/ClockworkConfig$Server;", "SERVER", "Lorg/valkyrienskies/clockwork/ClockworkConfig$Server;", "<init>", "()V", "Client", "Server", "clockwork"})
public final class ClockworkConfig {
    @NotNull
    public static final ClockworkConfig INSTANCE = new ClockworkConfig();
    @JvmField
    @NotNull
    public static final Client CLIENT = new Client();
    @JvmField
    @NotNull
    public static final Server SERVER = new Server();

    private ClockworkConfig() {
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\f\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b<\u0010=R\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\"\u0010\t\u001a\u00020\u00028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\t\u0010\u0004\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\"\u0010\f\u001a\u00020\u00028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\f\u0010\u0004\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\bR\"\u0010\u0010\u001a\u00020\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\"\u0010\u0017\u001a\u00020\u00168\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\"\u0010\u001e\u001a\u00020\u001d8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\"\u0010%\u001a\u00020$8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\"\u0010,\u001a\u00020+8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\"\u00103\u001a\u0002028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b3\u00104\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\"\u00109\u001a\u0002028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b9\u00104\u001a\u0004\b:\u00106\"\u0004\b;\u00108\u00a8\u0006>"}, d2={"Lorg/valkyrienskies/clockwork/ClockworkConfig$Client;", "", "", "debugRender", "Z", "getDebugRender", "()Z", "setDebugRender", "(Z)V", "renderDuctParticles", "getRenderDuctParticles", "setRenderDuctParticles", "simplifyDisplayUnits", "getSimplifyDisplayUnits", "setSimplifyDisplayUnits", "Lorg/valkyrienskies/clockwork/util/gui/DuctUnits$MassUnit;", "massDisplayUnit", "Lorg/valkyrienskies/clockwork/util/gui/DuctUnits$MassUnit;", "getMassDisplayUnit", "()Lorg/valkyrienskies/clockwork/util/gui/DuctUnits$MassUnit;", "setMassDisplayUnit", "(Lorg/valkyrienskies/clockwork/util/gui/DuctUnits$MassUnit;)V", "Lorg/valkyrienskies/clockwork/util/gui/DuctUnits$VolumeUnit;", "volumeDisplayUnit", "Lorg/valkyrienskies/clockwork/util/gui/DuctUnits$VolumeUnit;", "getVolumeDisplayUnit", "()Lorg/valkyrienskies/clockwork/util/gui/DuctUnits$VolumeUnit;", "setVolumeDisplayUnit", "(Lorg/valkyrienskies/clockwork/util/gui/DuctUnits$VolumeUnit;)V", "Lorg/valkyrienskies/clockwork/util/gui/DuctUnits$TemperatureUnit;", "tempDisplayUnit", "Lorg/valkyrienskies/clockwork/util/gui/DuctUnits$TemperatureUnit;", "getTempDisplayUnit", "()Lorg/valkyrienskies/clockwork/util/gui/DuctUnits$TemperatureUnit;", "setTempDisplayUnit", "(Lorg/valkyrienskies/clockwork/util/gui/DuctUnits$TemperatureUnit;)V", "Lorg/valkyrienskies/clockwork/util/gui/DuctUnits$PressureUnit;", "pressureDisplayUnit", "Lorg/valkyrienskies/clockwork/util/gui/DuctUnits$PressureUnit;", "getPressureDisplayUnit", "()Lorg/valkyrienskies/clockwork/util/gui/DuctUnits$PressureUnit;", "setPressureDisplayUnit", "(Lorg/valkyrienskies/clockwork/util/gui/DuctUnits$PressureUnit;)V", "Lorg/valkyrienskies/clockwork/util/gui/DuctUnits$EnergyUnit;", "energyDisplayUnit", "Lorg/valkyrienskies/clockwork/util/gui/DuctUnits$EnergyUnit;", "getEnergyDisplayUnit", "()Lorg/valkyrienskies/clockwork/util/gui/DuctUnits$EnergyUnit;", "setEnergyDisplayUnit", "(Lorg/valkyrienskies/clockwork/util/gui/DuctUnits$EnergyUnit;)V", "", "maxTemperatureWarning", "D", "getMaxTemperatureWarning", "()D", "setMaxTemperatureWarning", "(D)V", "maxPressureWarning", "getMaxPressureWarning", "setMaxPressureWarning", "<init>", "()V", "clockwork"})
    public static final class Client {
        @ConfigEntry(description="Enable debug rendering")
        private boolean debugRender;
        @ConfigEntry(description="Enable rendering particles for DuctBlock")
        private boolean renderDuctParticles = true;
        @ConfigEntry(description="Use metric prefixes for units (15000 Pa = 15 kPa)")
        private boolean simplifyDisplayUnits = true;
        @ConfigEntry(description="Gas mass display unit")
        @NotNull
        private DuctUnits.MassUnit massDisplayUnit = DuctUnits.MassUnit.KILOGRAM;
        @ConfigEntry(description="Duct volume display unit")
        @NotNull
        private DuctUnits.VolumeUnit volumeDisplayUnit = DuctUnits.VolumeUnit.CUBIC_METER;
        @ConfigEntry(description="Temperature display unit")
        @NotNull
        private DuctUnits.TemperatureUnit tempDisplayUnit = DuctUnits.TemperatureUnit.KELVIN;
        @ConfigEntry(description="Pressure display unit")
        @NotNull
        private DuctUnits.PressureUnit pressureDisplayUnit = DuctUnits.PressureUnit.PASCAL;
        @ConfigEntry(description="Gas energy display unit")
        @NotNull
        private DuctUnits.EnergyUnit energyDisplayUnit = DuctUnits.EnergyUnit.JOULE;
        @ConfigEntry(description="Threshold for high temperature warning. 0.9 = 90% of maximum", min=0.0, max=1.0)
        private double maxTemperatureWarning = 0.9;
        @ConfigEntry(description="Threshold for high pressure warning. 0.9 = 90% of maximum", min=0.0, max=1.0)
        private double maxPressureWarning = 0.9;

        public final boolean getDebugRender() {
            return this.debugRender;
        }

        public final void setDebugRender(boolean bl) {
            this.debugRender = bl;
        }

        public final boolean getRenderDuctParticles() {
            return this.renderDuctParticles;
        }

        public final void setRenderDuctParticles(boolean bl) {
            this.renderDuctParticles = bl;
        }

        public final boolean getSimplifyDisplayUnits() {
            return this.simplifyDisplayUnits;
        }

        public final void setSimplifyDisplayUnits(boolean bl) {
            this.simplifyDisplayUnits = bl;
        }

        @NotNull
        public final DuctUnits.MassUnit getMassDisplayUnit() {
            return this.massDisplayUnit;
        }

        public final void setMassDisplayUnit(@NotNull DuctUnits.MassUnit massUnit) {
            Intrinsics.checkNotNullParameter((Object)massUnit, (String)"<set-?>");
            this.massDisplayUnit = massUnit;
        }

        @NotNull
        public final DuctUnits.VolumeUnit getVolumeDisplayUnit() {
            return this.volumeDisplayUnit;
        }

        public final void setVolumeDisplayUnit(@NotNull DuctUnits.VolumeUnit volumeUnit) {
            Intrinsics.checkNotNullParameter((Object)volumeUnit, (String)"<set-?>");
            this.volumeDisplayUnit = volumeUnit;
        }

        @NotNull
        public final DuctUnits.TemperatureUnit getTempDisplayUnit() {
            return this.tempDisplayUnit;
        }

        public final void setTempDisplayUnit(@NotNull DuctUnits.TemperatureUnit temperatureUnit) {
            Intrinsics.checkNotNullParameter((Object)temperatureUnit, (String)"<set-?>");
            this.tempDisplayUnit = temperatureUnit;
        }

        @NotNull
        public final DuctUnits.PressureUnit getPressureDisplayUnit() {
            return this.pressureDisplayUnit;
        }

        public final void setPressureDisplayUnit(@NotNull DuctUnits.PressureUnit pressureUnit) {
            Intrinsics.checkNotNullParameter((Object)pressureUnit, (String)"<set-?>");
            this.pressureDisplayUnit = pressureUnit;
        }

        @NotNull
        public final DuctUnits.EnergyUnit getEnergyDisplayUnit() {
            return this.energyDisplayUnit;
        }

        public final void setEnergyDisplayUnit(@NotNull DuctUnits.EnergyUnit energyUnit) {
            Intrinsics.checkNotNullParameter((Object)energyUnit, (String)"<set-?>");
            this.energyDisplayUnit = energyUnit;
        }

        public final double getMaxTemperatureWarning() {
            return this.maxTemperatureWarning;
        }

        public final void setMaxTemperatureWarning(double d) {
            this.maxTemperatureWarning = d;
        }

        public final double getMaxPressureWarning() {
            return this.maxPressureWarning;
        }

        public final void setMaxPressureWarning(double d) {
            this.maxPressureWarning = d;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\bh\u0018\u00002\u00020\u0001B\t\u00a2\u0006\u0006\b\u0081\u0001\u0010\u0082\u0001R\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\"\u0010\n\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR(\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\"\u0010\u0018\u001a\u00020\u00028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0004\u001a\u0004\b\u0019\u0010\u0006\"\u0004\b\u001a\u0010\bR\"\u0010\u001c\u001a\u00020\u001b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\"\u0010\"\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\"\u0010\u000b\u001a\u0004\b#\u0010\r\"\u0004\b$\u0010\u000fR\"\u0010%\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b%\u0010\u000b\u001a\u0004\b&\u0010\r\"\u0004\b'\u0010\u000fR\"\u0010(\u001a\u00020\u001b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b(\u0010\u001d\u001a\u0004\b)\u0010\u001f\"\u0004\b*\u0010!R\"\u0010+\u001a\u00020\u001b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b+\u0010\u001d\u001a\u0004\b,\u0010\u001f\"\u0004\b-\u0010!R\"\u0010.\u001a\u00020\u001b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b.\u0010\u001d\u001a\u0004\b/\u0010\u001f\"\u0004\b0\u0010!R\"\u00101\u001a\u00020\u001b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b1\u0010\u001d\u001a\u0004\b2\u0010\u001f\"\u0004\b3\u0010!R\"\u00104\u001a\u00020\u00028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b4\u0010\u0004\u001a\u0004\b5\u0010\u0006\"\u0004\b6\u0010\bR\"\u00107\u001a\u00020\u001b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b7\u0010\u001d\u001a\u0004\b8\u0010\u001f\"\u0004\b9\u0010!R\"\u0010:\u001a\u00020\u001b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b:\u0010\u001d\u001a\u0004\b;\u0010\u001f\"\u0004\b<\u0010!R\"\u0010=\u001a\u00020\u001b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b=\u0010\u001d\u001a\u0004\b>\u0010\u001f\"\u0004\b?\u0010!R\"\u0010@\u001a\u00020\u001b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b@\u0010\u001d\u001a\u0004\bA\u0010\u001f\"\u0004\bB\u0010!R\"\u0010C\u001a\u00020\u001b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\bC\u0010\u001d\u001a\u0004\bD\u0010\u001f\"\u0004\bE\u0010!R\"\u0010F\u001a\u00020\u001b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\bF\u0010\u001d\u001a\u0004\bG\u0010\u001f\"\u0004\bH\u0010!R\"\u0010I\u001a\u00020\u001b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\bI\u0010\u001d\u001a\u0004\bJ\u0010\u001f\"\u0004\bK\u0010!R\"\u0010L\u001a\u00020\u00028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\bL\u0010\u0004\u001a\u0004\bM\u0010\u0006\"\u0004\bN\u0010\bR\"\u0010O\u001a\u00020\u001b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\bO\u0010\u001d\u001a\u0004\bP\u0010\u001f\"\u0004\bQ\u0010!R\"\u0010R\u001a\u00020\u001b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\bR\u0010\u001d\u001a\u0004\bS\u0010\u001f\"\u0004\bT\u0010!R\"\u0010U\u001a\u00020\u001b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\bU\u0010\u001d\u001a\u0004\bV\u0010\u001f\"\u0004\bW\u0010!R\"\u0010X\u001a\u00020\u001b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\bX\u0010\u001d\u001a\u0004\bY\u0010\u001f\"\u0004\bZ\u0010!R\"\u0010[\u001a\u00020\u001b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b[\u0010\u001d\u001a\u0004\b\\\u0010\u001f\"\u0004\b]\u0010!R\"\u0010^\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b^\u0010\u000b\u001a\u0004\b_\u0010\r\"\u0004\b`\u0010\u000fR\"\u0010a\u001a\u00020\u001b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\ba\u0010\u001d\u001a\u0004\bb\u0010\u001f\"\u0004\bc\u0010!R\"\u0010d\u001a\u00020\u001b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\bd\u0010\u001d\u001a\u0004\be\u0010\u001f\"\u0004\bf\u0010!R\"\u0010g\u001a\u00020\u001b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\bg\u0010\u001d\u001a\u0004\bh\u0010\u001f\"\u0004\bi\u0010!R\"\u0010j\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\bj\u0010\u000b\u001a\u0004\bk\u0010\r\"\u0004\bl\u0010\u000fR\"\u0010m\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\bm\u0010\u000b\u001a\u0004\bn\u0010\r\"\u0004\bo\u0010\u000fR\"\u0010p\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\bp\u0010\u000b\u001a\u0004\bq\u0010\r\"\u0004\br\u0010\u000fR\"\u0010s\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\bs\u0010\u000b\u001a\u0004\bt\u0010\r\"\u0004\bu\u0010\u000fR\"\u0010v\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\bv\u0010\u000b\u001a\u0004\bw\u0010\r\"\u0004\bx\u0010\u000fR\"\u0010y\u001a\u00020\u001b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\by\u0010\u001d\u001a\u0004\bz\u0010\u001f\"\u0004\b{\u0010!R\"\u0010|\u001a\u00020\u001b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b|\u0010\u001d\u001a\u0004\b}\u0010\u001f\"\u0004\b~\u0010!R\u001b\u0010\u007f\u001a\u00020\u001b8\u0006X\u0087D\u00a2\u0006\r\n\u0004\b\u007f\u0010\u001d\u001a\u0005\b\u0080\u0001\u0010\u001f\u00a8\u0006\u0083\u0001"}, d2={"Lorg/valkyrienskies/clockwork/ClockworkConfig$Server;", "", "", "debugMode", "Z", "getDebugMode", "()Z", "setDebugMode", "(Z)V", "", "kelvinSubSteps", "I", "getKelvinSubSteps", "()I", "setKelvinSubSteps", "(I)V", "", "", "blockBlacklist", "Ljava/util/Set;", "getBlockBlacklist", "()Ljava/util/Set;", "setBlockBlacklist", "(Ljava/util/Set;)V", "collisionSoundEffects", "getCollisionSoundEffects", "setCollisionSoundEffects", "", "ductVolme", "D", "getDuctVolme", "()D", "setDuctVolme", "(D)V", "collisionSoundEffectMax", "getCollisionSoundEffectMax", "setCollisionSoundEffectMax", "maxGravitronMass", "getMaxGravitronMass", "setMaxGravitronMass", "balloonForceMult", "getBalloonForceMult", "setBalloonForceMult", "permeabilityConstant", "getPermeabilityConstant", "setPermeabilityConstant", "heatTransferCoefficient", "getHeatTransferCoefficient", "setHeatTransferCoefficient", "reactionWheelEffectiveness", "getReactionWheelEffectiveness", "setReactionWheelEffectiveness", "bladeControllerUsesDurability", "getBladeControllerUsesDurability", "setBladeControllerUsesDurability", "maxBladeSize", "getMaxBladeSize", "setMaxBladeSize", "maxUniversalJointDistance", "getMaxUniversalJointDistance", "setMaxUniversalJointDistance", "hotAirBalloonMaxRaycastDistance", "getHotAirBalloonMaxRaycastDistance", "setHotAirBalloonMaxRaycastDistance", "hotAirBalloonMaxScanVolume", "getHotAirBalloonMaxScanVolume", "setHotAirBalloonMaxScanVolume", "hotAirBalloonMaxScanSurface", "getHotAirBalloonMaxScanSurface", "setHotAirBalloonMaxScanSurface", "unlockedModeRotationResistanceMultiplier", "getUnlockedModeRotationResistanceMultiplier", "setUnlockedModeRotationResistanceMultiplier", "unlockedModeOmegaErrorMultiplier", "getUnlockedModeOmegaErrorMultiplier", "setUnlockedModeOmegaErrorMultiplier", "allowWrenchingActivatedPhysBearing", "getAllowWrenchingActivatedPhysBearing", "setAllowWrenchingActivatedPhysBearing", "forceMulPerSailInPropeller", "getForceMulPerSailInPropeller", "setForceMulPerSailInPropeller", "encasedFanForceMul", "getEncasedFanForceMul", "setEncasedFanForceMul", "wanderOreForceMultiplier", "getWanderOreForceMultiplier", "setWanderOreForceMultiplier", "gasThrusterForceMul", "getGasThrusterForceMul", "setGasThrusterForceMul", "sugarRocketBlockThrust", "getSugarRocketBlockThrust", "setSugarRocketBlockThrust", "kelvinNodeBlockEntityLazyTickRate", "getKelvinNodeBlockEntityLazyTickRate", "setKelvinNodeBlockEntityLazyTickRate", "airCompressorSpeed", "getAirCompressorSpeed", "setAirCompressorSpeed", "airCompressorMaxPressure", "getAirCompressorMaxPressure", "setAirCompressorMaxPressure", "airCompressorHeliumAirDensity", "getAirCompressorHeliumAirDensity", "setAirCompressorHeliumAirDensity", "heaterSmoulderingTemp", "getHeaterSmoulderingTemp", "setHeaterSmoulderingTemp", "heaterKindledTemp", "getHeaterKindledTemp", "setHeaterKindledTemp", "heaterSeethingTemp", "getHeaterSeethingTemp", "setHeaterSeethingTemp", "bulkSmokingTemp", "getBulkSmokingTemp", "setBulkSmokingTemp", "bulkBlastingTemp", "getBulkBlastingTemp", "setBulkBlastingTemp", "survivalGravitronYeetForce", "getSurvivalGravitronYeetForce", "setSurvivalGravitronYeetForce", "survivalGravitronMaxRange", "getSurvivalGravitronMaxRange", "setSurvivalGravitronMaxRange", "meteor_density", "getMeteor_density", "<init>", "()V", "clockwork"})
    public static final class Server {
        @ConfigEntry(description="Enable verbose debug logging")
        private boolean debugMode;
        @ConfigEntry(description="Kelvin sub steps (per Tick)")
        private int kelvinSubSteps = 10;
        @NotNull
        private Set<String> blockBlacklist;
        @ConfigEntry(description="Enable collision sound effects")
        private boolean collisionSoundEffects;
        @ConfigEntry(description="Duct-like volume. The volume used for ducts, valves, exhausts, etc.")
        private double ductVolme;
        @ConfigEntry(description="Max collision events per tick. Dumps collision event queue if amount is bigger. Default is 100", min=1.0)
        private int collisionSoundEffectMax;
        @ConfigEntry(description="Max Gravitron mass in 1000 kg")
        private int maxGravitronMass;
        @ConfigEntry(description="Force multiplier for balloons. Realism is 1.0, default is 1000.0. Range: > 0.0", min=0.0)
        private double balloonForceMult;
        @ConfigEntry(description="Sets the gas retention efficiency of the balloon material; lower values simulate airtight rubber/synthetic, while higher values represent porous fabrics. Default 0.001.", min=0.0, max=1.0)
        private double permeabilityConstant;
        @ConfigEntry(description="Controls how fast air pocket temperature equalizes with the ambient temperature; lower values simulate thick insulation, while higher values cause rapid cooling or heating. Default 0.001", min=0.0, max=1.0)
        private double heatTransferCoefficient;
        @ConfigEntry(description="Effectiveness scalar for reaction wheels. Higher value means a single reaction wheel can better control an entire ship, regardless of its mass. Default value is 0.1.", min=0.001, max=1.0)
        private double reactionWheelEffectiveness;
        @ConfigEntry(description="Whether or not blade controllers consume the durability of the blades inside while rotating at high speeds.")
        private boolean bladeControllerUsesDurability;
        @ConfigEntry(description="The max size that a propeller blade can reach. Sizes higher than this will refuse to craft.")
        private double maxBladeSize;
        @ConfigEntry(description="The maximum distance (in blocks) allowed between two Universal Joints while connected.", min=1.0)
        private double maxUniversalJointDistance;
        @ConfigEntry(description="The length of the raycast made by the Gas Nozzle when attempting to find a valid balloon ceiling.", min=1.0)
        private double hotAirBalloonMaxRaycastDistance;
        @ConfigEntry(description="The maximum volume (in blocks) that the hot air balloon floodfill will scan when trying to determine the balloon's interior.", min=1.0)
        private double hotAirBalloonMaxScanVolume;
        @ConfigEntry(description="The maximum surface area (in blocks) that the hot air balloon floodfill will scan when trying to determine the balloon's exterior.", min=1.0)
        private double hotAirBalloonMaxScanSurface;
        @ConfigEntry(description="Force multiplier when no rpm is given")
        private double unlockedModeRotationResistanceMultiplier;
        @ConfigEntry
        private double unlockedModeOmegaErrorMultiplier;
        @ConfigEntry
        private boolean allowWrenchingActivatedPhysBearing;
        @ConfigEntry(min=0.0)
        private double forceMulPerSailInPropeller;
        @ConfigEntry(min=0.0)
        private double encasedFanForceMul;
        @ConfigEntry(description="Wanderlite blocks exert enough force to lift their own weight, times this multiplier.", min=0.0)
        private double wanderOreForceMultiplier;
        @ConfigEntry(min=0.0)
        private double gasThrusterForceMul;
        @ConfigEntry(min=0.0)
        private double sugarRocketBlockThrust;
        @ConfigEntry(description="The lazytick rate for Kelvin node block entity updates")
        private int kelvinNodeBlockEntityLazyTickRate;
        @ConfigEntry(description="The amount of air (in kg) that the air compressor produces per tick at sea level and 1 rpm")
        private double airCompressorSpeed;
        @ConfigEntry(description="The max amount of pressure that the air compressor will generate air for. In Pa")
        private double airCompressorMaxPressure;
        @ConfigEntry(description="Air density at which the air compressor will start generating aether. Setting it to 0 or a negative number will disable helium generation")
        private double airCompressorHeliumAirDensity;
        @ConfigEntry(description="Temperature for the gas heater to act like a passive heat source (campfires, dormant blaze burners). Default is 500K (baking oven)")
        private int heaterSmoulderingTemp;
        @ConfigEntry(description="Temperature for the gas heater to act like a heated blaze burner. Default is 1000K (ceramic firing)")
        private int heaterKindledTemp;
        @ConfigEntry(description="Temperature for the gas heater to act like a superheated blaze burner. Default is 1500K (real metallurgy)")
        private int heaterSeethingTemp;
        @ConfigEntry(description="Temperature for gas exhaust to trigger bulk smoking. Default is 500K (baking oven)")
        private int bulkSmokingTemp;
        @ConfigEntry(description="Temperature for gas exhaust to trigger bulk blasting. Default is 1000K (ceramic firing)")
        private int bulkBlastingTemp;
        @ConfigEntry(description="Multiplier applied to ship mass when yeeting (left-clicking) with the survival gravitron", min=0.0, max=10000.0)
        private double survivalGravitronYeetForce;
        @ConfigEntry(description="Maximum range (in blocks) the survival gravitron will interact with ships", min=1.0, max=1000.0)
        private double survivalGravitronMaxRange;
        @ConfigEntry(description="The density mult of wanderlite ore in meteors", min=0.0)
        private final double meteor_density;

        public Server() {
            Object[] objectArray = new String[]{"minecraft:bedrock", "minecraft:end_portal_frame", "minecraft:end_portal", "minecraft:end_gateway", "minecraft:portal", "minecraft:air", "minecraft:water", "minecraft:flowing_water", "minecraft:lava", "minecraft:flowing_lava", "vs_clockwork:physics_infuser"};
            this.blockBlacklist = SetsKt.setOf((Object[])objectArray);
            this.ductVolme = 0.4;
            this.collisionSoundEffectMax = 100;
            this.maxGravitronMass = 256;
            this.balloonForceMult = 50.0;
            this.permeabilityConstant = 0.01;
            this.heatTransferCoefficient = 0.01;
            this.reactionWheelEffectiveness = 1.0;
            this.maxBladeSize = 4.0;
            this.maxUniversalJointDistance = 10.0;
            this.hotAirBalloonMaxRaycastDistance = 64.0;
            this.hotAirBalloonMaxScanVolume = 100000.0;
            this.hotAirBalloonMaxScanSurface = 100000.0;
            this.unlockedModeRotationResistanceMultiplier = 1.0;
            this.unlockedModeOmegaErrorMultiplier = 50.0;
            this.forceMulPerSailInPropeller = 5.0;
            this.encasedFanForceMul = 40.0;
            this.wanderOreForceMultiplier = 2.0;
            this.gasThrusterForceMul = 200.0;
            this.sugarRocketBlockThrust = 10000.0;
            this.kelvinNodeBlockEntityLazyTickRate = 10;
            this.airCompressorSpeed = 1.0E-4;
            this.airCompressorMaxPressure = 1000000.0;
            this.airCompressorHeliumAirDensity = 0.3;
            this.heaterSmoulderingTemp = 500;
            this.heaterKindledTemp = 1000;
            this.heaterSeethingTemp = 1500;
            this.bulkSmokingTemp = 500;
            this.bulkBlastingTemp = 1000;
            this.survivalGravitronYeetForce = 1000.0;
            this.survivalGravitronMaxRange = 20.0;
        }

        public final boolean getDebugMode() {
            return this.debugMode;
        }

        public final void setDebugMode(boolean bl) {
            this.debugMode = bl;
        }

        public final int getKelvinSubSteps() {
            return this.kelvinSubSteps;
        }

        public final void setKelvinSubSteps(int n) {
            this.kelvinSubSteps = n;
        }

        @NotNull
        public final Set<String> getBlockBlacklist() {
            return this.blockBlacklist;
        }

        public final void setBlockBlacklist(@NotNull Set<String> set) {
            Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
            this.blockBlacklist = set;
        }

        public final boolean getCollisionSoundEffects() {
            return this.collisionSoundEffects;
        }

        public final void setCollisionSoundEffects(boolean bl) {
            this.collisionSoundEffects = bl;
        }

        public final double getDuctVolme() {
            return this.ductVolme;
        }

        public final void setDuctVolme(double d) {
            this.ductVolme = d;
        }

        public final int getCollisionSoundEffectMax() {
            return this.collisionSoundEffectMax;
        }

        public final void setCollisionSoundEffectMax(int n) {
            this.collisionSoundEffectMax = n;
        }

        public final int getMaxGravitronMass() {
            return this.maxGravitronMass;
        }

        public final void setMaxGravitronMass(int n) {
            this.maxGravitronMass = n;
        }

        public final double getBalloonForceMult() {
            return this.balloonForceMult;
        }

        public final void setBalloonForceMult(double d) {
            this.balloonForceMult = d;
        }

        public final double getPermeabilityConstant() {
            return this.permeabilityConstant;
        }

        public final void setPermeabilityConstant(double d) {
            this.permeabilityConstant = d;
        }

        public final double getHeatTransferCoefficient() {
            return this.heatTransferCoefficient;
        }

        public final void setHeatTransferCoefficient(double d) {
            this.heatTransferCoefficient = d;
        }

        public final double getReactionWheelEffectiveness() {
            return this.reactionWheelEffectiveness;
        }

        public final void setReactionWheelEffectiveness(double d) {
            this.reactionWheelEffectiveness = d;
        }

        public final boolean getBladeControllerUsesDurability() {
            return this.bladeControllerUsesDurability;
        }

        public final void setBladeControllerUsesDurability(boolean bl) {
            this.bladeControllerUsesDurability = bl;
        }

        public final double getMaxBladeSize() {
            return this.maxBladeSize;
        }

        public final void setMaxBladeSize(double d) {
            this.maxBladeSize = d;
        }

        public final double getMaxUniversalJointDistance() {
            return this.maxUniversalJointDistance;
        }

        public final void setMaxUniversalJointDistance(double d) {
            this.maxUniversalJointDistance = d;
        }

        public final double getHotAirBalloonMaxRaycastDistance() {
            return this.hotAirBalloonMaxRaycastDistance;
        }

        public final void setHotAirBalloonMaxRaycastDistance(double d) {
            this.hotAirBalloonMaxRaycastDistance = d;
        }

        public final double getHotAirBalloonMaxScanVolume() {
            return this.hotAirBalloonMaxScanVolume;
        }

        public final void setHotAirBalloonMaxScanVolume(double d) {
            this.hotAirBalloonMaxScanVolume = d;
        }

        public final double getHotAirBalloonMaxScanSurface() {
            return this.hotAirBalloonMaxScanSurface;
        }

        public final void setHotAirBalloonMaxScanSurface(double d) {
            this.hotAirBalloonMaxScanSurface = d;
        }

        public final double getUnlockedModeRotationResistanceMultiplier() {
            return this.unlockedModeRotationResistanceMultiplier;
        }

        public final void setUnlockedModeRotationResistanceMultiplier(double d) {
            this.unlockedModeRotationResistanceMultiplier = d;
        }

        public final double getUnlockedModeOmegaErrorMultiplier() {
            return this.unlockedModeOmegaErrorMultiplier;
        }

        public final void setUnlockedModeOmegaErrorMultiplier(double d) {
            this.unlockedModeOmegaErrorMultiplier = d;
        }

        public final boolean getAllowWrenchingActivatedPhysBearing() {
            return this.allowWrenchingActivatedPhysBearing;
        }

        public final void setAllowWrenchingActivatedPhysBearing(boolean bl) {
            this.allowWrenchingActivatedPhysBearing = bl;
        }

        public final double getForceMulPerSailInPropeller() {
            return this.forceMulPerSailInPropeller;
        }

        public final void setForceMulPerSailInPropeller(double d) {
            this.forceMulPerSailInPropeller = d;
        }

        public final double getEncasedFanForceMul() {
            return this.encasedFanForceMul;
        }

        public final void setEncasedFanForceMul(double d) {
            this.encasedFanForceMul = d;
        }

        public final double getWanderOreForceMultiplier() {
            return this.wanderOreForceMultiplier;
        }

        public final void setWanderOreForceMultiplier(double d) {
            this.wanderOreForceMultiplier = d;
        }

        public final double getGasThrusterForceMul() {
            return this.gasThrusterForceMul;
        }

        public final void setGasThrusterForceMul(double d) {
            this.gasThrusterForceMul = d;
        }

        public final double getSugarRocketBlockThrust() {
            return this.sugarRocketBlockThrust;
        }

        public final void setSugarRocketBlockThrust(double d) {
            this.sugarRocketBlockThrust = d;
        }

        public final int getKelvinNodeBlockEntityLazyTickRate() {
            return this.kelvinNodeBlockEntityLazyTickRate;
        }

        public final void setKelvinNodeBlockEntityLazyTickRate(int n) {
            this.kelvinNodeBlockEntityLazyTickRate = n;
        }

        public final double getAirCompressorSpeed() {
            return this.airCompressorSpeed;
        }

        public final void setAirCompressorSpeed(double d) {
            this.airCompressorSpeed = d;
        }

        public final double getAirCompressorMaxPressure() {
            return this.airCompressorMaxPressure;
        }

        public final void setAirCompressorMaxPressure(double d) {
            this.airCompressorMaxPressure = d;
        }

        public final double getAirCompressorHeliumAirDensity() {
            return this.airCompressorHeliumAirDensity;
        }

        public final void setAirCompressorHeliumAirDensity(double d) {
            this.airCompressorHeliumAirDensity = d;
        }

        public final int getHeaterSmoulderingTemp() {
            return this.heaterSmoulderingTemp;
        }

        public final void setHeaterSmoulderingTemp(int n) {
            this.heaterSmoulderingTemp = n;
        }

        public final int getHeaterKindledTemp() {
            return this.heaterKindledTemp;
        }

        public final void setHeaterKindledTemp(int n) {
            this.heaterKindledTemp = n;
        }

        public final int getHeaterSeethingTemp() {
            return this.heaterSeethingTemp;
        }

        public final void setHeaterSeethingTemp(int n) {
            this.heaterSeethingTemp = n;
        }

        public final int getBulkSmokingTemp() {
            return this.bulkSmokingTemp;
        }

        public final void setBulkSmokingTemp(int n) {
            this.bulkSmokingTemp = n;
        }

        public final int getBulkBlastingTemp() {
            return this.bulkBlastingTemp;
        }

        public final void setBulkBlastingTemp(int n) {
            this.bulkBlastingTemp = n;
        }

        public final double getSurvivalGravitronYeetForce() {
            return this.survivalGravitronYeetForce;
        }

        public final void setSurvivalGravitronYeetForce(double d) {
            this.survivalGravitronYeetForce = d;
        }

        public final double getSurvivalGravitronMaxRange() {
            return this.survivalGravitronMaxRange;
        }

        public final void setSurvivalGravitronMaxRange(double d) {
            this.survivalGravitronMaxRange = d;
        }

        public final double getMeteor_density() {
            return this.meteor_density;
        }
    }
}

