/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer.dynamic;

import com.google.common.collect.HashMultimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.analysis.selector.AnnotationValueHandle;
import org.sinytra.adapter.patch.api.ClassTransform;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchContext;
import org.sinytra.adapter.patch.util.AdapterUtil;

public class DynamicAnonymousShadowFieldTypePatch
implements ClassTransform {
    @Override
    public Patch.Result apply(ClassNode classNode, @Nullable AnnotationValueHandle<?> annotation, PatchContext context) {
        if (annotation == null || !annotation.getKey().equals("targets")) {
            return Patch.Result.PASS;
        }
        List targets = (List)annotation.get();
        if (targets.size() != 1) {
            return Patch.Result.PASS;
        }
        String targetReference = context.remap((String)targets.getFirst());
        if (!AdapterUtil.isAnonymousClass(targetReference)) {
            return Patch.Result.PASS;
        }
        ClassNode targetClass = context.environment().dirtyClassLookup().getClass(targetReference).orElse(null);
        if (targetClass == null) {
            return Patch.Result.PASS;
        }
        HashMap<String, String> renames = new HashMap<String, String>();
        HashMultimap fields = HashMultimap.create();
        for (FieldNode targetField : targetClass.fields) {
            fields.put((Object)targetField.desc, (Object)targetField);
        }
        for (FieldNode field : classNode.fields) {
            if (field.visibleAnnotations == null) continue;
            for (AnnotationNode ann : field.visibleAnnotations) {
                Collection targetFields;
                if (!"Lorg/spongepowered/asm/mixin/Shadow;".equals(ann.desc) || (targetFields = fields.get((Object)field.desc)).size() != 1) continue;
                FieldNode targetField = (FieldNode)targetFields.iterator().next();
                if (field.name.equals(targetField.name)) continue;
                renames.put(field.name, targetField.name);
                field.name = targetField.name;
            }
        }
        if (!renames.isEmpty()) {
            renames.forEach((from, to) -> context.environment().auditTrail().recordAudit((Object)this, classNode, "Rename anonymous class field %s to %s", from, to));
            for (MethodNode method : classNode.methods) {
                for (AbstractInsnNode insn : method.instructions) {
                    if (!(insn instanceof FieldInsnNode)) continue;
                    FieldInsnNode finsn = (FieldInsnNode)insn;
                    if (!finsn.owner.equals(classNode.name)) continue;
                    finsn.name = renames.getOrDefault(finsn.name, finsn.name);
                }
            }
            return Patch.Result.APPLY;
        }
        return Patch.Result.PASS;
    }
}

