/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.next.pipeline.resolver.injection;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.next.env.MixinContext;
import org.sinytra.adapter.next.env.ann.AtData;
import org.sinytra.adapter.next.env.ann.MixinData;
import org.sinytra.adapter.next.pipeline.Recipe;
import org.sinytra.adapter.next.pipeline.config.Configuration;
import org.sinytra.adapter.next.pipeline.config.MutableConfiguration;
import org.sinytra.adapter.next.pipeline.resolver.SubResolver;
import org.sinytra.adapter.patch.analysis.InstructionMatcher;
import org.sinytra.adapter.patch.analysis.MethodCallAnalyzer;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.util.AdapterUtil;
import org.sinytra.adapter.patch.util.MethodQualifier;

public class ArbitraryInjectionPointSubResolver
implements SubResolver {
    private static final Set<String> ACCEPTED_ANNOTATIONS = Set.of("Lorg/spongepowered/asm/mixin/injection/Inject;", "Lorg/spongepowered/asm/mixin/injection/ModifyArg;", "Lcom/llamalad7/mixinextras/injector/ModifyExpressionValue;");
    private static final int INSN_RANGE = 5;

    @Override
    @Nullable
    public Configuration resolve(MixinData mixin, MixinContext context, Configuration clean, Configuration dirty, Recipe recipe) {
        String injectionPointTarget = clean.getAtData().getTarget().orElse(null);
        if (injectionPointTarget == null) {
            return null;
        }
        Data data = this.prepare(context, clean, dirty);
        if (data == null) {
            return null;
        }
        MethodInsnNode targetMethodCall = this.resolveTargetCallInsn(data, context, injectionPointTarget);
        if (targetMethodCall == null) {
            return null;
        }
        if (targetMethodCall.owner.equals(data.dirtyTarget().classNode().name)) {
            MethodContext.TargetPair target = context.methods().findOwnMethodPair(context.dirtyLookup(), MethodQualifier.create(targetMethodCall));
            if (target == null) {
                return null;
            }
            List<AbstractInsnNode> insns = context.methods().findInjectionTargetInsns(target);
            if (insns.isEmpty()) {
                Type returnType = Type.getReturnType((String)context.methodNode().desc);
                Type dirtyReturnType = Type.getReturnType((String)target.methodNode().desc);
                if (context.methodAnnotation().matchesDesc("Lcom/llamalad7/mixinextras/injector/ModifyExpressionValue;") && returnType.equals((Object)dirtyReturnType)) {
                    return MutableConfiguration.create().setAtData(new AtData("INVOKE", MethodQualifier.create(targetMethodCall).asDescriptor(), null));
                }
                return null;
            }
        }
        if (targetMethodCall.owner.equals(data.dirtyTarget().classNode().name) && !context.methodAnnotation().matchesDesc("Lorg/spongepowered/asm/mixin/injection/Inject;")) {
            return MutableConfiguration.create().setTargetMethod(MethodQualifier.create(targetMethodCall));
        }
        return MutableConfiguration.create().setAtData(new AtData("INVOKE", MethodQualifier.create(targetMethodCall).asDescriptor(), null));
    }

    private MethodInsnNode resolveTargetCallInsn(Data data, MixinContext context, String injectionPointTarget) {
        MethodNode dirtyTargetMethod = data.dirtyTarget().methodNode();
        AbstractInsnNode cleanInjectionInsn = data.cleanInjectionInsn();
        AbstractInsnNode nextCallCandidate = ArbitraryInjectionPointSubResolver.findCandidates(MethodCallAnalyzer.findBackwardsInstructions(cleanInjectionInsn, 5).inverse(), dirtyTargetMethod, List::getLast);
        if (nextCallCandidate != null) {
            return ArbitraryInjectionPointSubResolver.findReplacementInjectionPoint(nextCallCandidate, AbstractInsnNode::getNext, context, injectionPointTarget);
        }
        AbstractInsnNode previousCallCandidate = ArbitraryInjectionPointSubResolver.findCandidates(MethodCallAnalyzer.findForwardInstructions(cleanInjectionInsn, 5), dirtyTargetMethod, List::getFirst);
        if (previousCallCandidate != null) {
            return ArbitraryInjectionPointSubResolver.findReplacementInjectionPoint(previousCallCandidate, AbstractInsnNode::getPrevious, context, injectionPointTarget);
        }
        return null;
    }

    private Data prepare(MixinContext context, Configuration clean, Configuration dirty) {
        if (context.methodAnnotation().matchesAny(ACCEPTED_ANNOTATIONS)) {
            MethodQualifier dirtyQualifier = dirty.getTargetMethod();
            if (dirtyQualifier == null) {
                return null;
            }
            MethodContext.TargetPair dirtyTarget = context.methods().findOwnMethodPair(context.dirtyLookup(), dirtyQualifier);
            if (dirtyTarget == null) {
                return null;
            }
            MethodContext.TargetPair cleanTarget = context.methods().findOwnMethodPair(context.cleanLookup(), clean.getTargetMethod());
            List<AbstractInsnNode> cleanInsns = context.methods().findInjectionTargetInsns(cleanTarget);
            if (cleanInsns.size() == 1 && dirtyTarget != null) {
                AbstractInsnNode cleanInjectionInsn = cleanInsns.getFirst();
                return new Data(dirtyTarget, cleanInjectionInsn);
            }
        }
        return null;
    }

    private static AbstractInsnNode findCandidates(InstructionMatcher cleanMatcher, MethodNode dirtyTargetMethod, Function<List<AbstractInsnNode>, AbstractInsnNode> selector) {
        if (cleanMatcher.after().isEmpty()) {
            return null;
        }
        int firstOpcode = cleanMatcher.after().getFirst().getOpcode();
        ArrayList<AbstractInsnNode> candidates = new ArrayList<AbstractInsnNode>();
        for (AbstractInsnNode insn : dirtyTargetMethod.instructions) {
            AbstractInsnNode lastInsn;
            InstructionMatcher dirtyMatcher;
            if (insn instanceof FrameNode || insn instanceof LineNumberNode || insn.getOpcode() != firstOpcode || !cleanMatcher.test(dirtyMatcher = MethodCallAnalyzer.findForwardInstructionsDirect(insn, 5), 1) || (lastInsn = selector.apply(dirtyMatcher.after())) == null) continue;
            candidates.add(lastInsn);
        }
        return !candidates.isEmpty() ? (AbstractInsnNode)candidates.getFirst() : null;
    }

    private static MethodInsnNode findReplacementInjectionPoint(AbstractInsnNode lastInsn, UnaryOperator<AbstractInsnNode> flow, MixinContext context, String injectionPointTarget) {
        if (context.methodAnnotation().matchesDesc("Lcom/llamalad7/mixinextras/injector/ModifyExpressionValue;")) {
            Type desiredReturnType = Type.getReturnType((String)injectionPointTarget);
            return (MethodInsnNode)AdapterUtil.iterateInsns(lastInsn, flow, v -> {
                if (!(v instanceof MethodInsnNode)) return false;
                MethodInsnNode minsn = (MethodInsnNode)v;
                if (!Type.getReturnType((String)minsn.desc).equals((Object)desiredReturnType)) return false;
                return true;
            });
        }
        return (MethodInsnNode)AdapterUtil.iterateInsns(lastInsn, flow, v -> v instanceof MethodInsnNode);
    }

    private record Data(MethodContext.TargetPair dirtyTarget, AbstractInsnNode cleanInjectionInsn) {
    }
}

