/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.screen;

import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class ModernFixOptionInfoScreen
extends Screen {
    private final Screen lastScreen;
    private final Component description;

    public ModernFixOptionInfoScreen(Screen lastScreen, String optionName) {
        super((Component)Component.literal((String)optionName));
        this.lastScreen = lastScreen;
        this.description = Component.translatable((String)("modernfix.option." + optionName));
    }

    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new Button.Builder(CommonComponents.GUI_DONE, button -> this.onClose()).pos(this.width / 2 - 100, this.height - 29).size(200, 20).build());
    }

    public void onClose() {
        this.minecraft.setScreen(this.lastScreen);
    }

    private void drawMultilineString(GuiGraphics guiGraphics, Font fr, Component str, int x, int y) {
        for (FormattedCharSequence s : fr.split((FormattedText)str, this.width - 50)) {
            guiGraphics.drawString(fr, s, x, y, 0xFFFFFF, true);
            Objects.requireNonNull(fr);
            y += 9;
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 8, 0xFFFFFF);
        this.drawMultilineString(guiGraphics, this.minecraft.font, this.description, 10, 50);
    }
}

