/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.model.quad.properties;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import org.embeddedt.embeddium.api.util.ColorABGR;
import org.embeddedt.embeddium.impl.model.quad.ModelQuadView;

public class ModelQuadFlags {
    public static final int IS_PARTIAL = 1;
    public static final int IS_PARALLEL = 2;
    public static final int IS_ALIGNED = 4;
    public static final int IS_VANILLA_SHADED = 8;
    public static final int IS_TRUSTED_SPRITE = 16;
    public static final int IS_PASS_OPTIMIZABLE = 32;
    public static final int IS_POPULATED = Integer.MIN_VALUE;

    public static boolean contains(int flags, int mask) {
        return (flags & mask) != 0;
    }

    public static int getQuadFlags(ModelQuadView quad, Direction face, int existingFlags) {
        boolean bl;
        boolean parallel;
        boolean partial;
        boolean nonOpaqueColor;
        block39: {
            block38: {
                boolean bl2;
                float maxZ;
                float maxY;
                float maxX;
                float minZ;
                float minY;
                float minX;
                block37: {
                    block36: {
                        block35: {
                            minX = 32.0f;
                            minY = 32.0f;
                            minZ = 32.0f;
                            maxX = -32.0f;
                            maxY = -32.0f;
                            maxZ = -32.0f;
                            int numVertices = 4;
                            if (quad instanceof BakedQuad) {
                                BakedQuad bakedQuad = (BakedQuad)quad;
                                numVertices = Math.min(numVertices, bakedQuad.getVertices().length / 8);
                            }
                            float lX = Float.NaN;
                            float lY = Float.NaN;
                            float lZ = Float.NaN;
                            boolean degenerate = false;
                            nonOpaqueColor = false;
                            for (int i = 0; i < numVertices; ++i) {
                                float x = quad.getX(i);
                                float y = quad.getY(i);
                                float z = quad.getZ(i);
                                minX = Math.min(minX, x);
                                minY = Math.min(minY, y);
                                minZ = Math.min(minZ, z);
                                maxX = Math.max(maxX, x);
                                maxY = Math.max(maxY, y);
                                maxZ = Math.max(maxZ, z);
                                if (x == lX && y == lY && z == lZ) {
                                    degenerate = true;
                                } else {
                                    lX = x;
                                    lY = y;
                                    lZ = z;
                                }
                                if (ColorABGR.unpackAlpha(quad.getColor(i)) == 255) continue;
                                nonOpaqueColor = true;
                            }
                            if (degenerate) break block35;
                            switch (face.getAxis()) {
                                default: {
                                    throw new MatchException(null, null);
                                }
                                case X: {
                                    if (minY >= 1.0E-4f || minZ >= 1.0E-4f || maxY <= 0.9999f || maxZ <= 0.9999f) {
                                        break;
                                    }
                                    break block36;
                                }
                                case Y: {
                                    if (minX >= 1.0E-4f || minZ >= 1.0E-4f || maxX <= 0.9999f || maxZ <= 0.9999f) {
                                        break;
                                    }
                                    break block36;
                                }
                                case Z: {
                                    if (!(minX >= 1.0E-4f || minY >= 1.0E-4f || maxX <= 0.9999f) && !(maxY <= 0.9999f)) break block36;
                                }
                            }
                        }
                        bl2 = true;
                        break block37;
                    }
                    bl2 = false;
                }
                partial = bl2;
                switch (face.getAxis()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case X: {
                        boolean bl3;
                        if (minX == maxX) {
                            bl3 = true;
                            break;
                        }
                        bl3 = false;
                        break;
                    }
                    case Y: {
                        boolean bl3;
                        if (minY == maxY) {
                            bl3 = true;
                            break;
                        }
                        bl3 = false;
                        break;
                    }
                    case Z: {
                        boolean bl3 = parallel = minZ == maxZ;
                    }
                }
                if (!parallel) break block38;
                switch (face) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case DOWN: {
                        if (minY < 1.0E-4f) {
                            break;
                        }
                        break block38;
                    }
                    case UP: {
                        if (maxY > 0.9999f) {
                            break;
                        }
                        break block38;
                    }
                    case NORTH: {
                        if (minZ < 1.0E-4f) {
                            break;
                        }
                        break block38;
                    }
                    case SOUTH: {
                        if (maxZ > 0.9999f) {
                            break;
                        }
                        break block38;
                    }
                    case WEST: {
                        if (minX < 1.0E-4f) {
                            break;
                        }
                        break block38;
                    }
                    case EAST: {
                        if (!(maxX > 0.9999f)) break block38;
                    }
                }
                bl = true;
                break block39;
            }
            bl = false;
        }
        boolean aligned = bl;
        int flags = existingFlags & 0xFFFFFFF8;
        if (partial) {
            flags |= 1;
        }
        if (parallel) {
            flags |= 2;
        }
        if (aligned) {
            flags |= 4;
        }
        if (!nonOpaqueColor && (flags & 0x10) != 0) {
            flags |= 0x20;
        }
        return flags |= Integer.MIN_VALUE;
    }
}

