/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.mixin.features.shader.uniform;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.ShaderInstance;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={ShaderInstance.class}, priority=500)
public abstract class ShaderProgramMixin {
    @Shadow
    @Final
    private List<String> samplerNames;
    @Shadow
    @Final
    private int programId;
    @Shadow
    @Final
    private List<Uniform> uniforms;
    @Unique
    private Object2IntMap<String> uniformCache;
    private static final int DEFAULT_NUM_SAMPLERS = 12;
    private static String[] SAMPLER_IDS = ShaderProgramMixin.embeddium$makeSamplerIds(12);

    @Shadow
    public abstract void setSampler(String var1, Object var2);

    @Redirect(method={"apply"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/shaders/Uniform;glGetUniformLocation(ILjava/lang/CharSequence;)I"))
    private int redirectGetUniformLocation(int program, CharSequence name) {
        int location;
        if (this.uniformCache == null) {
            this.uniformCache = new Object2IntOpenHashMap();
            this.uniformCache.defaultReturnValue(-1);
            for (String samplerName : this.samplerNames) {
                int location2 = Uniform.glGetUniformLocation((int)this.programId, (CharSequence)samplerName);
                if (location2 == -1) continue;
                this.uniformCache.put((Object)samplerName, location2);
            }
        }
        if ((location = this.uniformCache.getInt((Object)name)) == -1) {
            throw new IllegalStateException("Failed to find uniform '%s' during shader bind".formatted(name));
        }
        return location;
    }

    @Redirect(method={"apply"}, at=@At(value="FIELD", target="Lnet/minecraft/client/renderer/ShaderInstance;uniforms:Ljava/util/List;", ordinal=0))
    private List<Uniform> uploadUniforms(ShaderInstance instance) {
        List<Uniform> uniforms = this.uniforms;
        for (int i = 0; i < uniforms.size(); ++i) {
            uniforms.get(i).upload();
        }
        return Collections.emptyList();
    }

    private static String[] embeddium$makeSamplerIds(int len) {
        String[] samplerIds = new String[len];
        for (int i = 0; i < len; ++i) {
            samplerIds[i] = "Sampler" + i;
        }
        return samplerIds;
    }

    @ModifyExpressionValue(method={"setDefaultUniforms"}, at={@At(value="CONSTANT", args={"intValue=12"}, ordinal=0)})
    private int setSamplersManually(int numSamplers) {
        String[] samplerIds = SAMPLER_IDS;
        if (samplerIds.length < numSamplers) {
            SAMPLER_IDS = samplerIds = ShaderProgramMixin.embeddium$makeSamplerIds(numSamplers);
        }
        for (int i = 0; i < numSamplers; ++i) {
            this.setSampler(samplerIds[i], RenderSystem.getShaderTexture((int)i));
        }
        return 0;
    }
}

