/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gl.util;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.embeddedt.embeddium.impl.gl.util.EnumBit;

public class EnumBitField<T extends Enum<T>> {
    private final EnumSet<T> set;
    private final int bitfield;

    private EnumBitField(EnumSet<T> set) {
        this.set = set;
        this.bitfield = EnumBitField.computeBitField(set);
    }

    private static <T extends Enum<T>> int computeBitField(Set<T> set) {
        int field = 0;
        for (Enum e : set) {
            field |= ((EnumBit)((Object)e)).getBits();
        }
        return field;
    }

    @SafeVarargs
    public static <T extends Enum<T>> EnumBitField<T> of(T ... values) {
        List<T> list = Arrays.asList(values);
        EnumSet<T> set = EnumSet.copyOf(list);
        return new EnumBitField<T>(set);
    }

    public int getBitField() {
        return this.bitfield;
    }

    public boolean contains(T flag) {
        return this.set.contains(flag);
    }
}

