/*
 * Decompiled with CFR 0.152.
 */
package me.kall.doespotatotick.integration.sodium;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import me.kall.doespotatotick.config.TickConfig;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.NeoForge;
import org.embeddedt.embeddium.api.OptionGUIConstructionEvent;
import org.embeddedt.embeddium.api.options.OptionIdentifier;
import org.embeddedt.embeddium.api.options.control.TickBoxControl;
import org.embeddedt.embeddium.api.options.structure.OptionGroup;
import org.embeddedt.embeddium.api.options.structure.OptionImpact;
import org.embeddedt.embeddium.api.options.structure.OptionImpl;
import org.embeddedt.embeddium.api.options.structure.OptionPage;
import org.embeddedt.embeddium.api.options.structure.OptionStorage;
import org.embeddedt.embeddium.impl.gui.EmbeddiumOptions;
import org.embeddedt.embeddium.impl.gui.options.storage.EmbeddiumOptionsStorage;
import org.jetbrains.annotations.NotNull;

public class SodiumIntegration {
    private static final EmbeddiumOptionsStorage storage = new EmbeddiumOptionsStorage();

    @NotNull
    private static List<OptionGroup> groups() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        OptionImpl<EmbeddiumOptions, Boolean> skipRenderingUntickable = SodiumIntegration.booleanOptionFor("doespotatotick.skip.untickable", "doespotatotick.skip.untickable.tooltip", TickConfig.Client.SKIP_RENDERING_UNTICKABLE, OptionImpact.HIGH);
        OptionImpl<EmbeddiumOptions, Boolean> projectileWeaponSkip = SodiumIntegration.booleanOptionFor("doespotatotick.skip.shoot", "doespotatotick.skip.shoot.tooltip", TickConfig.Client.PROJECTILE_WEAPON_SKIP, OptionImpact.LOW);
        groups.add(OptionGroup.createBuilder().add(skipRenderingUntickable).add(projectileWeaponSkip).build());
        return groups;
    }

    private static OptionImpl<EmbeddiumOptions, Boolean> booleanOptionFor(String name, String tooltip, ModConfigSpec.BooleanValue config, OptionImpact impact) {
        return OptionImpl.createBuilder(Boolean.class, (OptionStorage)storage).setName((Component)Component.translatable((String)name)).setTooltip((Component)Component.translatable((String)tooltip)).setControl(TickBoxControl::new).setBinding((sodiumGameOptions, value) -> config.set(value), sodiumGameOptions -> (Boolean)config.get()).setImpact(impact).build();
    }

    private static void onPageLoad(@NotNull OptionGUIConstructionEvent event) {
        event.addPage(new OptionPage(OptionIdentifier.create((String)"doespotatotick", (String)"config"), (Component)Component.translatable((String)"doespotatotick.page"), ImmutableList.copyOf(SodiumIntegration.groups())));
    }

    public static void register() {
        NeoForge.EVENT_BUS.addListener(SodiumIntegration::onPageLoad);
    }
}

