/*
 * Decompiled with CFR 0.152.
 */
package me.kall.doespotatotick.events;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import me.kall.doespotatotick.config.ConfigConstants;
import me.kall.doespotatotick.ext.Tickable;
import me.kall.doespotatotick.integration.ClaimManager;
import me.kall.duplicationless.data.EntityTracker;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ConfigEvents {
    private static final Set<UUID> PLAYERS = new HashSet<UUID>();
    private static final ResourceLocation ENEMIES = ResourceLocation.fromNamespaceAndPath((String)"doespotatotick", (String)"enemies");

    public static void filter(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull EntityTracker.EntityFilterRegistryEvent event) {
        if (ConfigConstants.detectEnemies) {
            event.register(ENEMIES, entity -> entity instanceof Enemy);
        }
    }

    public static void onChunkTick(long chunk, ServerLevel level) {
        if (!ConfigConstants.mobFarmDetection || level.getServer().getTickCount() % 100 != 0) {
            return;
        }
        level.getServer().execute(() -> {
            ObjectList enemies;
            if (ConfigConstants.detectEnemies && ConfigEvents.count((ObjectList<IntSet>)(enemies = EntityTracker.getEntityList((ServerLevel)level, (long)chunk, (ResourceLocation)ENEMIES))) >= ConfigConstants.mobFarmThreshold) {
                for (IntSet intSet : enemies) {
                    IntIterator intIterator = intSet.iterator();
                    while (intIterator.hasNext()) {
                        int id = (Integer)intIterator.next();
                        Entity entity = level.getEntity(id);
                        if (entity == null) continue;
                        ((Tickable)entity).dpt$setAlwaysTick(true);
                    }
                }
            }
            if (!ConfigConstants.mobFarmTypes.isEmpty()) {
                for (EntityType<?> mobFarmType : ConfigConstants.mobFarmTypes) {
                    ObjectList typedEntities = EntityTracker.getEntityList((ServerLevel)level, (long)chunk, mobFarmType);
                    if (ConfigEvents.count((ObjectList<IntSet>)typedEntities) < ConfigConstants.mobFarmThreshold) continue;
                    for (IntSet intSet : typedEntities) {
                        IntIterator intIterator = intSet.iterator();
                        while (intIterator.hasNext()) {
                            int id = (Integer)intIterator.next();
                            Entity entity = level.getEntity(id);
                            if (entity == null) continue;
                            ((Tickable)entity).dpt$setAlwaysTick(true);
                        }
                    }
                }
            }
        });
    }

    @Contract(pure=true)
    private static int count(@NotNull ObjectList<IntSet> entities) {
        int count = 0;
        for (IntSet intSet : entities) {
            count = intSet.size() + count;
        }
        return count;
    }

    public static void warn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player;
        if (ConfigConstants.notification && !PLAYERS.contains((player = event.getEntity()).getUUID())) {
            player.displayClientMessage((Component)Component.translatable((String)ConfigEvents.warnKey()), false);
            PLAYERS.add(player.getUUID());
        }
    }

    @Contract(pure=true)
    @NotNull
    private static String warnKey() {
        if (ClaimManager.FTB_LOADED && ClaimManager.OPAC_LOADED) {
            return "doespotatotick.warn.both.present";
        }
        if (ClaimManager.FTB_LOADED) {
            return "doespotatotick.warn.ftbchunks.present";
        }
        if (ClaimManager.OPAC_LOADED) {
            return "doespotatotick.warn.openpartiesandclaims.present";
        }
        return "doespotatotick.warn.notfound";
    }

    public static void reloadConfig(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ModConfigEvent.Reloading event) {
        if (event.getConfig().getModId().equals("doespotatotick")) {
            ConfigConstants.validate();
        }
    }

    public static void loadConfig(@NotNull FMLCommonSetupEvent event) {
        event.enqueueWork(ConfigConstants::validate);
    }
}

