/*
 * Decompiled with CFR 0.152.
 */
package me.kall.doespotatotick.config;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import me.kall.doespotatotick.config.TickConfig;
import me.kall.doespotatotick.ext.Tickable;
import me.kall.duplicationless.util.RegistryEntries;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class ConfigConstants {
    public static boolean entityOptimizable;
    public static int verticalChunks;
    public static int horizontalChunks;
    public static int mobFarmThreshold;
    public static boolean ignoreEnemies;
    public static boolean ignoreProjectiles;
    public static boolean ignoreProjectileTargets;
    public static boolean ignoreItems;
    public static boolean ignoreRaidersIfRaiding;
    public static boolean ignoreAnimals;
    public static boolean onlyLiving;
    public static boolean onlyEnemies;
    public static boolean onlyAnimals;
    public static boolean onlyWhenNoRaids;
    public static boolean notification;
    public static boolean mobFarmDetection;
    public static boolean detectEnemies;
    public static final Set<ResourceLocation> alwaysTickEntities;
    public static final Set<ResourceLocation> alwaysTickRaiders;
    public static final Set<ResourceLocation> validDimensions;
    public static final Set<EntityType<?>> mobFarmTypes;
    public static final Set<String> alwaysTickEntitiesModID;
    public static volatile boolean skipRenderingUntickable;
    public static boolean projectileWeaponSkip;

    public static void validate() {
        entityOptimizable = (Boolean)TickConfig.ENTITY_OPTIMIZATION.get();
        verticalChunks = (Integer)TickConfig.TICKABLE_VERTICAL_CHUNKS.get();
        horizontalChunks = (Integer)TickConfig.TICKABLE_HORIZONTAL_CHUNKS.get();
        ignoreEnemies = (Boolean)TickConfig.IGNORE_ENEMIES.get();
        ignoreProjectiles = (Boolean)TickConfig.IGNORE_PROJECTILES.get();
        ignoreProjectileTargets = (Boolean)TickConfig.IGNORE_PROJECTILES_TARGETS.get();
        ignoreItems = (Boolean)TickConfig.IGNORE_ITEMS.get();
        ignoreRaidersIfRaiding = (Boolean)TickConfig.IGNORE_RAIDERS_IF_RAIDING.get();
        ignoreAnimals = (Boolean)TickConfig.IGNORE_ANIMALS.get();
        onlyLiving = (Boolean)TickConfig.ONLY_LIVING.get();
        onlyEnemies = (Boolean)TickConfig.ONLY_ENEMIES.get();
        onlyAnimals = (Boolean)TickConfig.ONLY_ANIMALS.get();
        onlyWhenNoRaids = (Boolean)TickConfig.ONLY_WHEN_NO_RAIDS.get();
        notification = (Boolean)TickConfig.NOTIFICATION.get();
        mobFarmDetection = (Boolean)TickConfig.MOB_FARM_DETECTION.get();
        mobFarmThreshold = (Integer)TickConfig.MOB_FARM_THRESHOLD.get();
        detectEnemies = (Boolean)TickConfig.DETECT_ENEMIES.get();
        alwaysTickEntities.clear();
        alwaysTickEntitiesModID.clear();
        alwaysTickRaiders.clear();
        validDimensions.clear();
        mobFarmTypes.clear();
        ((List)TickConfig.ALWAYS_TICK_ENTITIES.get()).stream().map(ResourceLocation::parse).forEach(alwaysTickEntities::add);
        alwaysTickEntitiesModID.addAll((Collection)TickConfig.ALWAYS_TICK_ENTITIES_MOD_ID.get());
        ((List)TickConfig.ALWAYS_TICK_RAIDERS.get()).stream().map(ResourceLocation::parse).forEach(alwaysTickRaiders::add);
        ((List)TickConfig.VALID_DIMENSIONS.get()).stream().map(ResourceLocation::parse).forEach(validDimensions::add);
        ((List)TickConfig.MOB_FARM_TYPES.get()).stream().map(ResourceLocation::parse).map(RegistryEntries::entityType).forEach(mobFarmTypes::add);
        ConfigConstants.alwaysTickSetup();
        if (FMLLoader.getDist().isClient()) {
            ConfigConstants.validateClient();
        }
    }

    public static void validateClient() {
        skipRenderingUntickable = (Boolean)TickConfig.Client.SKIP_RENDERING_UNTICKABLE.get();
        projectileWeaponSkip = (Boolean)TickConfig.Client.PROJECTILE_WEAPON_SKIP.get();
    }

    public static void alwaysTickSetup() {
        for (Map.Entry entry : BuiltInRegistries.ENTITY_TYPE.entrySet()) {
            ResourceLocation id = ((ResourceKey)entry.getKey()).location();
            Tickable.EntityType entityType = (Tickable.EntityType)entry.getValue();
            if (alwaysTickEntities.contains(id) || alwaysTickEntitiesModID.contains(id.getNamespace())) {
                entityType.dpt$setAlwaysTick(true);
            }
            if (!alwaysTickRaiders.contains(id)) continue;
            entityType.dpt$setRaidTick(true);
        }
        Optional.ofNullable(ServerLifecycleHooks.getCurrentServer()).ifPresent(server -> server.getAllLevels().forEach(level -> level.getEntities().getAll().forEach(entity -> ((Tickable)entity).dpt$setAlwaysTick(((Tickable)entity).dpt$checkAlwaysTick()))));
    }

    static {
        alwaysTickEntities = new ObjectOpenHashSet();
        alwaysTickRaiders = new ObjectOpenHashSet();
        validDimensions = new ObjectOpenHashSet();
        mobFarmTypes = new ObjectOpenHashSet();
        alwaysTickEntitiesModID = new ObjectOpenHashSet();
    }
}

