/*
 * Decompiled with CFR 0.152.
 */
package forge.me.thosea.badoptimizations.mixin.tick;

import forge.me.thosea.badoptimizations.config.Config;
import forge.me.thosea.badoptimizations.hook.CacheHooks;
import forge.me.thosea.badoptimizations.interfaces.BiomeSkyColorGetter;
import forge.me.thosea.badoptimizations.utils.CommonColorFactors;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientLevel.class})
public abstract class MixinClientWorld
extends Level {
    @Shadow
    @Final
    private Minecraft minecraft;
    private final BiomeSkyColorGetter bo$biomeColors = BiomeSkyColorGetter.of(this.getBiomeManager());
    private final CommonColorFactors bo$commonFactors = CommonColorFactors.SKY_COLOR;
    private Vec3 bo$skyColorCache;
    private int bo$lastBiomeColor = Integer.MIN_VALUE;
    private Vec3 bo$biomeColorVector = Vec3.ZERO;

    @Inject(method={"getSkyColor(Lnet/minecraft/world/phys/Vec3;F)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetSkyColor(Vec3 cameraPos, float tickDelta, CallbackInfoReturnable<Vec3> cir) {
        if (this.bo$skyColorCache == null || this.minecraft.player == null) {
            return;
        }
        CommonColorFactors.tick();
        if (this.bo$commonFactors.didTickChange()) {
            if (this.bo$isBiomeDirty(cameraPos.subtract(2.0, 2.0, 2.0).scale(0.25))) {
                this.bo$commonFactors.updateLastTime();
                return;
            }
            if (this.bo$commonFactors.isDirty() || this.bo$commonFactors.getTimeDelta() >= (long)Config.skyColorTimeForUpdate || CacheHooks.invokeSkyColor()) {
                this.bo$skyColorCache = this.bo$calcSkyColor(tickDelta);
                this.bo$commonFactors.updateLastTime();
            }
        }
        cir.setReturnValue((Object)this.bo$skyColorCache);
    }

    private boolean bo$isBiomeDirty(Vec3 pos) {
        int z;
        int y;
        int x = Mth.floor((double)pos.x);
        int color = this.bo$biomeColors.get(x - 2, (y = Mth.floor((double)pos.y)) - 2, (z = Mth.floor((double)pos.z)) - 2);
        if (this.bo$lastBiomeColor != color) {
            this.bo$lastBiomeColor = color;
            this.bo$biomeColorVector = Vec3.fromRGB24((int)color);
            return true;
        }
        return this.bo$biomeColors.get(x + 3, y + 3, z + 3) != color;
    }

    @Shadow
    public abstract int getSkyFlashTime();

    @Shadow
    public abstract Vec3 getSkyColor(Vec3 var1, float var2);

    private Vec3 bo$calcSkyColor(float delta) {
        double color;
        float angle = Mth.cos((float)(this.getTimeOfDay(1.0f) * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        angle = Mth.clamp((float)angle, (float)0.0f, (float)1.0f);
        double x = this.bo$biomeColorVector.x * (double)angle;
        double y = this.bo$biomeColorVector.y * (double)angle;
        double z = this.bo$biomeColorVector.z * (double)angle;
        if (CommonColorFactors.rainGradientMultiplier > 0.0f) {
            color = (x * (double)0.3f + y * (double)0.59f + z * (double)0.11f) * (double)0.6f;
            x = x * (double)CommonColorFactors.rainGradientMultiplier + color * (1.0 - (double)CommonColorFactors.rainGradientMultiplier);
            y = y * (double)CommonColorFactors.rainGradientMultiplier + color * (1.0 - (double)CommonColorFactors.rainGradientMultiplier);
            z = z * (double)CommonColorFactors.rainGradientMultiplier + color * (1.0 - (double)CommonColorFactors.rainGradientMultiplier);
        }
        if (CommonColorFactors.thunderGradientMultiplier > 0.0f) {
            color = (x * (double)0.3f + y * (double)0.59f + z * (double)0.11f) * (double)0.2f;
            x = x * (double)CommonColorFactors.thunderGradientMultiplier + color * (1.0 - (double)CommonColorFactors.thunderGradientMultiplier);
            y = y * (double)CommonColorFactors.thunderGradientMultiplier + color * (1.0 - (double)CommonColorFactors.thunderGradientMultiplier);
            z = z * (double)CommonColorFactors.thunderGradientMultiplier + color * (1.0 - (double)CommonColorFactors.thunderGradientMultiplier);
        }
        if (CommonColorFactors.lastLightningTicks > 0) {
            float lightningMultiplier = (float)CommonColorFactors.lastLightningTicks - delta;
            if (lightningMultiplier > 1.0f) {
                lightningMultiplier = 1.0f;
            }
            x = x * (double)(1.0f - (lightningMultiplier *= 0.45f)) + (double)(0.8f * lightningMultiplier);
            y = y * (double)(1.0f - lightningMultiplier) + (double)(0.8f * lightningMultiplier);
            z = z * (double)(1.0f - lightningMultiplier) + (double)lightningMultiplier;
        }
        return new Vec3(x, y, z);
    }

    @Inject(method={"getSkyColor(Lnet/minecraft/world/phys/Vec3;F)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="RETURN")})
    private void afterGetSkyColor(Vec3 cameraPos, float tickDelta, CallbackInfoReturnable<Vec3> cir) {
        this.bo$skyColorCache = (Vec3)cir.getReturnValue();
    }

    protected MixinClientWorld(WritableLevelData properties, ResourceKey<Level> registryRef, RegistryAccess registryManager, Holder<DimensionType> dimensionEntry, Supplier<ProfilerFiller> profiler, boolean isClient, boolean debugWorld, long biomeAccess, int maxChainedNeighborUpdates) {
        super(properties, registryRef, registryManager, dimensionEntry, profiler, isClient, debugWorld, biomeAccess, maxChainedNeighborUpdates);
    }
}

