/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.nvidium.util;

import me.cortex.nvidium.Nvidium;
import me.cortex.nvidium.gl.RenderDevice;
import me.cortex.nvidium.gl.buffers.IDeviceMappedBuffer;
import me.cortex.nvidium.gl.buffers.PersistentSparseAddressableBuffer;
import me.cortex.nvidium.util.SegmentedManager;
import me.cortex.nvidium.util.UploadingBufferStream;

public class BufferArena {
    SegmentedManager segments = new SegmentedManager();
    private final RenderDevice device;
    public final IDeviceMappedBuffer buffer;
    private long totalQuads;
    private final int vertexFormatSize;
    private final long memory_size;

    public BufferArena(RenderDevice device, long memory, int vertexFormatSize) {
        this.device = device;
        this.vertexFormatSize = vertexFormatSize;
        this.memory_size = memory;
        if (Nvidium.SUPPORTS_PERSISTENT_SPARSE_ADDRESSABLE_BUFFER) {
            this.buffer = device.createSparseBuffer(80000000000L);
        } else {
            this.buffer = device.createDeviceOnlyMappedBuffer(memory);
            this.segments.setLimit(memory / (4L * (long)this.vertexFormatSize));
        }
        this.allocQuads(1);
    }

    public int allocQuads(int quadCount) {
        this.totalQuads += (long)quadCount;
        int addr = (int)this.segments.alloc(quadCount);
        if ((long)addr == -1L) {
            return addr;
        }
        IDeviceMappedBuffer iDeviceMappedBuffer = this.buffer;
        if (iDeviceMappedBuffer instanceof PersistentSparseAddressableBuffer) {
            PersistentSparseAddressableBuffer psab = (PersistentSparseAddressableBuffer)iDeviceMappedBuffer;
            psab.ensureAllocated(Integer.toUnsignedLong(addr) * 4L * (long)this.vertexFormatSize, (long)quadCount * 4L * (long)this.vertexFormatSize);
        }
        return addr;
    }

    public void free(int addr) {
        int count = this.segments.free(addr);
        this.totalQuads -= (long)count;
        IDeviceMappedBuffer iDeviceMappedBuffer = this.buffer;
        if (iDeviceMappedBuffer instanceof PersistentSparseAddressableBuffer) {
            PersistentSparseAddressableBuffer psab = (PersistentSparseAddressableBuffer)iDeviceMappedBuffer;
            psab.deallocate(Integer.toUnsignedLong(addr) * 4L * (long)this.vertexFormatSize, (long)count * 4L * (long)this.vertexFormatSize);
        }
    }

    public long upload(UploadingBufferStream stream, int addr) {
        return stream.upload(this.buffer, Integer.toUnsignedLong(addr) * 4L * (long)this.vertexFormatSize, (int)this.segments.getSize(addr) * 4 * this.vertexFormatSize);
    }

    public void delete() {
        this.buffer.delete();
    }

    public int getAllocatedMB() {
        IDeviceMappedBuffer iDeviceMappedBuffer = this.buffer;
        if (iDeviceMappedBuffer instanceof PersistentSparseAddressableBuffer) {
            PersistentSparseAddressableBuffer psab = (PersistentSparseAddressableBuffer)iDeviceMappedBuffer;
            return (int)((long)psab.getPagesCommitted() * 0x100000L / 0x100000L);
        }
        return (int)(this.memory_size / 0x100000L);
    }

    public int getUsedMB() {
        return (int)(this.totalQuads * (long)this.vertexFormatSize * 4L / 0x100000L);
    }

    public long getMemoryUsed() {
        IDeviceMappedBuffer iDeviceMappedBuffer = this.buffer;
        if (iDeviceMappedBuffer instanceof PersistentSparseAddressableBuffer) {
            PersistentSparseAddressableBuffer psab = (PersistentSparseAddressableBuffer)iDeviceMappedBuffer;
            return (long)psab.getPagesCommitted() * 0x100000L;
        }
        return this.memory_size;
    }

    public float getFragmentation() {
        long expected = this.totalQuads * (long)this.vertexFormatSize * 4L;
        return (float)((double)expected / (double)this.getMemoryUsed());
    }

    public boolean canReuse(int addr, int quads) {
        return this.segments.getSize(addr) == (long)quads;
    }
}

