/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.profiler;

import ca.spottedleaf.moonrise.patches.profiler.LProfileGraph;
import ca.spottedleaf.moonrise.patches.profiler.LProfilerRegistry;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.text.DecimalFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;

public final class LeafProfiler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ThreadLocal<DecimalFormat> THREE_DECIMAL_PLACES = ThreadLocal.withInitial(() -> new DecimalFormat("#,##0.000"));
    private static final ThreadLocal<DecimalFormat> NO_DECIMAL_PLACES = ThreadLocal.withInitial(() -> new DecimalFormat("#,##0"));
    public final LProfilerRegistry registry;
    private final LProfileGraph graph;
    private long[] accumulatedTimers = new long[0];
    private long[] accumulatedCounters = new long[0];
    private long[] timers = new long[16];
    private long[] counters = new long[16];
    private final IntArrayFIFOQueue callStack = new IntArrayFIFOQueue();
    private int topOfStack = 0;
    private final LongArrayFIFOQueue timerStack = new LongArrayFIFOQueue();
    private long lastTimerStart = 0L;

    public LeafProfiler(LProfilerRegistry registry, LProfileGraph graph) {
        this.registry = registry;
        this.graph = graph;
    }

    private static void add(long[] dst, long[] src) {
        int srcLen = src.length;
        Objects.checkFromToIndex(0, srcLen, dst.length);
        for (int i = 0; i < srcLen; ++i) {
            int n = i;
            dst[n] = dst[n] + src[i];
        }
    }

    public ProfilingData copyCurrent() {
        return new ProfilingData(this.registry, this.graph, (long[])this.timers.clone(), (long[])this.counters.clone());
    }

    public ProfilingData copyAccumulated() {
        return new ProfilingData(this.registry, this.graph, (long[])this.accumulatedTimers.clone(), (long[])this.accumulatedCounters.clone());
    }

    public void accumulate() {
        if (this.accumulatedTimers.length != this.timers.length) {
            this.accumulatedTimers = Arrays.copyOf(this.accumulatedTimers, this.timers.length);
        }
        LeafProfiler.add(this.accumulatedTimers, this.timers);
        Arrays.fill(this.timers, 0L);
        if (this.accumulatedCounters.length != this.counters.length) {
            this.accumulatedCounters = Arrays.copyOf(this.accumulatedCounters, this.counters.length);
        }
        LeafProfiler.add(this.accumulatedCounters, this.counters);
        Arrays.fill(this.counters, 0L);
    }

    public void clearCurrent() {
        Arrays.fill(this.timers, 0L);
        Arrays.fill(this.counters, 0L);
    }

    private long[] resizeTimers(long[] old, int least) {
        this.timers = Arrays.copyOf(old, Math.max(old.length * 2, least * 2));
        return this.timers;
    }

    private void incrementTimersDirect(int nodeId, long count) {
        long[] timers = this.timers;
        if (nodeId >= timers.length) {
            long[] lArray = this.resizeTimers(timers, nodeId);
            int n = nodeId;
            lArray[n] = lArray[n] + count;
        } else {
            int n = nodeId;
            timers[n] = timers[n] + count;
        }
    }

    private long[] resizeCounters(long[] old, int least) {
        this.counters = Arrays.copyOf(old, Math.max(old.length * 2, least * 2));
        return this.counters;
    }

    private void incrementCountersDirect(int nodeId, long count) {
        long[] counters = this.counters;
        if (nodeId >= counters.length) {
            long[] lArray = this.resizeCounters(counters, nodeId);
            int n = nodeId;
            lArray[n] = lArray[n] + count;
        } else {
            int n = nodeId;
            counters[n] = counters[n] + count;
        }
    }

    public void incrementCounter(int timerId, long count) {
        int node = this.graph.getOrCreateNode(this.topOfStack, timerId);
        this.incrementCountersDirect(node, count);
    }

    public void incrementTimer(int timerId, long count) {
        int node = this.graph.getOrCreateNode(this.topOfStack, timerId);
        this.incrementTimersDirect(node, count);
    }

    public void startTimer(int timerId, long startTime) {
        long lastTimerStart = this.lastTimerStart;
        LProfileGraph graph = this.graph;
        int parentNode = this.topOfStack;
        IntArrayFIFOQueue callStack = this.callStack;
        LongArrayFIFOQueue timerStack = this.timerStack;
        this.lastTimerStart = startTime;
        this.topOfStack = graph.getOrCreateNode(parentNode, timerId);
        callStack.enqueue(parentNode);
        timerStack.enqueue(lastTimerStart);
    }

    public void stopTimer(int timerId, long endTime) {
        long lastStart = this.lastTimerStart;
        int currentNode = this.topOfStack;
        IntArrayFIFOQueue callStack = this.callStack;
        LongArrayFIFOQueue timerStack = this.timerStack;
        this.lastTimerStart = timerStack.dequeueLastLong();
        this.topOfStack = callStack.dequeueLastInt();
        if (currentNode != this.graph.getNode(this.topOfStack, timerId)) {
            LProfilerRegistry.ProfilerEntry timer = this.registry.getById(timerId);
            throw new IllegalStateException("Timer " + (timer == null ? "null" : timer.name()) + " did not stop");
        }
        this.incrementTimersDirect(currentNode, endTime - lastStart);
        this.incrementCountersDirect(currentNode, 1L);
    }

    public void stopLastTimer(long endTime) {
        long lastStart = this.lastTimerStart;
        int currentNode = this.topOfStack;
        IntArrayFIFOQueue callStack = this.callStack;
        LongArrayFIFOQueue timerStack = this.timerStack;
        this.lastTimerStart = timerStack.dequeueLastLong();
        this.topOfStack = callStack.dequeueLastInt();
        this.incrementTimersDirect(currentNode, endTime - lastStart);
        this.incrementCountersDirect(currentNode, 1L);
    }

    public record ProfilingData(LProfilerRegistry registry, LProfileGraph graph, long[] timers, long[] counters) {
        public List<String> dumpToString() {
            ProfileNode profileNode;
            List<LProfileGraph.GraphNode> graphDFS = this.graph.getDFS();
            Reference2ReferenceOpenHashMap nodeMap = new Reference2ReferenceOpenHashMap();
            ArrayDeque<ProfileNode> orderedNodes = new ArrayDeque<ProfileNode>();
            int len = graphDFS.size();
            for (int i = 0; i < len; ++i) {
                LProfileGraph.GraphNode graphNode = graphDFS.get(i);
                ProfileNode parent = (ProfileNode)nodeMap.get((Object)graphNode.parent());
                int nodeId = graphNode.nodeId();
                long totalTime = nodeId >= this.timers.length ? 0L : this.timers[nodeId];
                long totalCount = nodeId >= this.counters.length ? 0L : this.counters[nodeId];
                LProfilerRegistry.ProfilerEntry profiler = this.registry.getById(graphNode.timerId());
                ProfileNode profileNode2 = new ProfileNode(parent, nodeId, profiler, totalTime, totalCount);
                if (parent != null) {
                    parent.childrenTimingCount += totalTime;
                    parent.children.add(profileNode2);
                } else {
                    if (i != 0) {
                        throw new IllegalStateException("Node " + nodeId + " must have parent");
                    }
                    orderedNodes.add(profileNode2);
                }
                nodeMap.put((Object)graphNode, (Object)profileNode2);
            }
            ArrayList<String> ret = new ArrayList<String>();
            long totalTime = 0L;
            for (ProfileNode node : ((ProfileNode)orderedNodes.peekFirst()).children) {
                totalTime += node.totalTime;
            }
            ArrayDeque<ProfileNode> flatOrderedNodes = new ArrayDeque<ProfileNode>();
            while ((profileNode = (ProfileNode)orderedNodes.pollFirst()) != null) {
                int depth = profileNode.depth;
                profileNode.children.sort((p1, p2) -> {
                    int typeCompare = p1.profiler.type().compareTo(p2.profiler.type());
                    if (typeCompare != 0) {
                        return typeCompare;
                    }
                    if (p1.profiler.type() == LProfilerRegistry.ProfileType.COUNTER) {
                        return Long.compare(p2.totalCount, p1.totalCount);
                    }
                    return Long.compare(p2.totalTime, p1.totalTime);
                });
                boolean first = true;
                for (int i = profileNode.children.size() - 1; i >= 0; --i) {
                    ProfileNode child = profileNode.children.get(i);
                    if (child.totalCount == 0L) continue;
                    if (first) {
                        child.lastChild = true;
                        first = false;
                    }
                    child.depth = depth + 1;
                    orderedNodes.addFirst(child);
                }
                flatOrderedNodes.addLast(profileNode);
            }
            StringBuilder builder = new StringBuilder();
            IntArrayList closed = new IntArrayList();
            block8: while ((profileNode = (ProfileNode)flatOrderedNodes.pollFirst()) != null) {
                int depth = profileNode.depth;
                closed.removeIf(d -> d >= depth);
                if (profileNode.lastChild) {
                    closed.add(depth);
                }
                if (profileNode.nodeId == 0) continue;
                boolean noParent = profileNode.parent == null || profileNode.parent.nodeId == 0;
                long parentTime = noParent ? totalTime : profileNode.parent.totalTime;
                LProfilerRegistry.ProfilerEntry profilerEntry = profileNode.profiler;
                builder.setLength(0);
                for (int i = 0; i < depth; ++i) {
                    if (i == depth - 1) {
                        if (flatOrderedNodes.peekFirst() == null || profileNode.lastChild) {
                            builder.append("  \u2514\u2500");
                            continue;
                        }
                        builder.append("  \u251c\u2500");
                        continue;
                    }
                    if (!closed.contains(i + 1)) {
                        builder.append("  \u2502 ");
                        continue;
                    }
                    builder.append("    ");
                }
                switch (profilerEntry.type()) {
                    case TIMER: {
                        ret.add(builder.append(profilerEntry.name()).append(' ').append(THREE_DECIMAL_PLACES.get().format((double)profileNode.totalTime / (double)totalTime * 100.0)).append("% total, ").append(THREE_DECIMAL_PLACES.get().format((double)profileNode.totalTime / (double)parentTime * 100.0)).append("% parent, self ").append(THREE_DECIMAL_PLACES.get().format((double)(profileNode.totalTime - profileNode.childrenTimingCount) / (double)totalTime * 100.0)).append("% total, self ").append(THREE_DECIMAL_PLACES.get().format((double)(profileNode.totalTime - profileNode.childrenTimingCount) / (double)profileNode.totalTime * 100.0)).append("% children, avg ").append(THREE_DECIMAL_PLACES.get().format((double)profileNode.totalCount / (double)(noParent ? 1L : profileNode.parent.totalCount))).append(" sum ").append(NO_DECIMAL_PLACES.get().format(profileNode.totalCount)).append(", ").append(THREE_DECIMAL_PLACES.get().format((double)profileNode.totalTime / 1000000.0)).append("ms raw sum").toString());
                        continue block8;
                    }
                    case COUNTER: {
                        ret.add(builder.append('#').append(profilerEntry.name()).append(" avg ").append(THREE_DECIMAL_PLACES.get().format((double)profileNode.totalCount / (double)(noParent ? 1L : profileNode.parent.totalCount))).append(" sum ").append(NO_DECIMAL_PLACES.get().format(profileNode.totalCount)).toString());
                        continue block8;
                    }
                }
                throw new IllegalStateException("Unknown type " + String.valueOf((Object)profilerEntry.type()));
            }
            return ret;
        }
    }

    private static final class ProfileNode {
        public final ProfileNode parent;
        public final int nodeId;
        public final LProfilerRegistry.ProfilerEntry profiler;
        public final long totalTime;
        public final long totalCount;
        public final List<ProfileNode> children = new ArrayList<ProfileNode>();
        public long childrenTimingCount;
        public int depth = -1;
        public boolean lastChild;

        private ProfileNode(ProfileNode parent, int nodeId, LProfilerRegistry.ProfilerEntry profiler, long totalTime, long totalCount) {
            this.parent = parent;
            this.nodeId = nodeId;
            this.profiler = profiler;
            this.totalTime = totalTime;
            this.totalCount = totalCount;
        }
    }
}

