/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.profiler;

import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;

public final class LProfilerRegistry {
    private volatile ProfilerEntry[] typesById = new ProfilerEntry[16];
    private int totalEntries;
    private final ConcurrentHashMap<String, ProfilerEntry> nameToEntry = new ConcurrentHashMap();

    public ProfilerEntry getById(int id) {
        ProfilerEntry[] entries = this.typesById;
        return id < 0 || id >= entries.length ? null : entries[id];
    }

    public ProfilerEntry getByName(String name) {
        return this.nameToEntry.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOrCreateType(ProfileType type, String name) {
        ProfilerEntry entry = this.nameToEntry.get(name);
        if (entry != null) {
            return entry.id;
        }
        LProfilerRegistry lProfilerRegistry = this;
        synchronized (lProfilerRegistry) {
            entry = this.nameToEntry.get(name);
            if (entry != null) {
                return entry.id;
            }
            return this.createType(type, name);
        }
    }

    public int getOrCreateTimer(String name) {
        return this.getOrCreateType(ProfileType.TIMER, name);
    }

    public int getOrCreateCounter(String name) {
        return this.getOrCreateType(ProfileType.COUNTER, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createType(ProfileType type, String name) {
        LProfilerRegistry lProfilerRegistry = this;
        synchronized (lProfilerRegistry) {
            int id = this.totalEntries++;
            ProfilerEntry ret = new ProfilerEntry(type, name, id);
            ProfilerEntry prev = this.nameToEntry.putIfAbsent(name, ret);
            if (prev != null) {
                throw new IllegalStateException("Entry already exists: " + String.valueOf(prev));
            }
            ProfilerEntry[] entries = this.typesById;
            if (id >= entries.length) {
                this.typesById = entries = Arrays.copyOf(entries, entries.length * 2);
            }
            entries[id] = ret;
            return id;
        }
    }

    public record ProfilerEntry(ProfileType type, String name, int id) {
    }

    public static enum ProfileType {
        COUNTER,
        TIMER;

    }
}

