/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.chunk_system.level.poi;

import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.level.poi.ChunkSystemPoiManager;
import ca.spottedleaf.moonrise.patches.chunk_system.level.poi.ChunkSystemPoiSection;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import net.minecraft.SharedConstants;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiSection;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PoiChunk {
    private static final Logger LOGGER = LoggerFactory.getLogger(PoiChunk.class);
    public final ServerLevel world;
    public final int chunkX;
    public final int chunkZ;
    public final int minSection;
    public final int maxSection;
    private final PoiSection[] sections;
    private boolean isDirty;
    private boolean loaded;

    public PoiChunk(ServerLevel world, int chunkX, int chunkZ, int minSection, int maxSection) {
        this(world, chunkX, chunkZ, minSection, maxSection, new PoiSection[maxSection - minSection + 1]);
    }

    public PoiChunk(ServerLevel world, int chunkX, int chunkZ, int minSection, int maxSection, PoiSection[] sections) {
        this.world = world;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.minSection = minSection;
        this.maxSection = maxSection;
        this.sections = sections;
        if (this.sections.length != maxSection - minSection + 1) {
            throw new IllegalStateException("Incorrect length used, expected " + (maxSection - minSection + 1) + ", got " + this.sections.length);
        }
    }

    public void load() {
        TickThread.ensureTickThread((Level)this.world, this.chunkX, this.chunkZ, "Loading in poi chunk off-main");
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        ((ChunkSystemPoiManager)this.world.getChunkSource().getPoiManager()).moonrise$loadInPoiChunk(this);
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isEmpty() {
        for (PoiSection section : this.sections) {
            if (section == null || ((ChunkSystemPoiSection)section).moonrise$isEmpty()) continue;
            return false;
        }
        return true;
    }

    public PoiSection getOrCreateSection(int chunkY) {
        if (chunkY >= this.minSection && chunkY <= this.maxSection) {
            int idx = chunkY - this.minSection;
            PoiSection ret = this.sections[idx];
            if (ret != null) {
                return ret;
            }
            PoiManager poiManager = this.world.getPoiManager();
            long key = CoordinateUtils.getChunkSectionKey(this.chunkX, chunkY, this.chunkZ);
            this.sections[idx] = new PoiSection(() -> poiManager.setDirty(key));
            return this.sections[idx];
        }
        throw new IllegalArgumentException("chunkY is out of bounds, chunkY: " + chunkY + " outside [" + this.minSection + "," + this.maxSection + "]");
    }

    public PoiSection getSection(int chunkY) {
        if (chunkY >= this.minSection && chunkY <= this.maxSection) {
            return this.sections[chunkY - this.minSection];
        }
        return null;
    }

    public Optional<PoiSection> getSectionForVanilla(int chunkY) {
        if (chunkY >= this.minSection && chunkY <= this.maxSection) {
            PoiSection ret = this.sections[chunkY - this.minSection];
            return ret == null ? Optional.empty() : ((ChunkSystemPoiSection)ret).moonrise$asOptional();
        }
        return Optional.empty();
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    public CompoundTag save() {
        RegistryOps registryOps = RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)this.world.registryAccess());
        CompoundTag ret = new CompoundTag();
        CompoundTag sections = new CompoundTag();
        ret.put("Sections", (Tag)sections);
        ret.putInt("DataVersion", SharedConstants.getCurrentVersion().getDataVersion().getVersion());
        ServerLevel world = this.world;
        PoiManager poiManager = world.getPoiManager();
        int chunkX = this.chunkX;
        int chunkZ = this.chunkZ;
        for (int sectionY = this.minSection; sectionY <= this.maxSection; ++sectionY) {
            int finalSectionY;
            long key;
            Codec codec;
            DataResult serializedResult;
            Tag serialized;
            PoiSection section = this.sections[sectionY - this.minSection];
            if (section == null || ((ChunkSystemPoiSection)section).moonrise$isEmpty() || (serialized = (Tag)(serializedResult = (codec = PoiSection.codec(() -> PoiChunk.lambda$save$1(poiManager, key = CoordinateUtils.getChunkSectionKey(chunkX, sectionY, chunkZ)))).encodeStart((DynamicOps)registryOps, (Object)section)).resultOrPartial(arg_0 -> PoiChunk.lambda$save$2(world, chunkX, finalSectionY = sectionY, chunkZ, arg_0)).orElse(null)) == null) continue;
            sections.put(Integer.toString(sectionY), serialized);
        }
        return sections.isEmpty() ? null : ret;
    }

    public static PoiChunk empty(ServerLevel world, int chunkX, int chunkZ) {
        PoiChunk ret = new PoiChunk(world, chunkX, chunkZ, WorldUtil.getMinSection((Level)world), WorldUtil.getMaxSection((Level)world));
        ret.loaded = true;
        return ret;
    }

    public static PoiChunk parse(ServerLevel world, int chunkX, int chunkZ, CompoundTag data) {
        PoiChunk ret = PoiChunk.empty(world, chunkX, chunkZ);
        RegistryOps registryOps = RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)world.registryAccess());
        CompoundTag sections = data.getCompound("Sections");
        if (sections.isEmpty()) {
            return ret;
        }
        PoiManager poiManager = world.getPoiManager();
        boolean readAnything = false;
        for (int sectionY = ret.minSection; sectionY <= ret.maxSection; ++sectionY) {
            int finalSectionY;
            CompoundTag section;
            long coordinateKey;
            Codec codec;
            DataResult deserializeResult;
            PoiSection deserialized;
            String key = Integer.toString(sectionY);
            if (!sections.contains(key) || (deserialized = (PoiSection)(deserializeResult = (codec = PoiSection.codec(() -> PoiChunk.lambda$parse$3(poiManager, coordinateKey = CoordinateUtils.getChunkSectionKey(chunkX, sectionY, chunkZ)))).parse((DynamicOps)registryOps, (Object)(section = sections.getCompound(key)))).resultOrPartial(arg_0 -> PoiChunk.lambda$parse$4(world, chunkX, finalSectionY = sectionY, chunkZ, arg_0)).orElse(null)) == null || ((ChunkSystemPoiSection)deserialized).moonrise$isEmpty()) continue;
            readAnything = true;
            ret.sections[sectionY - ret.minSection] = deserialized;
        }
        ret.loaded = !readAnything;
        return ret;
    }

    private static /* synthetic */ void lambda$parse$4(ServerLevel world, int chunkX, int finalSectionY, int chunkZ, String description) {
        LOGGER.error("Failed to deserialize poi chunk for world: " + WorldUtil.getWorldName((Level)world) + ", chunk: (" + chunkX + "," + finalSectionY + "," + chunkZ + "); description: " + description);
    }

    private static /* synthetic */ void lambda$parse$3(PoiManager poiManager, long coordinateKey) {
        poiManager.setDirty(coordinateKey);
    }

    private static /* synthetic */ void lambda$save$2(ServerLevel world, int chunkX, int finalSectionY, int chunkZ, String description) {
        LOGGER.error("Failed to serialize poi chunk for world: " + WorldUtil.getWorldName((Level)world) + ", chunk: (" + chunkX + "," + finalSectionY + "," + chunkZ + "); description: " + description);
    }

    private static /* synthetic */ void lambda$save$1(PoiManager poiManager, long key) {
        poiManager.setDirty(key);
    }
}

