/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.chunk_system.level.entity.server;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.common.list.ReferenceList;
import ca.spottedleaf.moonrise.common.util.ChunkSystem;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemServerLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.ChunkEntitySlices;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.EntityLookup;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.LevelCallback;

public final class ServerEntityLookup
extends EntityLookup {
    private static final Entity[] EMPTY_ENTITY_ARRAY = new Entity[0];
    private final ServerLevel serverWorld;
    public final ReferenceList<Entity> trackerEntities = new ReferenceList<Entity>(EMPTY_ENTITY_ARRAY);

    public ServerEntityLookup(ServerLevel world, LevelCallback<Entity> worldCallback) {
        super((Level)world, worldCallback);
        this.serverWorld = world;
    }

    @Override
    protected Boolean blockTicketUpdates() {
        return ((ChunkSystemServerLevel)this.serverWorld).moonrise$getChunkTaskScheduler().chunkHolderManager.blockTicketUpdates();
    }

    @Override
    protected void setBlockTicketUpdates(Boolean value) {
        ((ChunkSystemServerLevel)this.serverWorld).moonrise$getChunkTaskScheduler().chunkHolderManager.unblockTicketUpdates(value);
    }

    @Override
    protected void checkThread(int chunkX, int chunkZ, String reason) {
        TickThread.ensureTickThread((Level)this.serverWorld, chunkX, chunkZ, reason);
    }

    @Override
    protected void checkThread(Entity entity, String reason) {
        TickThread.ensureTickThread(entity, reason);
    }

    @Override
    protected ChunkEntitySlices createEntityChunk(int chunkX, int chunkZ, boolean transientChunk) {
        return ((ChunkSystemServerLevel)this.serverWorld).moonrise$getChunkTaskScheduler().chunkHolderManager.getOrCreateEntityChunk(chunkX, chunkZ, transientChunk);
    }

    @Override
    protected void onEmptySlices(int chunkX, int chunkZ) {
    }

    @Override
    protected void entitySectionChangeCallback(Entity entity, int oldSectionX, int oldSectionY, int oldSectionZ, int newSectionX, int newSectionY, int newSectionZ) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ((ChunkSystemServerLevel)this.serverWorld).moonrise$getNearbyPlayers().tickPlayer(player);
        }
        PlatformHooks.get().entityMove(entity, CoordinateUtils.getChunkSectionKey(oldSectionX, oldSectionY, oldSectionZ), CoordinateUtils.getChunkSectionKey(newSectionX, newSectionY, newSectionZ));
    }

    @Override
    protected void addEntityCallback(Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ((ChunkSystemServerLevel)this.serverWorld).moonrise$getNearbyPlayers().addPlayer(player);
        }
    }

    @Override
    protected void removeEntityCallback(Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ((ChunkSystemServerLevel)this.serverWorld).moonrise$getNearbyPlayers().removePlayer(player);
        }
    }

    @Override
    protected void entityStartLoaded(Entity entity) {
        this.trackerEntities.add(entity);
    }

    @Override
    protected void entityEndLoaded(Entity entity) {
        this.trackerEntities.remove(entity);
    }

    @Override
    protected void entityStartTicking(Entity entity) {
    }

    @Override
    protected void entityEndTicking(Entity entity) {
    }

    @Override
    protected boolean screenEntity(Entity entity, boolean fromDisk, boolean event) {
        return ChunkSystem.screenEntity(this.serverWorld, entity, fromDisk, event);
    }
}

