/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.chunk_system.level.entity;

import ca.spottedleaf.moonrise.common.list.EntityList;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.map.ConcurrentLong2ReferenceChainedHashTable;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.map.SWMRLong2ObjectHashTable;
import ca.spottedleaf.moonrise.patches.chunk_system.entity.ChunkSystemEntity;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.ChunkEntitySlices;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.Visibility;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EntityLookup
implements LevelEntityGetter<Entity> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityLookup.class);
    protected static final int REGION_SHIFT = 5;
    protected static final int REGION_MASK = 31;
    protected static final int REGION_SIZE = 32;
    public final Level world;
    protected final SWMRLong2ObjectHashTable<ChunkSlicesRegion> regions = new SWMRLong2ObjectHashTable(128, 0.5f);
    protected final LevelCallback<Entity> worldCallback;
    protected final ConcurrentLong2ReferenceChainedHashTable<Entity> entityById = new ConcurrentLong2ReferenceChainedHashTable();
    protected final ConcurrentHashMap<UUID, Entity> entityByUUID = new ConcurrentHashMap();
    protected final EntityList accessibleEntities = new EntityList();

    public EntityLookup(Level world, LevelCallback<Entity> worldCallback) {
        this.world = world;
        this.worldCallback = worldCallback;
    }

    protected abstract Boolean blockTicketUpdates();

    protected abstract void setBlockTicketUpdates(Boolean var1);

    protected abstract void checkThread(int var1, int var2, String var3);

    protected abstract void checkThread(Entity var1, String var2);

    protected abstract ChunkEntitySlices createEntityChunk(int var1, int var2, boolean var3);

    protected abstract void onEmptySlices(int var1, int var2);

    protected abstract void entitySectionChangeCallback(Entity var1, int var2, int var3, int var4, int var5, int var6, int var7);

    protected abstract void addEntityCallback(Entity var1);

    protected abstract void removeEntityCallback(Entity var1);

    protected abstract void entityStartLoaded(Entity var1);

    protected abstract void entityEndLoaded(Entity var1);

    protected abstract void entityStartTicking(Entity var1);

    protected abstract void entityEndTicking(Entity var1);

    protected abstract boolean screenEntity(Entity var1, boolean var2, boolean var3);

    private static Entity maskNonAccessible(Entity entity) {
        if (entity == null) {
            return null;
        }
        Visibility visibility = EntityLookup.getEntityStatus(entity);
        return visibility.isAccessible() ? entity : null;
    }

    public Entity get(int id) {
        return EntityLookup.maskNonAccessible(this.entityById.get(id));
    }

    public Entity get(UUID id) {
        return EntityLookup.maskNonAccessible(id == null ? null : this.entityByUUID.get(id));
    }

    public boolean hasEntity(UUID uuid) {
        return this.get(uuid) != null;
    }

    public String getDebugInfo() {
        return "count_id:" + this.entityById.size() + ",count_uuid:" + this.entityByUUID.size() + ",count_accessible:" + this.getEntityCount() + ",region_count:" + this.regions.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<Entity> getAll() {
        EntityList entityList = this.accessibleEntities;
        synchronized (entityList) {
            int len = this.accessibleEntities.size();
            Entity[] cpy = (Entity[])Arrays.copyOf(this.accessibleEntities.getRawData(), len, Entity[].class);
            Objects.checkFromToIndex(0, len, cpy.length);
            return new ArrayIterable<Entity>(cpy, 0, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEntityCount() {
        EntityList entityList = this.accessibleEntities;
        synchronized (entityList) {
            return this.accessibleEntities.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entity[] getAllCopy() {
        EntityList entityList = this.accessibleEntities;
        synchronized (entityList) {
            return (Entity[])Arrays.copyOf(this.accessibleEntities.getRawData(), this.accessibleEntities.size(), Entity[].class);
        }
    }

    public <U extends Entity> void get(EntityTypeTest<Entity, U> filter, AbortableIterationConsumer<U> action) {
        Entity casted;
        Entity entity;
        Visibility visibility;
        Iterator<Entity> iterator = this.entityById.valueIterator();
        while (!(!iterator.hasNext() || (visibility = EntityLookup.getEntityStatus(entity = iterator.next())).isAccessible() && (casted = (Entity)filter.tryCast((Object)entity)) != null && action.accept((Object)casted).shouldAbort())) {
        }
    }

    public void get(AABB box, Consumer<Entity> action) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        this.getEntitiesWithoutDragonParts(null, box, entities, null);
        int len = entities.size();
        for (int i = 0; i < len; ++i) {
            action.accept((Entity)entities.get(i));
        }
    }

    public <U extends Entity> void get(EntityTypeTest<Entity, U> filter, AABB box, AbortableIterationConsumer<U> action) {
        Entity casted;
        ArrayList<Entity> entities = new ArrayList<Entity>();
        this.getEntitiesWithoutDragonParts(null, box, entities, null);
        int len = entities.size();
        for (int i = 0; !(i >= len || (casted = (Entity)filter.tryCast((Object)((Entity)entities.get(i)))) != null && action.accept((Object)casted).shouldAbort()); ++i) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entityStatusChange(Entity entity, ChunkEntitySlices slices, Visibility oldVisibility, Visibility newVisibility, boolean moved, boolean created, boolean destroyed) {
        boolean entityStatusUpdateBefore;
        this.checkThread(entity, "Entity status change must only happen on the main thread");
        if (((ChunkSystemEntity)entity).moonrise$isUpdatingSectionStatus()) {
            LOGGER.error("Cannot recursively update entity chunk status for entity " + String.valueOf(entity), new Throwable());
            return;
        }
        boolean bl = entityStatusUpdateBefore = slices == null ? false : slices.startPreventingStatusUpdates();
        if (entityStatusUpdateBefore) {
            LOGGER.error("Cannot update chunk status for entity " + String.valueOf(entity) + " since entity chunk (" + slices.chunkX + "," + slices.chunkZ + ") is receiving update", new Throwable());
            return;
        }
        try {
            Boolean ticketBlockBefore = this.blockTicketUpdates();
            try {
                ((ChunkSystemEntity)entity).moonrise$setUpdatingSectionStatus(true);
                try {
                    if (created && this.worldCallback != null) {
                        this.worldCallback.onCreated((Object)entity);
                    }
                    if (oldVisibility == newVisibility) {
                        if (moved && newVisibility.isAccessible() && this.worldCallback != null) {
                            this.worldCallback.onSectionChange((Object)entity);
                        }
                        return;
                    }
                    if (newVisibility.ordinal() > oldVisibility.ordinal()) {
                        if (!oldVisibility.isAccessible() && newVisibility.isAccessible()) {
                            this.entityStartLoaded(entity);
                            EntityList entityList = this.accessibleEntities;
                            synchronized (entityList) {
                                this.accessibleEntities.add(entity);
                            }
                            if (this.worldCallback != null) {
                                this.worldCallback.onTrackingStart((Object)entity);
                            }
                        }
                        if (!oldVisibility.isTicking() && newVisibility.isTicking()) {
                            this.entityStartTicking(entity);
                            if (this.worldCallback != null) {
                                this.worldCallback.onTickingStart((Object)entity);
                            }
                        }
                    } else {
                        if (oldVisibility.isTicking() && !newVisibility.isTicking()) {
                            this.entityEndTicking(entity);
                            if (this.worldCallback != null) {
                                this.worldCallback.onTickingEnd((Object)entity);
                            }
                        }
                        if (oldVisibility.isAccessible() && !newVisibility.isAccessible()) {
                            this.entityEndLoaded(entity);
                            EntityList entityList = this.accessibleEntities;
                            synchronized (entityList) {
                                this.accessibleEntities.remove(entity);
                            }
                            if (this.worldCallback != null) {
                                this.worldCallback.onTrackingEnd((Object)entity);
                            }
                        }
                    }
                    if (moved && newVisibility.isAccessible() && this.worldCallback != null) {
                        this.worldCallback.onSectionChange((Object)entity);
                    }
                    if (destroyed && this.worldCallback != null) {
                        this.worldCallback.onDestroyed((Object)entity);
                    }
                }
                finally {
                    ((ChunkSystemEntity)entity).moonrise$setUpdatingSectionStatus(false);
                }
            }
            finally {
                this.setBlockTicketUpdates(ticketBlockBefore);
            }
        }
        finally {
            if (slices != null) {
                slices.stopPreventingStatusUpdates(false);
            }
        }
    }

    public void chunkStatusChange(int x, int z, FullChunkStatus newStatus) {
        this.getChunk(x, z).updateStatus(newStatus, this);
    }

    public void addLegacyChunkEntities(List<Entity> entities, ChunkPos forChunk) {
        this.addEntityChunk(entities, forChunk, true);
    }

    public void addEntityChunkEntities(List<Entity> entities, ChunkPos forChunk) {
        this.addEntityChunk(entities, forChunk, true);
    }

    public void addWorldGenChunkEntities(List<Entity> entities, ChunkPos forChunk) {
        this.addEntityChunk(entities, forChunk, false);
    }

    protected void addRecursivelySafe(Entity root, boolean fromDisk) {
        if (!this.addEntity(root, fromDisk, true)) {
            root.stopRiding();
            return;
        }
        for (Entity passenger : root.getPassengers()) {
            this.addRecursivelySafe(passenger, fromDisk);
        }
    }

    protected void addEntityChunk(List<Entity> entities, ChunkPos forChunk, boolean fromDisk) {
        int len = entities.size();
        for (int i = 0; i < len; ++i) {
            Entity entity = entities.get(i);
            if (entity.isPassenger()) continue;
            if (forChunk != null && !entity.chunkPosition().equals((Object)forChunk)) {
                LOGGER.warn("Root entity " + String.valueOf(entity) + " is outside of serialized chunk " + String.valueOf(forChunk));
                continue;
            }
            Vec3 rootPosition = entity.position();
            for (Entity passenger : entity.getIndirectPassengers()) {
                if (forChunk == null || passenger.chunkPosition().equals((Object)forChunk)) continue;
                passenger.setPosRaw(rootPosition.x, rootPosition.y, rootPosition.z);
            }
            this.addRecursivelySafe(entity, fromDisk);
        }
    }

    public boolean addNewEntity(Entity entity) {
        return this.addNewEntity(entity, true);
    }

    public boolean addNewEntity(Entity entity, boolean event) {
        return this.addEntity(entity, false, event);
    }

    public static Visibility getEntityStatus(Entity entity) {
        if (entity.isAlwaysTicking()) {
            return Visibility.TICKING;
        }
        FullChunkStatus entityStatus = ((ChunkSystemEntity)entity).moonrise$getChunkStatus();
        return Visibility.fromFullChunkStatus((FullChunkStatus)(entityStatus == null ? FullChunkStatus.INACCESSIBLE : entityStatus));
    }

    protected boolean addEntity(Entity entity, boolean fromDisk, boolean event) {
        BlockPos pos = entity.blockPosition();
        int sectionX = pos.getX() >> 4;
        int sectionY = Mth.clamp((int)(pos.getY() >> 4), (int)WorldUtil.getMinSection(this.world), (int)WorldUtil.getMaxSection(this.world));
        int sectionZ = pos.getZ() >> 4;
        this.checkThread(sectionX, sectionZ, "Cannot add entity off-main thread");
        if (entity.isRemoved()) {
            LOGGER.warn("Refusing to add removed entity: " + String.valueOf(entity));
            return false;
        }
        if (((ChunkSystemEntity)entity).moonrise$isUpdatingSectionStatus()) {
            LOGGER.warn("Entity " + String.valueOf(entity) + " is currently prevented from being added/removed to world since it is processing section status updates", new Throwable());
            return false;
        }
        if (!this.screenEntity(entity, fromDisk, event)) {
            return false;
        }
        Entity currentlyMapped = this.entityById.putIfAbsent(entity.getId(), entity);
        if (currentlyMapped != null) {
            LOGGER.warn("Entity id already exists: " + entity.getId() + ", mapped to " + String.valueOf(currentlyMapped) + ", can't add " + String.valueOf(entity));
            return false;
        }
        currentlyMapped = this.entityByUUID.putIfAbsent(entity.getUUID(), entity);
        if (currentlyMapped != null) {
            this.entityById.remove(entity.getId(), entity);
            LOGGER.warn("Entity uuid already exists: " + String.valueOf(entity.getUUID()) + ", mapped to " + String.valueOf(currentlyMapped) + ", can't add " + String.valueOf(entity));
            return false;
        }
        ((ChunkSystemEntity)entity).moonrise$setSectionX(sectionX);
        ((ChunkSystemEntity)entity).moonrise$setSectionY(sectionY);
        ((ChunkSystemEntity)entity).moonrise$setSectionZ(sectionZ);
        ChunkEntitySlices slices = this.getOrCreateChunk(sectionX, sectionZ);
        if (!slices.addEntity(entity, sectionY)) {
            LOGGER.warn("Entity " + String.valueOf(entity) + " added to world '" + WorldUtil.getWorldName(this.world) + "', but was already contained in entity chunk (" + sectionX + "," + sectionZ + ")");
        }
        entity.setLevelCallback((EntityInLevelCallback)new EntityCallback(entity));
        this.addEntityCallback(entity);
        this.entityStatusChange(entity, slices, Visibility.HIDDEN, EntityLookup.getEntityStatus(entity), false, !fromDisk, false);
        return true;
    }

    public boolean canRemoveEntity(Entity entity) {
        int sectionZ;
        if (((ChunkSystemEntity)entity).moonrise$isUpdatingSectionStatus()) {
            return false;
        }
        int sectionX = ((ChunkSystemEntity)entity).moonrise$getSectionX();
        ChunkEntitySlices slices = this.getChunk(sectionX, sectionZ = ((ChunkSystemEntity)entity).moonrise$getSectionZ());
        return slices == null || !slices.isPreventingStatusUpdates();
    }

    protected void removeEntity(Entity entity) {
        int sectionX = ((ChunkSystemEntity)entity).moonrise$getSectionX();
        int sectionY = ((ChunkSystemEntity)entity).moonrise$getSectionY();
        int sectionZ = ((ChunkSystemEntity)entity).moonrise$getSectionZ();
        this.checkThread(sectionX, sectionZ, "Cannot remove entity off-main");
        if (!entity.isRemoved()) {
            throw new IllegalStateException("Only call Entity#setRemoved to remove an entity");
        }
        ChunkEntitySlices slices = this.getChunk(sectionX, sectionZ);
        if (slices == null) {
            LOGGER.warn("Cannot remove entity " + String.valueOf(entity) + " from null entity slices (" + sectionX + "," + sectionZ + ")");
        } else {
            if (slices.isPreventingStatusUpdates()) {
                throw new IllegalStateException("Attempting to remove entity " + String.valueOf(entity) + " from entity slices (" + sectionX + "," + sectionZ + ") that is receiving status updates");
            }
            if (!slices.removeEntity(entity, sectionY)) {
                LOGGER.warn("Failed to remove entity " + String.valueOf(entity) + " from entity slices (" + sectionX + "," + sectionZ + ")");
            }
        }
        ((ChunkSystemEntity)entity).moonrise$setSectionX(Integer.MIN_VALUE);
        ((ChunkSystemEntity)entity).moonrise$setSectionY(Integer.MIN_VALUE);
        ((ChunkSystemEntity)entity).moonrise$setSectionZ(Integer.MIN_VALUE);
        Entity currentlyMapped = this.entityById.remove(entity.getId(), entity);
        if (currentlyMapped != entity) {
            LOGGER.warn("Failed to remove entity " + String.valueOf(entity) + " by id, current entity mapped: " + String.valueOf(currentlyMapped));
        }
        Entity[] currentlyMappedArr = new Entity[1];
        this.entityByUUID.compute(entity.getUUID(), (keyInMap, valueInMap) -> {
            currentlyMappedArr[0] = valueInMap;
            if (valueInMap != entity) {
                return valueInMap;
            }
            return null;
        });
        if (currentlyMappedArr[0] != entity) {
            LOGGER.warn("Failed to remove entity " + String.valueOf(entity) + " by uuid, current entity mapped: " + String.valueOf(currentlyMappedArr[0]));
        }
        if (slices != null && slices.isEmpty()) {
            this.onEmptySlices(sectionX, sectionZ);
        }
    }

    protected ChunkEntitySlices moveEntity(Entity entity) {
        this.checkThread(entity, "Cannot move entity off-main");
        int sectionX = ((ChunkSystemEntity)entity).moonrise$getSectionX();
        int sectionY = ((ChunkSystemEntity)entity).moonrise$getSectionY();
        int sectionZ = ((ChunkSystemEntity)entity).moonrise$getSectionZ();
        BlockPos newPos = entity.blockPosition();
        int newSectionX = newPos.getX() >> 4;
        int newSectionY = Mth.clamp((int)(newPos.getY() >> 4), (int)WorldUtil.getMinSection(this.world), (int)WorldUtil.getMaxSection(this.world));
        int newSectionZ = newPos.getZ() >> 4;
        if (newSectionX == sectionX && newSectionY == sectionY && newSectionZ == sectionZ) {
            return null;
        }
        this.checkThread(newSectionX, newSectionZ, "Cannot move entity off-main");
        this.checkThread(sectionX, sectionZ, "Cannot move entity off-main");
        ChunkEntitySlices old = this.getChunk(sectionX, sectionZ);
        ChunkEntitySlices slices = this.getOrCreateChunk(newSectionX, newSectionZ);
        if (!old.removeEntity(entity, sectionY)) {
            LOGGER.warn("Could not remove entity " + String.valueOf(entity) + " from its old chunk section (" + sectionX + "," + sectionY + "," + sectionZ + ") since it was not contained in the section");
        }
        if (!slices.addEntity(entity, newSectionY)) {
            LOGGER.warn("Could not add entity " + String.valueOf(entity) + " to its new chunk section (" + newSectionX + "," + newSectionY + "," + newSectionZ + ") as it is already contained in the section");
        }
        ((ChunkSystemEntity)entity).moonrise$setSectionX(newSectionX);
        ((ChunkSystemEntity)entity).moonrise$setSectionY(newSectionY);
        ((ChunkSystemEntity)entity).moonrise$setSectionZ(newSectionZ);
        if (old.isEmpty()) {
            this.onEmptySlices(sectionX, sectionZ);
        }
        this.entitySectionChangeCallback(entity, sectionX, sectionY, sectionZ, newSectionX, newSectionY, newSectionZ);
        return slices;
    }

    public void getEntitiesWithoutDragonParts(Entity except, AABB box, List<Entity> into, Predicate<? super Entity> predicate) {
        int minChunkX = Mth.floor((double)box.minX) - 2 >> 4;
        int minChunkZ = Mth.floor((double)box.minZ) - 2 >> 4;
        int maxChunkX = Mth.floor((double)box.maxX) + 2 >> 4;
        int maxChunkZ = Mth.floor((double)box.maxZ) + 2 >> 4;
        int minRegionX = minChunkX >> 5;
        int minRegionZ = minChunkZ >> 5;
        int maxRegionX = maxChunkX >> 5;
        int maxRegionZ = maxChunkZ >> 5;
        for (int currRegionZ = minRegionZ; currRegionZ <= maxRegionZ; ++currRegionZ) {
            int minZ = currRegionZ == minRegionZ ? minChunkZ & 0x1F : 0;
            int maxZ = currRegionZ == maxRegionZ ? maxChunkZ & 0x1F : 31;
            for (int currRegionX = minRegionX; currRegionX <= maxRegionX; ++currRegionX) {
                ChunkSlicesRegion region = this.getRegion(currRegionX, currRegionZ);
                if (region == null) continue;
                int minX = currRegionX == minRegionX ? minChunkX & 0x1F : 0;
                int maxX = currRegionX == maxRegionX ? maxChunkX & 0x1F : 31;
                for (int currZ = minZ; currZ <= maxZ; ++currZ) {
                    for (int currX = minX; currX <= maxX; ++currX) {
                        ChunkEntitySlices chunk = region.get(currX | currZ << 5);
                        if (chunk == null || !chunk.status.isOrAfter(FullChunkStatus.FULL)) continue;
                        chunk.getEntitiesWithoutDragonParts(except, box, into, predicate);
                    }
                }
            }
        }
    }

    public void getEntities(Entity except, AABB box, List<Entity> into, Predicate<? super Entity> predicate) {
        int minChunkX = Mth.floor((double)box.minX) - 2 >> 4;
        int minChunkZ = Mth.floor((double)box.minZ) - 2 >> 4;
        int maxChunkX = Mth.floor((double)box.maxX) + 2 >> 4;
        int maxChunkZ = Mth.floor((double)box.maxZ) + 2 >> 4;
        int minRegionX = minChunkX >> 5;
        int minRegionZ = minChunkZ >> 5;
        int maxRegionX = maxChunkX >> 5;
        int maxRegionZ = maxChunkZ >> 5;
        for (int currRegionZ = minRegionZ; currRegionZ <= maxRegionZ; ++currRegionZ) {
            int minZ = currRegionZ == minRegionZ ? minChunkZ & 0x1F : 0;
            int maxZ = currRegionZ == maxRegionZ ? maxChunkZ & 0x1F : 31;
            for (int currRegionX = minRegionX; currRegionX <= maxRegionX; ++currRegionX) {
                ChunkSlicesRegion region = this.getRegion(currRegionX, currRegionZ);
                if (region == null) continue;
                int minX = currRegionX == minRegionX ? minChunkX & 0x1F : 0;
                int maxX = currRegionX == maxRegionX ? maxChunkX & 0x1F : 31;
                for (int currZ = minZ; currZ <= maxZ; ++currZ) {
                    for (int currX = minX; currX <= maxX; ++currX) {
                        ChunkEntitySlices chunk = region.get(currX | currZ << 5);
                        if (chunk == null || !chunk.status.isOrAfter(FullChunkStatus.FULL)) continue;
                        chunk.getEntities(except, box, into, predicate);
                    }
                }
            }
        }
    }

    public void getHardCollidingEntities(Entity except, AABB box, List<Entity> into, Predicate<? super Entity> predicate) {
        int minChunkX = Mth.floor((double)box.minX) - 2 >> 4;
        int minChunkZ = Mth.floor((double)box.minZ) - 2 >> 4;
        int maxChunkX = Mth.floor((double)box.maxX) + 2 >> 4;
        int maxChunkZ = Mth.floor((double)box.maxZ) + 2 >> 4;
        int minRegionX = minChunkX >> 5;
        int minRegionZ = minChunkZ >> 5;
        int maxRegionX = maxChunkX >> 5;
        int maxRegionZ = maxChunkZ >> 5;
        for (int currRegionZ = minRegionZ; currRegionZ <= maxRegionZ; ++currRegionZ) {
            int minZ = currRegionZ == minRegionZ ? minChunkZ & 0x1F : 0;
            int maxZ = currRegionZ == maxRegionZ ? maxChunkZ & 0x1F : 31;
            for (int currRegionX = minRegionX; currRegionX <= maxRegionX; ++currRegionX) {
                ChunkSlicesRegion region = this.getRegion(currRegionX, currRegionZ);
                if (region == null) continue;
                int minX = currRegionX == minRegionX ? minChunkX & 0x1F : 0;
                int maxX = currRegionX == maxRegionX ? maxChunkX & 0x1F : 31;
                for (int currZ = minZ; currZ <= maxZ; ++currZ) {
                    for (int currX = minX; currX <= maxX; ++currX) {
                        ChunkEntitySlices chunk = region.get(currX | currZ << 5);
                        if (chunk == null || !chunk.status.isOrAfter(FullChunkStatus.FULL)) continue;
                        chunk.getHardCollidingEntities(except, box, into, predicate);
                    }
                }
            }
        }
    }

    public <T extends Entity> void getEntities(EntityType<?> type, AABB box, List<? super T> into, Predicate<? super T> predicate) {
        int minChunkX = Mth.floor((double)box.minX) - 2 >> 4;
        int minChunkZ = Mth.floor((double)box.minZ) - 2 >> 4;
        int maxChunkX = Mth.floor((double)box.maxX) + 2 >> 4;
        int maxChunkZ = Mth.floor((double)box.maxZ) + 2 >> 4;
        int minRegionX = minChunkX >> 5;
        int minRegionZ = minChunkZ >> 5;
        int maxRegionX = maxChunkX >> 5;
        int maxRegionZ = maxChunkZ >> 5;
        for (int currRegionZ = minRegionZ; currRegionZ <= maxRegionZ; ++currRegionZ) {
            int minZ = currRegionZ == minRegionZ ? minChunkZ & 0x1F : 0;
            int maxZ = currRegionZ == maxRegionZ ? maxChunkZ & 0x1F : 31;
            for (int currRegionX = minRegionX; currRegionX <= maxRegionX; ++currRegionX) {
                ChunkSlicesRegion region = this.getRegion(currRegionX, currRegionZ);
                if (region == null) continue;
                int minX = currRegionX == minRegionX ? minChunkX & 0x1F : 0;
                int maxX = currRegionX == maxRegionX ? maxChunkX & 0x1F : 31;
                for (int currZ = minZ; currZ <= maxZ; ++currZ) {
                    for (int currX = minX; currX <= maxX; ++currX) {
                        ChunkEntitySlices chunk = region.get(currX | currZ << 5);
                        if (chunk == null || !chunk.status.isOrAfter(FullChunkStatus.FULL)) continue;
                        chunk.getEntities(type, box, into, predicate);
                    }
                }
            }
        }
    }

    public <T extends Entity> void getEntities(Class<? extends T> clazz, Entity except, AABB box, List<? super T> into, Predicate<? super T> predicate) {
        int minChunkX = Mth.floor((double)box.minX) - 2 >> 4;
        int minChunkZ = Mth.floor((double)box.minZ) - 2 >> 4;
        int maxChunkX = Mth.floor((double)box.maxX) + 2 >> 4;
        int maxChunkZ = Mth.floor((double)box.maxZ) + 2 >> 4;
        int minRegionX = minChunkX >> 5;
        int minRegionZ = minChunkZ >> 5;
        int maxRegionX = maxChunkX >> 5;
        int maxRegionZ = maxChunkZ >> 5;
        for (int currRegionZ = minRegionZ; currRegionZ <= maxRegionZ; ++currRegionZ) {
            int minZ = currRegionZ == minRegionZ ? minChunkZ & 0x1F : 0;
            int maxZ = currRegionZ == maxRegionZ ? maxChunkZ & 0x1F : 31;
            for (int currRegionX = minRegionX; currRegionX <= maxRegionX; ++currRegionX) {
                ChunkSlicesRegion region = this.getRegion(currRegionX, currRegionZ);
                if (region == null) continue;
                int minX = currRegionX == minRegionX ? minChunkX & 0x1F : 0;
                int maxX = currRegionX == maxRegionX ? maxChunkX & 0x1F : 31;
                for (int currZ = minZ; currZ <= maxZ; ++currZ) {
                    for (int currX = minX; currX <= maxX; ++currX) {
                        ChunkEntitySlices chunk = region.get(currX | currZ << 5);
                        if (chunk == null || !chunk.status.isOrAfter(FullChunkStatus.FULL)) continue;
                        chunk.getEntities(clazz, except, box, into, predicate);
                    }
                }
            }
        }
    }

    public void getEntitiesWithoutDragonParts(Entity except, AABB box, List<Entity> into, Predicate<? super Entity> predicate, int maxCount) {
        int minChunkX = Mth.floor((double)box.minX) - 2 >> 4;
        int minChunkZ = Mth.floor((double)box.minZ) - 2 >> 4;
        int maxChunkX = Mth.floor((double)box.maxX) + 2 >> 4;
        int maxChunkZ = Mth.floor((double)box.maxZ) + 2 >> 4;
        int minRegionX = minChunkX >> 5;
        int minRegionZ = minChunkZ >> 5;
        int maxRegionX = maxChunkX >> 5;
        int maxRegionZ = maxChunkZ >> 5;
        for (int currRegionZ = minRegionZ; currRegionZ <= maxRegionZ; ++currRegionZ) {
            int minZ = currRegionZ == minRegionZ ? minChunkZ & 0x1F : 0;
            int maxZ = currRegionZ == maxRegionZ ? maxChunkZ & 0x1F : 31;
            for (int currRegionX = minRegionX; currRegionX <= maxRegionX; ++currRegionX) {
                ChunkSlicesRegion region = this.getRegion(currRegionX, currRegionZ);
                if (region == null) continue;
                int minX = currRegionX == minRegionX ? minChunkX & 0x1F : 0;
                int maxX = currRegionX == maxRegionX ? maxChunkX & 0x1F : 31;
                for (int currZ = minZ; currZ <= maxZ; ++currZ) {
                    for (int currX = minX; currX <= maxX; ++currX) {
                        ChunkEntitySlices chunk = region.get(currX | currZ << 5);
                        if (chunk == null || !chunk.status.isOrAfter(FullChunkStatus.FULL) || !chunk.getEntitiesWithoutDragonParts(except, box, into, predicate, maxCount)) continue;
                        return;
                    }
                }
            }
        }
    }

    public void getEntities(Entity except, AABB box, List<Entity> into, Predicate<? super Entity> predicate, int maxCount) {
        int minChunkX = Mth.floor((double)box.minX) - 2 >> 4;
        int minChunkZ = Mth.floor((double)box.minZ) - 2 >> 4;
        int maxChunkX = Mth.floor((double)box.maxX) + 2 >> 4;
        int maxChunkZ = Mth.floor((double)box.maxZ) + 2 >> 4;
        int minRegionX = minChunkX >> 5;
        int minRegionZ = minChunkZ >> 5;
        int maxRegionX = maxChunkX >> 5;
        int maxRegionZ = maxChunkZ >> 5;
        for (int currRegionZ = minRegionZ; currRegionZ <= maxRegionZ; ++currRegionZ) {
            int minZ = currRegionZ == minRegionZ ? minChunkZ & 0x1F : 0;
            int maxZ = currRegionZ == maxRegionZ ? maxChunkZ & 0x1F : 31;
            for (int currRegionX = minRegionX; currRegionX <= maxRegionX; ++currRegionX) {
                ChunkSlicesRegion region = this.getRegion(currRegionX, currRegionZ);
                if (region == null) continue;
                int minX = currRegionX == minRegionX ? minChunkX & 0x1F : 0;
                int maxX = currRegionX == maxRegionX ? maxChunkX & 0x1F : 31;
                for (int currZ = minZ; currZ <= maxZ; ++currZ) {
                    for (int currX = minX; currX <= maxX; ++currX) {
                        ChunkEntitySlices chunk = region.get(currX | currZ << 5);
                        if (chunk == null || !chunk.status.isOrAfter(FullChunkStatus.FULL) || !chunk.getEntities(except, box, into, predicate, maxCount)) continue;
                        return;
                    }
                }
            }
        }
    }

    public <T extends Entity> void getEntities(EntityType<?> type, AABB box, List<? super T> into, Predicate<? super T> predicate, int maxCount) {
        int minChunkX = Mth.floor((double)box.minX) - 2 >> 4;
        int minChunkZ = Mth.floor((double)box.minZ) - 2 >> 4;
        int maxChunkX = Mth.floor((double)box.maxX) + 2 >> 4;
        int maxChunkZ = Mth.floor((double)box.maxZ) + 2 >> 4;
        int minRegionX = minChunkX >> 5;
        int minRegionZ = minChunkZ >> 5;
        int maxRegionX = maxChunkX >> 5;
        int maxRegionZ = maxChunkZ >> 5;
        for (int currRegionZ = minRegionZ; currRegionZ <= maxRegionZ; ++currRegionZ) {
            int minZ = currRegionZ == minRegionZ ? minChunkZ & 0x1F : 0;
            int maxZ = currRegionZ == maxRegionZ ? maxChunkZ & 0x1F : 31;
            for (int currRegionX = minRegionX; currRegionX <= maxRegionX; ++currRegionX) {
                ChunkSlicesRegion region = this.getRegion(currRegionX, currRegionZ);
                if (region == null) continue;
                int minX = currRegionX == minRegionX ? minChunkX & 0x1F : 0;
                int maxX = currRegionX == maxRegionX ? maxChunkX & 0x1F : 31;
                for (int currZ = minZ; currZ <= maxZ; ++currZ) {
                    for (int currX = minX; currX <= maxX; ++currX) {
                        ChunkEntitySlices chunk = region.get(currX | currZ << 5);
                        if (chunk == null || !chunk.status.isOrAfter(FullChunkStatus.FULL) || !chunk.getEntities(type, box, into, predicate, maxCount)) continue;
                        return;
                    }
                }
            }
        }
    }

    public <T extends Entity> void getEntities(Class<? extends T> clazz, Entity except, AABB box, List<? super T> into, Predicate<? super T> predicate, int maxCount) {
        int minChunkX = Mth.floor((double)box.minX) - 2 >> 4;
        int minChunkZ = Mth.floor((double)box.minZ) - 2 >> 4;
        int maxChunkX = Mth.floor((double)box.maxX) + 2 >> 4;
        int maxChunkZ = Mth.floor((double)box.maxZ) + 2 >> 4;
        int minRegionX = minChunkX >> 5;
        int minRegionZ = minChunkZ >> 5;
        int maxRegionX = maxChunkX >> 5;
        int maxRegionZ = maxChunkZ >> 5;
        for (int currRegionZ = minRegionZ; currRegionZ <= maxRegionZ; ++currRegionZ) {
            int minZ = currRegionZ == minRegionZ ? minChunkZ & 0x1F : 0;
            int maxZ = currRegionZ == maxRegionZ ? maxChunkZ & 0x1F : 31;
            for (int currRegionX = minRegionX; currRegionX <= maxRegionX; ++currRegionX) {
                ChunkSlicesRegion region = this.getRegion(currRegionX, currRegionZ);
                if (region == null) continue;
                int minX = currRegionX == minRegionX ? minChunkX & 0x1F : 0;
                int maxX = currRegionX == maxRegionX ? maxChunkX & 0x1F : 31;
                for (int currZ = minZ; currZ <= maxZ; ++currZ) {
                    for (int currX = minX; currX <= maxX; ++currX) {
                        ChunkEntitySlices chunk = region.get(currX | currZ << 5);
                        if (chunk == null || !chunk.status.isOrAfter(FullChunkStatus.FULL) || !chunk.getEntities(clazz, except, box, into, predicate, maxCount)) continue;
                        return;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entitySectionLoad(int chunkX, int chunkZ, ChunkEntitySlices slices) {
        this.checkThread(chunkX, chunkZ, "Cannot load in entity section off-main");
        EntityLookup entityLookup = this;
        synchronized (entityLookup) {
            ChunkEntitySlices curr = this.getChunk(chunkX, chunkZ);
            if (curr != null) {
                this.removeChunk(chunkX, chunkZ);
                curr.mergeInto(slices);
                this.addChunk(chunkX, chunkZ, slices);
            } else {
                this.addChunk(chunkX, chunkZ, slices);
            }
        }
    }

    public void entitySectionUnload(int chunkX, int chunkZ) {
        this.checkThread(chunkX, chunkZ, "Cannot unload entity section off-main");
        this.removeChunk(chunkX, chunkZ);
    }

    public ChunkEntitySlices getChunk(int chunkX, int chunkZ) {
        ChunkSlicesRegion region = this.getRegion(chunkX >> 5, chunkZ >> 5);
        if (region == null) {
            return null;
        }
        return region.get(chunkX & 0x1F | (chunkZ & 0x1F) << 5);
    }

    public ChunkEntitySlices getOrCreateChunk(int chunkX, int chunkZ) {
        ChunkEntitySlices ret;
        ChunkSlicesRegion region = this.getRegion(chunkX >> 5, chunkZ >> 5);
        if (region == null || (ret = region.get(chunkX & 0x1F | (chunkZ & 0x1F) << 5)) == null) {
            return this.createEntityChunk(chunkX, chunkZ, true);
        }
        return ret;
    }

    public ChunkSlicesRegion getRegion(int regionX, int regionZ) {
        long key = CoordinateUtils.getChunkKey(regionX, regionZ);
        return this.regions.get(key);
    }

    protected synchronized void removeChunk(int chunkX, int chunkZ) {
        long key = CoordinateUtils.getChunkKey(chunkX >> 5, chunkZ >> 5);
        int relIndex = chunkX & 0x1F | (chunkZ & 0x1F) << 5;
        ChunkSlicesRegion region = this.regions.get(key);
        int remaining = region.remove(relIndex);
        if (remaining == 0) {
            this.regions.remove(key);
        }
    }

    public synchronized void addChunk(int chunkX, int chunkZ, ChunkEntitySlices slices) {
        long key = CoordinateUtils.getChunkKey(chunkX >> 5, chunkZ >> 5);
        int relIndex = chunkX & 0x1F | (chunkZ & 0x1F) << 5;
        ChunkSlicesRegion region = this.regions.get(key);
        if (region != null) {
            region.add(relIndex, slices);
        } else {
            region = new ChunkSlicesRegion();
            region.add(relIndex, slices);
            this.regions.put(key, region);
        }
    }

    protected static final class ArrayIterable<T>
    implements Iterable<T> {
        private final T[] array;
        private final int off;
        private final int length;

        public ArrayIterable(T[] array, int off, int length) {
            this.array = array;
            this.off = off;
            this.length = length;
            if (length > array.length) {
                throw new IllegalArgumentException("Length must be no greater-than the array length");
            }
        }

        @Override
        public Iterator<T> iterator() {
            return new ArrayIterator<T>(this.array, this.off, this.length);
        }

        protected static final class ArrayIterator<T>
        implements Iterator<T> {
            private final T[] array;
            private int off;
            private final int length;

            public ArrayIterator(T[] array, int off, int length) {
                this.array = array;
                this.off = off;
                this.length = length;
            }

            @Override
            public boolean hasNext() {
                return this.off < this.length;
            }

            @Override
            public T next() {
                if (this.off >= this.length) {
                    throw new NoSuchElementException();
                }
                return this.array[this.off++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    protected final class EntityCallback
    implements EntityInLevelCallback {
        public final Entity entity;

        public EntityCallback(Entity entity) {
            this.entity = entity;
        }

        public void onMove() {
            Entity entity = this.entity;
            Visibility oldVisibility = EntityLookup.getEntityStatus(entity);
            ChunkEntitySlices newSlices = EntityLookup.this.moveEntity(this.entity);
            if (newSlices == null) {
                return;
            }
            Visibility newVisibility = EntityLookup.getEntityStatus(entity);
            EntityLookup.this.entityStatusChange(entity, newSlices, oldVisibility, newVisibility, true, false, false);
        }

        public void onRemove(Entity.RemovalReason reason) {
            Entity entity = this.entity;
            EntityLookup.this.checkThread(entity, "Cannot remove entity off-main");
            Visibility tickingState = EntityLookup.getEntityStatus(entity);
            EntityLookup.this.removeEntity(entity);
            EntityLookup.this.entityStatusChange(entity, null, tickingState, Visibility.HIDDEN, false, false, reason.shouldDestroy());
            EntityLookup.this.removeEntityCallback(entity);
            this.entity.setLevelCallback((EntityInLevelCallback)NoOpCallback.INSTANCE);
        }
    }

    public static final class ChunkSlicesRegion {
        private final ChunkEntitySlices[] slices = new ChunkEntitySlices[1024];
        private int sliceCount;

        public ChunkEntitySlices get(int index) {
            return this.slices[index];
        }

        public int remove(int index) {
            ChunkEntitySlices slices = this.slices[index];
            if (slices == null) {
                throw new IllegalStateException();
            }
            this.slices[index] = null;
            return --this.sliceCount;
        }

        public void add(int index, ChunkEntitySlices slices) {
            ChunkEntitySlices curr = this.slices[index];
            if (curr != null) {
                throw new IllegalStateException();
            }
            this.slices[index] = slices;
            ++this.sliceCount;
        }
    }

    protected static final class NoOpCallback
    implements EntityInLevelCallback {
        public static final NoOpCallback INSTANCE = new NoOpCallback();

        protected NoOpCallback() {
        }

        public void onMove() {
        }

        public void onRemove(Entity.RemovalReason reason) {
        }
    }
}

