/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.neoforge.mixin.chunk_system;

import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkSystemDistanceManager;
import ca.spottedleaf.moonrise.patches.chunk_tick_iteration.ChunkTickServerLevel;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.SortedArraySet;
import net.minecraft.world.level.ChunkPos;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={DistanceManager.class})
abstract class NeoForgeDistanceManagerMixin
implements ChunkSystemDistanceManager {
    @Shadow
    @Final
    private Long2ObjectOpenHashMap<SortedArraySet<Ticket<?>>> forcedTickets;

    NeoForgeDistanceManagerMixin() {
    }

    @Overwrite
    public <T> void addRegionTicket(TicketType<T> type, ChunkPos pos, int radius, T identifier, boolean forceTicks) {
        int level = ChunkLevel.byStatus((FullChunkStatus)FullChunkStatus.FULL) - radius;
        this.moonrise$getChunkHolderManager().addTicketAtLevel(type, pos, level, identifier);
        if (forceTicks) {
            Ticket forceTicket = new Ticket(type, level, identifier, forceTicks);
            this.forcedTickets.compute(pos.toLong(), (keyInMap, valueInMap) -> {
                SortedArraySet ret = valueInMap != null ? valueInMap : SortedArraySet.create((int)4);
                if (ret.add((Object)forceTicket)) {
                    ((ChunkTickServerLevel)this.moonrise$getChunkMap().level).moonrise$addPlayerTickingRequest(CoordinateUtils.getChunkX(keyInMap), CoordinateUtils.getChunkZ(keyInMap));
                }
                return ret;
            });
        }
    }

    @Overwrite
    public <T> void removeRegionTicket(TicketType<T> type, ChunkPos pos, int radius, T identifier, boolean forceTicks) {
        int level = ChunkLevel.byStatus((FullChunkStatus)FullChunkStatus.FULL) - radius;
        this.moonrise$getChunkHolderManager().removeTicketAtLevel(type, pos, level, identifier);
        if (forceTicks) {
            Ticket forceTicket = new Ticket(type, level, identifier, forceTicks);
            this.forcedTickets.computeIfPresent(pos.toLong(), (keyInMap, valueInMap) -> {
                if (valueInMap.remove((Object)forceTicket)) {
                    ((ChunkTickServerLevel)this.moonrise$getChunkMap().level).moonrise$removePlayerTickingRequest(CoordinateUtils.getChunkX(keyInMap), CoordinateUtils.getChunkZ(keyInMap));
                }
                return valueInMap.isEmpty() ? null : valueInMap;
            });
        }
    }

    @Overwrite
    public boolean shouldForceTicks(long chunkPos) {
        return this.forcedTickets.containsKey(chunkPos);
    }
}

