/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.neoforge;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.common.util.ConfigHolder;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.LoadingModList;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.level.ChunkDataEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;

public final class NeoForgeHooks
implements PlatformHooks {
    @Override
    public String getBrand() {
        return "Moonrise";
    }

    @Override
    public boolean isModLoaded(String modId) {
        ModList modList = ModList.get();
        if (modList == null) {
            return LoadingModList.get().getModFileById(modId) != null;
        }
        return modList.isLoaded(modId);
    }

    @Override
    public int getLightEmission(BlockState blockState, BlockGetter world, BlockPos pos) {
        return blockState.getLightEmission(world, pos);
    }

    @Override
    public Predicate<BlockState> maybeHasLightEmission() {
        return state -> state.hasDynamicLightEmission() || state.getLightEmission((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO) != 0;
    }

    @Override
    public void onExplosion(Level world, Explosion explosion, List<Entity> possiblyAffecting, double diameter) {
        EventHooks.onExplosionDetonate((Level)world, (Explosion)explosion, possiblyAffecting, (double)diameter);
    }

    @Override
    public Vec3 modifyExplosionKnockback(Level world, Explosion explosion, Entity entity, Vec3 original) {
        return EventHooks.getExplosionKnockback((Level)world, (Explosion)explosion, (Entity)entity, (Vec3)original);
    }

    @Override
    public boolean hasCurrentlyLoadingChunk() {
        return true;
    }

    @Override
    public LevelChunk getCurrentlyLoadingChunk(GenerationChunkHolder holder) {
        return holder.currentlyLoading;
    }

    @Override
    public void setCurrentlyLoading(GenerationChunkHolder holder, LevelChunk levelChunk) {
        holder.currentlyLoading = levelChunk;
    }

    @Override
    public void chunkFullStatusComplete(LevelChunk newChunk, ProtoChunk original) {
        NeoForge.EVENT_BUS.post((Event)new ChunkEvent.Load((ChunkAccess)newChunk, !(original instanceof ImposterProtoChunk)));
    }

    @Override
    public boolean allowAsyncTicketUpdates() {
        return false;
    }

    @Override
    public void onChunkHolderTicketChange(ServerLevel world, NewChunkHolder holder, int oldLevel, int newLevel) {
        EventHooks.fireChunkTicketLevelUpdated((ServerLevel)world, (long)CoordinateUtils.getChunkKey(holder.chunkX, holder.chunkZ), (int)oldLevel, (int)newLevel, (ChunkHolder)holder.vanillaChunkHolder);
    }

    @Override
    public void chunkUnloadFromWorld(LevelChunk chunk) {
        NeoForge.EVENT_BUS.post((Event)new ChunkEvent.Unload((ChunkAccess)chunk));
    }

    @Override
    public void chunkSyncSave(ServerLevel world, ChunkAccess chunk, CompoundTag data) {
        NeoForge.EVENT_BUS.post((Event)new ChunkDataEvent.Save(chunk, (LevelAccessor)world, data));
    }

    @Override
    public void onChunkWatch(ServerLevel world, LevelChunk chunk, ServerPlayer player) {
        EventHooks.fireChunkWatch((ServerPlayer)player, (LevelChunk)chunk, (ServerLevel)world);
    }

    @Override
    public void onChunkUnWatch(ServerLevel world, ChunkPos chunk, ServerPlayer player) {
        EventHooks.fireChunkUnWatch((ServerPlayer)player, (ChunkPos)chunk, (ServerLevel)world);
    }

    @Override
    public void addToGetEntities(Level world, Entity entity, AABB boundingBox, Predicate<? super Entity> predicate, List<Entity> into) {
        for (PartEntity part : world.getPartEntities()) {
            if (part == entity || !part.getBoundingBox().intersects(boundingBox) || predicate != null && !predicate.test((Entity)part)) continue;
            into.add((Entity)part);
        }
    }

    @Override
    public <T extends Entity> void addToGetEntities(Level world, EntityTypeTest<Entity, T> entityTypeTest, AABB boundingBox, Predicate<? super T> predicate, List<? super T> into, int maxCount) {
        if (into.size() >= maxCount) {
            return;
        }
        for (PartEntity part : world.getPartEntities()) {
            Entity casted = (Entity)entityTypeTest.tryCast((Object)part);
            if (casted == null || !casted.getBoundingBox().intersects(boundingBox) || predicate != null && !predicate.test(casted)) continue;
            into.add(casted);
            if (into.size() < maxCount) continue;
            break;
        }
    }

    @Override
    public void entityMove(Entity entity, long oldSection, long newSection) {
        CommonHooks.onEntityEnterSection((Entity)entity, (long)oldSection, (long)newSection);
    }

    @Override
    public boolean screenEntity(ServerLevel world, Entity entity, boolean fromDisk, boolean event) {
        return !event || !((EntityJoinLevelEvent)NeoForge.EVENT_BUS.post((Event)new EntityJoinLevelEvent(entity, entity.level(), fromDisk))).isCanceled();
    }

    @Override
    public boolean configFixMC224294() {
        return ConfigHolder.getConfig().bugFixes.fixMC224294;
    }

    @Override
    public boolean configAutoConfigSendDistance() {
        return ConfigHolder.getConfig().chunkLoading.advanced.autoConfigSendDistance;
    }

    @Override
    public double configPlayerMaxLoadRate() {
        return ConfigHolder.getConfig().chunkLoading.basic.playerMaxLoadRate;
    }

    @Override
    public double configPlayerMaxGenRate() {
        return ConfigHolder.getConfig().chunkLoading.basic.playerMaxGenRate;
    }

    @Override
    public double configPlayerMaxSendRate() {
        return ConfigHolder.getConfig().chunkLoading.basic.playerMaxSendRate;
    }

    @Override
    public int configPlayerMaxConcurrentLoads() {
        return ConfigHolder.getConfig().chunkLoading.advanced.playerMaxConcurrentChunkLoads;
    }

    @Override
    public int configPlayerMaxConcurrentGens() {
        return ConfigHolder.getConfig().chunkLoading.advanced.playerMaxConcurrentChunkGenerates;
    }

    @Override
    public long configAutoSaveInterval() {
        return ConfigHolder.getConfig().chunkSaving.autoSaveInterval.getTimeTicks();
    }

    @Override
    public int configMaxAutoSavePerTick() {
        return ConfigHolder.getConfig().chunkSaving.maxAutoSaveChunksPerTick;
    }

    @Override
    public boolean configFixMC159283() {
        return ConfigHolder.getConfig().bugFixes.fixMC159283;
    }
}

