/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.starlight.lightengine;

import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemServerLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkSystemChunkHolder;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkTaskScheduler;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.starlight.light.StarLightInterface;
import ca.spottedleaf.moonrise.patches.starlight.light.StarLightLightingProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacket;
import net.minecraft.server.level.ChunkTaskPriorityQueueSorter;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.util.thread.ProcessorHandle;
import net.minecraft.util.thread.ProcessorMailbox;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.lighting.LevelLightEngine;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ThreadedLevelLightEngine.class})
abstract class ThreadedLevelLightEngineMixin
extends LevelLightEngine
implements StarLightLightingProvider {
    @Shadow
    private ProcessorMailbox<Runnable> taskMailbox;
    @Shadow
    private ProcessorHandle<ChunkTaskPriorityQueueSorter.Message<Runnable>> sorterMailbox;
    @Unique
    private final AtomicLong chunkWorkCounter = new AtomicLong();

    public ThreadedLevelLightEngineMixin(LightChunkGetter chunkProvider, boolean hasBlockLight, boolean hasSkyLight) {
        super(chunkProvider, hasBlockLight, hasSkyLight);
    }

    @Unique
    private void queueTaskForSection(int chunkX, int chunkY, int chunkZ, Supplier<StarLightInterface.LightQueue.ChunkTasks> supplier) {
        ServerLevel world = (ServerLevel)this.starlight$getLightEngine().getWorld();
        ChunkAccess center = this.starlight$getLightEngine().getAnyChunkNow(chunkX, chunkZ);
        if (center == null || !center.getPersistedStatus().isOrAfter(ChunkStatus.LIGHT)) {
            return;
        }
        StarLightInterface.ServerLightQueue.ServerChunkTasks scheduledTask = (StarLightInterface.ServerLightQueue.ServerChunkTasks)supplier.get();
        if (scheduledTask == null) {
            return;
        }
        if (!scheduledTask.markTicketAdded()) {
            return;
        }
        Long ticketId = this.chunkWorkCounter.getAndIncrement();
        ChunkPos pos = new ChunkPos(chunkX, chunkZ);
        world.getChunkSource().addRegionTicket(StarLightInterface.CHUNK_WORK_TICKET, pos, StarLightInterface.REGION_LIGHT_TICKET_LEVEL, (Object)ticketId);
        scheduledTask.queueOrRunTask(() -> world.getChunkSource().removeRegionTicket(StarLightInterface.CHUNK_WORK_TICKET, pos, StarLightInterface.REGION_LIGHT_TICKET_LEVEL, (Object)ticketId));
    }

    @Override
    public final int starlight$serverRelightChunks(Collection<ChunkPos> chunks0, Consumer<ChunkPos> chunkLightCallback, IntConsumer onComplete) {
        LinkedHashSet<ChunkPos> chunks = new LinkedHashSet<ChunkPos>(chunks0);
        HashMap<ChunkPos, Long> ticketIds = new HashMap<ChunkPos, Long>();
        ServerLevel world = (ServerLevel)this.starlight$getLightEngine().getWorld();
        Iterator iterator = chunks.iterator();
        while (iterator.hasNext()) {
            ChunkPos pos = (ChunkPos)iterator.next();
            Long id = ChunkTaskScheduler.getNextChunkRelightId();
            world.getChunkSource().addRegionTicket(ChunkTaskScheduler.CHUNK_RELIGHT, pos, StarLightInterface.REGION_LIGHT_TICKET_LEVEL, (Object)id);
            ticketIds.put(pos, id);
            ChunkAccess chunk = (ChunkAccess)world.getChunkSource().getChunkForLighting(pos.x, pos.z);
            if (chunk != null && chunk.isLightCorrect() && chunk.getPersistedStatus().isOrAfter(ChunkStatus.LIGHT)) continue;
            iterator.remove();
            ticketIds.remove(pos);
            world.getChunkSource().removeRegionTicket(ChunkTaskScheduler.CHUNK_RELIGHT, pos, StarLightInterface.REGION_LIGHT_TICKET_LEVEL, (Object)id);
        }
        ((ChunkSystemServerLevel)world).moonrise$getChunkTaskScheduler().radiusAwareScheduler.queueInfiniteRadiusTask(() -> this.starlight$getLightEngine().relightChunks(chunks, pos -> {
            if (chunkLightCallback != null) {
                chunkLightCallback.accept((ChunkPos)pos);
            }
            ((ChunkSystemServerLevel)world).moonrise$getChunkTaskScheduler().scheduleChunkTask(pos.x, pos.z, () -> {
                NewChunkHolder chunkHolder = ((ChunkSystemServerLevel)world).moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(pos.x, pos.z);
                if (chunkHolder == null) {
                    return;
                }
                List<ServerPlayer> players = ((ChunkSystemChunkHolder)chunkHolder.vanillaChunkHolder).moonrise$getPlayers(false);
                if (players.isEmpty()) {
                    return;
                }
                ClientboundLightUpdatePacket relightPacket = new ClientboundLightUpdatePacket(pos, (LevelLightEngine)((ThreadedLevelLightEngine)this), null, null);
                for (ServerPlayer player : players) {
                    ServerGamePacketListenerImpl conn = player.connection;
                    if (conn == null) continue;
                    conn.send((Packet)relightPacket);
                }
            });
        }, relight -> {
            if (onComplete != null) {
                onComplete.accept(relight);
            }
            for (Map.Entry entry : ticketIds.entrySet()) {
                world.getChunkSource().removeRegionTicket(ChunkTaskScheduler.CHUNK_RELIGHT, (ChunkPos)entry.getKey(), StarLightInterface.REGION_LIGHT_TICKET_LEVEL, (Object)((Long)entry.getValue()));
            }
        }));
        return chunks.size();
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void initHook(CallbackInfo ci) {
        this.taskMailbox = null;
        this.sorterMailbox = null;
    }

    @Overwrite
    public void addTask(int x, int z, ThreadedLevelLightEngine.TaskType type, Runnable task) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void addTask(int x, int z, IntSupplier ticketLevelSupplier, ThreadedLevelLightEngine.TaskType type, Runnable task) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void tryScheduleUpdate() {
    }

    @Overwrite
    public void runUpdate() {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void checkBlock(BlockPos pos) {
        BlockPos posCopy = pos.immutable();
        this.queueTaskForSection(posCopy.getX() >> 4, posCopy.getY() >> 4, posCopy.getZ() >> 4, () -> this.starlight$getLightEngine().blockChange(posCopy));
    }

    @Overwrite
    public void updateChunkStatus(ChunkPos pos) {
    }

    @Overwrite
    public void updateSectionStatus(SectionPos pos, boolean notReady) {
        this.queueTaskForSection(pos.getX(), pos.getY(), pos.getZ(), () -> this.starlight$getLightEngine().sectionChange(pos, notReady));
    }

    @Overwrite
    public void propagateLightSources(ChunkPos pos) {
    }

    @Overwrite
    public void setLightEnabled(ChunkPos pos, boolean lightEnabled) {
    }

    @Overwrite
    public void queueSectionData(LightLayer lightType, SectionPos pos, @Nullable DataLayer nibbles) {
    }

    @Overwrite
    public void retainData(ChunkPos pos, boolean retainData) {
    }

    @Overwrite
    public CompletableFuture<ChunkAccess> initializeLight(ChunkAccess chunk, boolean lit) {
        return CompletableFuture.completedFuture(chunk);
    }

    @Overwrite
    public CompletableFuture<ChunkAccess> lightChunk(ChunkAccess chunk, boolean lit) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public CompletableFuture<?> waitForPendingTasks(int chunkX, int chunkZ) {
        throw new UnsupportedOperationException();
    }
}

