/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.random_ticking;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.common.list.ShortList;
import ca.spottedleaf.moonrise.common.util.SimpleRandom;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.block_counting.BlockCountingChunkSection;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.WritableLevelData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={ServerLevel.class})
abstract class ServerLevelMixin
extends Level
implements WorldGenLevel {
    @Unique
    private static final LevelChunkSection[] EMPTY_SECTION_ARRAY = new LevelChunkSection[0];
    @Unique
    private final SimpleRandom simpleRandom = new SimpleRandom(0L);

    protected ServerLevelMixin(WritableLevelData writableLevelData, ResourceKey<Level> resourceKey, RegistryAccess registryAccess, Holder<DimensionType> holder, Supplier<ProfilerFiller> supplier, boolean bl, boolean bl2, long l, int i) {
        super(writableLevelData, resourceKey, registryAccess, holder, supplier, bl, bl2, l, i);
    }

    @Redirect(method={"tickChunk"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/RandomSource;nextInt(I)I"))
    private int nextInt(RandomSource instance, int bound) {
        return this.simpleRandom.nextInt(bound);
    }

    @Redirect(method={"tickChunk"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/LevelChunk;getSections()[Lnet/minecraft/world/level/chunk/LevelChunkSection;", ordinal=0))
    private LevelChunkSection[] optimiseRandomTick(LevelChunk chunk, @Local(ordinal=0, argsOnly=true) int tickSpeed) {
        LevelChunkSection[] sections = chunk.getSections();
        int minSection = WorldUtil.getMinSection((Level)((ServerLevel)this));
        SimpleRandom simpleRandom = this.simpleRandom;
        boolean doubleTickFluids = !PlatformHooks.get().configFixMC224294();
        ChunkPos cpos = chunk.getPos();
        int offsetX = cpos.x << 4;
        int offsetZ = cpos.z << 4;
        int sectionsLen = sections.length;
        for (int sectionIndex = 0; sectionIndex < sectionsLen; ++sectionIndex) {
            int offsetY = sectionIndex + minSection << 4;
            LevelChunkSection section = sections[sectionIndex];
            PalettedContainer states = section.states;
            if (!section.isRandomlyTickingBlocks()) continue;
            ShortList tickList = ((BlockCountingChunkSection)section).moonrise$getTickingBlockList();
            for (int i = 0; i < tickSpeed; ++i) {
                FluidState fluidState;
                int tickingBlocks = tickList.size();
                int index = simpleRandom.nextInt() & 0xFFF;
                if (index >= tickingBlocks) continue;
                int location = tickList.getRaw(index) & 0xFFFF;
                BlockState state = (BlockState)states.get(location);
                BlockPos pos = new BlockPos(location & 0xF | offsetX, location >>> 8 & 0xF | offsetY, location >>> 4 & 0xF | offsetZ);
                state.randomTick((ServerLevel)this, pos, (RandomSource)simpleRandom);
                if (!doubleTickFluids || !(fluidState = state.getFluidState()).isRandomlyTicking()) continue;
                fluidState.randomTick((Level)((ServerLevel)this), pos, (RandomSource)simpleRandom);
            }
        }
        return EMPTY_SECTION_ARRAY;
    }
}

